/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ConvIoniz called by ConvEdenIonz, it calls ConvIonizeOpacityDo until converged */
#include "cddefines.h"
#include "thermal.h"
#include "heat.h"
#include "trace.h"
#include "converge.h"

void ConvIoniz(void)
{
	long int 
		/* the oinization loop counter */
		loopi ,
		/* the limit to how many times we will try calling ConvIonizeOpacityDo before giving up */
		LoopLimit;

#	ifdef DEBUG_FUN
	fputs( "<+>ConvIoniz()\n", debug_fp );
#	endif

	/* this routine is called by ConvTempIonz, it calls ConvIonizeOpacityDo
	 * until it converges */

	if( conv.lgSearch )
	{
		/* expand limit to number of calls to ConvIonizeOpacityDo during search phase */
		LoopLimit = 30;
	}
	else
	{
		LoopLimit = 20;
	}

	/* zero the ionization loop counter */
	loopi = 0;

	/* do not go into the loop with first call to ioniz,
	 * since results will be bogus - do it here */
	if( !conv.lgSearch && conv.nPres2Ioniz == 0 )
	{
		ConvIonizeOpacityDo(loopi);
	}

	strcpy( conv.chConvIoniz, " NONE!!!!!" );
	/* this is ionization/electron density convergence loop
	 * keep calling ConvIonizeOpacityDo until lgIonDone is true */
	do 
	{

		/* set the convergece flag to TRUE, 
		 * if anything changes in ConvIonizeOpacityDo, it will be set false */
		conv.lgConvIoniz = TRUE;

		/* compute the current ionization, ots rates, secondary ionization rates */
		ConvIonizeOpacityDo(loopi);

		if( trace.lgTrConvg>=4 )
		{
			/* cooling has not been evaluated yet */
			fprintf( ioQQQ, 
				"    ConvIoniz4%4ld heat:%10.2e cool:%10.2e ", 
			  loopi, heat.htot , thermal.ctot );

			/* this is flag saying whether or not ionization/eden has converged */
			if( conv.lgConvIoniz )
			{
				fprintf( ioQQQ, " ioniz converged\n" );
			}
			else
			{
				fprintf( ioQQQ, " ioniz no conv:%10.10s old %.3e new %.3e OscilOTS %c\n", 
				  conv.chConvIoniz , conv.BadConvIoniz[0],conv.BadConvIoniz[1] ,
				  TorF(conv.lgOscilOTS) );
			}

		}

		/* increment ionization loop, and keep going until we converge */
		++loopi;
	}	while( !conv.lgConvIoniz && loopi < LoopLimit && !conv.lgAbort );

	if( !conv.lgConvIoniz )
	{
		/* this is a major problem, ConvIoniz did not converge the ionization */
		++conv.nConvIonizFails;
		/* this is flag saying that an ionization convergence problem occurred in this
		 * zone, will be used to help choose next dr */
		++conv.lgConvIonizThisZone;
	}

	/* if trace convergence is in operation and we did not converge, give warning */
	if( trace.lgTrConvg>=4 && !conv.lgConvIoniz )
	{
			fprintf( ioQQQ, 
				"       ConvIoniz4>>>>>>>>>>exit without converging after %li tries!!!!\n",loopi);
	}

#	ifdef DEBUG_FUN
	fputs( " <->ConvIoniz()\n", debug_fp );
#	endif
	return;
}

