/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
#include "cddefines.h"
#include "complexmath.h"

complex ftocm(double r,double i )	/* convert floats to dp complex */
{
	complex dz;
	dz.re = r;
	dz.im = i;
	return( dz );
}

complex cmneg(complex dz )	/* dp complex unary minus operation */
{
	dz.re = -dz.re;
	dz.im = -dz.im;
	return( dz );
}

double cmabs(complex dz )	/* dp complex absolute value */
{
	double s;

	dz.re = fabs(dz.re);
	dz.im = fabs(dz.im);

	if( dz.re == 0. )
		return dz.im;
	else if ( dz.im == 0. )
		return dz.re;
	else if( fabs( log10(dz.re) - log10(dz.im) ) > 15. )
	{
		return fabs( MAX2(dz.re, dz.im) );
	}
	else if( dz.re<1e-100 || dz.re>1e100 )
	{
		return dz.re * sqrt( 1. + (dz.im/dz.re)*(dz.im/dz.re) );
	}
	else
	{
		s = dz.re*dz.re + dz.im*dz.im;
		return( sqrt(s) );
	}
}

complex cmadd(complex l,complex r )	/* retn the sum of two dp complex nos. */
{
	l.re += r.re;
	l.im += r.im;
	return( l );
}

complex cmsub(complex l,complex r )	/* retn the difference of two dp complex nos. */
{
	l.re -= r.re;
	l.im -= r.im;
	return( l );
}


complex cmmul(complex l,complex r )	/* retn the product of two dp complex nos. */
{
	complex dz;
	dz.re = l.re*r.re - l.im*r.im;
	dz.im = l.re*r.im + l.im*r.re;
	return( dz );
}

complex cmdiv(complex l,complex r )	/* retn the quotient of two dp complex nos. */
{
	complex dz;
	double den;

	if( r.re == 0. && r.im == 0. )
		fprintf( ioQQQ, " Complex division by 0." );

	den = r.re*r.re + r.im*r.im;

	/* chng 07 june 02, by Ryan. I changed the order of operations 
	 * in order to prevent overflows and underflows when r is very small or big	*/
	
	/*dz.re = ( l.re*r.re + l.im*r.im )/den;
	dz.im = ( r.re*l.im - l.re*r.im )/den;	*/

	dz.re = l.re/den*r.re + l.im/den*r.im;
	dz.im = r.re/den*l.im - l.re/den*r.im;

	return( dz );
}

complex cmexp(complex dz )	/* dp complex exponential */
{
	double exp_re;

	if( dz.re == 0. )
		exp_re = 1.;
	else
		exp_re = exp(dz.re);

	if( dz.im == 0.0 ) {	/* real only complex no. */
		dz.re = exp_re;
		return( dz );
	}
	dz.re = exp_re*cos(dz.im);
	dz.im = exp_re*sin(dz.im);

	return( dz );
}

