/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* AAAAA routine keeping track of version numbers
 *******************************************************************************
 *                                                                             *
 *                                                                             *
 *                                                                             *
 *                   This is version 96 of Cloudy                              *
 *                                                                             *
 *                                                                             *
 *                                                                             *
 *  Cloudy is copywrited 1978-2003 by Gary J. Ferland.                         *
 *  This code is copywrited material and may not be copied without             *
 *  acknowledging its origin.                                                  *
 *  Portions of the code are derived from the work of others,                  *
 *  as acknowledged in Hazy.                                                   *
 *                                                                             *
 *  The development of Cloudy has been supported by grants from                *
 *  NASA and NSF.                                                              *
 *                                                                             *
 *  Use of this code is not restricted provided that acknowledgement           *
 *  is made in each publication.  The bibliographic reference to this          *
 *  version of Cloudy is Ferland, G.J., 2002, Hazy, a Brief Introduction       *
 *  to Cloudy 96, University of Kentucky, Physics Department Internal Report.  *
 *                                                                             *
 *  Make sure that you have the current version (with the latest atomic        *
 *  data and fixed problems) by checking the Cloudy Web site                   *
 *  http://www.pa.uky.edu/~gary/cloudy                                         *
 *                                                                             *
 *  To be atutomatically notified of these changes, ask to be placed on the    *
 *  cloudy mailing list by sending an e-mail to gary@cloud9.pa.uky.edu         *
 *                                                                             *
 *******************************************************************************/
#include "cddefines.h"
#include "version.h"
#include "aaaa.h"

void AAAA(void)
{

#	ifdef DEBUG_FUN
	fputs( "<+>AAAA()\n", debug_fp );
#	endif

	strcpy( version.chDate, "03Mar21" );
	strcpy( version.chVersion, " 95.06 " );

	/* this is beta version number, beta test, normally zero
	 *c90 beta 3, May 23, 1996
	 *c90 beta 4, Jun  9, 1996 */
	/*c94 beta 1, Jul  9, 1999 */
	/*c94 beta 2, Oct  1, 1999 */
	/*c96 beta 1, Feb  2, 2001 */
	/*c96 beta 2, Apr 18, 2001 */
	/*c96 beta 3, Feb 19, 2002 */
	/*c96 beta 4, Jun  1, 2002 */
	/*c96 beta 5, Mar 21, 2003 */
	version.nBetaVer = 5;

	/*
	 *  .05  03 Mar 21, version is feature complete, He-like stands by itself,
	 *                  molecular network stable
	 *  .04  02 Feb 19, He-like seqence complete except for collisions & top-off, 
	 *                  new-style grains stable
	 *  .03  01 jun 30, visit to Pequignot in Paris, heavy element recombin continua, Lya, Bal 
	 *  .02  01 apr 21, small problems fixed after beta released
	 *  .01  01 apr 05, test whether ionization convergence ever had problems during current
	 *                  solution, in nextdr, when choosing zone logic 
	 *95.00  01 Feb 02, leaving for Hilo,
	 *                  major update in charge transfer, including Pequignot and Prasad numbers
	 *  .00q 00 dec 19, change correction for dTau in continuum pumping of lines in RTMakeStat 
	 *  .00p 00 oct 22, logic for converging electron density slightly changed in ConvEdenIon,
	 *                  electron density residuls now 10 - 100 times smaller in predominantly neutral regions,
	 *                  with slightly longer execution times
	 *  .00o 00 oct 16, CO all in, increased resolution of submm to resolve rot lines
	 *  .00n 00 sep 28, problem with opacity offset for H- photodissociation in hmole fixed.
	 *                  CoStar halo abundance set added
	 *  .00m 00 sep 11, updated all SIII cs data to Tayal & Grupta 1999
	 *                  format of wavelengths changed for lines below 100A to give
	 *                  more precision in the wavelength.  A new command, the
	 *                  SET OLDWAVELENGTH command, will cause the code to behave
	 *                  as it did before.
	 *                  Changed resolution across mid and far ir to 1% to better
	 *                  resolve thermal ir
	 *   00l 00 sep 08, LaMothe&Ferland free-bound cooling coefficients
	 *   00k 00 aug 21, he 2^1S decay to ground change A from 8.2 to 51
	 *   00j 00 aug 14, boron sequence fully in for CII], NIII], OIV], SiII] and S IV]
	 *   00i 00 aug 04, LevelN loop counting cooling did not include alpha transitions
	 *  .00h 00 jul 30, break out boron sequence for c2, n3, o4, & s4
	 *  .00g 00 jun 04, dest0 in RT_DestProb changed to 0 
	 *  .00f 00 Apr 28, work function of graphite changed from 0.5883 Ryd to
	 *                  0.3235 Ryd
	 *  .00e 00 Apr 06, error in index for ionization threshold of hydrogen-like species
	 *                  of all elements heavier than helium.  
	 *  .00d 00 Mar 21, widflx cleanup following cdSPEC testing, 
	 *                  underflow problem with correction to continuum pumping rate
	 *                  sphere staic, no loger set HeI 10830 optical depth to large initial value
	 *  .00c 00 Feb 28, iso.numLevels[ipH_LIKE] => iso.numLevels[ipH_LIKE][ipZ]
	 *  .00b 00 Jan 03, added ConOutRecInter to carry single cell rec continua 
	 *  .00a 00 Jan 03, fixed crash due to renorm of opac, problem with punch transmitted continuum
	 *94.00  99 Dec 24, leaving for Texas
	 *  .06d 99 dec 18  lya photo of excited state ca+ was zeroed out
	 *  .06c 99 dec 03  assert map added, map.in added to auto, map cleaned up
	 *  .06b 99 dec 02  added correction for optical depth across zone to continuum pumping rates,
	 *                  mainly affected very optically thick models like ism 
	 *  .06  99 nov 23  changed switch to low ion H soln, and pop vs dep, after dalton
	 *                  models had problems
	 *  .05a 99 nov 18  dest0 changed to 1e-20 in RT_DestProb to stop lya from overwhelming
	 *                  flow heating rates.  this did not affect 90 since low opacites
	 *                  did not include ots rates
	 *                  added stromgren length check to firstdr 
	 *  .05  99 Nov 14  H two photons were not reset, many bugs in quantum heating
	 *                  routines 
	 *  .04  99 Oct 13  improved continuum resolution between 100 and 1000 microns
	 *  .03  99 Oct 01  beta 2, several small fixes after running entire tsuite
	 *  .02  99 Sep 14  ConvTempxxx did not call routines to redo temperature related
	 *                  variables, biggest effect was at restart of next iteration,
	 *                  wrong temp var used for first pass through thermal soln
	 *                  level3.c did not define the ots dest rates
	 *  .01  99 Jul 18, all lines now use EmLine structure
	 *93.00  99 Jul 09, beta 1 of C94
	 *  .21  99 Jun 25, fixed problems with balmer line optical depths (bring 2s-2p
	 *                  together) also feii dest of lya was added to ots field
	 *  .20  99 Jun 15, model atoms in H-like sequence can have any size at all
	 *                  successfully ran 100 level atom with ism, ran out of memory
	 *                  with full element set
	 *                  conv now checks whether ots oscillations occur, if so take
	 *                  mean of old and new dest rates, old had always done this
	 *                  with Lya only
	 *  .19  99 Jun 08, pure He gas goes to STE, fixed problems in rec cooling,
	 *  .18  99 May 27, sphere slit option, variable number of feii levels
	 *  .17  99 May 16, Verner FeII atom does not crash 
	 *  .16  99 May 01. CoStar stars in, phymir in, compton bug fixed 
	 *  .15  99 Apr 28, table rauch stars now work, flxfnt limit on high energy
	 *                  end of continuum reinstated
	 *  .14  99 Apr 10, repaired error in hydrogenic collision strength introduced a few
	 *                  weeks ago.  changed RT_DestProb so that scattering limit is ok
	 *  .13  99 Apr 02, passed through purify, problem with gammak doing non-existant
	 *                  shells discovered by Mark Giroux
	 *  .12  99 Mar 17, both optim routines work, series of models get same answer as single
	 *  .11  99 Mar 10, all nebulae, single zone models work, H He reproduce HS case B
	 *  .10  99 jan 25, hydrogen-only models get correct Q(H)-hbeta, sphere and parallel
	 *  .09  99 jan 18, constant temperature H-only models work
	 *  .08  98 oct 21, all explicit forms of line addressing removed, level 1 read in
	 *  .07  98 oct 17, all cdstring, fcrt, fcio removed 
	 *  .06  98 oct 11, canadian thanksgiving! bug in tauinc, for fixing hydrogenic opacities, fixes
	 *  .05  98 Oct 08, all prototype.h removed, prototypes totally on their own
	 *  .04  Oak Ridge, 98 sep 28, updated 7 H CT rates that Jim Kingdon revised
	 *  .03  removed all nsS( calls from code
	 *  .02  removing prototype.h, fewer continuum mesh points
	 *  .01  1998 aug 4 in Maine, exactly same answers with c and 91
	 *92.00  1998 June 10, c version runs 1-zone parispn
	 *
	 *  .02  all hydrogenic species through O compare with HS
	 *91.01  hydrogen gets same answer again
	 *91.00  starting to break the hydrogen atom  . . . .
	 *  .04  Sept 5, 1997
	 *  .03i all individual chem element pointers removed
	 *  .03h update He+ collisional ionization with HydColIon by Jason Ferguson
	 *  .03g eden to edhi in hlevel, caused slight departures from lte in very
	 * dense models, also caused 3-body heating to be too important
	 * HeI collision data updated to Sawey and Berrington
	 * At. Data Nucl. Data Tables 55, 81
	 * very cool fully molecular models could have CO inversion error
	 * due to OH underflow
	 *  .03f problem with calcium fixed (introduced 5 days before), all transferred
	 * lines in radiation pressure, which is now larger.  Radiation
	 * pressure only capped on first iteration instead of all except last.
	 *  .03e second Thornley problem otslinon off, variable grain abundances in
	 *  .03d variable grain abundances
	 *  .03c several fixes for Lya photo induced oscillaitons
	 *  .03b add cooling derivative for HeI and HeII lines(!!),
	 * cooling for 1s-2s for HeI and HeII
	 * reset grain potential at start/end of calculation
	 * change limit to opacity in OpacityAddTotal to 1e-29
	 * error in logic for change in electron density
	 * default line width in plots changed to 1000 km/sec
	 *  .03  change SIII collision strengths, Tayal '97
	 *  .03a error in nWerner, off by one
	 *  .03  Dima's recombination lines all in
	 *  .02z increased resolution of continuum up past Fe K edge
	 *  .02y deriv of photo heating cooling did not include top stage of ioniz
	 * small increase in A for NII 2140 Brage Hibbert LEckrone apj 478, 423
	 *  .02x HeI singlet line cooling multiplied by HeIII not HeII
	 *  .02w error in rec to ground and Lya of heavy elements, no electron density
	 * rec coef for ion rec on grain surface had grain not elec temp
	 *  .02v fixed error introduced in SIV cs in .02k
	 *  .02u killed cont pumping of Heii when underflow upset matrix
	 *  .02t submitted version of Dalgarno CT rates put in
	 *  .02s small changes in atomic constants in parameters, to be in line
	 * with '86 codata recomendations
	 *  .02r Ar IV model atom revised to 5 levels, cs data to Ramsbottom et al 97
	 * major change (fac of several) in collision strength
	 * change FeX, FeXI, and FeXIV cs data to 1
	 *  .02q increased continuum resolution above 4.0 to 4.05 ryd
	 *  .02p added lots of [Ca VII] lines, [Fe VII] 6087 cs too small by 2.96x
	 *  .02o abundances of rare species in ism and HII Region mixes changed
	 * to Savage and Sembach Ann REv 1996
	 *  .02n statistical charge transfer rate coef of 8.5e-10q put in
	 *  .02m added 2 fir fevii lines, updated fir energies with Feuchtgruber et al
	 *  .02l Kevin Volk star1 routine all in, with option renamed kuwn
	 *  .02k new cs for [SIV] 10 mic line, fixed error in H matrx flag resetting
	 *  .02j changed limit to Lev3Fail=4 from 1e-7 to 1e-8 in level3
	 * changed default lower limit for all range options from 1 Ryd to 0.9996 ryd
	 * for H mass rydberg
	 *  .02i change logic for test of HeII/HeI in hei, for case where pumping of
	 * atom resulted in photoionization, new var is chk2ov1
	 * code now exits totally when cold molecular first zone does not converge
	 *  .02h error in cs for Ar VI 4.53 micron line, should have been 6.33, was 0.8
	 *  .02g fixed problems with level3 roundoff causing cooling to underflow
	 *  .02f expression for HeI Lya cooling changed to be accruate near LTE
	 *  .02e in metdif defn of incremental outward changed to refer to all
	 * previous outward - SumIncCon
	 *  .02d protect against roundoff error in level3
	 *  .02c colfit 2.0 in, fixed discontinuity in H collisional ionization
	 *  .02b zoning for first 10 allowed dr to get too big, error introduced
	 * in very late 90.01
	 *  .02a restored test whether H collisionally or photo ionized - logic
	 * had been blown, this improved thermal stability
	 *  .02  improved temp predictor-corrector when ff heating dominant
	 *  .01p added logic to damp oscillations in bidiag auger during search
	 *  .01o 16 level FeII goes to very low temperatures continuously
	 *  .01n 2 errors in bidiag, used yield of last electron, clobbered Auger
	 * rates when collisional ionization set
	 * ionization potential of hydrogen now 0.9996 ryd
	 *  .01m very small change in evaluation of H ff heating, to keep constant
	 * when running large grids
	 *  .01l sanity checks against zero photo cross secs, fixed several elem
	 * with 0 cs at energyies below threshold
	 *  .01k moved all H ct to Jim Kingdon's routine
	 *  .01j major bug in total photo cross section for OP elements,
	 * sub shell photo cross sect only went up to next major theshold,
	 * which was assumed to dominate.  In many op species there is
	 * no jump at shell edges, so subshells must go to much higher energy
	 * result was that some species has zero cross sections at some energies
	 *  .01i DstWght now in for all RT_DestProb destruction probabilities
	 * temp of last zone was used for cs in [OIII] analysis, changed to 1e4K
	 *  .01h better protection against counting ns kludge from closed shell
	 * (no effect on balance of any major elements).  Better bracket gamma
	 * branch routine from Jason
	 *  .01g 16 level FeII atom put in
	 *  .01f reflected continuum albedo now defined
	 *  .01e slight change in As for NIV] and OIV]
	 *  .01d added 12 level [FeIV] atom, H atom can do 50 levels
	 *  .01c bug in computing grain drift velocity in grids when 
	 * grains turned off initially, then turned on
	 * added [Mg V] and [Mg VII] lines, improved temp dependencies
	 * of many IR line collision strengths
	 *  .01b improved coll str fits with temp for many IR lines,
	 * added [K IV] and [K VI] IR lines
	 *  .01a fixed error in atomic number pointer for P X, updated cs
	 * expression for CII 157 mic
	 *  .01  several of Kirk's grids have run ok, final touchup with
	 * adding frequency points to diffuse continuum printout
	 *  .00h lines broken up, F sequence in using Saraph and Tully AAS 107, 29.
	 *  .00g tmn added back to outward lines in metdif
	 *  .00f helium triplet collisional cooling did not include
	 * three body heating, problems when close to lte
	 *  .00e error in he triplet population at VERY low densities,
	 * [FeX] collision strength changed to straight Pelan and berrington
	 * so 10x larger
	 *  .00d work on punch continua, level2 includes pump before check
	 * on magnitude of coll exciatation
	 * punch transmitted continuum had major error
	 *  .00c Cl sequence updated from Pelan and Berrington
	 *  .00bsphere static did not increment optical depths correctly, and
	 *  did not have correct ipLnTauCon which was added
	 *  typo in Dima's line list, OIV 609 line had bad energy
	 *  very small change in cs of 3P levels of SV
	 *  .00a first installment on fixes, labels changed for "2" lines
	 *  dielectronic recom contributions updated
	 *90.00 96 June 17, leaving for Disney World
	 *  .28 cleaned up lots of small problems on sgi and cray
	 *  .27 runs on cray 90 with stack memory, indefinites
	 *  .26 changed logic for converging optical depths
	 *  .25 he1 and he2 had rec coef from cota levels, made smooth - caused
	 *  maser in HeI and HeII 7-6 transition
	 *  .24 removed last of bad A's from cota levels
	 *  .23 error in opacities for HeI and HeII lines
	 *  .22 logic added for H masing lines, problem in csupra when
	 *  metals far more abundance than H or He
	 *  .21 error in conversion FeII A into oscil
	 *  .20 leaving for Mike Brotherton's defense in Austin, this is c90 beta 3
	 *  .19 4 new IR lines, 4 old lines moved to line arrays,
	 *  problems with free-free gaunt factor routine partially fixed
	 *  .18 changed VolFac to OutFac, using dVeff
	 *  better protection against table read from old version
	 *  .17 h ct back on again
	 *  .16 damped ophf oscillations, set traps for neg ots fields gracefully
	 *  .15 trap set in TauInc for strong maser emission
	 *  changed he sin, ion line rates to hdexct (had included psuedo states)
	 *  .14 stepped OI photo cross sections, Pequignot rad rec coef
	 *  .13 hnet, he1net he2net had cap of 1 on escape prob, prevented
	 *  maser emission
	 *  .12 many new ir lines added, changed cs for H Lya, 1-3, 2-3 transition,
	 *  updated He+ collision strengths, 1-2-3
	 *  .11 cured two instabilities discovered by Jim Kingdon, fixed several
	 *  bugs discovered by Kevin Volk, none affected line answers,
	 *  lowest energy continuum point was 3sx too small
	 *  update doublet ratios for forb line, A's for beseq
	 *  .10 this is c90 beta 1 released Apr 26 96,
	 *  15 level hydrogen atom now default, topoff over upper 5 levels
	 *  .09a sec highest level in feii atom - no stim em cor, to fix over-masing
	 *  .09 h atom topoff back to all in highest level
	 *  .08 reflected and outward continua now produce correct eq on plots
	 *  .07 fixed rec lines that spilled over into next higher continuum
	 *  .06  default nhlvl now 25
	 *  .05d branch now goes to 30,000K, for n=4,5 better fit at intermed den
	 *  .05c first abund arg removed from level3 routine
	 *  .05b h atom top-off now to all n=3,nhlvl
	 *  .05a changed He + N+3 =. N+2 + He+ ct rate to Sun et al cfa pre 4208
	 *  .05 abundances now Grevesse and Noel, meteoretic, Fe down 33%
	 *  .04b changed default orion abundances to baldwin et al
	 *  .04a removed big fudge factor on coll ion rate from n=9 of hydrogen
	 *  .04 arbitrary level hydrogen atom works (?)
	 *  .03a killed kludge rec for iron since in arnaud and raymond rates
	 *  .03 bad induced continuum in he 1 2 excited states
	 *  .02 set escape proba for highest H Lyman line to 1,
	 *  to avoid numerical oscillations in totally optically thick models
	 *  changed free-free heating evaluation to do every time if signigicant
	 *  .01 numerous changes after comparison with ION,
	 *  Dima's radiative rec now totally in
	 *89.00 leaving for Israel
	 *  .25 passed code through array limits checker
	 *  .24 all col ioniz now Dima's colfit, many rates very different
	 *  .23 new cs for Mg+* photo, MgII twice as strong
	 *  .22  new colstrgbar with neutrals, KI fit to cs
	 *  .21f full population of upper level of mg2 2798 inc in photo fhof mg+
	 *  .21e put ff emission in fir back into outward beam
	 *  .21d change NaD cs to Dima's new value
	 *  .21c he3relax defined as frac that go to singlets
	 *  .21bmade hydrogen opacity call to opinb
	 *  .21 HeI, HeII Lya lines now have ExpmTau included, less outward
	 *  .20 reeval grains for every iteration since heating-cooling change
	 *  .19 secla not updated in gamk, bnfun, and bnfun used all enr for sec
	 *  .18 hydrogen line net heating has better derivatives
	 *  .17 REALLY BIG BUG in Neon I photo crossection fixed
	 * 1996
	 *  .16 collisions from H n=2 to 3 and up HAD BEEN TURNED OFF!
	 *  .15 tmn back in but with damped dr, all lex meeting tests ok
	 *  except for blister
	 *  .14 brems not ever added to outward beam below EnergyBremsThin
	 *  .13avery slight coding changes for secondary ionization changes
	 *  .13 added check for temperature oscillation, double optical
	 *  depths to convergence tests, moved block data vars to executable
	 *  .12 lines tranferred did not have popl and popopc correct
	 *  mostly affected CaII
	 *  .11 several bugs related to ipLnPopl vs iipLnPopOpc
	 *  also incorrect setting of these in ionize, not using level2
	 *  for wind lines
	 *  .10 chage trans ion of h back out
	 *  .09 charge transfer ionizat of hydrogen now vector */
	/*  .08 careful comparison with lexington meeting test results
	 *  .06 H ff now HFFNet = cool-heat for H free free, same for free bound
	 *  h now includes charge transfer recombination
	 *  .05 fixed problem with eden going negative, unable to converge cooling
	 *  for low density warm gas
	 *  .04  level3 did not zero cooling when abundance zero, leveln did
	 * not zero deriv of cooling when abundance zero
	 *  .03a put evaluation of Lya heating in hydrogen so that it is done
	 * all the time = = =  put logic for change in temp in nextdr
	 *  .03  Jim Kingdon's depletions in, fluctuations affects abundances
	 *  .02  lots of small changes after kirk's loc models
	 *  .01  cleaned up temp failures after one of kirk's loc runs
	 *88.00  July 28 95, after converting level3 to sep heating-cooling
	 * .53 cleaned up crashes from running hazy all
	 * .52 worked on more bugs from instability of 35Z blr
	 * .51 increased resolution in 100-1000eV range, ipContSave
	 * .50 got pdr.in to work well, lots of little bugs working through hazy
	 * .49 removed bug dealing with too many incremeents of photo rates
	 * .48 trying to get all models to work again
	 * .47 several loop reogrinizations, code speed up by 3x
	 * nexdr now relies mainly on dTau at max interaction
	 * .46 get exactly same results for pn on sun and cray 90
	 * .45 lots of small init bugs discovered from running on eagle cray c90
	 * .44 g-bar lines use ContBoltz not exp for boltzmann factor
	 * .43 winddat lines use inner escprob not conpmp, do not write onto ots
	 * .42 collapsed line transfer loops into MakeLineRT
	 * .41 all 6k of Dima's lines now in cooling
	 * .40 he1 array t206 was not dim nta - had buggered solarsave(26)
	 * .39 fixed error in ipLnAovTot in level3 (forgot escape prob)
	 * .38 conpmp now uses optical depth in center of next zone
	 * .37 fixed error in opacity 1-9 transition of H
	 * .36 removed all PDoublet - now three level atoms
	 * cs for al iii was in error, and ovi doublet had one line
	 * .35 got lalpha.in to work, lowered bn(2s) by increasing cs 2s photo
	 * .34 corrected error in H stat weight introduced in 33
	 * .33 lots of work on hydrogen matrix
	 * hopac matrix defined from A's
	 * .32 fixed bug in gamk heating introduced in speedup below
	 * .31 population in line arrays not set when gas too cool
	 * .30 added ionization species to punch continuum
	 * bug fixed - when abundance of species set to zero by trim,
	 * ots was not set to zero
	 * .29 bug in rec eff function when temp passed below 1500K
	 * .28 first runs of orion with verner feii atom,
	 * electron density converged in map
	 * .27 Verner's FeII atom in, lots of neutral species
	 * .26 energy inputs to grain heating straightened out
	 * .25 cleaned up OI and FeII routines to eleimanate negative pops
	 * .24 at end of first iteration integrated H He Lyman line optical
	 * depths are now corrected for assumed initial optical depth -
	 * this helps convergence in models optically thin in Lyman lines
	 * .23 highest 4 levels in H not used for collisional ionziation cooling
	 * .22 no more calls to pexc()
	 * .21 supppression in for all dielec recomb
	 * .20 supression of nuss+storey dielectronic suppression as in burgess
	 * also moved suppression routine out of carbon
	 * .19 HeI lines in outward beam
	 * .18 big error in si iii] cs, again
	 * .17 all heavy line optical depths now just one array
	 * .16 fstaus history
	 * .15 all fines refernces out, level3 agrees exactly
	 * .14 level3 gives same answer for ci ir lines
	 * .13 atomic data for oiv] changed, 20% difference
	 * .12 larger A for 1909 (121 from 96)
	 * .11 problems with fines calls for ci and mgv ir lines
	 * .10 all character onto hungarian notation
	 * .09 PDoublet routine used for AlIII
	 * .08 nearly all commons out?  all implict none?
	 * .07 burgess dielec recom not considered at low eneough temp
	 * .06 lots more commons out
	 * .05 answer for hydogen changed when commons, implicit none, changed
	 * .04 low end of pl in agn now exp cutoff
	 * .03 contin now clean, implicit none
	 * .02 comole and comment have no common, all implcit none
	 * .01 block.f has no commons, all implicit none
	 * 87.00 Lexington meeting final models
	 *Jan19 95
	 *  .50 Dima changed S+ photo cross to opacity project value
	 *  .49 changed SiIII 1898 cs to 3x larger value
	 *  .48 power law flat again in agn command
	 *  .47 put in bump for agn command
	 *  .46 iondun also set by checking oxygen convergence
	 * 1995
	 *  .45 fixed ratio crash in ion bal for zinc
	 *  .44 agn now has -0.5 slope bb, option to change it
	 *  .43 lots more continue removed 
	 *  .42 Stafford et al NII collision strengths
	 *  .41 agn command
	 *  .40 heat now working again
	 *  .39 cleaned up more continues, saved photo rates in common
	 *  .38 mewe yields are now all in
	 *  .37 lots of includes added
	 *  .36 all optical dpeth arrays into includes
	 *  .35 two constant temp models called in row identical
	 *  .34 gffsub not called first time on multi-run calcs
	 *  .33 a few small fixes
	 *  .32 changed 11 to nhlvl+2 in hydrogen
	 *  .31 cloudy.ini can be any file name
	 *  .30 cloudy.ini can be on the path
	 *  .29 cloudy.ini file now read in with init file
	 *  .28 titanium , scandium in iwth fe data
	 *  .27 Li, Be, B in with carbon rec, coll ioniz data
	 *  .26 "heating" array now fulling in, pheat parallel
	 *  .25 fe, cobalt, nickel, cleaned up, NOPSV trimed down
	 *  .24 chlorine, argon, calcium cleaned up
	 *  .23 alum, sil, sulph cleared up
	 *  .22 oxy ne toally cleaned out
	 *  .21 all elements formerly in use dima opacities only
	 *  .20 all 30 elements now have opacities
	 *  .19 all remants of old carbon ionization gone
	 *  .18 old carbon ionization totally out
	 *  .17 new ionization, recomb, bi-diag written, in par with old
	 *  .16 all opacities up to neon, and iron, now to dima
	 *  .15 more li seq lines in, increase ligbar by 3.5%
	 *  .14 fixed bug in counting cooling for mg 10 twice
	 *  .13 ar 16 and fe 24 2s2p transition split into two lines
	 *  .12 half dozen li seq lines in with both 2s2p and 2s3p
	 *  .11 lots more Li seq lines added to optical depth arrays
	 *  .10 new collision strengths for Li-seq
	 *  .09 cs for FeX 6374 from Mohan et al, 20x larger than Mason
	 *  .08 Dima Verner's photo used for thresholds
	 *  .07 incorporating branch, new level scheme for hydrogen
	 *  .06 new h atom work begins, mean of old and new H level pops used for opacity
	 *  .05 rough charge temperature dependence for dielec suppression
	 *  .04 bug in implementation of shull and van steenberg recomb rates
	 *  .03 bug in implementation of shull and van steenberg coll rates
	 *  .02 pointers for cobalt and clorine not reset at end of iteration
	 *  .01 three new vary commands
	 *86.00 sparc 20 arrives, try to stabalize all tests
	 *  .47  table stars atlas works again, lly-a counted as rec line for energy bal
	 *  .46  jason's subplex 
	 *  .45 bug in Ly-bet escape prob when no oxy 1
	 *  .44 escape simple added
	 *  .43  nend() and itrprt() changed to parameter, itrdim
	 *  .42  ContDiff only evaluated in diffem for ots
	 *  .41  gaunt factor toutine now includes limits
	 *  .40  lines self-fluoresced since OccNumbIncidCont included lines
	 *  .39  outward beamed lines completed
	 *  .38  all taun lines now reflected, outward beams
	 *  .37  energy in h col psuedo levels off for n=9
	 *  .36  pumping, dest, into Fred's 6 level atom
	 *  .35  nlevel in for 3 level fe ii atom
	 *  .34  H- mutual neutralization production of H-alpha added
	 *  .33  small bugs in HMOLE  - H2+ goes to lte for high n
	 *  .32  last of small set of bugs
	 *  .31  element vary works, element scales can be combined with other
	 * abundance commands
	 *  .30  check for energy conservation changed to adds of rec and cool
	 *  .29  sorted out hydrogen line rec, col, and info, in routine lines
	 *  .28  collisional ionization cooling of helium
	 *  .27  fabden now has depth as argument too
	 *  .26  all elements turned off with elements off command
	 *  .25  element command added
	 *  .24  contin pumping now turned on for rest of elements (only C up to now)
	 *  .23  underflow in how punch line structure cause return of zero in 
	 * geometries with large radius
	 *  .22  Cl in with corr photo, rec cs, co with cor photo, ni rec
	 *  .21  Cl, Co added to abundances
	 *  .20  cleaned up bugs in NIII 990 pumping
	 *  .19  all cool1 and cool2 converted to array pexc
	 *  .18  CIV 1540 now all in
	 *  .17  beseq now fully incorporated with tarray
	 *  .16  carbon moved to tarrays in TauInc
	 *  .15  taux arrays now have all radiative info on a line,
	 * cleaned up print out for last page
	 *  .14  NC_ELL increase to 1500
	 *  .13  eold changed to enew in ionize, comment with tet 
	 *  .12  changed to outward only as default diffuse fields
	 *  .11  e2 in diffem for outward flux
	 *  .10  receff not evaluated for tau gt 5
	 *  .10  beginning of outward only approx
	 *  .09  no stimulated emission correction in OpacityAddTotal during thermal search
	 *  .08  now drChange and didh, drChange returned to 0.15, didh=0.1
	 *  .07  work on HeII bowen to get Paris PN right
	 *  .06  changed default drChange to .10 to get orion exact
	 *  .05  two photon emission of helium now exact
	 *  .04  more work on HeI emission
	 *  .03  closed shell dielec recomb fixed
	 *  .02a heII two photon emission
	 *  .02  further work on HeI diffuse fields
	 *  .01  hei trip to ground one photon decay added to outward beam
	 *  .00a new threshold energies for Al 6 and Ne 9 (VERY small change)
	 *85.00  try to upgrade amoeba routine to press et al sec edition
	 *84.10a lgDHetOn, lgDColOn, lgPhysOK moved to zero out of block data
	 *84.09  error in declaration of Z in function ratabn
	 *84.08  error in excitation potential of [SiIX] IR lines
	 *84.07  original Reilman and Manson opacity for S+7 used instead of
	 * their revised one
	 * problem with negative globule when iterating fixed
	 * overflow in conset for intense continuum guarded against better
	 * wind error, change in velocity not computed correctly
	 * stop thickness did not work exactly
	 *84.06f in PDR, steps too big before H2 came in
	 *84.06e oscillation at depth in x-ray ionized dusty models
	 *84.06d set lgHe1ON and lgHe2ON to true in zero 
	 *84.06c collision strengths within 6D ground of FeII to Pradhan and Zhang '93
	 *84.06b changed CS data for Si II to Dufton and Kingston 91 - BIG change in
	 * 1814 CS
	 *84.06a added 3 more Si II lines, major change in CS for 1808 line
	 *84.06  Volk's continua were divided by nu^2 instead of nu in ffun1, */
	/* bug discovered by P van Hoof,
	 * problem with large scale fluctuations discovered by K Kwitter
	 *84.05h changed transfer of CII] 2326 against Balmer continuum
	 *84.05g transferred mgi 4561 since it becaume really strong in al lll models
	 *84.05f many small typoes discovered by running on cray
	 *84.05e bug in receff discovered by S. Schaefer
	 *84.05d cdsqte now always includes HI/1E4
	 *84.05c force reevaluation of H, HeI, HeII collisional terms when const temp
	 *84.05b damped oscillations in intermediate cosmic ray dominated case
	 *84.05a altered optical depth treat of oi ir line heating
	 *84.05  factor for OI pump by IR background off by 1
	 *84.04k problem with He+ trace ionization when cosmic ray ionized,
	 * and gas all neutral
	 *84.04j stat weight eror in OI 6300 optical depths
	 *84.04i problem with cosmic ray ionization dominated, totally netural limit
	 * traced down to product hn(1) * HII not Hi
	 *84.04h Steffen Schaefer found problem in interpretation of logs in
	 * table power law command
	 *84.04g Paul O'Brien found typo in HeI esc prob routine, did not affect results
	 *84.04f punch grain opacity command did not work
	 *84.04e overrun of optical depth scale caused oscillations at high density
	 * added depletion to metals command
	 *84.04d problem with low den ioniz continuity over 1000K break
	 *84.04c fixed oscillation in VERY high U models due to pair production
	 *84.04b change in helium ionzation dr logic for high U model oscillations
	 * added lgNxtDROff flag for nextdr services
	 *84.04a added comment to indicate how much He 23S photo was Lya
	 *84.04  new collision strengths for AlIII, AlII, SiIII, SiIV,
	 * those for Al are quite different
	 *84.03a yet more instabilities at very high densities cured
	 *84.03  instabilities at very high densities cured
	 *84.02f Kevin Volk's grey grains
	 *84.02e high density instabilities
	 *84.02d subtracted 3-body rec from diffuse part of heav el cont
	 *84.02c altered dr logic for very dense model oscillations
	 *84.00b damper on feii esc prob to stop h-ionization oscillations
	 *84.00a numerical instability in L-shell auger
	 *84.02  problem with extinguish command led to rewrite of flxfnt logic
	 *84.01a r1/r0 factor missing in one punch continuum
	 *84.01  line driving in winds not properly computed
	 *84.00d iostat not properly checked in Volk routines
	 *84.00c turned line acceleration back on
	 *84.00b problem with cdLine div by zero reference line intensity
	 *84.00a check for ZERO hbeta intensity for flour in comment.f
	 *84.00 Feb 13 93
	 *  .71 fixed instability in cooling flow cloud model
	 *  .70 cooling term from H + H+ => H2+
	 *  .69 logic for CO-dr in pdr models
	 *  .68 fully incoporated into model atom
	 *  .67 optical depths for hei 2.06 micron line
	 *  .66 revised collision cross sections for He+
	 *  .65 added Paul O'Brien's code to do two sided helium escape prob
	 *  .64 set so that heII cant be turned back on deep in neutral gas
	 *  .63 OpacityAddTotal now called within ionize, solved instability in blr.in
	 *  .62 bad pointer to Ca+ photoionization opacity fixed
	 *  .61 fixed bad pointer put in in ver .60
	 *  .60 altered matrix for L-shell ionization, broke out LSION
	 *  .59 computed collision strength for NaD
	 *  .58 separate ksion and lsion instead of xrion
	 *  .57 OI 6300, 6363 predicted independently, using each optical depth
	 *  .56 he singlets matrix only used if photoionization rate not zero
	 *  .55 new transit prob for NIII] 1750
	 *  .54 set nmap option in place
	 *  .53 table atlas, werner, both seem to work
	 *  .52 new version of Kevin Volk atlas routines, grid
	 *  .51 continuum pumping of 1240
	 *  .50 up to 10 stop line commands
	 *  .49 transferred svi 933
	 *  .48 Fred Hamonn's abundance set put in without documentation
	 *  .47 changed atlas91 format, file half as long
	 *1993
	 *  .46 minor bug in Lya esc prob when grid overrun, changed initial
	 *  Lya optical depth to 1e20 when none entered
	 *  .45 density dep for coll dis of H2, non-lte from dalgarno and roberge
	 *  .44 Kevin Volk's large atlas grid implemented
	 *  .43 new version of volk type 7 grains block data
	 *  .42 added more lines to fred's feii atom, now 373
	 *  .41 improved cs for H2+ + hnu => H + H+
	 *  .40 diffon totally removed, lgNewIon cleaned up, "diffue fields" cmd gone
	 *  .39 diffuse fields removed from code
	 *  .38 suprathermal excitation to n=4 of H added
	 *  .37 gamk added, slightly smaller heating due to K shell in neutral regions
	 *  .36 many bugs in secondary excitation of H lines discovered with M Voit
	 *  .35 conorm totally rewritten to linearize it, alpha ox on ratio command
	 *  .34 ratio command put in
	 *  .33 PUNCH RESULTS command, and the ability to read it, added
	 *  .32 move complete, no write(6 anywhere
	 *  .31 move write(6, to write(qq,
	 *  .30 derivative of cooling due to collisional ionization of H improved
	 *  .29 negative Ly-a cooling changed to heating
	 *  .28 print continuum in, final continuum printout no longer by default
	 *  .27 electron collis dest of H2+
	 *  .26 moved H2+ opacity over to opsv array
	 *  .25 electron collisional destruction of H2
	 *  .24 playing around with scale factor multiplying te in TFIRST
	 *  .23 ElecFrac for routine NOCKON is now ratio electrons to total nuclei,
	 *  had been to total hydrogen
	 *  .22 comment if Ca+ photo by Lyalpha ever important
	 *  .21 increases NLINES to 1000 everywhere
	 *  .20 updated transit prob for [FeII] lines
	 *  .19 more [FeII] lines added
	 *  .18 subroutine CDNOEX added to print header only
	 *  .17 STIMON removed, only NDUCON used for "NO INDUCED PROCESSES"
	 *  .16 htau was used for cont pumping of H lines instead of htnext
	 *  .15 a continuum of zero below 1/36 Ryd turned off occupation numbers
	 *  .14 small changes to get compton equil to work at very low, hi temp
	 *  on sparc station
	 *below end of Cambridge visit
	 *  .13 fine struc escape prob changed to de Jong et al 1980
	 *  .12 heating due to CII 157 micron
	 *  .11 error in implementing Tielens and Hollenbach neutrl collisions
	 *  .10 ion recombination of grain surfaces
	 *  .09 heavy element molecule column densities now computed
	 *  .08 co cooling
	 *  .07 cosmic ray ionization of helium now ok
	 *  .06 cosmic ray background doubled to agree with Tielens and Hollenbach
	 *  .05 CO fully molecular with feedback to carbon, cr ioniz of H2
	 *  .04 works for NO H-ionizing radiaion, PDR Tielens and Hollenbach
	 *  .03 cooling flow table continuum
	 *  .02 excited atom radiative association formation of H2
	 *below end of Ohio State, ver 82.31, June 19 1992
	 *  .31 cross section for FeXI 6.09 microns line was off by 100x
	 *  .30 maser cap changed to -20 optical depths
	 *  .29 cap on 911 ots field
	 *  .28 ism abundances added in .22 had wrong n
	 *  .27 option to add together weighted line intensities
	 *  .26 minor problem with grain heating entered into lines
	 *  .25 vary and log options added to turbulence command
	 *  .24 NIII 990 rad pump includes coll deexcit
	 *  .23 coments, warnings, etc, now printed in subroutine
	 *  .22 removed NLR abundances, put ISM in place
	 *  .21 new coll str for NIII 990 and NIII]1750
	 *  .20 all photo opacities fully converted to table look-up and plotted
	 *  .19 changed limits to d(EDEN) in IONIZE
	 *  .18 NaD in with coll str=1
	 *  .17 Ni rec, col ion, data up
	 *  .16 all opacities in, but not debugged, ni rec coef not yet right
	 *  .15 nickel in, but rec, coll data not right
	 *  .14 starting to put ni in
	 *  .13 sodium put in
	 *  .12 three more lines transferred
	 *  .11 /TAU/ broken up into many smaller blocks
	 *  .10 table look up up through magnesion for opacity
	 *  .09 changed opacity for niii 1750
	 *  .08 cooling due to collis ioniz-3 body of H, HE was wrong
	 *  .07 HJBAR now function calling array OccNumbIncidCont
	 *  .06 bowen lya problems again
	 *  .05 allowed number of pressure iterations increased to 20
	 *  .04 xopac is history, all in opsv
	 *  .03 all x-ray opacities now in main opacity array
	 *  .02 optical depths in Fred's FeII atom
	 *  .01 abs for vary match of line flux
	 *82.00 try to stabilize these changes
	 *  .49 problem with abundances sent to OPACIN recently introduced
	 *  .48 call to HExCOL moved to before if branch: sometimes
	 *  temp had changed a great deal after evaluation
	 *  .47 all outer shell opacities rationalized, cs not good yet
	 *  .46 second row now complete
	 *  .45 fixing frequency mesh for opacity
	 *  .44 mtrxin broken into recomb, ionization parts
	 *  .43 punch lines structure didn't work with other punch commands
	 *  .42 emission from AlII] doublet added
	 *  .41 collisional ionization of Helium cooling back in
	 *  .40 cleaned up some formatting
	 *  .39 change increment DTAU1 from .1 to .001
	 *  .38 bowen niii all done
	 *  .37 continuum pumping of "bowen" NIII lines
	 *  .36 energy density command for cont intensity
	 *  .35 zero out continuum below plasma frequency
	 *  .34 hydrogen goes fully atomic gracefully (?)
	 *  .33 stop if negative molecule abundances
	 *  .32 error in printed optical depth for sphere static, only printout
	 *  .31 freds improved list of feii lines included
	 *  .30 feii in on ots fields, abs by balmer continuum
	 *  .29 feii feed-back into sp population
	 *  .28 FeII pump by Ly-alpha in?
	 *  .27 feii pumping routines moving in
	 *  .26 big COOLNG is history, stack complete?
	 *  .25 second check that stack is ok
	 *  .24 all coolants in stack
	 *  .23 begin move to stack cooling function
	 *  .22 grain reradiation added as recombination to energy balance check
	 *  .21 residuals in vary for upper limit changed
	 *  .20 print sum option added, error in s3 branching ratio fixed
	 *  .19 few small bugs fixed
	 *  .18 bug in helium sec ioniz rate introduced in .09
	 *  .17 Blum and Pradhan cs for CII, NIII, OIV
	 *  .16 UNKN for rspec is history
	 *  .15 intensity command added
	 *  .14 more work on sorting out sqcm vs 4 pi
	 *  .13 several small changes with control interface
	 *  .12 metals vary grains abundances too
	 *  .11 large destruction prob when esp prob is one
	 *  .10 optimize trace implemented
	 *  .09 more work on SECMET sec ionization rate
	 *  .08 major problems with sefn of secion and secla
	 *  .07 added lots of CALL OpacityAddTotal to TFIRST
	 *  .06 induced He lines photo and cooling removed, was in 2x
	 *  .05 problem with induced opacity going to zero
	 *  for very low temp, ContBoltz is 0, energy not */
	/*  conserved for very low temp
	 *  .04 case B sum in HeI rec coef for very low temp
	 *  .03 very low temp ly-alpha now case b
	 *  .02 change NeV coll strength to Lennon and Burke
	 *81.01 photo cross sec for Fe o changed
	 *  .05 as debugged as its going to get
	 *  .04 two small fixes so density of 1e-5 works again
	 *  .03 grids smaller near Ca-Fe L-edges
	 *  .02 Brian Espey found compton underflow for low den clouds
	 *  .01 problem with covering factor command
	 *80.00 July 31, 1991, all four machines give same answer
	 *  .17 double precision error in hmole fixed
	 *  .16 caution if neg heav mole negative
	 *  .15 certain HeI and HeII variables not reset when no helium
	 *  .14 compiles on vax, comment if large c in molecules
	 *  .13 bug in setting outward fraction in radinc, conems
	 *  .12 improved ir ff heat response to dT
	 *  .11 default HII region abundances changed, Orion out
	 *  .10 numerious small changes on sun, back to cray
	 *  .09 wind problems on sun fixed
	 *  .08 O2 and O2+ both back in
	 *  .07 bug in HISTAG setting cap on NFLUX instead of NUPPER
	 *  .06 lots of work on CO molecules
	 *  .05 C+ now in heavy molecule balance
	 *  .04 massive collisional ionization cs update
	 *  .03 starting to put in CO, etc
	 *  .02 table star now in vary
	 *  .01 subroutine for calling code as sub now set
	 *79.00 May 20, 91, small fixes to get sun, cray to agree
	 *  .76 all heavy elements reeval in main ioniz loop always
	 *  .75 change cell size near 10,000 ryd to 10 percent
	 *  .74 increased lowest temp for h matrix to 400k
	 *  .73 bug that only happened on 32-bit machines fixed
	 *  .72 pointer for al opacity off, attenuated 3.8R continuum
	 *  .71 several small problems, dust now grain in commands
	 *  .70 several problems with molecules fixed
	 *  .69 cells reworked with dust
	 *  .68 dust now rewritten with sense
	 *  .67 CEXTRA added
	 *  .66 amoeba range, increment options changed
	 *  .65 heating terms in electron coll with grains corrected
	 *  .64 ncell increased to 600, dust grid finer
	 *  .63 bug in dust cooling
	 *  .62 radius book-keeping changed to double precision
	 *  .61 Fe Ka divided into hot and cold
	 *  .60 code checks that R+dR not equal to R
	 *  .59 all radius variables moved to new sub, NEWRAD
	 *  .58 rewrite d(Temp) zoning
	 *  .57 pointers to H, He, and He+ psuedo-states were off
	 *  .56 bug in H- emission for low temp
	 *  .55 more changes in choice of DR for globule
	 *  .54 covering factor now covgeo, covrt, brmfac is always 0.5
	 *  .53 change in choice of dr
	 *  .52 covering factor added correctly
	 *  .51 covering factor added
	 *  .50 4 ionizing lines added outward only
	 *  .49 three nebular approx ionizing lines added transfer
	 *  .48 added gaunt free-free for He+
	 *  .47 OVI 1034 in outward beam
	 *  .46 Fe K-a Auger added in outward only
	 *  .45 TMN sorted out
	 *  .44 some ionizing Si, Mg lines added in
	 *  .43 all rest heavy elemnt rec lines
	 *  .42 Ly lines of C, O, and Fe in outward only
	 *  .41 iron included in ots
	 *  .40 still more ionizing iron lines in outward only
	 *  .39 C, O, Fe, rec in outward only for sphere
	 *  .38 HeII rec to n=2 as Milne-relation continuum
	 *  .37 really stupid typo in reset of occupation numbers on iteration
	 *  .36 some uv fe lines in outward approx
	 *  .35 bug in continuum emission due to H n=9 pseudo-state
	 *  .34 several bugs on iteration with variables not reset
	 *  .33 zone thickness now checks for dr
	 *  .32 definition of effective optical depth bad on first iteration
	 *  .31 several trivial bugs fixed after HII region crash at rice
	 *  .30 contin renorm in interpolate after OBrien crash
	 *  .29 OI presses on when negative populations found
	 *  .28 stop effective column changed back to 1kev due to O K-edge
	 *  .27 option to read in any slope with TABLE POWER LAW
	 *  .26 helium in bound electron scattering
	 *  .25 OI back reaction in as difference
	 *  .24 sub-millimeter break in agn table changed to 10 microns
	 *  .23 FeIX 245 in; OI back-effect on HI not included
	 *1990 below
	 *  .22 ots OI fields all in, ADDOTS defined
	 *  .21 oxygen model atom seems to work
	 *  .20 OI now six level atom
	 *  .19 abundances no dust no longer changes abundances of depleted elements
	 *  .18 multiple numbers on vary generated line, HDEN now thichness or radius
	 *  .17 put OTS continua from C, O back in as source of ionization
	 *  .16 Bowen 660 ots bug introduced in .14 fixed
	 *  .15 c, o rec continua back in, all otslin, otscon
	 *  .14 He ots fields fully looped, checking for overlap in pntset
	 *  .13 CONOTS split into OTSCON and OTSLIN
	 *  .12 bug introduced in .10 fixed
	 *  .11 OIII 5007/4959 ratio four not three; bug for about 6 months
	 *  .10 all helium lines OTS, destruction
	 *  .09 line center opacity for OIII 1666 10 times too small
	 *  .08 cooling due to hydrodynamic expansion
	 *  .07 option to iterate until it converges
	 *  .06 H state specific recombination cooling over wide range of temp
	 *  .05 exact form of H rad rec coef
	 *  .04 hydrogen absorption, emission, now up to n=9
	 *  .03 Pradhan's hydrogenic cros sec in for H, He+
	 *  .02 formally correct hydrogen continuum escape prob
	 *  .01 Hummer escape prob did not go to 1 at zero optical depth
	 *78.00 Nov 13 90, all checks running ok?
	 *  .42 bound compton heat now included for all ionization levels
	 *  .41 optimize column densities fully implemented
	 *  .40 mean ionization arrays from original Camb version to logical one
	 *  .39 bug introdcued in resizine flux, pointer to Lyman line above LyCon
	 *  .38 bug in computation of wind velocity
	 *  .37 change H optical depths from Hummer to me
	 *  .36 RECEFF for all helium states
	 *  .35 TAUTOT now in and out, RECEFF just pointer
	 *  .34 carbon, oxygen outward killed
	 *  .33 made opacity array defined for all freq no matter what nflux
	 *  .32 debugged Hummer escape for Ly-a
	 *  .31 move to Hummer Lya escape, dest prob
	 *  .30 numerical arry to 100MeV; compton, pair now exact
	 *  .29 now passes induced test for He; bug in cont pump esc prob
	 *  .28 OPSAV is history
	 *  .27 all he reference to opsav gone
	 *  .26 many non-he opac  sources changed from OPSAV to OPSV
	 *  .25 only evaluate OPAC0 on first shot at code
	 *  .24 yet another H opacity pointer bug introduced in .17
	 *  .23 optimize line intensities included
	 *  .22 H induced cooling array was not zeroed at start of iteration
	 *  .21 array telling if line added heat, cool, or intensity
	 *  .20 T912 on zone print now total aborption optical depth
	 *  .19 change printout of AMOEBA routine, range option
	 *  .18 He opac bug introduced in ver .17 fixed; OPSV array one dimen
	 *  .17 effective x-ray optical depth now 0.5 kev not 1 kev, H opsv array
	 *  .16 HeI oscillations of dest prob in high density models
	 *  .15 read in table of points
	 *  .14 readjusted frequency partition; dust probably wont work now
	 *  .13 explicit E2 function written, Harrington version deleted
	 *  .12 change Hummer PESCK2 to my ESA0K2
	 *  .11 EOVRLP back to original state
	 *  .10 H continuum goes to LTE within few percent
	 *  .09 correc to He sing pop, trip pop, in opacity scale
	 *  .08 He ground rec in diffus, ionizing rad not added to conots
	 *  .07 "reflected" continuum supposed to be in with exp integral
	 *  .06 options to read arrays or do IO for calling as sub
	 *  .05 optimize seems to work
	 *  .04 all Bob's subs in place for optimize
	 *  .03 all input lines now into KARDSV first, then read array
	 *  .02 line width constant core for 8446 problem
	 *  .01 gaunt factor of nu**-0.2 added to brems
	 *77.00 minor change in dust common block, now DSTAP and DSTAP1
	 *  .03 more minor changes, get map to work
	 *  .02 last day at JILA, a trivial chagnge, orion paper submitted
	 *  .01 remesh continuum between 8 and 10 eV to stop grain pot oscil
	 *76.00 final Orion Models
	 *  .63 checking on dielec rec for sulphur
	 *  .62 7th grain added
	 *  .61 change in 374 pumping of HeII
	 *  .60 grain recombination cooling of gas
	 *  .59 collisional heating of grain in
	 *  .58 six grain types now in
	 *  .57 function hlnop gone, now just summed into conots
	 *  .56 BUG - FillFac not mult DRNEXT in TauInc
	 *  .55 CIV 1540 destruction by Balmer continuum
	 *  .54 BIG BIG CHANGE in LyA/Hbet due to Hummer beta*F(beta) function
	 *  .53 many small bugs in h line photoionization
	 *  .52 0.5 - 1 ryd continuum three times higher resolution
	 *  .51 many small changes in NEXTDR to stop TE fail, better H line ioniat
	 *  .50 all hydrogen now HNET and HDEST included, along with CONOTS
	 *  .49 all lines now humer k2
	 *  .48 bound free continuum in optical and ir vastly improved
	 *  .47 line destruction probabilities now Hummer function
	 *  .46 helium now rid of all E1 fun for IR continua
	 *  .45 free-free heating cooling now uses real ff tau
	 *  .44 Lyman lines now K2 by default
	 *  .43 K2 now default for hydrogen subordinate lines
	 *  .42 h levels 3 - 7 now done correctly for photo effects
	 *  .41 better Rayleigh scattering cross sections
	 *  .40 Humer K2 function for H subordinate lines
	 *  .39 scattering opacity now half in dI propto dTau
	 *  .38 start moving to HDEN is total hydrogen nuclei in all forms;
	 *  .37 lgDustOn1 used to turn off individual dust grains
	 *  .36 first shot at Peter's reworking of grain heating
	 *  .35 Q's defined always before cap
	 *  .34 bug in calculation of nFnu in lines
	 *  .33 new SOLAR abundances
	 *  .32 lots of bugs in pressure; loop now keeps const to 2 percent
	 *  .31 all OPSVMM removed
	 *  .30 both emission and opacity in for HeII free bound
	 *  .29 bound free opacities in for hydrogen n=3,6
	 *  .28 Kevin Volk PN silicate grain opacity function now in as 3rd dust
	 *  .27 H- radiative assoc now series of approximations; LTE pop better for mol
	 *  .26 several more LINEAR options added
	 *  .25 CI mm lines  in, molecules work? H2+ shielding
	 *  .24 breaking finished
	 *  .23 plot broken up into pieces
	 *  .22 fine structure line pumping now in
	 *  .21 reflected beam now in
	 *  .20 warn if mole not done, neiii fs156 was not in array
	 *  .19 two pop of dust in photo threshold
	 *  .18 attenuation of HeI pump by continuum */
	/*  .17 change resion to OTS, put into conots
	 *  .16 static now works
	 *  .15 Q now defined in terms of correct dust area for cap or abs
	 *  .14 fractional bit, interpolated potential, now in
	 *  .13 electron vel in grain recombin wrong; now larger
	 *  .12 grain heating bug fixed
	 *  .11 punch continuum now same units as continuum flux in output
	 *  .10 STATIC now works on iteration for all lines
	 *  .09 background opacity destruction of 10830; STATIC defined
	 *  .08 now TAUTOT, TAUABS, and TAUSCT arrays
	 *  .07 dust reemission missed factor of 4pi
	 *  .06 now print temp of rad fields every zone
	 *  .05 neutron command now more standard, efficiency added
	 *  .04 sec ioniz due to neutrons included
	 *  .03 bug in effect col den printed where sphere set
	 *  .02 NEXTDR now looks at change in temp also
	 *  .01 OTSCap now command
	 *75.00 stop effective column; major debugging completed
	 *  .23 dust heating reduced by Draine factors
	 *  .20 wind line optical depths fixed (big bug), "u" before Te
	 *  .19 new Kurucz model atmospheres
	 *  .18 now 10 tables ok
	 *  .16 HOUTON killed, no hydrogen outward command
	 *  .15 helium continuum masing made stable for HII region
	 *  .14 dust sticking prob, photo yield, changed
	 *  .05 everything works? (fixed 3-body bug, eden bug for cold phase)
	 *  .04 he bug traced to numerical instability in matrix error, OK?
	 *  .02 Q's now in for dust, effective area per proton too
	 *  .01 HII/HI now variable H2OVH1, use all six low n
	 *74.00 RIDGE crash; move onto CRAY, everything OK with INDEF, dynamic mem
	 *  .53 COOLR broken up into each element
	 *  .52 plot map of heating cooling
	 *  .51 TALK now included in PUNT
	 *  .49 SPTYPE changed from integer to word, laser should work exact Q
	 *  .48 some fixes to array pointers; IPOINT now works new way
	 *  .47 NCELMM is history
	 *  .46 NCELMM not used except except in COMMON
	 *  .45 all heavy element pointers now on NCELMM+NC_ELL scale
	 *  .44 HeI singlet opacity bug introduced in .43 fixed
	 *  .43 helium pointers now go to NCELMM+NC_ELL, but answer is wrong
	 *  .42 IPOINT now runs to NCELMM+NC ELL
	 *  .41 OPSAV now NCELMM+NC ELL
	 *  .40 no array(NCELMM) in code now; doesn't work though
	 *  .39 no more mm vs uv in setup
	 *  .38 more changes to get rid of anumm
	 *  .36 warnings if density very small and dC/dT zero
	 *  .35 warn if maser very thick, sphere comments corrected
	 *  .34 stop optical depth command
	 *  .33 photoelectric heating of gas by dust
	 *  .32 DRMIN problem, now nu*f_nu at 912 in header
	 *  .31 OTS helium field induced recombination, cooling
	 *  .30 change in EOVLAP caused RESION to be misdefined in COOLR
	 *  .29 helium ots fields not defined correctly for very low temper
	 *  .28 bug; extin command did not affect contin saved for second iteration
	 *  .27 adjusted behavior of HE2LEV in low temp limit
	 *  .26 ISM option for TABLE command, from Black 1987
	 *  .25 Orion dust option, cap on dust opacity
	 *  .24 force due to incident continuum now printed
	 *  .23 magnitudes now printed, slant angle also
	 *  .22 S+ cross section to Mendoza background
	 *  .21 now print NeN+ dl, without temp
	 *  .20 print options added
	 *  .19 HeI two photon in outward beam
	 *  .18 TABLE STAR MIHALAS now in for log(g) = 4
	 *  .17 grain charge, ionization potential, now consistent
	 *  .16 Draine and Salpeter grain charge, drift vel
	 *  .15 minor fixes after VAX and CRAY runs
	 *  .14 Bowen set to 0.5, ContDiff defined
	 *  .13 heii bowen depletion of ly-a included
	 *  .12 H-beta flux for test hot PN exact agreement with Harrington
	 *  .11 HeI, II Ly-a OTS, CONOTS array, Lyman dst prop in both
	 *  .10 he works well for large densities, singlets off by 2 for largel rad
	 *  .09 triplet - singlet coupling
	 *  .08 sort of runs on Cray with Indef
	 *  .07 statistical weights OK for HeI singlets, goes to LTE
	 *  .06 try to get HeI to LTE in high photon limit
	 *  .05 minor problems fixed
	 *  .04 HeII lines added, test against Seaton case B
	 *  .03 n=1, 2 state photo included for HeI singlets
	 *  .02 error in As for two phot, WIDFLX not included
	 *  .01 initial induced two photon rate
	 *73.00 HeII goes to LTE both high phot and H density
	 *  .28 adjusted rec to HeII n=2 to get exactly right departure coef
	 *  .27 HeII goes to LTE in hi-gam limit, photo cross sec was off
	 *  .26 sort of runs on Cray with indef
	 *  .25 multiple lgHeBug options
	 *  .24 HeII goes to LTE, but atomic data wrong
	 *  .23 much confusion about helium
	 *  .22 LINDST includes LINADD; DSTRAD cleaned up
	 *  .21 default inner, outer radii changed
	 *  .20 AS => HYAS
	 *  .19 some minor changes in hydrogen
	 *  .18 NLR abundances
	 *  .17 GLOB, outward dust line interaction
	 *  .16 much confusion about dust
	 *  .15 fixed plot, new cs from peter martin
	 *  .14 two dust temps work, but not yet Ly-alpha
	 *  .13 dust temp works
	 *  .12 first edition of spline dust cross section, 1 abs only
	 *  .11 hydrogen HLNOPC now uses full opacity array
	 *  .10 dust now in its own array, NDUST used, scatter+abs OK
	 *  .09 reorganized RFIELD so IR, UV arrays are adjacent
	 *  .08 HeI 584 radiation pressure
	 *  .07 WIDFLX defined consistently; HEVAL defined
	 *  .06 Mgo + H+ => Mg+ + Ho charge transfer from Allan et al. 88
	 *  .05 all temp are logs if 10 or below
	 *  .04 IRCOIL misspelled in loop for soft ionizing scattering opacity
	 *  .03 further improve on 304 rad press; two sided esc kept now
	 *  .02 FIREBALL command, final few fixes for Compton limit
	 *  .01 minor changes in ANU array for Compton limit
	 *72.00 full log scale for UV array, IPOINT works in both regimes
	 *  .21 lowest frequency changed to 1E-5 Ryd
	 *  .20 EDEN added, tuning EMM
	 *  .19 bug in DA when temperatures near 10K
	 *  .18 trying to bet 34K blackbodies to work
	 *  .17 rough induced Compton heating included for T=10^9K
	 *  .16 IR continuum Comptonization now zone by zone, cell by cell
	 *  .15 Crab Nebula continuum added to TABLE command
	 *  .14 TAUMN chanced to TMNUV, TMNMM defined for IR array
	 *  .13 cleaned up several aspects of wind; passes e- only tests
	 *  .12 RFORCE was not included in acceleration
	 *  .11 RECEFF now works for 50,000K and Balmer continuum
	 *  .10 HTOT now only evaluated from PHEAT
	 *  .09 heating was being changed in IONTE loop incorrectly
	 *  .08 CSUPRA was on when EDEN/(H+HE) < 0.95; now ratio is E/H only
	 *  .07 low energy cutoff in power law command
	 *  .06 FirstDR changed to take stop ionized and neutral into account
	 *  .05 STOP IONIZED and NEUTRAL column density
	 *  .04 cleaned up luminosity option, dump lines,
	 *  .03 rewrite lumin renorm, now default is total lumin, t=3K works
	 *  .02 approximations for H, He ground state rec ceof
	 *  .01 check whether opac(NH)=0 in DIFOTS (fix crash at T=10**9K)
	 *71.00 gaunt factors for UV arrays
	 *  .02 define DERROR in IONTE, include D(Heat)/dT always
	 *70.00 all OK?
	 *  .62 con dest XYZ, optical depth F12
	 *  .61 opacity due to bound electron scattering
	 *  .59 Hummer gaunt now in for IR array
	 *  .58 Boltz fact now 4 parts, not always evaluated
	 *  .56 Steward (79) cross section for HeI 23S, 2x bigger
	 *  .55 HeI ground state diffuse fields counted twice
	 *  .53 electron scattering treated as 1/tau not e-tau
	 *  .48 H-line heating now corrected for dust cross section
	 *  .47 optical depths for [CI] [OI] lines, SiVII added
	 *  .46 wrong A for CaII K
	 *  .45 thermal dust emission in IR array
	 *  .44 all H- processes have back reactions
	 *  .42 better opacities for H-, induced, spon, but not in yet
	 *  .41 H- changed to Lites and Mihalas
	 *  .39 defined far numerical array, Kindgon Ca charge transfer
	 *  .36 CaII IR trip with complete redis
	 *  .35 change to esc prob with a's
	 *  .34 H 7-8 opacity added
	 *  .33 H- heating added
	 *  .29 Koristas numbers for iron line pumping
	 *  .28 hydrogen self ionization now in
	 *  .27 problem with ionizat stage pointers on iteration
	 *  .26 calcium 5-level atom ok(?)
	 *  .21 dust emission in line array, abund in FINAL ok for faint
	 *  .19 corrected neg sign error in FCHEI, elec den converg
	 *  .18 added f(nu) option for luminosity
	 *  .15 2-pt Gaussian quad for CONSET freq integ
	 *  .12 Si II fs collision strength from Keenan et al.
	 *  .11 Helium now modularized, but HEONE still separate
	 *  .07 bug in free-free heating rate
	 *69.00 end of Cambridge stay
	 *  .27 Ly-beta had overlap rate, not emission rate, in line printout
	 *  .26 Lyman continuum astrophysical flux now predicted
	 *  .25 heavy element collision ionization now separate coolant
	 *  .23 induced Compton scatter for numerical array
	 *  .22 fix several bugs introduced along the way, added Occ, Tbr printout
	 *  .18 cooling due to induced rec
	 *  .17 free-free heating
	 *  .16 heating due to n>=3 of hydrogen
	 *  .15 induced rec and photoioniz from level 7
	 *  .14 induced processes for all H lines
	 *  .12 three body rec to He, departure coef defined
	 *  .11 continuum does not HAVE to be fully defined, warning results
	 *  .10 continuous opacity scale corrected for induced rec
	 *  .09 induced rec to 1, 2
	 *  .08 induced rec to n=3,6 of hydrogen
	 *  .07 full optical depths for O5 630, Ne8 774
	 *  .05 logic error in stop for line strength
	 *68.01 vary HTOT in IONTE when only H changed
	 *67.00 IBM version - OK
	 *  .43 Berrington and Kingston He I rates
	 *  .33 escape prob for fine structure lines; optical depth scale fixed
	 *  .29 rework Fe II and Mg II photo onto n=2 (small numer chan)
	 *  .28 8446 on n=3 pop
	 *  .24 BIG bug in defn of outer optical depths
	 *  .13 heavy element brems now from Harrington '82 pn paper
	 *66.00 ten level hydrogen atom
	 *  .04 cs for Mg3+ Mg4+ from Mendoza ann Zeippen 1987
	 *  .03 Pequignot and Aldrovandi fits to rad rec for t<1000
	 *65.00 three body rec coef from S. Cota
	 *64.00 PAIR PRODUCTION!!!  also extend nu to 100 MeV
	 *  .01 calcium and aluminum
	 *63.00 made c a subroutine, exch coll for he to berrington et al, setup>3 */

#	ifdef DEBUG_FUN
	fputs( " <->AAAA()\n", debug_fp );
#	endif
	return;
}

