/*main program that calls cloudy when used as a stand-alone program */
#include "c:\projects\cloudy\current\source\cddefines.h"
#include "c:\projects\cloudy\current\source\cddrive.h"

/*int main( int argc, char *argv[] )*/
int main( void )
{
	int lgOK ;
	double hdenLimit , hdenInit , hden, TeInc ,
		r5007,r4363,r1665,ro3_88,ro3_52, r1661 ,
		absolute , temp, TeLimit, TeInit , hdenInc ;

	FILE *ioOUT , *ioDATA ;
	char chLine[100];

	/* this is limit to the number of command chLines we can still put in */
	long int nleft;

	if( (ioOUT = fopen("varyNT.out","w")) == NULL )
	{
		printf(" could not open varyTF.out for writing.\n");
		exit(1);
	}

	/* calculation's results will go to this file*/
	if( (ioDATA = fopen("varyNT.txt","w")) == NULL )
	{
		printf(" could not open varyTF.txt for writing.\n");
		exit(1);
	}

	/* the range of density, and the increment in density, for this grid */
	hdenInit = 0.;
	hdenLimit = 7.;
	hdenInc = 1.;

	/* the range of temperatures for the grid */
	TeInit = 5000.;
	TeLimit = 30000.;
	/* multiplicative inc */
	TeInc = 1.5;

	/* set the density and temperature to the initial values */
	hden = hdenInit;
	temp = TeInit;

	/* print the header for the data file */
	fprintf(ioDATA,
		"density\ttemp\tOIII 5007\t4363\t1665\t88\t52\t1661\n");

	while( hden < 1.01 * hdenLimit )
	{
		while( temp < 1.01*TeLimit )
		{

			/* initialize the code for this run */
			cdInit();

			/* direct the standard output to this file */
			cdOutp(ioOUT);

			/* option to not execute the code, uncomment when debugging setup */
			/*cdNoexec( );*/

			/* gas temperature for this calculation */
			sprintf(chLine,"constant temperature %f", temp);
			nleft = cdRead( chLine  );

			/* gas density for this calculation */
			sprintf(chLine,"hden %f", hden);
			nleft = cdRead( chLine  );

			/* only want the first zone */
			nleft = cdRead( "stop zone 1 "  );

			/* speed up calculation by not included some elements and lines */
			nleft = cdRead( "init file \"fast.ini\" "  );

			nleft = cdRead( "normalize to \"o  3\" 5007 "  );

			/* an incident continuum must be specified to get the code
			 * to run at all - not very important since we will set
			 * the gas temperature */
			nleft = cdRead( "blackbody 40000  "  );
			nleft = cdRead( "ionization parameter -3  "  );

			/* actually call the code */
			lgOK = cdDrive();
			/* flush the output so we see it on the screen */
			fflush(ioOUT );

			fprintf(ioDATA,"%.3e\t%.3e",	hden, temp );
			fprintf(stderr,"%.3e\t%.3e",	hden, temp );

			/************************ O III ******************/
			lgOK = cdLine( "O  3", 5007 , &r5007 , &absolute );
			if( lgOK==FALSE )
				printf("did not find O  3 5007\n");
			/* this should be unity */
			fprintf(ioDATA,"\t%.3e",	r5007 );
			fprintf(stderr,"\t%.3e",	r5007 );

			lgOK = cdLine( "totl", 4363 , &r4363 , &absolute );
			if( lgOK==FALSE )
				printf("did not find totl 4363\n");
			fprintf(ioDATA,"\t%.3e",	r4363 );
			fprintf(stderr,"\t%.3e",	r4363 );

			lgOK = cdLine( "totl", 1665 , &r1665 , &absolute );
			if( lgOK==FALSE )
				printf("did not find totl 1665\n");
			fprintf(ioDATA,"\t%.3e",	r1665 );
			fprintf(stderr,"\t%.3e",	r1665 );

			lgOK = cdLine( "O  3", 883300 , &ro3_88 , &absolute );
			if( lgOK==FALSE )
				printf("did not find O  3 88\n");
			fprintf(ioDATA,"\t%.3e",	ro3_88 );
			fprintf(stderr,"\t%.3e",	ro3_88 );

			lgOK = cdLine( "O  3", 518000 , &ro3_52 , &absolute );
			if( lgOK==FALSE )
				printf("did not find O  3 52\n");
			fprintf(ioDATA,"\t%.3e",	ro3_52 );
			fprintf(stderr,"\t%.3e",	ro3_52 );

			lgOK = cdLine( "O  3", 1661 , &r1661 , &absolute );
			if( lgOK==FALSE )
				printf("did not find O  3 1661\n");
			fprintf(ioDATA,"\t%.3e",	r1661 );
			fprintf(stderr,"\t%.3e",	r1661 );


			/************************* end lines with lf and flush it ***************/
			fprintf(ioDATA,"\n" );
			fflush(ioDATA );
			fprintf(stderr,"\n" );

			temp *= TeInc;
		}
		temp = TeInit;
		hden += hdenInc;
	}

	puts( "[Stop in varyTF]" );
	exit(0);
}

