#!/usr/bin/perl -w
#
# all statement starting with a # are comments
#
# look for botched asserts and warnings,
# and check for models that did not end.
# summary of errors will be in checkall.txt
#
# execute this script from within the directory where the
# *.out files live.  The following command should work:
# perl checkall.pl
#

# flag to remember whether we found problems
$lgProblems = 0;

print( "About to look for botched results and warnings:\n");

# find "BOTCH " and "W-" string in all the output file and write
# corresponding line into checkall.txt file.
system "grep Botched  *.out >checkall.txt";
system "grep W-  *.out >> checkall.txt";
# system "grep PROBLEM *.out >> checkall.txt";

# if this file has non-zero length, we detected a problem
if( -s "checkall.txt")
{
  print STDERR "\n WARNING! botchs, warnings or problems were found. \n Check the file checkall.txt for a list of names, checkall.asr for the asserts.\n\n";      
  system "grep Cloudy < checkall.txt ";
  system "grep botch  *.out >checkall.asr";
  $lgProblems = 1;
}
else
{
	print "\nno problems so far ...\n\n";
}
    
# check all output files to see whether they contain "Cloudy ends:"
# string and write corresponding line into checkend.txt file.
# if size of file $o_dir/checkend.txt is zero, then program crashed.  

printf( "now looking for models that did not end:\n");

$nMod = 0;
while(defined($output= glob("*.out")) )
{
	++$nMod;
	system "grep 'Cloudy ends'  $output >checkend.txt";
	printf( "n");

#	if zero length, code did  not end
	if(-z "checkend.txt")
	{
	  printf( STDERR "\n Cloudy crashed in:%s \n" , $output );      
	  system "echo crash in $output >> checkall.txt ";
  	  $lgProblems = 1;
	}
}
printf( "\n %i models were checked.\n ",$nMod);

if( $lgProblems )
{
	print "\n problems were found, see checkall.txt for summary\n\n ";
}
else
{
	print "\n\nCongratulations!! No problems were found\n\n";
}
