/*ZeroAbund set initial abundances for different mixes */
#ifdef _MSC_VER
#	pragma warning( disable : 4305 )/* disable bogus const double to float in MS VS*/
#endif
#include "cddefines.h"
#include "abundances.h"
#include "zero.h"

void ZeroAbund(void)
{
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ZeroAbund()\n", debug_fp );
#	endif

	/* solar abundances Grevesse and Anders 1989, Grevesse and Noel 1993 */
	abundances.SolarSave[ipHYDROGEN] = 1.0;
	abundances.SolarSave[ipHELIUM] = 0.100;
	abundances.SolarSave[ipLITHIUM] = 2.04e-9;
	abundances.SolarSave[ipBERYLLIUM] = 2.63e-11;
	abundances.SolarSave[ipBORON] = 7.59e-10;
	abundances.SolarSave[ipCARBON] = 3.55e-4;
	abundances.SolarSave[ipNITROGEN] = 9.33e-5;
	abundances.SolarSave[ipOXYGEN] = 7.41e-4;
	abundances.SolarSave[ipFLUORINE] = 3.02e-8;
	abundances.SolarSave[ipNEON] = 1.17e-4;
	abundances.SolarSave[ipSODIUM] = 2.06e-6;
	abundances.SolarSave[ipMAGNESIUM] = 3.80e-5;
	abundances.SolarSave[ipALUMINIUM] = 2.95e-6;
	abundances.SolarSave[ipSILICON] = 3.55e-5;
	abundances.SolarSave[ipPHOSPHORUS] = 3.73e-7;
	abundances.SolarSave[ipSULPHUR] = 1.62e-5;
	abundances.SolarSave[ipCHLORINE] = 1.88e-7;
	abundances.SolarSave[ipARGON] = 3.98e-6;
	abundances.SolarSave[ipPOTASIUM] = 1.35e-7;
	abundances.SolarSave[ipCALCIUM] = 2.29e-6;
	abundances.SolarSave[ipSCANDIUM] = 1.58e-9;
	abundances.SolarSave[ipTITANIUM] = 1.10e-7;
	abundances.SolarSave[ipVANADIUM] = 1.05e-8;
	abundances.SolarSave[ipCHROMIUM] = 4.84e-7;
	abundances.SolarSave[ipMANGANESE] = 3.42e-7;
	abundances.SolarSave[ipIRON] = 3.24e-5;
	abundances.SolarSave[ipCOBALT] = 8.32e-8;
	abundances.SolarSave[ipNICKEL] = 1.76e-6;
	abundances.SolarSave[ipCOPPER] = 1.87e-8;
	abundances.SolarSave[ipZINC] = 4.52e-8;

	/* Nova Cyg 75 abundances, C, O, NE UP 20, NIT UP 100, REST SOLAR AR */
	abundances.anova[ipHYDROGEN] = 1.0;
	abundances.anova[ipHELIUM] = 0.098;
	abundances.anova[ipLITHIUM] = 2.04e-9;
	abundances.anova[ipBERYLLIUM] = 2.6e-11;
	abundances.anova[ipBORON] = 7.60e-9;
	abundances.anova[ipCARBON] = 9.4e-4;
	abundances.anova[ipNITROGEN] = 9.8e-3;
	abundances.anova[ipOXYGEN] = 1.7e-2;
	abundances.anova[ipFLUORINE] = 3.02e-8;
	abundances.anova[ipNEON] = 2.03e-3;
	abundances.anova[ipSODIUM] = 2.06e-6;
	abundances.anova[ipMAGNESIUM] = 3.80e-5;
	abundances.anova[ipALUMINIUM] = 2.95e-6;
	abundances.anova[ipSILICON] = 3.55e-5;
	abundances.anova[ipPHOSPHORUS] = 3.73e-7;
	abundances.anova[ipSULPHUR] = 1.62e-5;
	abundances.anova[ipCHLORINE] = 1.88e-7;
	abundances.anova[ipARGON] = 3.63e-6;
	abundances.anova[ipPOTASIUM] = 1.35e-7;
	abundances.anova[ipCALCIUM] = 2.29e-6;
	abundances.anova[ipSCANDIUM] = 1.22e-9;
	abundances.anova[ipTITANIUM] = 8.60e-8;
	abundances.anova[ipVANADIUM] = 1.05e-8;
	abundances.anova[ipCHROMIUM] = 4.84e-7;
	abundances.anova[ipMANGANESE] = 3.42e-7;
	abundances.anova[ipIRON] = 4.68e-5;
	abundances.anova[ipCOBALT] = 2.24e-9;
	abundances.anova[ipNICKEL] = 1.76e-6;
	abundances.anova[ipCOPPER] = 1.87e-8;
	abundances.anova[ipZINC] = 4.52e-8;

	/* primordial abundances */
	abundances.aprim[ipHYDROGEN] = 1.0;
	abundances.aprim[ipHELIUM] = 0.072;
	abundances.aprim[ipLITHIUM] = 1e-10;
	abundances.aprim[ipBERYLLIUM] = 1e-16;

	for( i=4; i < LIMELM; i++ )
	{
		abundances.aprim[i] = 1e-25;
	}

	/* typical ISM abundances, mean of Table 3, Cowie+Songaila, Ann Rev '86
	 * also Table 5, Savage and Sembach, Ann Rev 1996 */
	abundances.aism[ipHYDROGEN] = 1.;
	abundances.aism[ipHELIUM] = 0.098;
	abundances.aism[ipLITHIUM] = 5.4e-11;
	abundances.aism[ipBERYLLIUM] = 1e-20;
	abundances.aism[ipBORON] = 8.9e-11;
	abundances.aism[ipCARBON] = 2.51e-4;
	abundances.aism[ipNITROGEN] = 7.94e-5;
	/* >>chng >>01 feb 19, from 5.01e-4 to 3.19e-4, value from */
	/* >>refer	O	abundance	Meyers, D.M., Jura, M., & Cardelli, J.A., 1998, ApJ, 493, 222-229 */
	/* they quote 3.19 +/- 0.14 e-4 */
	abundances.aism[ipOXYGEN] = 3.19e-4;
	abundances.aism[ipFLUORINE] = 1e-20;
	abundances.aism[ipNEON] = 1.23e-4;
	abundances.aism[ipSODIUM] = 3.16e-7;
	abundances.aism[ipMAGNESIUM] = 1.26e-5;
	abundances.aism[ipALUMINIUM] = 7.94e-8;
	abundances.aism[ipSILICON] = 3.16e-6;
	abundances.aism[ipPHOSPHORUS] = 1.6e-7;
	abundances.aism[ipSULPHUR] = 3.24e-5;
	abundances.aism[ipCHLORINE] = 1e-7;
	abundances.aism[ipARGON] = 2.82e-6;
	abundances.aism[ipPOTASIUM] = 1.1e-8;
	abundances.aism[ipCALCIUM] = 4.1e-10;
	abundances.aism[ipSCANDIUM] = 1e-20;
	abundances.aism[ipTITANIUM] = 5.8e-10;
	abundances.aism[ipVANADIUM] = 1.0e-10;
	abundances.aism[ipCHROMIUM] = 1.0e-8;
	abundances.aism[ipMANGANESE] = 2.3e-8;
	abundances.aism[ipIRON] = 6.31e-7;
	abundances.aism[ipCOBALT] = 1e-20;
	abundances.aism[ipNICKEL] = 1.82e-8;
	abundances.aism[ipCOPPER] = 1.5e-9;
	abundances.aism[ipZINC] = 2.0e-8;

	/* HII region abundances, Orion mean of Baldwin et al, Rubin et al,
	 * and DEO et al, all 1991 apj
	 * also Table 5, Savage and Sembach, Ann Rev 1996 for ism */
	abundances.ahii[ipHYDROGEN] = 1.;
	abundances.ahii[ipHELIUM] = 0.095;
	abundances.ahii[ipLITHIUM] = 5.4e-11;
	abundances.ahii[ipBERYLLIUM] = 1e-20;
	abundances.ahii[ipBORON] = 8.9e-11;
	abundances.ahii[ipCARBON] = 3.e-4;
	abundances.ahii[ipNITROGEN] = 7.0e-5;
	abundances.ahii[ipOXYGEN] = 4.0e-4;
	abundances.ahii[ipFLUORINE] = 1e-20;
	abundances.ahii[ipNEON] = 6e-5;
	abundances.ahii[ipSODIUM] = 3e-7;
	abundances.ahii[ipMAGNESIUM] = 3.e-6;
	abundances.ahii[ipALUMINIUM] = 2.e-7;
	abundances.ahii[ipSILICON] = 4.e-6;
	abundances.ahii[ipPHOSPHORUS] = 1.6e-7;
	abundances.ahii[ipSULPHUR] = 1.0e-5;
	abundances.ahii[ipCHLORINE] = 1.e-7;
	abundances.ahii[ipARGON] = 3.e-6;
	abundances.ahii[ipPOTASIUM] = 1.1e-8;
	abundances.ahii[ipCALCIUM] = 2.e-8;
	abundances.ahii[ipSCANDIUM] = 1e-20;
	abundances.ahii[ipTITANIUM] = 5.8e-10;
	abundances.ahii[ipVANADIUM] = 1.0e-10;
	abundances.ahii[ipCHROMIUM] = 1.0e-8;
	abundances.ahii[ipMANGANESE] = 2.3e-8;
	abundances.ahii[ipIRON] = 3.0e-6;
	abundances.ahii[ipCOBALT] = 1e-20;
	abundances.ahii[ipNICKEL] = 1e-7;
	abundances.ahii[ipCOPPER] = 1.5e-9;
	abundances.ahii[ipZINC] = 2.0e-8;

	/* PN abund from  */
	/* >>refer	PN	abundances	Aller+Czyzak, ApJ Sup 51, 211 */
	abundances.apn[ipHYDROGEN] = 1.;
	abundances.apn[ipHELIUM] = 0.1;
	abundances.apn[ipLITHIUM] = 1e-20;
	abundances.apn[ipBERYLLIUM] = 1e-20;
	abundances.apn[ipBORON] = 1e-20;
	abundances.apn[ipCARBON] = 7.8e-4;
	abundances.apn[ipNITROGEN] = 1.8e-4;
	abundances.apn[ipOXYGEN] = 4.4e-4;
	abundances.apn[ipFLUORINE] = 3e-7;
	abundances.apn[ipNEON] = 1.1e-4;
	abundances.apn[ipSODIUM] = 1.9e-6;
	abundances.apn[ipMAGNESIUM] = 1.6e-6;
	abundances.apn[ipALUMINIUM] = 2.7e-7;
	abundances.apn[ipSILICON] = 1e-5;
	abundances.apn[ipPHOSPHORUS] = 2e-7;
	abundances.apn[ipSULPHUR] = 1e-5;
	abundances.apn[ipCHLORINE] = 1.7e-7;
	abundances.apn[ipARGON] = 2.7e-6;
	abundances.apn[ipPOTASIUM] = 1.2e-7;
	abundances.apn[ipCALCIUM] = 1.2e-8;
	abundances.apn[ipSCANDIUM] = 1e-20;
	abundances.apn[ipTITANIUM] = 1e-20;
	abundances.apn[ipVANADIUM] = 1e-20;
	abundances.apn[ipCHROMIUM] = 1e-20;
	abundances.apn[ipMANGANESE] = 1e-20;
	abundances.apn[ipIRON] = 5.0e-7;
	abundances.apn[ipCOBALT] = 1e-20;
	abundances.apn[ipNICKEL] = 1.8e-8;
	abundances.apn[ipCOPPER] = 1e-20;
	abundances.apn[ipZINC] = 1e-20;

	/* mix from Cameron 1982, in "Essays on Nuclear Astro" */
	abundances.camern[ipHYDROGEN] = 1.;
	abundances.camern[ipHELIUM] = .0677;
	abundances.camern[ipLITHIUM] = 2.2e-9;
	abundances.camern[ipBERYLLIUM] = 4.5e-11;
	abundances.camern[ipBORON] = 3.4e-10;
	abundances.camern[ipCARBON] = 4.22e-4;
	abundances.camern[ipNITROGEN] = 8.72e-5;
	abundances.camern[ipOXYGEN] = 6.93e-4;
	abundances.camern[ipFLUORINE] = 2.9e-8;
	abundances.camern[ipNEON] = 9.77e-5;
	abundances.camern[ipSODIUM] = 2.25e-6;
	abundances.camern[ipMAGNESIUM] = 3.98e-5;
	abundances.camern[ipALUMINIUM] = 3.20e-6;
	abundances.camern[ipSILICON] = 3.76e-5;
	abundances.camern[ipPHOSPHORUS] = 2.4e-7;
	abundances.camern[ipSULPHUR] = 1.88e-5;
	abundances.camern[ipCHLORINE] = 1.78e-7;
	abundances.camern[ipARGON] = 3.99e-6;
	abundances.camern[ipPOTASIUM] = 1.3e-7;
	abundances.camern[ipCALCIUM] = 2.35e-6;
	abundances.camern[ipSCANDIUM] = 1.16e-9;
	abundances.camern[ipTITANIUM] = 9.0e-8;
	abundances.camern[ipVANADIUM] = 9.5e-9;
	abundances.camern[ipCHROMIUM] = 4.8e-7;
	abundances.camern[ipMANGANESE] = 3.5e-7;
	abundances.camern[ipIRON] = 3.38e-5;
	abundances.camern[ipCOBALT] = 8.27e-8;
	abundances.camern[ipNICKEL] = 1.80e-6;
	abundances.camern[ipCOPPER] = 2.0e-8;
	abundances.camern[ipZINC] = 4.7e-8;

	/* set logical flags saying whether to include element in AGN tables */
	/* first set all false, since most not included */
	for( i=0; i < LIMELM; i++ )
	{
		abundances.lgAGN[i] = FALSE;
	}
	abundances.lgAGN[ipHYDROGEN] = TRUE;
	abundances.lgAGN[ipHELIUM] = TRUE;
	abundances.lgAGN[ipCARBON] = TRUE;
	abundances.lgAGN[ipNITROGEN] = TRUE;
	abundances.lgAGN[ipOXYGEN] = TRUE;
	abundances.lgAGN[ipNEON] = TRUE;
	abundances.lgAGN[ipMAGNESIUM] = TRUE;
	abundances.lgAGN[ipSILICON] = TRUE;
	abundances.lgAGN[ipSULPHUR] = TRUE;
	abundances.lgAGN[ipARGON] = TRUE;
	abundances.lgAGN[ipIRON] = TRUE;

#	ifdef DEBUG_FUN
	fputs( " <->ZeroAbund()\n", debug_fp );
#	endif
	return;
}

