/*ehe12p two photon emission from helium singlets */
/*eva2nu two photon emission function for hydrogen */
/*twopht hydrogen two photon emission, including induced emission */
#include "cddefines.h"
#include "physconst.h"
#include "hydrogenic.h"
#include "taulines.h"
#include "interpolate.h"
#include "max2pht.h"
#include "trace.h"
#include "rfield.h"
#include "twophoton.h"
#define	NCRS	21

double ehe12p(double freq)
{
	double ehe12p_v, 
	  y;
	static double y2[NCRS];
	static double ener[NCRS]={0.,0.03738,0.07506,0.1124,0.1498,0.1875,
	  0.225,0.263,0.300,0.3373,0.375,0.4127,0.4500,0.487,0.525,0.5625,
	  0.6002,0.6376,0.6749,0.7126,0.75};
	static double crs[NCRS]={0.,5.03,8.09,10.16,11.52,12.52,13.25,13.70,
	  14.02,14.25,14.27,14.25,14.02,13.70,13.25,12.52,11.52,10.16,
	  8.09,5.03,0.};
	static int lgFirst = TRUE;

#	ifdef DEBUG_FUN
	fputs( "<+>ehe12p()\n", debug_fp );
#	endif

	if( lgFirst )
	{
		/* set up coefficients for spline */
		spline(ener,crs,NCRS,2e31,2e31,y2);
		lgFirst = FALSE;
	}

	if( freq < 0. || freq >= 1.56 )
	{
		ehe12p_v = 0.;
	}
	else
	{
		splint(ener,crs,y2,NCRS,freq/2.08,&y);
		ehe12p_v = y/2.16;
	}

#	ifdef DEBUG_FUN
	fputs( " <->ehe12p()\n", debug_fp );
#	endif
	return( ehe12p_v );
}


/*eva2nu two photon emission function for hydrogen */
double eva2nu(double freq)
{
	double eva2nu_v, 
	  y;
	static double y2[NCRS];

	/* this is the photon energy in Rydbergs, energy Table 1 */
	/* >>refer	HI	2nu	Spitzer, L., & Greenstein, J., 1951, ApJ, 114, 407 */
	static double ener[NCRS]={
	  0.,     0.03738,  0.07506,  0.1124,  0.1498,  0.1875,
	  0.225,  0.263,    0.300,    0.3373,  0.375,   0.4127,
	  0.4500, 0.487,    0.525,    0.5625,  0.6002,  0.6376,
	  0.6749, 0.7126,   0.75};

	  /* probability \psi(y), from col 3 of Table 1 of SG 51 */
	static double crs[NCRS]={
	  0.000,  1.725,    2.783,    3.481,   3.961,   4.306,
	  4.546,  4.711,    4.824,    4.889,   4.907,   4.889,
	  4.824,  4.711,    4.546,    4.306,   3.961,   3.481,
	  2.783,  1.725,    0.000};
	/*static double crs[NCRS]={
	  0.,     5.03,     8.09,     10.16,   11.52,   12.52,
	  13.25,  13.70,   14.02,     14.25,   14.27,   14.25,
	  14.02,  13.70,   13.25,     12.52,   11.52,   10.16,
	  8.09,    5.03,    0.};*/

	static int lgFirst = TRUE;

#	ifdef DEBUG_FUN
	fputs( "<+>eva2nu()\n", debug_fp );
#	endif

	if( lgFirst )
	{
		/*  set up coefficients for spline */
		spline(ener,crs,NCRS,2e31,2e31,y2);
		lgFirst = FALSE;
	}

	if( freq < 0. || freq >= 0.75 )
	{
		eva2nu_v = 0.;
	}
	else
	{
		splint(ener,crs,y2,NCRS,freq,&y);
		eva2nu_v = y;
	}

#	ifdef DEBUG_FUN
	fputs( " <->eva2nu()\n", debug_fp );
#	endif
	return( eva2nu_v );
}


/*twopht evaluate rate of induced hydrogen two photon emission */
void twopht(
	/* atomic number on c scale */
	long nelem , 
	/* 2s to 1s total rate, spontaneous + induced */
	float *ri2s1s , 
	/* induced upward rate, 1s to 2s */
	float *ri1s2s , 
	/* the iso sequence, must be either 0 (hydrogen) or 1 (he-like) */
	long ipISO )
{
	long int i, 
	  limit;
	double SponRate;
	/*static int j=0;*/

#	ifdef DEBUG_FUN
	fputs( "<+>twopht()\n", debug_fp );
#	endif

	/* ipISO must be either 0 or 1 */
	ASSERT( ipISO==0 || ipISO==1 );

	/* must set the A here since we may bail if fluorescense is turned off */
	/* >>chng 01 jan 26, from 8.23 to 8.226 */
	*ri2s1s = (float)(8.226*powi( (1.+nelem) , 6 ) );
	*ri1s2s = 0.;

	/* return if induced processes are turned off */
	if( !rfield.lgInducProcess )
	{ 
#		ifdef DEBUG_FUN
		fputs( " <->twopht()\n", debug_fp );
#		endif
		return;
	}

	SponRate = 0.;
	*ri2s1s = 0.;
	*ri1s2s = 0.;
	fixit();/* ipISO is an option for this routine -why is it not checked? */
	ipISO = ipHYDROGEN;
	for( i=0; i < hydro.ipHalfLya[ipISO][nelem]; i++ )
	{
		/* the integral over the product of the two occupation numbers and the
		 * effecive spontaneous A.  Hy2nu already has width of cell included */
		/* this is the total downward rate, sum of spontaneous and induced */
		/* >>chng 01 sep 16, break out factor of TWO_PHOT_CONST from all two photon stored rates */
		*ri2s1s += hydro.AsHy2nu[ipISO][nelem][i]*(1.f+rfield.SummedOcc[i])*
			(1.f+rfield.SummedOcc[hydro.ipSymHy2nu[ipISO][nelem][i]-1])*(float)TWO_PHOT_CONST ;

		/* the upward rate */
		*ri1s2s += hydro.AsHy2nu[ipISO][nelem][i]*rfield.SummedOcc[i]*
			rfield.SummedOcc[hydro.ipSymHy2nu[ipISO][nelem][i]-1]*(float)TWO_PHOT_CONST ;

		SponRate += hydro.AsHy2nu[ipISO][nelem][i]*TWO_PHOT_CONST;
		/*if( j>0 ) fprintf(ioQQQ,"%.2e\t%.2e\t%.2e\t%.2e %s\n", 
			rfield.anu[i], 
			*ri2s1s,
			rfield.SummedOcc[i]/rfield.widflx[i] ,
			rfield.SummedOcc[hydro.ipSymHy2nu[nelem][i]-1]/rfield.widflxhydro.ipSymHy2nu[nelem][i]-1]  ,
			rfield.chLineLabel[hydro.ipSymHy2nu[nelem][i]-1]
			);*/
	}
	/* above was only half the integral - other half is symmetric */
	*ri2s1s *= 2.;
	*ri1s2s *= 2.;
	SponRate *= 2.;

	/* remember maximum value, but only for hydrogen,
	 * and only remember enhancement over spontaneous */
	if( nelem==0 )
	{
		Max2Pht.xMax2Pht = MAX2(Max2Pht.xMax2Pht,*ri2s1s-(float)SponRate);
	}
#	if 0
	/*++j;
	if( j==3 )exit(EXIT_FAILURE);*/
	*ri2s1s = (float)SponRate; *ri1s2s = 0.;
	fixit(); /* remove following line */
	/* >>chng 01 jan 26, from 8.23 to 8.226 */
	*ri2s1s = (float)(8.226*powi( (1.+nelem) , 6 ) );
#	endif

	/* >>chng 01 jan 26, from 8.23 to 8.226 */
	/*fprintf(ioQQQ,"2pht2pht\t%li\t%.3e\t%.3e\n", nelem,SponRate ,8.226*pow(1.+nelem,6)  );*/
	ASSERT( fabs(SponRate-8.226*pow(1.+nelem,6)) / SponRate < 0.05 );

	if( trace.lgTrace && trace.lgBug2nu )
	{
		limit = EmisLines[ipH_LIKE][nelem][ipH2p][ipH1s].ipCont-1;
		for( i=1; i < limit; i += 10 )
		{
			fprintf( ioQQQ, "%12.4e%12.4e", rfield.anu[i], 
			  rfield.OccNumbIncidCont[i] );
		}
		fprintf( ioQQQ, "\n" );

		/* sum two-nu A's to check OK */
		SponRate = 0.;
		for( i=0; i < limit; i++ )
		{
			SponRate += hydro.AsHy2nu[ipISO][nelem][i];
		}

		fprintf( ioQQQ, "       TWOPHT finds induced two photon rate =%12.3e spontaneous A=%12.3e\n", 
		  *ri2s1s, SponRate );
	}

#	ifdef DEBUG_FUN
	fputs( " <->twopht()\n", debug_fp );
#	endif
	return;
}

#undef	NCRS
