/* these are the global variables dealing with the effects of hot secondary electrons */
EXTERN struct t_Secondaries {

	float  heatef, 
	  efionz, 
	  exctef, 
	  csupra;
	  /* number of secondaries per primary ionization */
	float sec2prim;

	/* sec2total is ratio of secondary to total ionizaitons of ground state H,
	 * evaluated in hydrogen, used in ionization to determine how fine a 
	 * convergence on the secondary rates is needed */
	float sec2total;

	/* max ratio of sec2total, recall to identify sec ioniz models */
	float SecHIonMax;

	/*SetCsupra is secondary ionization rate set with set csupra command */
	float SetCsupra;

	/*lgCSetOn set with set csupra command */
	int lgCSetOn;

	/*flag saying that secondary electron have been turned off, 
	 * set true with no secondaries command */
	int lgSecOFF;

	/* pointer to continuum energies where secondary ionization can occur, 100eV */
	long int ipSecIon;

	/* this block of variables save the state of the code in startr,
	 * in reset, resets this state for the start of the next zone */
	float supsav, 
	  hetsav, 
	  savefi, 
	  x12sav;

	/* x12tot rate for excitation of Lya */
	float x12tot, 
		/* used to store secondary exciatation rates for levels of hydrogenic species
		 * [0][level] is for levels of the atom, [1][level] is the ion */ 
	  Hx12[2][NHYDRO_MAX_LEVEL];

	}	Secondaries;

