/*RTTauUpdate computes average of old and new optical depths for new scale at end of iter,
 * called by update, also pop371 */
#include "cddefines.h"
#include "opacity.h"
#include "sphere.h"
#include "printit.h"
#include "rt.h"

void RTTauUpdate(EmLine * t, 
  double WeightNew)
{
	char chSave[11];

#	ifdef DEBUG_FUN
	fputs( "<+>RTTauUpdate()\n", debug_fp );
#	endif

	/* option to print masing lines, set with print maser */
	if( printit.lgPrtMaser && 
		( t->TauTot < -0.01 || t->TauIn <  -0.01) )
	{
		strcpy( chSave, chLineLbl(t) );
		fprintf( ioQQQ, " Masing line:%10.10s t(in, out)=%10.2e%10.2e\n", 
		  chSave, t->TauIn, t->TauTot );
	}

	if( iteration == 1 && (!sphere.lgStatic) )
	{
		/* first shot at model, set T(ipLnTauTot) to T(1)
		 * DoubleTau normally 1, set to 2 by DoubleTau command in order
		 * to simulate two-sided photoionization */
		t->TauTot = t->TauIn*rt.DoubleTau;
		t->TauIn = (float)MIN2(opac.taumin,t->TauTot/2.);
	}
	else if( sphere.lgSphere && sphere.lgStatic )
	{
		/* static sphere, both sides interact */
		if( iteration == 1 )
		{
			/* on first iteration TauIn was 0 for first zone */
			t->TauTot = (float)(2.*t->TauIn);
		}
		else
		{
			t->TauTot = (float)(t->TauIn*WeightNew + t->TauTot*
			  (1. - WeightNew));
		}
		t->TauIn = (float)(t->TauTot/2.);
	}
	else
	{
		/* take some sort of mean of old and new limiting optical depths */
		if( t->TauIn > 0. && t->TauTot > 0. )
		{
			t->TauTot = (float)pow(10.,log10(t->TauTot)*(1. - WeightNew) + 
				log10(t->TauIn*rt.DoubleTau)*WeightNew);
			t->TauIn = (float)MIN2(opac.taumin,t->TauTot/ 2.);
		}
		else
		{
			t->TauTot = (float)((t->TauIn*rt.DoubleTau + 
			  t->TauTot)/2.);
			t->TauIn = (float)MIN2(opac.taumin,t->TauTot/2.);
		}
	}

	/* this is escape prob */
	t->Pesc = 0.5f*(1.f + 1.f/MAX2(1.f,t->TauTot));

	/* this is fraction inward */
	t->FracInwd = MIN2(1.f,1.5f-t->Pesc);

	/* this is destruction probability
	 * >>chng 96 sep 4, was not here, needed to add since now taking
	 * mean of old and new dest prob */
	t->Pdest = 0.;
	t->Pelec_esc = 0.;

	/* line opacity */
	t->dTau = 0.;

	/* optical depth to the continuum source */
	t->TauCon = opac.taumin;

	/* >>chng 01 sep 01, zero out some pops and energies */
	t->PopLo = 0.;
	/* >>chng 97 jul 21, added following zero
	 * population of upper level */
	t->PopHi = 0.;
	/* population of lower level with correction for stim emission */
	t->PopOpc = 0.;
	/* following two heat exchange excitation, deexcitation */
	t->cool = 0.;
	t->heat = 0.;
	/* intensity of line */
	t->xIntensity = 0.;
	/* number of photons emitted in line */
	t->phots = 0.;
	/* opacity in line */
	t->dTau = 0.;

#	ifdef DEBUG_FUN
	fputs( " <->RTTauUpdate()\n", debug_fp );
#	endif
	return;
}

