/*RTOptDepthReset after first iteration, updates the optical depths, mirroring this
 * routine but with the previous iteration's variables */
#include "cddefines.h"
#include "taulines.h"
#include "nhe1lvl.h"
#include "trace.h"
#include "iso.h"
#include "rfield.h"
#include "opacity.h"
#include "he1tau.h"
#include "he3tau.h"
#include "he1nxt.h"
#include "phycon.h"
#include "h2.h"
#include "sphere.h"
#include "helike.h"
#include "stopcalc.h"
#include "abundances.h"
#include "pop371.h"
#include "itercnt.h"
#include "phe1lv.h"
#include "nhe1.h"
#include "colden.h"
#include "punch.h"
#include "converge.h"
#include "receff.h"
#include "rt.h"

/* ====================================================================== */
/*RTOptDepthReset update total optical depth scale, 
 * called after iteration is complete */
void RTOptDepthReset(void)
{
	int lgConverged;

	long int i, 
	  ipHi, 
	  ipISO,
	  nelem, 
	  ipLo;

	double AverFac, 
	  TauOff, 
	  f1, 
	  f2, 
	  fhe1;

	static double OldEfrac=0.;

#	ifdef DEBUG_FUN
	fputs( "<+>RTOptDepthReset()\n", debug_fp );
#	endif

	/* save column density */
	coldenCom.ColDenSav[iteration-1] = coldenCom.colden[ipCOLUMNDENSITY];

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " UPDATE estimating new optical depths\n" );
		if( trace.lgHBug && trace.lgIsoTraceFull[ipH_LIKE] )
		{
			fprintf( ioQQQ, " New Hydrogen outward optical depths:\n" );
			for( ipHi=1; ipHi < iso.numLevels[ipH_LIKE][trace.ipIsoTrace[ipH_LIKE]]; ipHi++ )
			{
				fprintf( ioQQQ, "%3ld", ipHi );
				for( ipLo=0; ipLo < ipHi; ipLo++ )
				{
					fprintf( ioQQQ, "%10.2e", 
						EmisLines[ipH_LIKE][trace.ipIsoTrace[ipH_LIKE]][ipHi][ipLo].TauIn );
				}
				fprintf( ioQQQ, "\n" );
			}
		}
	}

	/* pumping of CaH */
	opac.tpcah[1] = opac.tpcah[0];
	opac.tpcah[0] = opac.taumin;

	/* =======================================================================*/
	/* this is an option to keep iterating until it converges
	 * iterate to convergence option
	 * autocv is percentage difference in optical depths allowed,
	 * =0.20 in block data */
	lgConverged = TRUE;
	strcpy( conv.chNotConverged, "Converged!" );
	if( iteration > 1 && conv.lgAutoIt )
	{
		for( nelem=0; nelem < LIMELM; nelem++ )
		{
			if( abundances.lgElmtOn[nelem] )
			{
				/* check both H-alpha and Ly-alpha - only if balmer lines thick */
				/* following checks if Ha optical deth significant */
				if( EmisLines[ipH_LIKE][nelem][3][2].TauIn > 0.5 )
				{
					if( fabs(EmisLines[ipH_LIKE][nelem][ipH2p][ipH1s].TauTot/
					  (EmisLines[ipH_LIKE][nelem][ipH2p][ipH1s].TauIn*rt.DoubleTau)-1.) > 
					  conv.autocv )
					{
						/* not converged to within AUTOCV, normally 15 percent */
						lgConverged = FALSE;

						/* for iterate to convergence, print reason why it was not converged 
						 * on 3rd and higher iterations */
						strcpy( conv.chNotConverged, "H Lya     " );

						if( punch.lgPunConv )
						{
							fprintf( punch.ipPunConv, " H Lya\n" );
						}
					}

					if( fabs(EmisLines[ipH_LIKE][nelem][3][2].TauTot/
					  (EmisLines[ipH_LIKE][nelem][3][2].TauIn*rt.DoubleTau)-1.) > 
					  conv.autocv )
					{
						/* not converged to within AUTOCV, normally 15 percent */
						lgConverged = FALSE;

						/* for iterate to convergence, print reason why it was not converged 
						 * on 3rd and higher iterations */
						strcpy( conv.chNotConverged, "H B a     " );

						if( punch.lgPunConv )
						{
							fprintf( punch.ipPunConv, " H B a\n" );
						}
					}
				}
			}
		}

		/* check for changes in the HeI Lya line */
		if( (he1tauCOM.he1tau[0][1] - rt.TAddHeI) > 0.5 )
		{
			if( fabs(he1tauCOM.he1tau[0][1]*rt.DoubleTau/he1tauCOM.he1lim[0][1]-1.) > 
				conv.autocv )
			{
				lgConverged = FALSE;
				strcpy( conv.chNotConverged, "He1 Lya   " );

				if( punch.lgPunConv )
				{
					fprintf( punch.ipPunConv, " He1 Lya\n" );
				}

			}
		}

		/* >>>chng 00 mar 24, also check on 10830 if optically thick */
		if( he3tau[IPT10830-1].TauIn > 0.5 )
		{
			if( fabs(he3tau[IPT10830-1].TauTot/
			  (he3tau[IPT10830-1].TauIn*rt.DoubleTau)-1.) > 
			  conv.autocv )
			{
				/* not converged to within AUTOCV, normally 15 percent */
				lgConverged = FALSE;
				strcpy( conv.chNotConverged, "HeI 10830 " );
				if( punch.lgPunConv )
				{
					fprintf( punch.ipPunConv, " 10830\n" );
				}
			}
		}

		if( punch.lgPunConv && lgConverged )
		{
			fprintf( punch.ipPunConv, " converged\n" );
		}

		/* lower limit to number of iterations if converged */
		if( lgConverged )
			IterCnt.itermx = MIN2(IterCnt.itermx,iteration);

		/* >>chng 96 dec 20, moved following to within if on lgAutoIt
		 * this is test for stopping on first zone */
		if( phycon.te < StopCalc.tend && nzone == 1 )
		{
			lgConverged = TRUE;
			strcpy( conv.chNotConverged, "          " );
			IterCnt.itermx = MIN2(IterCnt.itermx,iteration);
		}
	}

	/* ======================================================================== */
	/* must take average of old and new optical depths - were old in place?
	 * */
	if( iteration <= 1 )
	{
		/* this is first pass */
		f1 = 1.;
	}
	else
	{
		/* >>chng 96 jun 06, kill logic for oscillations, do not use
		 * optical depths this was too conservative.  instead check whether
		 * i-front breaking out by looking at electron fractions */
		if( (OldEfrac - 0.98)*(phycon.ElecFrac - 0.98) < 0. )
		{
			f1 = 0.2;
		}
		else
		{
			/* no oscillations, save to speed up convergence */
			f1 = 0.75;
		}
	}

	/* will use this to check on electron density oscillations */
	OldEfrac = phycon.ElecFrac;

	AverFac = f1;
	f2 = 1. - f1;

	/* ===================================================================== */
	/* HeI He I singlet emission lines */
	/* static is false unless sphere static set */
	if( sphere.lgStatic )
	{
		for( ipHi=1; ipHi < NHE1LVL; ipHi++ )
		{
			/* DoubleTau is usually 1, set to 2 with the DoubleTau option to
			 * simulate two-sided photoionization */
			if( iteration == 1 )
			{
				TauOff = rt.TAddHeI*he1tauCOM.he1opc[0][ipHi]/he1tauCOM.he1opc[0][1];
			}
			else
			{
				TauOff = 0.;
			}

			he1tauCOM.he1lim[0][ipHi] = (float)pow(10.,log10(MAX2(opac.taumin,
			  (he1tauCOM.he1tau[0][ipHi]-TauOff)*rt.DoubleTau))*
			  f1 + log10(MAX2(opac.taumin,he1tauCOM.he1lim[0][ipHi]))* f2);

			if( he1tauCOM.he1lim[0][ipHi] <= 0. )
			{
				/* this probably due to underflow above */
				he1tauCOM.he1lim[0][ipHi] = (float)(TauOff/1e6);
			}
			he1nxtCOM.he1nxt[0][ipHi] = he1tauCOM.he1lim[0][ipHi]/2.f;
			he1tauCOM.he1tau[0][ipHi] = he1tauCOM.he1lim[0][ipHi]/2.f;
		}
	}
	else
	{
		for( ipHi=1; ipHi < NHE1LVL; ipHi++ )
		{
			/* DoubleTau is usually 1, set to 2 with the DoubleTau option to
			 * simulate two-sided photoionization */
			if( iteration == 1 )
			{
				TauOff = rt.TAddHeI*he1tauCOM.he1opc[0][ipHi]/he1tauCOM.he1opc[0][1];
			}
			else
			{
				TauOff = 0.;
			}
			/* he1lim(ipHi,1) = (he1tau(ipHi,1)-TauOff)*f1*DoubleTau + he1lim(ipHi,1)*f2 */
			he1tauCOM.he1lim[0][ipHi] = (float)pow(10.,log10(MAX2(opac.taumin,
			  (he1tauCOM.he1tau[0][ipHi]-TauOff)*rt.DoubleTau))*
			  f1 + log10(MAX2(opac.taumin,he1tauCOM.he1lim[0][ipHi]))*
			  f2);
			if( he1tauCOM.he1lim[0][ipHi] <= 0. )
			{
				/* this probably due to underflow above */
				he1tauCOM.he1lim[0][ipHi] = (float)(TauOff/1e6);
			}
			he1nxtCOM.he1nxt[0][ipHi] = 
				MIN2(opac.taumin,he1tauCOM.he1lim[0][ipHi]/2.f);
			he1tauCOM.he1tau[0][ipHi] = 
				MIN2(opac.taumin,he1tauCOM.he1lim[0][ipHi]/2.f);
		}
	}

	if( sphere.lgStatic )
	{
		for( ipLo=1; ipLo < (NHE1LVL - 1); ipLo++ )
		{
			for( ipHi=ipLo + 1; ipHi < NHE1LVL; ipHi++ )
			{
				/* he1lim(ipHi,ipLo) = he1tau(ipHi,ipLo)*f1*DoubleTau + he1lim(ipHi,ipLo) * f2 */
				he1tauCOM.he1lim[ipLo][ipHi] = (float)pow(10.,log10(MAX2(opac.taumin,
				  (he1tauCOM.he1tau[ipLo][ipHi])*rt.DoubleTau))*f1 + 
				  log10(MAX2(opac.taumin,he1tauCOM.he1lim[ipLo][ipHi]))*f2);

				he1nxtCOM.he1nxt[ipLo][ipHi] = he1tauCOM.he1lim[ipLo][ipHi]/2.f;
				he1tauCOM.he1tau[ipLo][ipHi] = he1tauCOM.he1lim[ipLo][ipHi]/2.f;
			}
		}
	}
	else
	{
		for( ipLo=1; ipLo < (NHE1LVL - 1); ipLo++ )
		{
			for( ipHi=ipLo + 1; ipHi < NHE1LVL; ipHi++ )
			{
				/* he1lim(ipHi,ipLo) = he1tau(ipHi,ipLo)*f1*DoubleTau + he1lim(ipHi,ipLo) * f2 */
				he1tauCOM.he1lim[ipLo][ipHi] = (float)pow(10.,log10(MAX2(opac.taumin,
				  (he1tauCOM.he1tau[ipLo][ipHi])*rt.DoubleTau))*f1 + 
				  log10(MAX2(opac.taumin,he1tauCOM.he1lim[ipLo][ipHi]))*f2);

				he1nxtCOM.he1nxt[ipLo][ipHi] = 
					MIN2(opac.taumin,he1tauCOM.he1lim[ipLo][ipHi]/2.f);
				he1tauCOM.he1tau[ipLo][ipHi] = 
					MIN2(opac.taumin,he1tauCOM.he1lim[ipLo][ipHi]/ 2.f);
			}
		}
	}

	/* force hydrogen outward optical depths to be on */
	opac.lgTauOutOn = TRUE;

	/* possibly fix La optical depths
	 * tlamin is set to large number when case b set */
	if( (opac.tlamin > 1e-5 && (!sphere.lgStatic)) || opac.lgCaseB )
	{
		fhe1 = opac.tlamin/he1tauCOM.he1opc[0][1];
		he1tauCOM.he1tau[0][1] = opac.tlamin;
		he1tauCOM.he1lim[0][1] = opac.tlamin*2.f;
		he1nxtCOM.he1nxt[0][1] = opac.tlamin;
		for( ipHi=2; ipHi < NHE1LVL; ipHi++ )
		{
			he1tauCOM.he1tau[0][ipHi] = (float)(fhe1*he1tauCOM.he1opc[0][ipHi]);
			he1tauCOM.he1lim[0][ipHi] = he1tauCOM.he1tau[0][ipHi]*2.f;
			he1nxtCOM.he1nxt[0][ipHi] = he1tauCOM.he1tau[0][ipHi];
		}
	}

	/* following sets (1)=inward optical depth to TAUMIN,
	 * (2)=outward = (log) mean of old optical depths,
	 * sets (3) to escap prob for first zone */
	for( ipHi=0; ipHi < NHE3TAU; ipHi++ )
	{
		RTTauUpdate(&he3tau[ipHi],AverFac);
	}

	RTTauUpdate(&t206,AverFac);

	if( sphere.lgSphere )
	{
		phe1lv.he1rec[ipRecNetEsc][0] = MAX2(0.f,opac.otsmin);
		phe1lv.he1rec[ipRecNetEsc][1] = 1.;
	}
	else
	{
		phe1lv.he1rec[ipRecNetEsc][0] = (float)receff(nhe1Com.nhe1[0]);
	}

	opac.telec = opac.taumin;
	opac.thmin = opac.taumin;
#if 0
	/* he-like species */
	for( nelem=1; nelem < LIMELM; nelem++ )
	{
		if( abundances.lgElmtOn[nelem] )
		{
			for( ipHi=1; ipHi <iso.numLevels[ipHE_LIKE][nelem]; ipHi++ )
			{
				for( ipLo=0; ipLo < ipHi; ipLo++ )
				{
					/*RTTauUpdate computes average of old and new optical depths 
					 * for new scale at end of iter */
					RTTauUpdate(&EmisLines[ipHE_LIKE][nelem][ipHi][ipLo],0.5);
				}
			}
		}
	}
#	endif
	/* do optical depths in extra Lyman lines */
	for(ipISO=0; ipISO<NISO; ++ipISO )
	{

		/* the main set of all lines in the model atoms */
		for( nelem=0; nelem < LIMELM; nelem++ )
		{
			if( abundances.lgElmtOn[nelem] )
			{
				for( ipLo=0; ipLo < (iso.numLevels[ipISO][nelem] - 1); ipLo++ )
				{
					for( ipHi=ipLo + 1; ipHi < iso.numLevels[ipISO][nelem]; ipHi++ )
					{
						/*RTTauUpdate computes average of old and new optical depths 
						* for new scale at end of iter */
 						RTTauUpdate(&EmisLines[ipISO][nelem][ipHi][ipLo],0.5);
					}
				}
			}
		}

		for( nelem=ipISO; nelem < LIMELM; nelem++ )
		{
			if( abundances.lgElmtOn[nelem] )
			{
				for( ipHi=2; ipHi <iso.nLyman[ipISO]; ipHi++ )
				{
					iso.ExtraLymanLines[ipISO][nelem][ipHi].TauIn = opac.taumin;
				}
			}
		}
	}

	/* >>>chng 99 nov 11 did not have case b for hydrogenic species on second and
	 * higher iterations */
	/* option to clobber these taus for lyman lines, if case b is set */
	if( opac.lgCaseB )
	{
		for( nelem=0; nelem < LIMELM; nelem++ )
		{
			if( abundances.lgElmtOn[nelem] )
			{
				float f;
				/* La may be case B, tlamin set to 1e9 by default with case b command */
				EmisLines[ipH_LIKE][nelem][ipH2p][ipH1s].TauIn = opac.tlamin;
				/* >>>chng 99 nov 22, did not reset TauCon */
				EmisLines[ipH_LIKE][nelem][ipH2p][ipH1s].TauCon = EmisLines[ipH_LIKE][nelem][ipH2p][ipH1s].TauIn;
				EmisLines[ipH_LIKE][nelem][ipH2p][ipH1s].TauTot = 
				  2.f*EmisLines[ipH_LIKE][nelem][ipH2p][ipH1s].TauIn;
				f = opac.tlamin/EmisLines[ipH_LIKE][nelem][ipH2p][ipH1s].opacity;

				for( ipHi=3; ipHi < iso.numLevels[ipH_LIKE][nelem]; ipHi++ )
				{
					EmisLines[ipH_LIKE][nelem][ipHi][ipH1s].TauIn = 
						f*EmisLines[ipH_LIKE][nelem][ipHi][ipH1s].opacity;
					/* reset line optical depth to continuum source */
					EmisLines[ipH_LIKE][nelem][ipHi][ipH1s].TauCon = EmisLines[ipH_LIKE][nelem][ipHi][ipH1s].TauIn;
					EmisLines[ipH_LIKE][nelem][ipHi][ipH1s].TauTot = 
					  2.f*EmisLines[ipH_LIKE][nelem][ipH2p][ipH1s].TauIn;
				}
			}
		}

		/* now do helium like sequence - different since collapsed levels 
		 * all go to ground */
		for( nelem=1; nelem < LIMELM; nelem++ )
		{
			if( abundances.lgElmtOn[nelem] )
			{
				float Aprev,
					ratio;
				/* La may be case B, tlamin set to 1e9 by default with case b command */
				EmisLines[ipHE_LIKE][nelem][ipHe2p1P][ipHe1s1S].TauIn = opac.tlamin;

				EmisLines[ipHE_LIKE][nelem][ipHe2p1P][ipHe1s1S].TauCon = EmisLines[ipHE_LIKE][nelem][ipHe2p1P][ipHe1s1S].TauIn;

				EmisLines[ipHE_LIKE][nelem][ipHe2p1P][ipHe1s1S].TauTot = 
				  2.f*EmisLines[ipHE_LIKE][nelem][ipHe2p1P][ipHe1s1S].TauIn;

				ratio = opac.tlamin/EmisLines[ipHE_LIKE][nelem][ipHe2p1P][ipHe1s1S].opacity;

				/* this will be the trans prob of the previous lyman line, will use this to 
				 * find the next one up in the series */
				Aprev = EmisLines[ipHE_LIKE][nelem][ipHe2p1P][ipHe1s1S].Aul;

				i = ipHe2p1P+1;
				/* >>chng 02 jan 05, remove explicit list of lyman lines, use As to guess
				 * which are which - this will work for any number of levels */
				while( i < iso.numLevels[ipHE_LIKE][nelem] )
				/*while( i < N_HE_LYMAN && ipHeLyman[i] < iso.numLevels[ipHE_LIKE][nelem] )*/
				{
					/* >>chng 02 mar 19 use proper test for resonance collapsed lines */
					/*if( EmisLines[ipHE_LIKE][nelem][i][ipHe1s1S].Aul> Aprev/10. )*/
					if( EmisLines[ipHE_LIKE][nelem][i][ipHe1s1S].Aul> Aprev/10. ||
						iso_quant_desig[ipHE_LIKE][nelem][i].s < 0 )
					{
						Aprev = EmisLines[ipHE_LIKE][nelem][i][ipHe1s1S].Aul;
						EmisLines[ipHE_LIKE][nelem][i][ipHe1s1S].TauIn = 
							ratio*EmisLines[ipHE_LIKE][nelem][i][ipHe1s1S].opacity;
						/* reset line optical depth to continuum source */
						EmisLines[ipHE_LIKE][nelem][i][ipHe1s1S].TauCon = EmisLines[ipHE_LIKE][nelem][i][ipHe1s1S].TauIn;
						EmisLines[ipHE_LIKE][nelem][i][ipHe1s1S].TauTot = 
						  2.f*EmisLines[ipHE_LIKE][nelem][i][ipHe1s1S].TauIn;
						/*fprintf(ioQQQ,"%li\t%li\t%.2e\t%.2e\n",nelem, i, 
							EmisLines[ipHE_LIKE][nelem][i][ipHe1s1S].Aul, EmisLines[ipHE_LIKE][nelem][i][ipHe1s1S].TauIn );*/
					}
					++ i;
				}
			}
		}
	}

	/* all heavy element lines */
	for( i=1; i <= nLevel1; i++ )
	{
		RTTauUpdate(&TauLines[i],AverFac);
		/* >>chng 96 jul 06 following sanity check added
		 *begin sanity check */
		if( fabs(TauLines[i].TauIn) > 
			fabs(TauLines[i].TauTot) )
		{
			fprintf( ioQQQ, " UPDATE finds TauIn>TauOut, line=%5ld%10.2e%10.2e\n", 
			  i, TauLines[i].TauIn, TauLines[i].TauTot );
			ShowMe();
			puts( "[Stop in RTOptDepthReset]" );
			cdEXIT(EXIT_FAILURE);
		}
		/*end sanity check */
	}

	/* all level 2 heavy element lines */
	for( i=0; i < nWindLine; i++ )
	{
		if( TauLine2[i].nelem != TauLine2[i].IonStg )
		{
			RTTauUpdate(&TauLine2[i],AverFac);
		}
	}

	/* all hyperfine structure lines */
	for( i=0; i < nHFLines; i++ )
	{
		RTTauUpdate(&HFLines[i],AverFac);
	}

	/* co carbon monoxide lines */
	for( i=0; i < nCORotate; i++ )
	{
		RTTauUpdate(&C12O16Rotate[i],AverFac);
		RTTauUpdate(&C13O16Rotate[i],AverFac);
	}

	/* the large H2 molecule */
	H2_TauAver();

	/* large FeII atom */
	if( FeII.lgFeIION )
	{
		FeIITauAver();
	}

	if( opac.lgCaseB )
	{
		for( i=0; i < rfield.nupper; i++ )
		{
			/* DEPABS and SCT are abs and sct optical depth for depth only
			 * we will not change total optical depths, just reset inner to half
			 * TauAbsGeo(i,2) = 2.*TauAbsFace(i) */
			opac.TauAbsGeo[0][i] = opac.TauAbsGeo[1][i]/2.f;
			/* TauScatGeo(i,2) = 2.*TauScatFace(i) */
			opac.TauScatGeo[0][i] = opac.TauScatGeo[1][i]/2.f;
			opac.TauScatFace[i] = opac.taumin;
			opac.TauAbsFace[i] = opac.taumin;
		}
	}
	else if( sphere.lgSphere )
	{
		for( i=0; i < rfield.nupper; i++ )
		{
			/* [1] is total optical depth from previous iteration,
			 * [0] is optical depth at current position */
			opac.TauAbsGeo[1][i] = 2.f*opac.TauAbsFace[i];
			opac.TauAbsGeo[0][i] = opac.TauAbsFace[i];
			opac.TauScatGeo[1][i] = 2.f*opac.TauScatFace[i];
			opac.TauScatGeo[0][i] = opac.TauScatFace[i];
			opac.TauTotalGeo[1][i] = opac.TauScatGeo[1][i] + opac.TauAbsGeo[1][i];
			opac.TauTotalGeo[0][i] = opac.TauScatGeo[0][i] + opac.TauAbsGeo[0][i];
			/* TauAbsFace and TauScatFace are abs and sct optical depth to ill face */
			opac.TauScatFace[i] = opac.taumin;
			opac.TauAbsFace[i] = opac.taumin;
		}
	}
	else
	{
		for( i=0; i < rfield.nupper; i++ )
		{
			opac.TauTotalGeo[1][i] = opac.TauTotalGeo[0][i];
			opac.TauTotalGeo[0][i] = opac.taumin;
			opac.TauAbsGeo[1][i] = opac.TauAbsGeo[0][i];
			opac.TauAbsGeo[0][i] = opac.taumin;
			opac.TauScatGeo[1][i] = opac.TauScatGeo[0][i];
			opac.TauScatGeo[0][i] = opac.taumin;
			opac.TauScatFace[i] = opac.taumin;
			opac.TauAbsFace[i] = opac.taumin;
		}
	}

	/* this is optical depth at x-ray point defining effective optical depth */
	rt.tauxry = opac.TauAbsGeo[0][rt.ipxry-1];

#	ifdef DEBUG_FUN
	fputs( " <->RTOptDepthReset()\n", debug_fp );
#	endif
	return;
}

