/*MakeRT drive static or wind metal line radiative transfer,
 * if argument is TRUE then do both escape and deEXTERN struction probs,
 * if false only update deEXTERN struction probabilities.  routine only
 * called by cloudy(TRUE) and ConvIonizeOpacityDo(FALSE) */
void RTMake(int);

/* in following two the logical variable says whether to do the
 * escape probs too (TRUE) or just the deEXTERN struction probs (FALSE) */

/*RTMakeStat do line radiative transfer for static geometry */
void RTMakeStat(EmLine * t , 
	int lgDoEsc );

/*RTMakeWind do line radiative transfer for wind geometry */
void RTMakeWind(EmLine * t ,
	int lgDoEsc );

/*RTDiffuse fill in DiffCont and ThrowOut arrays, with diffuse emission for this zone */
void RTDiffuse(void);

/*RT_OTS compute diffuse fields due to helium atom, metals,
 * hydro done in HydroOTS */
void RT_OTS(void);

/*RT_OTS_AddLine add local destruction of lines to ots field */
void RT_OTS_AddLine(float ots, 
	/* pointer on the f scale */
  long int ip );

/*add local destruction of continuum to ots field */
void RT_OTS_AddCont(
					/* the ots rate itself */
					float ots, 
					/* pointer to continuum cell for ots, on f scale */
					long int ip);
/*RTOTSUpdata sum flux, otscon, otslin, ConInterOut, outlin, 
 * to form SummeDif, SummedCon SummedOcc, 
 * returns sum of ots rates
 * int * is pointer to energy in continuum where this change happened,
 * BigFrac is largest relative change in ots allowed, 0 for no cap */
void RT_OTS_Update(double* SumOTS , long int * ipOTSchange , double BigFrac);

/* zero these things out, called in zero */
void RT_OTS_Zero( void );

/*RT_OTS_ChkSum sanity check confirms summed continua reflect contents of individuals */
void RT_OTS_ChkSum(long int ipPnt);

/*RTLineTauInc increment optical depths for all heavy element lines, zone by zone */
void RTLineTauInc(EmLine * t );

/*RTOptDepthInit set initial outward optical depths at start of first iteration */
void RTOptDepthInit(void);

/*RTTauUpdate computes average of old and new optical depths for new scale at end of iter */
void RTTauUpdate(EmLine * t , 
  double f1);

/*RTOptDepthReset update total optical depth scale, called after iteration is complete */
void RTOptDepthReset(void);

/*RTOptDepthIncre increment optical depths once per zone, called after RadInc */
void RTOptDepthIncre(void);

/*RT_OTS_PrtRate print ots arrays, called by ionize */
void RT_OTS_PrtRate(
	  /* arg is weakest rate to print */
	  double weak ,
	  /* flag, 'c' continuum, 'l' line, 'b' both */
	  int chFlag );

EXTERN struct t_rt {
	/* >>chng 01 jun 23, these not used, instead iRedisFun */
	/* label destruction probability functions for subordinate lines*
	 * "simp" for simple, "__k2" for hummer's k2, and "INCO" for incomplete
	char chDstFun[5],  */
	/* label for escape probability functions *
	 * "simp" for simple, "__k2" for hummer's k2, and "INCO" for incomplete
	  chEscFunSubord[5]; */

	/* the redistribution for La 
	 * options are INCO, COMP, WIND
	
	char chRedisLa[5]; */

	/* wayin - escape probability in inward direction */
	float wayin, 
	/* wayout - escape probability in outward direction
	 * =1 when outward optical depths unknown (touton .false.) */
	  wayout, 
	/* fractin = wayin / (wayin+wayout) when outer defined, else zero */
	  fracin;

	/* optical depths to add to Lyman lines for three series */
	float TAddHLya, 
	  TAddHeI;

	/* 1 or two, set to double optical depth scale, set to 2 with double command
	* default is 1 */
	float DoubleTau;

	/* offset in continuum array for energy where x-ray opacity determined */
	long int ipxry;

	/* optical depth at this energy */
	float tauxry;

	/* option to turn off fine structure line optical depths */
	int lgFstOn;

	/* electron scattering escape for lines */
	int lgElecScatEscape;

}	rt;
