/* recom.h */
EXTERN struct t_recom {

	/*
	 * recombination rates per vol, (cm^-3 s^-1) for all elements
	 * has been multiplied by the elctron density 
	 * first dim is nelem, the atomic number of element
	 * secnd dim is stage of ionizaiton, 1 for atom
	 */
	float RecombinRate[LIMELM][LIMELM];

	/* which version of Dima's rrfit routine to use? */
	int lgVrrFit;

	/* GrnIonRec - rate coefficient for ionic recombination on grain surfaces */
	float GrnIonRec, 
	 /*grecon usually 1, set to 0 with no grain neutralization command	 */
	  grecon;

	/* suppresssion factors for dielectronic recombination
	 * 1 is burgess and 2 is storey */
	float DielSupprs[2][LIMELM];

	/* logical flag for suppression of dielectronic recombination
	 * 1 is burgess, 2 is nussbaumer and storey	 */
	int lgSupDie[2];

	/* this is fudge factor for scaled nussbamer and story diel recom
	 * set with diel kludge commmand, usually 1 */
	float GuessDiel[4];

	/* following all for 3-body recombination */
	/* lgNoCota flag set with no three body recombination */
	int lgNoCota;

	/* the actual rates */
	float CotaRate[LIMELM];

	/* these are error flags for three-body recombination */
	long int ilt, 
	  iltln, 
	  ilthn, 
	  ihthn, 
	  ifail;

	}	recom;

