EXTERN struct t_printit {

	/* lgSortLines, option to sort lines by wavelength- print sort command */
	int lgSortLines;

	/* if above is set, then one of the following must also be set,
	 * say whether to sort by wavelength or intensity */
	int lgSortLineWavelength , lgSortLineIntensity;

	/* lower and upper wavelength bounds for printed spectrum,
	 * range option on print sort command */
	float wlSort1 , wlSort2;

	/* print hydrogenic level populations, 
	 * set with print hydrogenic command
	int lgPrintHLevPops; */

	/* print column densities */
	int lgPrintColumns;

	/* should we print execution time?  normally true, but set false
	 * with no times command so that different runs can compare exactly */
	int lgPrintTime;

	/* print ages command tells code to print various timescales */
	int lgPrnAges;

	/* option to print maser lines (true) normally false
	 * print maser turns on */
	int lgPrtMaser;

	/* lgPrtTau tells whether to print line optical depths */
	int lgPrtTau;

	/* lgPrintFluxEarth says to print flux of lines at Earth, 
	 * if luminosity can be predicted */
	int lgPrintFluxEarth;

	/* PrtTauFnt is smallest line optical depth to print */
	float PrtTauFnt;

	/* these are various contributors to the line output,
	 * and are changed with the print line or print continuum commands
	 * in prtfinal code uses these to make a final filter over what lines
	 * will be printed */
	int lgPrnPump, 
	  lgPrnHeat, 
	  lgPrnColl, 
	  lgPrnInwd, 
	  lgPrnDiff;

	/* flag set with print continuum command */
	int lgPrtCont;

	/* flags for determining what is included in nFnu */
	int lgSourceReflected;
	int lgSourceTransmitted;
	int lgDiffuseInward;
	int lgDiffuseOutward;

	/* flag set with print departure coefficients */
	int lgPrtBN;

	/* if true then print only last iteration */
	int lgPrtLastIt;

	/* flag set with print short comand */
	int lgPrtShort;

	/* lgOnlyZone set with print only zones */
	int lgOnlyZone;
	/* lgOnlyHead set with print only header */
	int lgOnlyHead;

	/* lgPrtStart is option to start printout at certain zone */
	int lgPrtStart;

	/*nstart is zone number, set with print start command */
	long int nstart;

	/* flag to turn on printout of heat sources */
	int lgPrintHeating;

	/* flag set with print array command to print ionization recombination arrays */
	int lgPrtArry;

	/* logical lgFaintOn normally true, says to not print very faint lines
	 * set false with print faint off command
	 *lines fainter than TooFaint will not be printed.  This is set in zerologic
	 *and reset with print line faint command  */
	float TooFaint;
	int lgFaintOn;

	/* flag set true if print faint command entered,
	 * only used to not overrid it with print short */
	int lgFntSet;

	/* option to print main block of lines as a single colum
	 * instead of the normal array.  if TRUE then usual array */
	int lgPrtLineArray;

	/* printins as a column also has an option to print linear quantity 
	 * in exponential format */
	int lgPrtLineLog;

	}	printit;
