/*pfeii create punch output describing pumping of FeII by Lya */
#include "cddefines.h"
#include "nfeii.h"
#include "doppvel.h"
#include "ionfracs.h"
#include "fe2pmp.h"
#include "fe2tau.h"
#include "iso.h"
#include "hydrogenic.h"
#include "pop371.h"
#include "pfeii.h"

void pfeii(FILE* io)
{
	long int i;
	double hopc, 
	  rate;

#	ifdef DEBUG_FUN
	fputs( "<+>pfeii()\n", debug_fp );
#	endif

	/* compute efficiency of FeII emission overlapping with Ly-alpha
	 * implemented with Fred Hamann */
	if( (xIonFracs[ipIRON][1] <= 0. || !FeII.lgLyaPumpOn) || 
		hydro.dstfe2lya <= 0. )
	{
		fprintf( io, " No Fe II in this zone\n" );
		
#		ifdef DEBUG_FUN
		fputs( " <->pfeii()\n", debug_fp );
#		endif
		return;
	}

	for( i=0; i < NFEII; i++ )
	{
		/* Ly-alpha line-center opacity */
		if( xIonFracs[ipHYDROGEN][1] > 0. )
		{
			hopc = 7.60e-8*iso.Pop2Ion[ipH_LIKE][0][ipH1s]*xIonFracs[ipHYDROGEN][1]/DoppVel.doppler[0];
		}
		else
		{
			hopc = 7.60e-8*xIonFracs[ipHYDROGEN][0]/DoppVel.doppler[0];
		}

		rate = (fe2tau.feopc[i]/(fe2tau.feopc[i] + hopc))*(DoppVel.doppler[25]/
		  DoppVel.doppler[0])*(1. - 1./(1. + 1.6*fe2tau.Fe2TauLte[i]));

		/* dstfe2lya is total Lya deexcitation probability due to line overlap */
		fprintf( io, "%15.5e%10.2e\n", fe2pmp.fe2lam[i], rate/
		  hydro.dstfe2lya );
	}

#	ifdef DEBUG_FUN
	fputs( " <->pfeii()\n", debug_fp );
#	endif
	return;
}

