/*ParseSet scan parameters off SET command */
#include "cddefines.h"
#include "physconst.h"
#include "zonecnt.h"
#include "kshllenr.h"
#include "co.h"
#include "phycon.h"
#include "path.h"
#include "mappar.h"
#include "converge.h"
#include "hevmolec.h"
#include "secondaries.h"
#include "rfield.h"
#include "ionrange.h"
#include "punchskip.h"
#include "numderiv.h"
#include "didz.h"
#include "punch.h"
#include "stopcalc.h"
#include "printit.h"
#include "opacity.h"
#include "hydrogenic.h"
#include "peimbt.h"
#include "radius.h"
#include "phfit.h"
#include "wkhtcl.h"
#include "chargtran.h"
#include "continuum.h"
#include "plwidth.h"
#include "testit.h"
#include "physok.h"
#include "typmatrx.h"
#include "grain.h"
#include "grainvar.h"
#include "parse.h"

#define NINT(X) ((long)((X) < 0. ? (X)-0.5 : (X)+0.5))

void ParseSet(char *chCard )
{
	int lgEOL ;
	long int i, 
		ip;
	char *chEnd;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseSet()\n", debug_fp );
#	endif

	/* commands to set certain variables, "SET XXX=" */
	if( lgMatch(" CHA",chCard) )
	{
		/* set log of minimum charge transfer rate for high ions and H
		 * default of 1.92e-10 set in zero */
		i = 5;
		ChargTran.HCTAlex = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( lgEOL )
		{
			NoNumb(chCard);
		}
		if( ChargTran.HCTAlex < 0. )
		{
			ChargTran.HCTAlex = pow(10.,ChargTran.HCTAlex);
		}
	}

	else if( lgMatch("CSUP",chCard) )
	{
		/* force secondary ionization rate, log entered */
		i = 5;
		Secondaries.SetCsupra = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		Secondaries.lgCSetOn = TRUE;
		if( lgEOL )
		{
			NoNumb(chCard);
		}
		Secondaries.SetCsupra = (float)pow(10.f,Secondaries.SetCsupra);
	}

	else if( lgMatch(" D/H",chCard) )
	{
		/* set D to H ratio */
		i = 5;
		hydro.D2H_ratio = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( hydro.D2H_ratio <= 0. || lgMatch( " LOG", chCard ) )
		{
			hydro.D2H_ratio = pow(10.f,hydro.D2H_ratio);
		}
		if( lgEOL )
		{
			NoNumb(chCard);
		}

	}

	else if( lgMatch("12C1",chCard) )
	{
		/* set the 12C to 13C abundance ratio - default is 30 */
		i = 5;
		/* first two numbers on the line are 12 and 13 - we don't want them */
		hevmolec.RatioC12O16_2_C13O16 = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		hevmolec.RatioC12O16_2_C13O16 = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

		/* now we can get the ratio */
		hevmolec.RatioC12O16_2_C13O16 = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( lgEOL )
			NoNumb(chCard);

		if( hevmolec.RatioC12O16_2_C13O16 <= 0. || lgMatch( " LOG", chCard ) )
			hevmolec.RatioC12O16_2_C13O16 = (float)pow(10.f,hevmolec.RatioC12O16_2_C13O16);

	}

	else if( lgMatch("DIDZ",chCard) )
	{
		/* set parameter to do with choice of dr;
		 * par is the largest optical depth to allow in the zone. 
		 * >>chng 96 jan 08 had been two numbers - dtau1 removed */
		i = 5;
		didz.drChange = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( didz.drChange <= 0. )
		{
			didz.drChange = (float)pow(10.f,didz.drChange);
		}
		if( lgEOL )
		{
			NoNumb(chCard);
		}

	}

	/* something to do with electron density */
	else if( lgMatch("EDEN",chCard) )
	{
		/* >>chng 02 apr 20, from ERROR to TOLERANCE to be parallel to set temp equivalent*/
		if( lgMatch("TOLE",chCard) )
		{
			/* keyword is tolerance 
			 * set tolerance in eden match */
			i = 5;
			phycon.EdenError = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
			if( lgEOL )
			{
				NoNumb(chCard);
			}

			if( phycon.EdenError < 0. )
			{
				phycon.EdenError = (float)pow(10.f,phycon.EdenError);
			}
		}

		else if( lgMatch("SOLV",chCard) )
		{
			/* the electron density solver */
			if( lgMatch("NEW",chCard) ) 
			{
				/* new method */
				strcpy( conv.chSolverEden , "new" );
			}
			else
			{
				/* default method */
				strcpy( conv.chSolverEden , "simple" );
			}
		}
		else 
		{
			/* no keyword, assume log of electron density */
			i = 5;
			/* set the electron density */
			phycon.EdenSet = (float)pow(10.,FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL));
			/* warn that this model is meaningless */
			physok.lgPhysOK = FALSE;
		}
	}

	/* something to do with pressure */
	else if( lgMatch("PRES",chCard) )
	{
		if( lgMatch("ERRO",chCard) )
		{
			/* keyword is error 
			 * set tolerance in pressure match */
			i = 5;
			phycon.PressureError = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
			if( lgEOL )
			{
				NoNumb(chCard);
			}

			if( phycon.PressureError < 0. )
			{
				phycon.PressureError = (float)pow(10.f,phycon.PressureError);
			}
		}
	}

	else if( lgMatch("COLI",chCard) )
	{
		/* set maximum CO/C ratio */
		i = 5;
		co.COLimit = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( lgEOL )
		{
			NoNumb(chCard);
		}

		if( co.COLimit < 0. )
		{
			co.COLimit = (float)pow(10.f,co.COLimit);
		}
	}

	else if( lgMatch("SPEC",chCard) )
	{
		/* "set spectrum" for optional parameters for punch spectrum command */
		if( lgMatch("RANG" , chCard ) )
		{
			/* wavelength range option */
			i = 5;
			punch.cp_range_min[punch.cp_npun] = (float)pow(10.,FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL));
			punch.cp_range_max[punch.cp_npun] = (float)pow(10.,FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL));
			if( lgEOL )
			{
				NoNumb(chCard);
			}
			/* contfirm that wavelengths are in correct order */
			if( punch.cp_range_min[punch.cp_npun] >= punch.cp_range_max[punch.cp_npun] )
			{
				fprintf( ioQQQ, " The limits must be in increasing order.\n" );
				puts( "[Stop in ParseSet]" );
				cdEXIT(EXIT_FAILURE);
			}
		}
		else if( lgMatch("RESO" , chCard ) )
		{
			/* resolving power, default is zero, which means leave at native resolution */
			i = 5;
			punch.cp_resolving_power[punch.cp_npun] = (float)pow(10.,FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL));
			if( lgEOL )
			{
				NoNumb(chCard);
			}
		}
	}

	else if( lgMatch("RESO" , chCard ) )
	{
		/* set resolution, get factor that will multiply continuum resolution that
		 * is contained in the file continuum_mesh.dat */
		i = 5;
		continuum.ResolutionScaleFactor = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( lgEOL )
		{
			NoNumb(chCard);
		}
		/* negative numbers were logs */
		if( continuum.ResolutionScaleFactor <= 0. )
			continuum.ResolutionScaleFactor = pow(10.,continuum.ResolutionScaleFactor);
	}

	else if( lgMatch(" DR ",chCard) )
	{
		/* set zone thickness by forcing drmax and drmin */
		i = 5;
		/* at this stage linear, but default is log */
		radius.sdrmax = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( !lgMatch("LINE",chCard) ) 
		{
			/* linear was not on command, so default is log */
			radius.sdrmax = (float)pow( 10.f , radius.sdrmax );
		}
		if( lgEOL )
		{
			NoNumb(chCard);
		}
		radius.sdrmin = radius.sdrmax;
	}

	else if( lgMatch("DRMA",chCard) )
	{
		/* set maximum zone thickness */
		i = 5;
		radius.sdrmax = (float)pow(10.,FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL));
		if( lgEOL )
		{
			NoNumb(chCard);
		}
	}

	else if( lgMatch("DRMI",chCard) )
	{
		/* set minimum zone thickness */
		i = 5;
		radius.sdrmin = (float)pow(10.,FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL));
		if( lgEOL )
		{
			NoNumb(chCard);
		}
		radius.lgSMinON = TRUE;
	}

	else if( lgMatch("FLXF",chCard) )
	{
		/* faintest continuum flux to consider */
		i = 5;
		rfield.FluxFaint = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( lgEOL )
		{
			NoNumb(chCard);
		}
		if( rfield.FluxFaint < 0. )
		{
			rfield.FluxFaint = (float)pow(10.f,rfield.FluxFaint);
		}
	}

	/* >>chng 01 jul 27, this was not in hazy, and set temperature now does all te */
#	if 0
	else if( lgMatch("LOWE",chCard) )
	{
		/*  set lowest te to constant */
		i = 5;
		StopCalc.TeLowest = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

		/*  linear option */
		if( StopCalc.TeLowest <= 10. && !lgMatch("LINE",chCard) )
		{
			StopCalc.TeLowest = (float)pow(10.,StopCalc.TeLowest);
		}

		if( lgEOL )
		{
			NoNumb(chCard);
		}

		if( StopCalc.TeLowest < 2.8 )
		{
			fprintf( ioQQQ, " TE < 3K, reset to 2.8K.\n" );
			StopCalc.TeLowest = 2.8f;
		}
	}
#	endif

	else if( lgMatch("MATR",chCard) )
	{
		/* which matrix inversion routine to use */
		if( lgMatch("MATI",chCard) )
		{
			/* this is matin1 */
			strcpy( TypMatrx.chMatrix, "matin1 " );
		}

		else if( lgMatch("LINP",chCard) )
		{
			/* linpack is the default, set in zero.c */
			strcpy( TypMatrx.chMatrix, "linpack" );
		}

		else if( lgMatch("BEVI",chCard) )
		{
			/* Bevington matinv  */
			strcpy( TypMatrx.chMatrix, "Bevingt" );
		}

		else if( lgMatch("VECL",chCard) )
		{
			/* veclib, not currently implimented */
			strcpy( TypMatrx.chMatrix, "veclib " );
		}

		else
		{
			fprintf( ioQQQ, " The matrix inversion routines I know about are LINPACK, VECLIB, and MATIN1.\n" );
			puts( "[Stop in ParseSet]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	/* >>chng 00 dec 08, command added by Peter van Hoof */
	else if( lgMatch("NFNU",chCard) )
	{
		/* set nFnu [incident_reflected] [incident_transmitted] [diffuse_inward] [diffuse_outward]
		 *   command for specifying what to include in the nFnu entries in LineSv */
		/* >>chng 01 nov 12, also accept form with space */
		/* "incident reflected" keyword */
		printit.lgSourceReflected = lgMatch("NT R",chCard) || lgMatch("NT_R",chCard);
		/* "incident transmitted" keyword */
		printit.lgSourceTransmitted = lgMatch("NT_T",chCard) || lgMatch("NT T",chCard);
		/* "diffuse inward" keyword */
		printit.lgDiffuseInward = lgMatch("SE_I",chCard) || lgMatch("SE I",chCard);
		/* "diffuse outward" keyword */
		printit.lgDiffuseOutward = lgMatch("SE_O",chCard) || lgMatch("SE O",chCard);

		/* at least one of these needs to be set ! */
		if( ! ( printit.lgSourceReflected || printit.lgSourceTransmitted ||
			printit.lgDiffuseInward || printit.lgDiffuseOutward ) )
		{
			fprintf( ioQQQ, " set nFnu expects one or more of the following keywords:\n" );
			fprintf( ioQQQ, " INCIDENT_REFLECTED, INCIDENT_TRANSMITTED, DIFFUSE_INWARD, DIFFUSE_OUTWARD\n" );
			puts( "[Stop in ParseSet]" );
			cdEXIT(EXIT_FAILURE);
		}
		/* automatically print the nFnu items in the output - it is not necessary to also include
		 * a print continua command if this is entered */
		printit.lgPrnDiff = TRUE;
	}

	else if( lgMatch("TEMP",chCard) )
	{
		/* set something to do with temperature, currently solver, tolerance, floor */
		if( lgMatch("SOLV",chCard) )
		{
			/* solver */
			/* the electron density solver */
			if( lgMatch("NEW",chCard) ) 
			{
				/* new method */
				strcpy( conv.chSolverTemp , "new" );
			}
			else
			{
				/* default method */
				strcpy( conv.chSolverTemp , "simple" );
			}
		}
		else if( lgMatch("FLOO",chCard) )
		{
			i = 5;
			StopCalc.TeFloor = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

			/*  linear option */
			if( StopCalc.TeFloor <= 10. && !lgMatch("LINE",chCard) )
			{
				StopCalc.TeFloor = (float)pow(10.f,StopCalc.TeFloor);
			}

			if( lgEOL )
			{
				NoNumb(chCard);
			}

			if( StopCalc.TeFloor < 2.8 )
			{
				fprintf( ioQQQ, " TE < 3K, reset to 2.8K.\n" );
				StopCalc.TeFloor = 2.8f;
			}
		}
		else if( lgMatch("TOLE",chCard) )
		{
			/* error tolerance in heating cooling match, number is error/total */
			i = 5;
			conv.HeatCoolRelError = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
			if( lgEOL )
			{
				NoNumb(chCard);
			}
			if( conv.HeatCoolRelError <= 0. )
			{
				conv.HeatCoolRelError = (float)pow(10.f,conv.HeatCoolRelError);
			}
		}
		else
		{
			fprintf( ioQQQ, "\nI did not recognize a keyword on this SET TEPERATURE command.\n%s\n" , chCard);
			fprintf( ioQQQ, "The keywords are SOLVer, FLOOr, and TOLErance.\n" );
			puts( "[Stop in ParseSet]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	else if( lgMatch("TEST",chCard) )
	{
		/* set flag saying to turn on some test */
		Testit.lgTestOn = TRUE;
	}

	else if( lgMatch("TRIM",chCard) )
	{
		/* set trim upper or lower, for ionization stage trimming
		 * in routine TrimStage */
		i = 5;
		if( lgMatch("UPPE",chCard) )
		{
			/* set trim upper */
			IonRange.trimhi = pow(10.,FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL));
		}

		else if( lgMatch("LOWE",chCard) )
		{
			/* set trim lower */
			IonRange.trimlo = pow(10.,FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL));
		}

		else if( lgMatch("SMAL",chCard) )
		{
			/* set small limits to both upper and lower limit*/
			IonRange.trimlo = SMALLFLOAT;
			IonRange.trimhi = SMALLFLOAT;
			lgEOL = FALSE;
		}

		else
		{
			/* set trim upper */
			IonRange.trimhi = pow(10.,FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL));

			/* set trim lower to same number */
			IonRange.trimlo = IonRange.trimhi;
		}

		if( lgEOL )
		{
			NoNumb(chCard);
		}

		if( IonRange.trimlo >= 1. || IonRange.trimhi >= 1. )
		{
			fprintf( ioQQQ, " number must be negative since log\n" );
			puts( "[Stop in ParseSet]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	else if( lgMatch("SKIP",chCard) )
	{
		/* skip punch command, for punching every n't point */
		i = 5;
		PunchSkip.ncPunchSkip = (long)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( lgEOL )
		{
			NoNumb(chCard);
		}
	}

	else if( lgMatch("EAKH",chCard) )
	{
		/* set WeakHeatCool, threshold on punch heating and cooling, default 0.05 */
		i = 5;
		WkHtCl.WeakHeatCool = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

		if( lgEOL )
		{
			NoNumb(chCard);
		}

		if( WkHtCl.WeakHeatCool < 0. )
		{
			WkHtCl.WeakHeatCool = (float)pow(10.f,WkHtCl.WeakHeatCool);
		}
	}

	else if( lgMatch("KSHE",chCard) )
	{
		/* upper limit to opacities for k-shell ionizaiton */
		i = 5;
		KshllEnr.EnergyKshell = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( lgEOL )
		{
			NoNumb(chCard);
		}

		if( KshllEnr.EnergyKshell == 0. )
		{
			/* arg of 0 causes upper limit to energy array */
			KshllEnr.EnergyKshell = rfield.egamry;
		}

		else if( KshllEnr.EnergyKshell < 194. )
		{
			fprintf( ioQQQ, " k-shell energy must be greater than 194 Ryd\n" );
			puts( "[Stop in ParseSet]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	else if( lgMatch("NCHR",chCard) )
	{
		/* option to set the number of charge states for grain model */
		long ii = 5;
		double val = FFmtRead(chCard,&ii,INPUT_LINE_LENGTH,&lgEOL);

		if( lgEOL )
		{
			NoNumb(chCard);
		}
		else
		{
			long nChrg = NINT(val);
			if( nChrg < 2 || nChrg > NCHS )
			{
				fprintf( ioQQQ, " illegal value for number of charge states: %ld\n", nChrg );
				fprintf( ioQQQ, " choose a value between 2 and %ld\n", NCHS );
				fprintf( ioQQQ, " or increase NCHS in grainvar.h and recompile\n" );
				puts( "[Stop in ParseSet]" );
				cdEXIT(EXIT_FAILURE);
			}
			else
			{
				SetNChrgStates(nChrg);
			}
		}
	}

	else if( lgMatch("NEGO",chCard) )
	{
		/* punch negative opacities if they occur, set negopac */
		opac.lgNegOpacIO = TRUE;
	}

	else if( lgMatch("NEND",chCard) )
	{
		/* default limit to number of zones to be computed
		 * only do this if nend is NOT currently left at its default
		 * nend is set to nEndDflt in routine zero
		 * this command only has effect if stop zone not entered */
		if( ZoneCnt.lgEndDflt )
		{
			i = 5;
			/* this is default limit to number of zones, change it to this value */
			ZoneCnt.nEndDflt = (long)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
			ZoneCnt.lgEndDflt = FALSE;
			if( lgEOL )
			{
				NoNumb(chCard);
			}

			/* now change all limits, for all iterations, to this value */
			for( i=0; i < ITRDIM; i++ )
			{
				ZoneCnt.nend[i] = ZoneCnt.nEndDflt;
			}
		}
	}

	else if( lgMatch("TSQD",chCard) )
	{
		/* upper limit for highest density considered in the 
		 * Peimbert-style t^2 section of the printout */
		i = 5;
		peimbt.tsqden = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

		if( lgEOL )
		{
			NoNumb(chCard);
		}
		peimbt.tsqden = (float)pow(10.f,peimbt.tsqden);
	}

	else if( lgMatch("NMAP",chCard) )
	{
		/* how many steps in plot or punch of heating-cooling map */
		i = 5;
		MapPar.nMapStep = (long)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( lgEOL )
		{
			NoNumb(chCard);
		}
	}

	else if( lgMatch("NUME",chCard) && lgMatch("DERI",chCard) )
	{
		/* this is an option to use numerical derivatives for heating and cooling */
		NumDeriv.lgNumDeriv = TRUE;
	}

	/* set path for certain files */
	else if( lgMatch("PATH",chCard) )
	{
		/* set path for picking up files
		 * format is for path to be within double quotes */
		lgDataPathSet = TRUE;

		/* 
		 * get any string within double quotes, and return it as
		 * null terminated string to chDataPath
		 * also sets name in OrgCard and chCard to blanks so that
		 * do not trigger off it later 
		 */
		GetQuote( chDataPath , chCard );

		/* make sure path ends with proper end of line for unix, dos, or vms *
		 * do nothing in any of these cases */

		/* find end of string, null char */
		chEnd = strchr( chDataPath ,'\0' );
		if( chEnd==NULL )
		{
			fprintf( ioQQQ, " strchr returned NULL in ParseSet\n" );
			puts( "[Stop in ParseSet]" );
			cdEXIT(EXIT_FAILURE);
		}

		/* set pointer to last valid char */
		--chEnd;

		/* now see what this char is */
		if( (*chEnd != '/' && *chEnd != ']') && *chEnd != '\\' )
		{
			/* string is not ended properly, we will have to do it */

			/* find which character to end with since none set above *
			 * there must have been something within the string to indicate 
			 * what type of system we are on */
			if(strchr( chDataPath , '/' ) != NULL )
			{
				/* there was a forward slash somewhere, so cat another to the end */
				strcat( chDataPath , "/" );
			}
			else if( strchr( chDataPath , '\\' ) != NULL )
			{
				/* there was a backward slash somewhere, so cat another to the end */
				strcat( chDataPath , "\\" );
			}
			else if( strchr( chDataPath , '[' ) != NULL )
			{
				/* there was a [ somewhere, so cat ] to the end */
				/* this should work on a vms machine, but I have not tried it */
				strcat( chDataPath , "]" );
			}
			/* if none of the above were triggered then we did not find anything, 
			 * just leave it alone, either user knew something we didn't, or will
			 * fail when we try to open the file later on */
		}
		/*printf(" final path is %s \n",chDataPath );*/
	}

	else if( lgMatch("PHFI",chCard) )
	{
		/* which version of PHFIT to use, 1995 or 1996 */
		i = 5;
		ip = (long)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( lgEOL )
		{
			NoNumb(chCard);
		}

		if( ip == 1995 )
		{
			/* option to go back to old results, pre op */
			PhFitOn.lgPhFit = TRUE;
		}
		else if( ip == 1996 )
		{
			/* default is to use newer results, including opacity project */
			PhFitOn.lgPhFit = FALSE;
		}
		else
		{
			fprintf( ioQQQ, " Two possible values are 1995 and 1996.\n" );
			puts( "[Stop in ParseSet]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	else if( lgMatch("WIDT",chCard) )
	{
		/* set line width for contrast in continuum plots */
		i = 5;
		/* units are km/sec */
		PLWidth.PunchLWidth = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

		/* lgEOL if no number hit, could have been c */
		if( lgEOL )
		{
			if( lgMatch("  C " , chCard ) )
			{
				/* no number but __c_, so enter speed of light in km/s */
				PLWidth.PunchLWidth = (float)(SPEEDLIGHT/1e5);
			}
			else
			{
				NoNumb(chCard);
			}
		}

		if( PLWidth.PunchLWidth <= 0. )
		{
			fprintf( ioQQQ, " line width must be greater than zero.\n" );
			puts( "[Stop in ParseSet]" );
			cdEXIT(EXIT_FAILURE);
		}
		/* this is the factor that is used to add the lines to the continuum,
		 * 15 converts to cm/s */
		PLWidth.PunchLWidth = (float)(SPEEDLIGHT/(PLWidth.PunchLWidth*1e5));

	}
	else
	{
		fprintf( ioQQQ, " I didnt recognize a key on this SET line.\n" );
		puts( "[Stop in ParseSet]" );
		cdEXIT(EXIT_FAILURE);
	}


#	ifdef DEBUG_FUN
	fputs( " <->ParseSet()\n", debug_fp );
#	endif
	return;
}

