/*ParseGrainP parse parameters on pgrains command 
 * this will become the default grains at some future time*/
#include "cddefines.h"
#include "grainvar.h"
#include "physok.h"
#include "input.h"
#include "varypar.h"
#include "parse.h"
#include "mie.h"

void ParseGrainP(char *chCard, 
		 int *lgDSet)
{
	int lgEOL, 
	  lgEOL2,
	  lgLinSet, 
	  lgLogLinSet, 
	  lgQuoteFound,
	  lgSizeDistribution;
	GrainPar gp;

	char chFile[FILENAME_PATH_LENGTH_2];/*possible name of input file with opacities */
	long int i;
	double gsize;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseGrainP()\n", debug_fp );
#	endif

#ifdef INCLUDE_OLD_GRAINS
	/* grain model, numbers are logs of grain abundance rel to std */
	gv.lgDustOn = TRUE;
#endif

	*lgDSet = TRUE;

	/* >>chng 00 dec 20, initialize chFile to empty string..., PvH */
	chFile[0] = '\0';
	/* >>chng 01 jan 17, read filename first, it may contain digits that would upset FFmtRead,
	 * as well as other tests that will follow. GetQuote will erase the filename from chCard, PvH */
	lgQuoteFound = strchr( input.chOrgCard,'\"' ) != NULL;
	if( lgQuoteFound )
	{
		/* 
		 * this will both scan in whatever label is inside the quotes in OrgCard, 
		 * but also remove the contents there and in chCard,
		 * so that following keywords will not trigger off it
		 */
		GetQuote( chFile , chCard );
	}

	/* now check for the keyword "function" - this is a special case,
	 * where grain abundance varies with depth */
	gp.lgAbunVsDepth = lgMatch("FUNC",chCard);

	/* check for the keyword "single bin" - 
	 * use resolved grain size distributions if not present */
	lgSizeDistribution = ! lgMatch("SING",chCard);

	/* check for the keyword "qheating" - 
	 * quantum heating should be turned on */
	gp.lgForbidQHeating = FALSE;
	gp.lgRequestQHeating = lgMatch("QHEA",chCard);

	/* the keyword "no qheat" always takes precedence */
	if( lgMatch("O QH",chCard) ) {
		gp.lgForbidQHeating = TRUE;
		gp.lgRequestQHeating = FALSE;
		physok.lgPhysOK = FALSE;
	}
	
	/* log - linear option for grain abundance */
	lgLogLinSet = FALSE;
	lgLinSet = FALSE;
	if( lgMatch(" LOG",chCard) )
	{
		lgLogLinSet = TRUE;
		lgLinSet = FALSE;
	}
	else if( lgMatch("LINE",chCard) )
	{
		lgLogLinSet = TRUE;
		lgLinSet = TRUE;
	}

	/* get the grain abundance as the first parameter,
	 * returns 0 if no number, ok since interpreted as log, or unity*/
	i = 5;
	gp.dep = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

	/* scan off second number, probably not there */
	gsize = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL2);

	/* was keyword log or linear on the line? */
	if( lgLogLinSet )
	{
		/* log or linear was specified, which was it */
		if( lgLinSet )
		{
			/* linear quantity entered, check it */
			if( gp.dep <= 0. )
			{
				fprintf( ioQQQ, " Impossible value for linear abundance.\n" );
				fprintf( ioQQQ, " Abundance entered was%10.2e\n", gp.dep );
				fprintf( ioQQQ, " Sorry.\n" );
				puts( "[Stop in ParseGrainP]" );
				cdEXIT(EXIT_FAILURE);
			}
		}
		else
		{
			gp.dep = pow(10.,gp.dep);
		}
	}
	else
	{
		/* neither log nor linear specified, check sign
		 * force it to be a log - linear if greater than 0 */
		if( gp.dep <= 0. )
		{
			gp.dep = pow(10.,gp.dep);
		}
	}

	if( gp.dep < FLT_MIN )
	{
		fprintf( ioQQQ, " Grain abundance entered here (%f) is impossible.\n", gp.dep );
		puts( "[Stop in ParseGrainP]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* it is possible that there is a file name on the command line - 
	 * if so then we want to call correct reoutine, and not look for keywords 
	 * the signature of a keyword is a pair of quotes - is one present?
	 */
	if( lgQuoteFound )
	{
		/* this is the new code for many-sized grains */
		mie_read_opc(chFile,gp);
	}
	else
	{
		if( lgMatch("ORIO",chCard) )
		{
			/* optional keyword ORION to use orion curves for large R grains */
			/* only turn on one if graphite or silicate is on line, both if not */
			if( lgMatch("GRAP",chCard) )
			{
				/* only turn on orion graphite */
				if( lgSizeDistribution )
				{
					mie_read_opc("graphite_orion_10.opc",gp);
				}
				else
				{
					mie_read_opc("graphite_orion_01.opc",gp);
				}
			}
			else if( lgMatch("SILI",chCard) )
			{
				/* only turn on orion silicate */
				if( lgSizeDistribution )
				{
					mie_read_opc("silicate_orion_10.opc",gp);
				}
				else
				{
					mie_read_opc("silicate_orion_01.opc",gp);
				}
			}
			else
			{
				/* turn both on */
				if( lgSizeDistribution )
				{
					mie_read_opc("graphite_orion_10.opc",gp);
					mie_read_opc("silicate_orion_10.opc",gp);
				}
				else
				{
					mie_read_opc("graphite_orion_01.opc",gp);
					mie_read_opc("silicate_orion_01.opc",gp);
				}
			}
		}

		else if( lgMatch("GREY",chCard) || lgMatch("GRAY",chCard))
		{
			/* grey grains */
			if( lgSizeDistribution )
			{
				mie_read_opc("grey_ism_10.opc",gp);
			}
			else
			{
				mie_read_opc("grey_ism_01.opc",gp);
			}
		}

		else if( lgMatch(" ISM",chCard) )
		{
			if( lgMatch("GRAP",chCard) )
			{
				/* only turn on ism graphite */
				if( lgSizeDistribution )
				{
					mie_read_opc("graphite_ism_10.opc",gp);
				}
				else
				{
					mie_read_opc("graphite_ism_01.opc",gp);
				}
			}
			else if( lgMatch("SILI",chCard) )
			{
				/* only turn on orion silicate */
				if( lgSizeDistribution )
				{
					mie_read_opc("silicate_ism_10.opc",gp);
				}
				else
				{
					mie_read_opc("silicate_ism_01.opc",gp);
				}
			}
			else
			{
				/* turn both ISM graphite and silicate on */
				if( lgSizeDistribution )
				{
					mie_read_opc("graphite_ism_10.opc",gp);
					mie_read_opc("silicate_ism_10.opc",gp);
				}
				else
				{
					mie_read_opc("graphite_ism_01.opc",gp);
					mie_read_opc("silicate_ism_01.opc",gp);
				}
			}
		}

		/* this case - single sized silicate,
		 * but only if second number was on command line */
		else if( lgMatch("SILI",chCard) && !lgEOL2 )
		{
			if( fabs( gsize/0.01 - 1.) < 0.01 )
			{
				mie_read_opc("silicate_0m010.opc",gp);
			}
			else if( fabs( gsize/0.1 - 1.) < 0.01 )
			{
				mie_read_opc("silicate_0m100.opc",gp);
			}
			else if( fabs( gsize/1. - 1.) < 0.01 )
			{
				mie_read_opc("silicate_1m000.opc",gp);
			}
			else
			{
				fprintf( ioQQQ, " Silicate size must be specified\n" );
				fprintf( ioQQQ, " Sorry.\n" );
				puts( "[Stop in ParseGrainP]" );
				cdEXIT(EXIT_FAILURE);
			}
		}

		/* default case */
		else
		{
			/* turn both ISM graphite and silicate on */
			if( lgSizeDistribution )
			{
				mie_read_opc("graphite_ism_10.opc",gp);
				mie_read_opc("silicate_ism_10.opc",gp);
			}
			else
			{
				mie_read_opc("graphite_ism_01.opc",gp);
				mie_read_opc("silicate_ism_01.opc",gp);
			}
		}
	}

	/* option to turn off photoelectric heating by grain, NO HEATING */
	if( lgMatch("O HE",chCard) )
	{
		physok.lgPhysOK = FALSE;
		gv.lgDHetOn = FALSE;
	}

	/* option to turn off gas cooling by grain, NO COOLING */
	if( lgMatch("O CO",chCard) )
	{
		physok.lgPhysOK = FALSE;
		gv.lgDColOn = FALSE;
	}


	/* vary option */
	if( VaryPar.lgVarOn )
	{
		char chHold[INPUT_LINE_LENGTH];
		/*  pointer to where to write */
		VaryPar.nvfpnt[VaryPar.nparm] = input.nRead;
		VaryPar.vparm[0][VaryPar.nparm] = (float)log10(gp.dep);
		VaryPar.vincr[VaryPar.nparm] = 1.;

		/* these are varios options for density laws, 
		 * first is constant density or pressre*/
		strcpy( VaryPar.chVarFmt[VaryPar.nparm] , "PGRAIN DISTRIBUTION ABUND=%f LOG ");
		/* >>chng 00 dec 20, chFile may not be defined..., PvH */
		if( chFile[0] != '\0' )
		{
			sprintf(chHold , "\"%s\" ", chFile  );
			strcat( VaryPar.chVarFmt[VaryPar.nparm] , chHold );
		}

		VaryPar.nvarxt[VaryPar.nparm] = 1;
		++VaryPar.nparm;
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseGrainP()\n", debug_fp );
#	endif
	return;
}

