/*ParseAtomHeLike parse parameters off the helium command */
#include "cddefines.h"
#include "taulines.h"
#include "helike.h"
#include "physok.h"
#include "iso.h"
#include "parse.h"

void ParseAtomHeLike(char *chCard )
{
	long int i, 
		nHe,
		nelem;
	int lgEOL;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseAtomHeLike()\n", debug_fp );
#	endif

	if( lgMatch("COLL",chCard) )
	{
		if( lgMatch("EXCI",chCard) )
		{
			/* turn off collisional excitation */
			iso.lgColl_excite[ipHE_LIKE] = FALSE;
			physok.lgPhysOK = FALSE;
		}
		else if( lgMatch("IONI",chCard) )
		{
			/* turn off collisional ionization */
			iso.lgColl_ionize[ipHE_LIKE] = FALSE;
			physok.lgPhysOK = FALSE;
		}
		else if( lgMatch("L-MI",chCard) )
		{
			/* >>chng 02 feb 07, change from 2s2p to l-mixing */
			/* this is the atom he-like collision l-mixing command */
			/* turn off same-n collisions */
			iso.lgColl_l_mixing[ipHE_LIKE] = FALSE;
			physok.lgPhysOK = FALSE;
		}
		else
		{
			/* turn everything off, since no keyword given */
			iso.lgColl_excite[ipHE_LIKE] = FALSE;
			iso.lgColl_ionize[ipHE_LIKE] = FALSE;
			iso.lgColl_l_mixing[ipHE_LIKE] = FALSE;
			physok.lgPhysOK = FALSE;
		}
#		if 0
		/* >>chng 02 feb 11, bogus logic, remove since work done with above */
		/* turn off helium atom collisions */
		if( lgMatch(" OFF",chCard) )
		{
			helike.lgHeClON = FALSE;
		}
		else
		{
			helike.lgHeClON = TRUE;
		}
#		endif
	}

	else if( lgMatch("BENJ",chCard) )
	{
		/* use set of physics to replicate Benjamin et al HeI papers */
		/* affects are:
				use his recombination coefficients, rather than Milne relation results
				do not use fake 0.1 collisions for transitions with no data
				no collisional excitation to n=5 */

		helike.lgSetBenjamin = TRUE;
	}

	else if( lgMatch(" NEW",chCard) )
	{
		helike.lgUseOld = FALSE;
	}

	else if( lgMatch(" OLD",chCard) )
	{
		helike.lgUseOld = TRUE;
	}

	else if( lgMatch("LEVE",chCard) )
	{
		/* the number of levels read in is n, the principal quantum number
		 * only lines with upper levels less than n will be printed */

		/* number of levels for helium iso-sequence */
		/* there are two options here,
		 * when keyword ELEMENT appears, scan off element name and change levels only for
		 * that one.
		 * when there is no ELEMENT then set all he-like levels to same number */

		/* lgHydroMalloc is FALSE at start of calculation, set true when space 
		 * allocated for the hydrogen and helium lines.  Once done we must ignore all 
		 * future changes in the number of levels */
		if( !lgHydroMalloc )
		{
			i = 5;
			nHe = (long int)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

			if( lgEOL )
			{
				/* must be a number, or a key, either large (or limit) or small
				 * if no number but LARGER or SMALL then set to preset number */
				if( lgMatch("LARG",chCard) )
				{
					/* there is no real limit, but this includes all levels with tabulated rec coef
					 * set to 20 in helike.h*/
					nHe = HE_RREC_MAXN;
				}

				/* this is small or compact keyword */
				else if( lgMatch("SMAL",chCard) || lgMatch("COMP",chCard) )
				{
					/* a small atom only has n=3, 13 levels */
					nHe = 3;
				}

				/* this is limit keyword, sets to largest possible value */
				else
				{
					/* punch out if no number */
					NoNumb(chCard);
				}
			}
			else if( nHe < 3 )
			{
				fprintf( ioQQQ, " cannot have fewer than 3 levels, the requested number was %li\n" ,
					nHe  );
				fprintf( ioQQQ, " Sorry.\n" );
				puts( "[Stop in ParseAtomHeLike]" );
				cdEXIT(EXIT_FAILURE);
			}

			/* we now have the desired number of levels, and it has been fully qualified. 
			 * now check whether ELEMENT keyword is on line, if not then set all to
			 * the number, if so then only element in use */
			if( lgMatch("ELEM",chCard) )
			{
				/* check which element is on the line, nelem is atomic number on C scale */
				nelem = GetElem(chCard);
				{
					iso.n_HighestResolved[ipHE_LIKE][nelem] = nHe;
					iso.numLevels[ipHE_LIKE][nelem] = nHe*nHe + nHe + 1;
					iso.numPrintLevels[ipHE_LIKE][nelem] = (nHe-1)*(nHe-1) + (nHe-1) + 1;
				}
			}
			else
			{
				/* keyword element did not appear, so set all he-like species to this number */
				for( i=ipHELIUM; i<LIMELM; ++i )
				{
					iso.n_HighestResolved[ipHE_LIKE][i] = nHe;
					iso.numLevels[ipHE_LIKE][i] = nHe*nHe + nHe + 1;
					iso.numPrintLevels[ipHE_LIKE][i] = (nHe-1)*(nHe-1) + (nHe-1) + 1;
				}
			}
		}
	}

	else if( lgMatch("TOPO",chCard) )
	{
		/* number of levels needed to top off the he atoms,
		 * these will be added to the total number of levels */
		i = 5;
		iso.nTopOff[ipHE_LIKE] = (long int)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

		if( lgEOL )
		{
			NoNumb(chCard);
		}
	}

	else
	{
		fprintf( ioQQQ, " There should have been a keyword - STOP\n" );
		puts( "[Stop in ParseAtomHeLike]" );
		cdEXIT(EXIT_FAILURE);
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseAtomHeLike()\n", debug_fp );
#	endif
	return;
}

