/*ParseAtomH2 parse information from the rotor command line */
#include "cddefines.h"
#include "h2.h"
#include "parse.h"

void ParseAtomH2(char *chCard )
{
	int lgEOL;
	long int i , j;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseAtomH2()\n", debug_fp );
#	endif

	/* this command has a 2 in the H2 label - must not parse the two by
	 * accident.  Get the first number off the line image, and confirm that
	 * it is a 2 */
	i = 5;
	j = (long int)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
	if( j != 2 )
	{
		fprintf( ioQQQ, " Something is wrong with the order of the numbers on this line.\n" );
		fprintf( ioQQQ, " The first number I encounter should be a 2.\n Sorry.\n" );
		puts( "[Stop in ParseAtomH2]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* the mere calling of this routine turns the large H2 molecule on */
	h2.lgH2ON = TRUE;

	if( lgMatch("LEVE",chCard) )
	{
		/* number of electronic levels */

		/* lgH2_READ_DATA is FALSE at start of calculation, set true when space 
		 * allocated for the H lines.  Once done we must ignore all 
		 * future changes in the number of levels */
		if( !lgH2_READ_DATA )
		{
			h2.nelec = (long int)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
			if( lgEOL )
			{
				if( lgMatch("LARG",chCard) )
				{
					/* LARGE is option to use the most number of electronic levels */
					h2.nelec = N_H2_ELEC;
				}
				else
				{
					NoNumb(chCard);
				}
			}

			if( h2.nelec < 2 )
			{
				fprintf( ioQQQ, " This would be too few levels.\n" );
				puts( "[Stop in ParseAtomH2]" );
				cdEXIT(EXIT_FAILURE);
			}
			/* N_H2_ELEC is in h2.h and is the greatest number of elec lev possible */
			else if( h2.nelec > N_H2_ELEC )
			{
				fprintf( ioQQQ, 
					" This would be too many levels, the limit is %i.\n" , 
					N_H2_ELEC);
				puts( "[Stop in ParseAtomH2]" );
				cdEXIT(EXIT_FAILURE);
			}
		}
	}

	else if( lgMatch("LIMI",chCard) )
	{
		/* the limit to the H2 / Htot ratio - 
		* if smaller than this, do not compute large H2 mole */
		h2.H2_to_H_limit = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		/* a number <= 0 is the log of the ratio */
		if( h2.H2_to_H_limit <= 0. )
			h2.H2_to_H_limit = pow(10., h2.H2_to_H_limit);
	}
	/* there is no final branch - if we do not find a keyword, simply
	 * turn on the H2 molecule */

#	ifdef DEBUG_FUN
	fputs( " <->ParseAtomH2()\n", debug_fp );
#	endif
	return;
}

