/*OpacityAdd1Element enter total photo cross section for all subshells into opacity array */
#include "cddefines.h"
#include "iso.h"
#include "rfield.h"
#include "heavy.h"
#include "helike.h"
#include "ionfracs.h"
#include "opacity.h"

void OpacityAdd1Element(
		/* nelem is 0 for H, 1 for He, etc */
		long int nelem)
{
	long int ipHi, 
	  ipop, 
	  limit,
	  low, 
	  n, 
	  ion, 
	  nshell;
	char chStat;
	float abundance;

#	ifdef DEBUG_FUN
	fputs( "<+>OpacityAdd1Element()\n", debug_fp );
#	endif

	/* this routine drives OpacityAdd1Subshell to put in total opacities for all shells*/

	/*begin sanity check */
	assert (nelem >=0 );
	ASSERT( nelem < LIMELM );

	/* this is number of species that are not treated on common iso-electronic series */
	/*limit = nelem-1;*/
	limit = nelem + 1 - NISO;
	/* this can be called with hydrogen itself, in which case nelem is 0 */
	limit = MAX2( 0 , limit );

	/* do not include the ion stages that have complete atoms,
	 * currently H and He like iso sequences */
	for( ion=0; ion < limit; ion++ )
	{
		if( xIonFracs[nelem][ion] > 0. )
		{
			/*start with static opacities, then do volatile*/
			
			chStat = 's';
			/* number of bound electrons */
			for( nshell=0; nshell < Heavy.nsShells[nelem][ion]; nshell++ )
			{
				/* highest shell will be volatile*/
				if( nshell== Heavy.nsShells[nelem][ion]-1 )
					chStat = 'v';
				/* set lower and upper limits to this range */
				low = opac.ipElement[nelem][ion][nshell][0];
				ipHi = opac.ipElement[nelem][ion][nshell][1];
				ipop = opac.ipElement[nelem][ion][nshell][2];
				/* OpacityAdd1Subshell will not do anything if static opacities do not need to be reset*/
				OpacityAdd1Subshell(ipop,low,ipHi,xIonFracs[nelem][ion] , chStat );
			}
		}
	}

	/* >>chng 02 jan 17, add loop over H and He like */
	/* ion is on the c scale, =0 for HI, =1 for HeII */
	for( ion=limit; ion<nelem+1; ++ion )
	{
		/* ipISO is 0 for H-like, 1 for He-like */
		long int ipISO = nelem-ion;
		ASSERT( ipISO == ipHYDROGEN || ipISO == ipHELIUM );

		/* now do H-like and He-like, but only if present 
		 * test for nelem+1 in case atom present but not ion, test is whether the
		 * abundance of the recombined species is present */
		/* >>chng 02 jan 17, sec dim had been nelem+1, change to ion+1 */
		/*if( xIonFracs[nelem][nelem] > 0. )*/
		if( xIonFracs[nelem][ion] > 0. )
		{
			/* do ground first, then all excited states */
			n = 0;
			/* abundance of recombined species, which can be zero if no ion present */
			/* >>chng 02 jan 17, to arbitrary iso sequence */
			/*abundance = iso.Pop2Ion[ipH_LIKE][nelem][n]*xIonFracs[nelem][nelem+1];*/
			abundance = iso.Pop2Ion[ipISO][nelem][n]*xIonFracs[nelem][ion+1];
			/*TODO remove second part of test when he is ready */
			/* >>chng 02 may 06, add second test, had been just the chck on helium,
			 * with no option to use new soln */
			if( abundance == 0. || (helike.lgUseOld && ipISO==ipHELIUM ) )
			/* >>chng 02 jan 17, logical error here, must use xIonFracs if abundance is 0 */
			{
				/* no ionized species, assume everything in ground */
				/* >>chng 02 jan 17, to arbitrary iso sequence */
				abundance = xIonFracs[nelem][ion];
			}

			/* >>chng 02 jan 17, to arbitrary iso sequence */
			/* use computed opacities and departure coef for level */
			OpacityAdd1SubshellInduc(
				iso.ipOpac[ipISO][nelem][n],
				iso.ipIsoLevNIonCon[ipISO][nelem][n],
				/* the upper limit to the integration, 
				 * ground opacity goes up to the high energy limit of code*/
				rfield.nflux,
				/* the abundance of the ion */
				abundance,
				/* departure coef, volatile opac, always reevaluate */
				iso.DepartCoef[ipISO][nelem][n] , 'v' );

			/* do excited levvels,
			 * this loop only if upper levels have finite population*/
			/* >>chng 02 jan 17, to arbitrary iso sequence */
			/*if( iso.Pop2Ion[ipH_LIKE][nelem][3]*xIonFracs[nelem][nelem+1] > 0. )*/
			if( iso.Pop2Ion[ipISO][nelem][3]*xIonFracs[nelem][ion+1] > 0. )
			{
				char chType = 'v';
				/* always want to evaluate all opacities for n=3, 4, use static opacities for higher levels */
				/* >>chng 02 jan 17, to arbitrary iso sequence, use single loop, setting type of opacity */
				for( n=1; n < iso.numLevels[ipISO][nelem]; n++ )
				{
					/* this is for lower levels */
					OpacityAdd1SubshellInduc(
						iso.ipOpac[ipISO][nelem][n],
						iso.ipIsoLevNIonCon[ipISO][nelem][n],
						/* the high energy bound of excited states is the 
						 * edge of the Lyman continuum */
						iso.ipIsoLevNIonCon[ipISO][nelem][0],
						iso.Pop2Ion[ipISO][nelem][n]*xIonFracs[nelem][ion+1],
						/* departure coef, volitile opacities */
						iso.DepartCoef[ipISO][nelem][n] , chType );
					/* above 4 is static */
					if( n==4)
						chType = 's';
				}
			}
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->OpacityAdd1Element()\n", debug_fp );
#	endif
	return;
}

