/*molcol generate and print molecular column densities */
#include "cddefines.h"
#include "hevmolec.h"
#include "radius.h"
#include "phycon.h"
#include "doppvel.h"
#include "molcol.h"

void molcol(char *chLabel)
{
	long int i;
	double Xm4;
	static double xMosheH2O;
	static char chMole[17][5] = 
	{
		"  CH" ,
		" CH+" ,
		"  OH" ,
		" OH+" ,
		"  O2" ,
		"  C2" ,
		"  CO" ,
		" CO+" ,
		" H2O" ,
		"H2O+" ,
		" O2+" ,
		" C2+" ,
		" H3+" ,
		"H3O+" ,
		"CH2+" ,
		" CH2" ,
		" CH3"};

#	ifdef DEBUG_FUN
	fputs( "<+>molcol()\n", debug_fp );
#	endif


	if( strcmp(chLabel,"ZERO") == 0 )
	{
		/*  zero out the column densities */
		for( i=0; i < NHEVML; i++ )
		{
			hevmolec.hevcol[i] = 0.;
		}
		xMosheH2O = 0.;

	}
	else if( strcmp(chLabel,"ADD ") == 0 )
	{
		/*  add together column densities */
		for( i=0; i < NHEVML; i++ )
		{
			hevmolec.hevcol[i] += hevmolec.hevmol[i]*(float)radius.dReff;
		}

		/*  parameters for Moshe's maser theory */
		Xm4 = hevmolec.hevmol[8]*1e4/phycon.hden;
		xMosheH2O += Xm4*(POW2(phycon.hden*1e-9))*(radius.dReff/
		  1e13)*(DoppVel.doppler[8]/1e5);

	}
	else if( strcmp(chLabel,"PRIN") == 0 )
	{
		/*  print the column densities */
		fprintf( ioQQQ, "               " );
		for( i=0; i < 7; i++ )
		{
			fprintf( ioQQQ, " %s:", chMole[i] );
			PrintE93( ioQQQ, hevmolec.hevcol[i] );
		}
		fprintf( ioQQQ, "\n" );

		fprintf( ioQQQ, "               " );
		for( i=7; i < 14; i++ )
		{
			fprintf( ioQQQ, " %s:", chMole[i] );
			PrintE93( ioQQQ, hevmolec.hevcol[i] );
		}
		fprintf( ioQQQ, "\n" );

		fprintf( ioQQQ, "               " );
		for( i=14; i < 17; i++ )
		{
			fprintf( ioQQQ, " %s:", chMole[i] );
			PrintE93( ioQQQ, hevmolec.hevcol[i] );
		}
		fprintf( ioQQQ, "MoH2O ");
		PrintE93( ioQQQ , xMosheH2O );
		fprintf( ioQQQ, "\n" );
	}
	else
	{
		fprintf( ioQQQ, " MOLCOL does not understand the label %4.4s\n", 
		  chLabel );
		puts( "[Stop in molcol]" );
		cdEXIT(EXIT_FAILURE);
	}


#	ifdef DEBUG_FUN
	fputs( " <->molcol()\n", debug_fp );
#	endif
	return;
}

