/*lint -e817 pclint generates tons of bogus nelem < 0 warnings*/
/*MakeRecomb generate recombination coefficients for any species */
/*MakeRecombAGN generate recombination coefficients for AGN table */
#include "cddefines.h"
#include "recom.h"
#include "nsbig.h"
#include "phycon.h"
#include "abundances.h"
#include "tfidle.h"
#include "heavy.h"
#include "ionrange.h"
#include "punch.h"
#include "elementnames.h"
#include "drfe.h"
#include "converge.h"
#include "rrfit.h"
#include "makerecomb.h"

void MakeRecomb(double rec[], 
  double pl[], 
  double *dicoef, 
  double *dite, 
  double ditcrt[], 
  double aa[], 
  double bb[], 
  double cc[], 
  double dd[], 
  double ff[], 
  /* nelem is the atomic number on the C scale, 0 for H */
  long int nelem, 
  double tlow[])
{
#define DICOEF(I_,J_)	(*(dicoef+(I_)*(nelem+1)+(J_)))
#define DITE(I_,J_)	(*(dite+(I_)*(nelem+1)+(J_)))
	long int NeBoundIon, 
	  i, 
	  ion, 
	  limit;
	double 
	  fac2, 
	  factor,
	  DielRecomHiT[LIMELM] ,
	  DielRecomLowT[LIMELM] ,
	  RecomRad3BodGrain[LIMELM] ,
	  t4m1, 
	  tefac;
	float radrec;
	/* these are guessed diel rec rates, taken from 
	  >>refer	all	diel	Ali, B., Blum, R. D., Bumgardner, T. E., Cranmer, S. R., Ferland, G. J., 
	  >>refercon Haefner, R. I., & Tiede, G. P. 1991, PASP, 103, 1182 */
	static double cludge[4]={3e-13,3e-12,1.5e-11,2.5e-11};

#	ifdef DEBUG_FUN
	fputs( "<+>MakeRecomb()\n", debug_fp );
#	endif

	/* set up ionization balance matrix, C(I,1)=destruction, 2=creation
	 * heating rates saved in array B(I) in same scrat block
	 * factor is for Aldrovandi+Pequignot fit, FAC2 is for Nuss+Storey
	 * fit for dielectronic recomb
	 * GrnIonRec is rate ions recombine on grain surface, normally zero;
	 * set in hmole, already has factor of hydrogen density
	 * */

	/* routine only used for Li on up */
	ASSERT( nelem < LIMELM);
	ASSERT( nelem > 1 );

	/* check that range of ionization is correct */
	ASSERT( IonRange.IonLow[nelem] >= 0 );
	ASSERT( IonRange.IonLow[nelem] <= nelem+1 );

	nsbigCom.nsbig = MAX2(IonRange.IonHigh[nelem]+1,nsbigCom.nsbig);
	t4m1 = 1e4/phycon.te;
	fac2 = 1e-14*phycon.sqrte;

	/* test putting limit back to h-like */
	limit = MIN2(nelem,IonRange.IonHigh[nelem]-1);
	limit = MIN2(nelem-2,IonRange.IonHigh[nelem]-1);

	/* zero-out loop comes before main loop since there are off-diagonal
	 * elements in the main ionization loop, due to multi-electron processes */
	/* >>chng 00 dec 07, limit changed to identical to bidiag */
	for( ion=0; ion <= limit; ion++ )
	{
		recom.RecombinRate[nelem][ion] = 0.;
		RecomRad3BodGrain[ion] = 0.;
		DielRecomHiT[ion] = 0.;
		DielRecomLowT[ion] = 0.;
	}
	for( ion=limit+1; ion < LIMELM; ion++ )
	{
		/* >>chng 01 dec 18, do not set this to FLT_MAX since it clobbers what
		 * had been set in h-like and he-like routines - that would only affect
		 * the printout */
		/*recom.RecombinRate[nelem][ion] = -FLT_MAX;*/
		RecomRad3BodGrain[ion] = -FLT_MAX;
		DielRecomHiT[ion] = -FLT_MAX;
		DielRecomLowT[ion] = -FLT_MAX;
	}

	/* H-like and he-like stages use results from hydrogenic series done by hydro... routines */
	/* this was evaluated in hydro routines, and must not be changed here
	 * since we want the bidiag routine to get the same answer */
	RecomRad3BodGrain[nelem] = recom.RecombinRate[nelem][nelem]/phycon.eden ;
	/* now do he-like */
	RecomRad3BodGrain[nelem-1] = recom.RecombinRate[nelem][nelem-1]/phycon.eden ;

	DielRecomHiT[nelem] = 0. ;
	DielRecomHiT[nelem-1] = 0. ;

	DielRecomLowT[nelem] = 0. ;
	DielRecomLowT[nelem-1] = 0. ;

	/* these are counted elsewhere and must not be added here */
	Heavy.xLyaHeavy[nelem][nelem] = 0.;
	Heavy.xLyaHeavy[nelem][nelem-1] = 0.;



	/*--------------------------------------------------------------------- */

	/* ionLow is on physical scale, so is 1 for atom */
	for( ion=IonRange.IonLow[nelem]; ion <= limit; ion++ )
	{
		/* number of bound electrons of the ion, for an atom this is
		 * equal to nelem, the element on the c scale, nelem is 5 for carbon */
		NeBoundIon = nelem - ion;
		if( recom.lgVrrFit )
		{
			/* this branch dima's fits */
			radrec = (float)rrfit( nelem+1 , NeBoundIon+1 , phycon.te );
		}
		else
		{
			/* this branch uses old fits to re coef */
			if( (phycon.te > 1e3 || ion > 0) || tlow[0] == 0. )
			{
				radrec = (float)(rec[ion]*pow((double)phycon.te,pl[ion]));
			}
			else
			{
				/* use special Pequignot and Aldrovandi fit for low temp */
				radrec = (float)(tlow[0]*pow((double)phycon.te,tlow[1]));
			}
		}
		recom.RecombinRate[nelem][ion] = (float)(phycon.eden*(radrec + 
		  recom.CotaRate[ion])) ;

		/* recombinatinon on grain surface */
		recom.RecombinRate[nelem][ion] += recom.GrnIonRec;

		/* rate coefficient for radiative plus three body, and
		 * recombination on grain surfaces */
		RecomRad3BodGrain[ion] = radrec + recom.CotaRate[ion] + recom.GrnIonRec/phycon.eden;

		/* Burgess dielectronic recombination */
		DielRecomHiT[ion] = 0.;
		if( phycon.te > (float)(ditcrt[ion]*0.1) )
		{
			DielRecomHiT[ion] = recom.DielSupprs[0][ion]/phycon.te32*
			  DICOEF(0,ion)*exp(-DITE(0,ion)/phycon.te)*
			  (1. + DICOEF(1,ion)*
			  sexp(DITE(1,ion)/phycon.te));
			recom.RecombinRate[nelem][ion] += (float)(DielRecomHiT[ion]*
			  phycon.eden);
		}
#		if 0
		/* print helium data */
		if( ion ==nelem-1 )
		{
			fprintf(ioQQQ,"%li\t%.1e\t%.2e\t%.2e\t%.2e\t%.2e\n",nelem,
				ditcrt[ion] ,
				DICOEF(0,ion),
				DITE(0,ion),
				DICOEF(1,ion),
				DITE(1,ion));
		}
#		endif

		/* Nussbaumer and Storey dielectronic recombination
		 * do not ever do it for rec from
		 * a closed shell, NeBoundIon is number of bound electrons in ion */
		DielRecomLowT[ion] = 0.;
		if( (NeBoundIon != 2 && NeBoundIon != 10) && NeBoundIon != 18 )
		{
			tefac = ff[ion]*t4m1;
			/* fac2 = 1e-14 * sqrte */
			if( ff[ion] != 0. && fabs(tefac) < 30. )
			{
				factor = (((aa[ion]*t4m1+bb[ion])*t4m1+cc[ion])*t4m1+dd[ion])* exp(-tefac);
				DielRecomLowT[ion] = recom.DielSupprs[1][ion]*fac2*
					MAX2(0.,factor );
			}
			else if( (phycon.te > 100. && ff[ion] == 0.) && ion <= 3 )
			{
				/* >>chng 01 jun 30, make GuessDiel array */
				DielRecomLowT[ion] = recom.DielSupprs[1][ion]*cludge[ion]*
				  recom.GuessDiel[ion];
			}
			recom.RecombinRate[nelem][ion] += (float)(DielRecomLowT[ion]*
			  phycon.eden);
		}

		/* >>chng 01 jun 30, FRAC_LINE was 0.1, not 1, did not include anything except
		 * radiative recombination, the radrec term */
#		define FRAC_LINE 1.
		/* was 0.1 */
		/*Heavy.xLyaHeavy[nelem][ion] = (float)(phycon.eden*radrec*FRAC_LINE );*/
		Heavy.xLyaHeavy[nelem][ion] = (float)(phycon.eden*
			(radrec+DielRecomLowT[ion]+DielRecomHiT[ion])*FRAC_LINE );

	}

	/* for case of iron, add on Dima's fits to diel part, above was zero */
	if( nelem==25 )
	{
		float DieRate;
		/* add on special dima diel coef */
		for( ion=IonRange.IonLow[nelem]; ion < (IonRange.IonHigh[nelem]); ion++ )
		{
			drfe(ion+1,phycon.te,&DieRate);
			DielRecomLowT[ion] = DieRate;
			/*fprintf(ioQQQ,"%li %g %g\n", ion, recom.RecombinRate[NELEM-1][ion], DieRate*phycon.eden );*/
			recom.RecombinRate[nelem][ion] += (float)(DieRate*phycon.eden);
		}
	}

	/* option to punch rec coef */
	if( punch.lgioRecom )
	{
		/* print name of element */
		fprintf( punch.ioRecom, 
			" %s recombination coefficients \n", 
			elementnames.chElementName[nelem] );

		limit = MIN2(11,IonRange.IonHigh[nelem]);
		for( i=0; i < limit; i++ )
		{
			fprintf( punch.ioRecom, "%10.2e", RecomRad3BodGrain[i] );
		}
		fprintf( punch.ioRecom, " radiative + 3body + grain vs Z\n" );

		for( i=0; i < limit; i++ )
		{
			fprintf( punch.ioRecom, "%10.2e", DielRecomHiT[i] );
		}
		fprintf( punch.ioRecom, " Burgess vs Z\n" );

		for( i=0; i < limit; i++ )
		{
			fprintf( punch.ioRecom, "%10.2e", DielRecomLowT[i] );
		}
		fprintf( punch.ioRecom, " Nussbaumer Storey vs Z\n" );

		/* total recombination rate, with density included - this goes into the matrix */
		for( i=0; i < limit; i++ )
		{
			fprintf( punch.ioRecom, "%10.2e", recom.RecombinRate[nelem][i] );
		}
		fprintf( punch.ioRecom, 
			" total rec rate (with density) for %s\n\n", 
			elementnames.chElementSym[nelem] );

		/* spill over to next line for many stages of ionization */
		if( IonRange.IonHigh[nelem] > 11 )
		{
			limit = MIN2(29,IonRange.IonHigh[nelem]);
			fprintf( punch.ioRecom, " R " );
			for( i=11; i < limit; i++ )
			{
				fprintf( punch.ioRecom, "%10.2e", RecomRad3BodGrain[i] );
			}
			fprintf( punch.ioRecom, "\n" );

			fprintf( punch.ioRecom, " B " );
			for( i=11; i < limit; i++ )
			{
				fprintf( punch.ioRecom, "%10.2e", DielRecomHiT[i] );
			}
			fprintf( punch.ioRecom, "\n" );

			fprintf( punch.ioRecom, " NS" );
			for( i=11; i < limit; i++ )
			{
				fprintf( punch.ioRecom, "%10.2e", DielRecomLowT[i] );
			}
			fprintf( punch.ioRecom, "\n" );

			fprintf( punch.ioRecom, "   " );
			for( i=11; i < limit; i++ )
			{
				fprintf( punch.ioRecom, "%10.2e", recom.RecombinRate[nelem][i] );
			}
			fprintf( punch.ioRecom, "\n\n" );
		}
	}

	limit = MIN2(nelem-2,IonRange.IonHigh[nelem]-1);
	for( i=IonRange.IonLow[nelem]; i <= limit; i++ )
	{
		ASSERT( Heavy.xLyaHeavy[nelem][i] > 0. );
		ASSERT( recom.RecombinRate[nelem][i] > 0. );
	}

#	ifdef DEBUG_FUN
	fputs( " <->MakeRecomb()\n", debug_fp );
#	endif
	return;
#undef	DITE
#undef	DICOEF
}

/*MakeRecombAGN generate recombination coefficients for AGN table */
void MakeRecombAGN( FILE * io )
{
#	define N1LIM 3
#	define N2LIM 4
	double te1[N1LIM]={ 5000., 10000., 20000.};
	double te2[N2LIM]={ 20000.,50000.,100000.,1e6};
	/* this is boundary between two tables */
	double BreakEnergy = 100./13.0;
	long int nelem, ion , i;
	/* this will hold element symbol + ionization */
	char chString[100],
		chOutput[100];

#	ifdef DEBUG_FUN
	fputs( "<+>MakeRecomb()\n", debug_fp );
#	endif

	phycon.eden = 1.;
	/*CreateData();*/

	/* first put header on file */
	fprintf(io,"X+i\\Te");
	for( i=0; i<N1LIM; ++i )
	{
		phycon.te = (float)te1[i];
		tfidle(FALSE);
		fprintf(io,"\t%.0f K",phycon.te);
	}
	fprintf(io,"\n");

	/* now do loop over temp, but add elements */
	for( nelem=ipLITHIUM; nelem<LIMELM; ++nelem )
	{
		/* this list of elements included in the AGN tables is defined in zeroabun.c */
		if( abundances.lgAGN[nelem] )
		{
			for( ion=0; ion<=nelem; ++ion )
			{
				ASSERT( Heavy.Valence_IP_Ryd[nelem][ion] > 0.05 );

				if( Heavy.Valence_IP_Ryd[nelem][ion] > BreakEnergy )
					break;

				/* print chemical symbol */
				sprintf(chOutput,"%s", 
					elementnames.chElementSym[nelem]);
				/* some elements have only one letter - this avoids leaving a space */
				if( chOutput[1]==' ' )
					chOutput[1] = chOutput[2];
				/* now ionization stage */
				if( ion==0 )
				{
					sprintf(chString,"0 ");
				}
				else if( ion==1 )
				{
					sprintf(chString,"+ ");
				}
				else
				{
					sprintf(chString,"+%li ",ion);
				}
				strcat( chOutput , chString );
				fprintf(io,"%5s",chOutput );

				for( i=0; i<N1LIM; ++i )
				{
					phycon.te = (float)te1[i];
					IonRange.IonLow[nelem] = 0;
					IonRange.IonHigh[nelem] = nelem+1;
					tfidle(FALSE);
					ConvIonizeOpacityDo(0);
					fprintf(io,"\t%.2e",recom.RecombinRate[nelem][ion]);
				}
				fprintf(io,"\n");
			}
			fprintf(io,"\n");
		}
	}

	/* second put header on file */
	fprintf(io,"X+i\\Te");
	for( i=0; i<N2LIM; ++i )
	{
		phycon.te = (float)te2[i];
		tfidle(FALSE);
		fprintf(io,"\t%.0f K",phycon.te);
	}
	fprintf(io,"\n");

	/* now do same loop over temp, but add elements */
	for( nelem=ipHYDROGEN; nelem<LIMELM; ++nelem )
	{
		/* this list of elements included in the AGN tables is defined in zeroabun.c */
		if( abundances.lgAGN[nelem] )
		{
			for( ion=0; ion<=nelem; ++ion )
			{
				ASSERT( Heavy.Valence_IP_Ryd[nelem][ion] > 0.05 );

				if( Heavy.Valence_IP_Ryd[nelem][ion] <= BreakEnergy )
					continue;

				/* print chemical symbol */
				fprintf(io,"%s", 
					elementnames.chElementSym[nelem]);
				/* now ionization stage */
				if( ion==0 )
				{
					fprintf(io,"0 ");
				}
				else if( ion==1 )
				{
					fprintf(io,"+ ");
				}
				else
				{
					fprintf(io,"+%li",ion);
				}

				for( i=0; i<N2LIM; ++i )
				{
					phycon.te = (float)te2[i];
					IonRange.IonLow[nelem] = 0;
					IonRange.IonHigh[nelem] = nelem+1;
					tfidle(FALSE);
					ConvIonizeOpacityDo(0);
					fprintf(io,"\t%.2e",recom.RecombinRate[nelem][ion]);
				}
				fprintf(io,"\n");
			}
			fprintf(io,"\n");
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->MakeRecombAGN()\n", debug_fp );
#	endif
	return;
}

/*lint +e817 pclint generates tons of bogus nelem < 0 warnings*/

