/*lines_lv1_na_ar place lines of elements sodium through argon into lines storage stack */
#include "cddefines.h"
#include "coolheavy.h"
#include "pmp2s.h"
#include "phycon.h"
#include "embesq.h"
#include "taulines.h"
#include "recom.h"
#include "ionfracs.h"
#include "trace.h"
#include "sii.h"
#include "linadd.h"
#include "lindst.h"
#include "putline.h"
#include "lines.h"

void lines_lv1_na_ar(void)
{
	long int ipnt;
	double drec, 
	  fac, 
	  rec, 
	  sum, 
	  t4;

#	ifdef DEBUG_FUN
	fputs( "<+>lines_lv1_na_ar()\n", debug_fp );
#	endif

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "   lines_lv1_na_ar called\n" );
	}

	t4 = phycon.te/1e4;

	/* sodium
	 * sum of Na D lines */
	PutLine(&TauLines[ipT5895]);

	/* [NaIII] 7.319 micron */
	PutLine(&TauLines[ipfsNa373]);

	/* [NaIV] 9.048 micron */
	PutLine(&TauLines[ipfsNa490]);

	/* [NaIV] 21.29 micron */
	PutLine(&TauLines[ipfsNa421]);

	/* [NaV] 1365, sum of 1365.1+1365.8; cs only guess */
	PntForLine(1365.,"Na 5",&ipnt);
	lindst(CoolHeavy.c1365,1365,"Na 5",ipnt,'c',TRUE );
	
	/* [NaV] 2067, sum of 2066.9+2068.4; cs only guess */
	PntForLine(2067.,"Na 5",&ipnt);
	lindst(CoolHeavy.c2067,2067,"Na 5",ipnt,'c',TRUE );
	
	/* [NaV] 4017, sum of 4010.9+4016.7+4022.7; cs only guess */
	PntForLine(4017.,"Na 5",&ipnt);
	lindst(CoolHeavy.c4017,4017,"Na 5",ipnt,'c',TRUE );
	
	/* [Na VI] 2568.9 */
	PntForLine(2569.,"Na 6",&ipnt);
	lindst(CoolHeavy.c2569,2569,"Na 6",ipnt,'c',TRUE );
	
	/* [Na VI] 1356.6 */
	PntForLine(1357.,"Na 6",&ipnt);
	lindst(CoolHeavy.c1357,1357,"Na 6",ipnt,'c',TRUE );
	
	/* [Na VI] 2971.9 */
	PntForLine(2972.,"Na 6",&ipnt);
	lindst(CoolHeavy.c2972/(1.+1./3.02),2972,"Na 6",ipnt,'c',TRUE );
	
	/* [Na VI] 2872.7 */
	PntForLine(2872.,"Na 6",&ipnt);
	lindst(CoolHeavy.c2972/(1.+3.02),2872,"Na 6",ipnt,'c',TRUE );
	
	/* [NaVI] 14.32 micron */
	PutLine(&TauLines[ipxNa6143]);

	/* [NaVI] 8.62 micron */
	PutLine(&TauLines[ipxNa6862]);

	/* [NaVII] 4.675 micron */
	PutLine(&TauLines[ipxNa0746]);

	/* Magnesium I 4571, O I data for coll strength and trans prob */
	PutLine(&TauLines[ipT4561]);

	/* Mg I 2853 */
	PutLine(&TauLines[ipMgI2853]);

	/* Mg I 2026 */
	PutLine(&TauLines[ipMgI2026]);

	/* Mg II 2798  */
	linadd(TauLines[ipT2796].xIntensity+TauLines[ipT2804].xIntensity,2798,
		"TOTL",'i' );
	sum =  TauLines[ipT2796].xIntensity*TauLines[ipT2796].FracInwd + 
		TauLines[ipT2804].xIntensity*TauLines[ipT2804].FracInwd;

	/* inward part of Mg II 2798 */
	linadd(sum,2798,"Inwd",'i' );
	PutLine(&TauLines[ipT2796]);
	PutLine(&TauLines[ipT2804]);

	/* Mg IV 4.5 micron */
	PutLine(&TauLines[ipTMg4]);

	/* Mg V  13.5 micron emission */
	PutLine(&TauLines[ipTMg14]);

	/* Mg V 5.6 micron emission */
	PutLine(&TauLines[ipTMg6]);

	/* [Mg 5] 2571, 2893 */
	PutLine(&TauLines[ipxMg52855]);

	/* [Mg 5] 2417.5A, 3-2 in model atom */
	PutLine(&TauLines[ipxMg52417]);

	/* [Mg 5] 1324.58A, 3-1 in model atom */
	PutLine(&TauLines[ipxMg51325]);

	/* MG VI */
	PntForLine(1806.,"Mg 6",&ipnt);
	lindst(CoolHeavy.c1806,1806,"Mg 6",ipnt,'c',TRUE );
	
	/* [Mg 7] 2510, 2629, 2-1 transitions, together */
	PutLine(&TauLines[ipxMg72569]);

	/* [Mg 7] 3-2 transition, 2261.5 */
	PutLine(&TauLines[ipxMg72261]);

	/* [Mg 7] 3-1 transition, 1189.82A */
	PutLine(&TauLines[ipxMg71190]);

	/* Mg 7 IR line 5.50 microns */
	PutLine(&TauLines[ipfsMg755]);

	/* Mg 7 IR line 9.03 microns */
	PutLine(&TauLines[ipfsMg790]);

	/* [Mg 8] 3.03 micron */
	PutLine(&TauLines[ipxMg08303]);

	/* Mg 9 704.5 */
	PutLine(&TauLines[ipT705]);

	/* Mg 10 614.9 bothof doublet, li seq 2s 2p */
	linadd(TauLines[ipTMg610].xIntensity+TauLines[ipTMg625].xIntensity,615,"TOTL",'i' );
	PutLine(&TauLines[ipTMg610]);
	PutLine(&TauLines[ipTMg625]);

	/* part of Mg 10 destroyed by background opacity */
	/* Mg 10 58 li seq 2s 3p */
	PutLine(&TauLines[ipT58]);
	linadd(TauLines[ipTMg610].ots*TauLines[ipTMg610].EnergyErg+
		TauLines[ipTMg625].ots*TauLines[ipTMg625].EnergyErg,615,"dest",'i' );

	/* Aluminum
	 * Al I 3957 */
	PutLine(&TauLines[ipAlI3957]);

	/* Al I 3090 */
	PutLine(&TauLines[ipAlI3090]);

	/* Al II 1671
	 * total emission in Al II] 2669.7, 2660 doublet */
	linadd(embesq.em2669+TauLines[ipT2670].xIntensity,2665,"totl",'i' );
	PutLine(&TauLines[ipT2670]);

	/* emission in Al II] 2669 alone */
	linadd(embesq.em2669,2660,"Al 2",'i' );

	/* Al III */
	linadd(TauLines[ipT1855].xIntensity+TauLines[ipT1863].xIntensity,1860,"TOTL",'i' );
	sum = TauLines[ipT1855].xIntensity*TauLines[ipT1855].FracInwd + 
		TauLines[ipT1863].xIntensity* TauLines[ipT1863].FracInwd;

	/* inward part of AlIII line */
	linadd(sum,1860,"Inwd",'i' );
	PutLine(&TauLines[ipT1855]);
	PutLine(&TauLines[ipT1863]);

	/* [Al V] 2.905 mic */
	PutLine(&TauLines[ipAl529]);

	/* [Al VI] 3.66 mic */
	PutLine(&TauLines[ipAl6366]);

	/* [Al VI] 9.12 mic */
	PutLine(&TauLines[ipAl6912]);

	/* [Al VI] 2428.4 */
	PntForLine(2428.,"Al 6",&ipnt);
	lindst(CoolHeavy.c2428/(1.+1./3.73),2428,"Al 6",ipnt,'c',TRUE );
	
	/*  [Al VI] 2601.0 */
	PntForLine(2601.,"Al 6",&ipnt);
	lindst(CoolHeavy.c2428/(1.+3.73),2601,"Al 6",ipnt,'c',TRUE );
	
	/* [Al VI] 1169.86 */
	PntForLine(1170.,"Al 6",&ipnt);
	lindst(CoolHeavy.c1170,1170,"Al 6",ipnt,'c',TRUE );
	
	/* [Al VI] 2124.95 */
	PntForLine(2125.,"Al 6",&ipnt);
	lindst(CoolHeavy.c2125,2125,"Al 6",ipnt,'c',TRUE );
	
	/* [Al VIII] 5.75 mic */
	PutLine(&TauLines[ipAl8575]);

	/* [Al VIII] 3.70 mic */
	PutLine(&TauLines[ipAl8370]);

	/* [Al IX] 2.04 micron, no collision strength, A NIST */
	PutLine(&TauLines[ipAl09204]);

	/* Al X */
	PutLine(&TauLines[ipT639]);

	/* Al 11, Li seq 2s2p */
	linadd(TauLines[ipTAl550].xIntensity+TauLines[ipTAl568].xIntensity,556,"TOTL",'i' );
	PutLine(&TauLines[ipTAl550]);
	PutLine(&TauLines[ipTAl568]);

	/* Al 11, Li seq 2s3p */
	PutLine(&TauLines[ipTAl48]);

	/* silicon
	 * Si I 2518 */
	PutLine(&TauLines[ipSii2518]);

	/* Si I 2215 */
	PutLine(&TauLines[ipSii2215]);

	/* Silicon II 35 micron */
	PutLine(&TauLines[ipTSi35]);

	/* total intensity of S IV] 1406, all lines in the multiplet */
	linadd(
		TauLines[ipSi2_2334].xIntensity+
		TauLines[ipSi2_2329].xIntensity+
		TauLines[ipSi2_2350].xIntensity+
		TauLines[ipSi2_2344].xIntensity+
		TauLines[ipSi2_2336].xIntensity,
		2335,"TOTL",'i' );
	PutLine(&TauLines[ipSi2_2334]);
	PutLine(&TauLines[ipSi2_2329]);
	PutLine(&TauLines[ipSi2_2350]);
	PutLine(&TauLines[ipSi2_2344]);
	PutLine(&TauLines[ipSi2_2336]);

	/* SI II 1808, permitted resonance line, collisionally excited */
	PutLine(&TauLines[ipT1808]);

	/* SI II 1527, permitted resonance line, collisionally excited */
	PutLine(&TauLines[ipT1527]);

	/* SI II 1305, permitted resonance line, collisionally excited */
	PutLine(&TauLines[ipT1305]);

	/* SI II 1260, permitted resonance line, collisionally excited */
	PutLine(&TauLines[ipT1260]);

	/* SI II 1260, rough guess of dielec contribution */
	drec = xIonFracs[13][2]*phycon.eden*7.6e-7/phycon.te32*
	  1.57e-11*recom.DielSupprs[1][2];
	fac = TauLines[ipT1260].AovTot;
	PntForLine(1260.,"Si 2",&ipnt);
	lindst(drec*fac,1260,"diel",ipnt,'i',TRUE );
	
	/* dielectronic recombination SiII 1909 */
	PntForLine(1909.,"Si 2",&ipnt);
	lindst(drec*1260./1909.,1909,"diel",ipnt,'i',TRUE );

	rec = 1e-12*(0.1152/t4 - 0.3082 + 4.4734*t4 + 0.0207*t4*t4)/pow(t4,1.5)*
	  sexp(0.2981/t4);

	/* >>chng 96 jul 8, added dielectronic recombination contribution to 789 */
	rec *= xIonFracs[13][3]*phycon.eden*TauLines[ipT1207].AovTot*
	  1.65e-11*recom.DielSupprs[1][2];

	PutExtra(MAX2(0.,rec));

	/* SI III 1207, collisional excitation and dielectronic recombination */
	PutLine(&TauLines[ipT1207]);

	/* Si III 1207, dielectronic recombination only */
	linadd(MAX2(0.,rec),1207,"rec ",'i' );

	/* Si III] 1892+1883, total intensity of both lines */
	linadd(embesq.em1895+TauLines[ipT1895].xIntensity,1888,"TOTL",'i' );
	PutLine(&TauLines[ipT1895]);

	/* Si III] 1883 by itself */
	PntForLine(1883.,"Si 3",&ipnt);
	lindst(embesq.em1895,1883,"Si 3",ipnt,'i',TRUE );

	fac = TauLines[ipT1895].AovTot;

	/* photoproduction by inner shell removal */
	linadd(pmp2s.p1895*1.05e-11*fac,1895,"PHOT",'i' );

	/* Si IV 1397, collisionally excited */
	linadd(TauLines[ipT1403].xIntensity+TauLines[ipT1394].xIntensity,1397,"TOTL",'i' );

	sum = TauLines[ipT1403].xIntensity*TauLines[ipT1403].FracInwd + 
		TauLines[ipT1394].xIntensity* TauLines[ipT1394].FracInwd;

	/* inward part of SiIV 1397 */
	linadd(sum,1397,"Inwd",'i' );
	PutLine(&TauLines[ipT1403]);
	PutLine(&TauLines[ipT1394]);

	/* SI VI 1.9641 micron */
	PutLine(&TauLines[ipSi619]);

	/* SI VII, 2148, O III like, collisionally excited */
	PntForLine(2148.,"Si 7",&ipnt);
	lindst(CoolHeavy.c2148,2148,"Si 7",ipnt,'c',TRUE );

	/* Si VII 2.48, 6.49 micron, collisionally excited */
	PutLine(&TauLines[ipTSi25]);

	/* Si VII 2.48, 6.49 micron, collisionally excited */
	PutLine(&TauLines[ipTSi65]);

	/* SI VIII 1446, OIII like, collisionally excited */
	PntForLine(1446.,"Si 8",&ipnt);
	lindst(CoolHeavy.c1446,1446,"Si 8",ipnt,'c',TRUE );
	
	/* SI IX 1985, 2150, collisionally excited */
	PntForLine(1985.,"Si 9",&ipnt);
	lindst(CoolHeavy.c1985,1985,"Si 9",ipnt,'c',TRUE );
	
	/* collisionally excited */
	PntForLine(949.,"Si 9",&ipnt);
	lindst(CoolHeavy.c949,949,"Si 9",ipnt,'c',TRUE );
	
	/* collisionally excited */
	PntForLine(1815.,"Si 9",&ipnt);
	lindst(CoolHeavy.c1815,1815,"Si 9",ipnt,'c',TRUE );
	
	/* SI 9, 3.86, 2.84 3P fine structure lines */
	PutLine(&TauLines[ipTSi4]);

	/* SI 9, 3.86, 2.84 3P fine structure lines */
	PutLine(&TauLines[ipTSi3]);

	/* both components of 5S-3P doublet */
	PntForLine(691.,"Si 9",&ipnt);
	lindst(CoolHeavy.c691,691,"Si 9",ipnt,'c',TRUE );
	
	/* SI 10 606A, actually group of 4 intercombination lines. */
	PntForLine(606.,"Si10",&ipnt);
	lindst(CoolHeavy.c606,606,"Si10",ipnt,'c',TRUE );
	
	/* [Si 10] 1.43 micron, collisionally excited */
	PutLine(&TauLines[ipSi10143]);

	/* SI XI 582.9, collisionally excited */
	/* >>chng 01 may 23, wavelength from 583 to 581 */
	PntForLine(583.,"Si11",&ipnt);
	lindst(CoolHeavy.c583,581,"Si11",ipnt,'c',TRUE );

	/* now make total */
	linadd(TauLines[ipTSi499].xIntensity+TauLines[ipTSi521].xIntensity,506,"TOTL",'i' );

	/* SI XII 506 li seq 2s 2p */
	PutLine(&TauLines[ipTSi499]);
	PutLine(&TauLines[ipTSi521]);

	/* SI XII 40.9A, li seq 2s 3p */
	PutLine(&TauLines[ipTSi41]);

	/* phosphorus */
	/* [P II] 60.64 micron */
	PutLine(&TauLines[ipP0260]);

	/* [P II] 32.87 micron */
	PutLine(&TauLines[ipP0233]);

	/* 3-2 1.64 mic */
	PntForLine(16400.,"P  2",&ipnt);
	lindst(CoolHeavy.p2_32,16400,"P  2",ipnt,'c',TRUE );

	/* >>chng 01 may 15, add these lines */
	/* 3-1 4670, 4738 vac wl, 4669, 4737 air */
	PntForLine(4669.,"P  2",&ipnt);
	lindst(CoolHeavy.p2_31*0.75,4669,"P  2",ipnt,'c',TRUE );

	PntForLine(4737.,"P  2",&ipnt);
	lindst(CoolHeavy.p2_31*0.25,4737,"P  2",ipnt,'c',TRUE );

	/* 2-1 1.147, 1.189 mic */
	PntForLine(11890.,"P  2",&ipnt);
	lindst(CoolHeavy.p2_21*0.75,11890,"P  2",ipnt,'c',TRUE );

	PntForLine(11470.,"P  2",&ipnt);
	lindst(CoolHeavy.p2_21*0.25,11470,"P  2",ipnt,'c',TRUE );

	/* [P III] 17.885 micron */
	PutLine(&TauLines[ipP0318]);

	/* [P VII] 1.3745 micron */
	PutLine(&TauLines[ipP713]);

	/* [P VIII] 4.85 mic */
	PutLine(&TauLines[ipP848]);

	/* [P VIII] 1.735 microns */
	PutLine(&TauLines[ipP817]);

	/* [P X] 2.708 mic */
	PutLine(&TauLines[ipP1027]);

	/* [P X] 1.868 microns */
	PutLine(&TauLines[ipP1018]);

	/* sulphur */
	/* guestimate of Sulphur I triplet excited state recombination rate.
	 * this is to check whether photoexcit of S II is ever important */
	linadd(1.75e-22*phycon.eden*xIonFracs[ipSULPHUR][1]/phycon.sqrte/
	  phycon.te10/phycon.te03,1807,"S 1R",'i' );

	/* S II 6731 + 6716 together */
	linadd(CoolHeavy.c6731,6720,"S  2",'c' );

	/* S II 4070 +4078 together */
	linadd(sii.S4070+sii.S4078,4074,"S  2",'c' );

	/* S II N=3 lines, all four lines together */
	PntForLine(10330.,"S  2",&ipnt);
	lindst(CoolHeavy.c10330,10330,"S  2",ipnt,'c',TRUE );

	/* now output the real thing
	 * individual line from five level atom */
	PntForLine(6731.,"S II",&ipnt);
	lindst(sii.S6733,6731,"S II",ipnt,'i',TRUE );
	
	/* individual line from five level atom */
	PntForLine(6716.,"S II",&ipnt);
	lindst(sii.S6718,6716,"S II",ipnt,'i',TRUE );
	
	/* individual line from five level atom */
	PntForLine(4070.,"S II",&ipnt);
	lindst(sii.S4070,4070,"S II",ipnt,'i',TRUE );
	
	/* individual line from five level atom */
	PntForLine(4078.,"S II",&ipnt);
	lindst(sii.S4078,4078,"S II",ipnt,'i',TRUE );
	
	/* individual line from five level atom */
	linadd(sii.S10323,10323,"S II",'i' );

	/* individual line from five level atom */
	linadd(sii.S10289,10289,"S II",'i' );

	/* individual line from five level atom */
	linadd(sii.S10373,10373,"S II",'i' );

	/* individual line from five level atom */
	linadd(sii.S10339,10339,"S II",'i' );

	/* resonance line near NV, collisionally excited */
	PutLine(&TauLines[ipT1256]);

	/* S III fine structure 18.7 */
	PutLine(&TauLines[ipTS19]);

	/* S III fine structure 34 */
	PutLine(&TauLines[ipTS34]);

	/* S III] 1713.12, 1728.94 */
	PutLine(&TauLines[ipTS1720]);

	/* [S III] 9532 alone */
	PntForLine(9532.,"S  3",&ipnt);
	lindst(CoolHeavy.c9532/(1.+1./2.48),9532,"S  3",ipnt,'c',TRUE );

	/* [S III] 9069 alone */
	PntForLine(9069.,"S  3",&ipnt);
	lindst(CoolHeavy.c9532/(1.+2.48),9069,"S  3",ipnt,'c',TRUE );

	/* [S III] 6312, transauroral temperature sensitive */
	PntForLine(6312.,"S  3",&ipnt);
	lindst(CoolHeavy.c6312,6312,"S  3",ipnt,'c',TRUE );
	
	/* [S III] 3722, same upper level as 6312 */
	PntForLine(3722.,"S  3",&ipnt);
	lindst(CoolHeavy.c6312*0.59,3722,"S  3",ipnt,'c',TRUE );
	
	/* WL, other data, from Ho + Henry Ap.J. 1984 */
	PutLine(&TauLines[ipT1194]);

	/* S IV 10.5 micron, collisionally excited (label is 105) */
	PutLine(&TauLines[ipTS11]);

	/* total intensity of S IV] 1406, all lines in the multiplet */
	linadd(
		TauLines[ipS4_1405].xIntensity+
		TauLines[ipS4_1398].xIntensity+
		TauLines[ipS4_1424].xIntensity+
		TauLines[ipS4_1417].xIntensity+
		TauLines[ipS4_1407].xIntensity,
		1406,"TOTL",'i' );
	PutLine(&TauLines[ipS4_1405]);
	PutLine(&TauLines[ipS4_1398]);
	PutLine(&TauLines[ipS4_1424]);
	PutLine(&TauLines[ipS4_1417]);
	PutLine(&TauLines[ipS4_1407]);

	/* S V 1198] both lines together */
	linadd(embesq.em1198+TauLines[ipT1198].xIntensity,1198,"TOTL",'i' );

	/* S V 1198] the stronger transition */
	PutLine(&TauLines[ipT1198]);

	/* Be seq, weaker of the two transitions */
	linadd(embesq.em1198,1188,"S  5",'i' );

	/* S V 786.5, collisionally excited */
	PutLine(&TauLines[ipT786]);

	/* S VI 933+944, collisionally excited
	 * total S VI 933+944 */
	linadd(TauLines[ipT944].xIntensity+TauLines[ipT933].xIntensity,933,"TOTL",'i' );
	PutLine(&TauLines[ipT944]);
	PutLine(&TauLines[ipT933]);

	/* S VIII 9913 */
	PutLine(&TauLines[ipfsS810]);

	/* S IX 1.25 microns */
	PutLine(&TauLines[ipfsS912]);

	/* S IX  3.78 microns */
	PutLine(&TauLines[ipfsS938]);

	/* S XI 1.91 microns */
	PutLine(&TauLines[ipfsS1119]);

	/* S XI 1.40 microns */
	PutLine(&TauLines[ipfsS1114]);

	/* S IX 1715, 1987, collisionally excited */
	PntForLine(1715.,"S  9",&ipnt);
	lindst(CoolHeavy.c1715,1715,"S  9",ipnt,'c',TRUE );
	
	/* S XII 7611.2 */
	PutLine(&TauLines[ipfsS1207]);

	/* S X 1213, 1197, collisionally excited */
	PntForLine(1213.,"S 10",&ipnt);
	lindst(CoolHeavy.c1213,1213,"S 10",ipnt,'c',TRUE );
	
	/* S XI 1615, 1826, collisionally excited */
	PntForLine(1826.,"S 11",&ipnt);
	lindst(CoolHeavy.c1826,1826,"S 11",ipnt,'c',TRUE );
	
	/* group of four intercombination lines */
	PntForLine(520.,"S 12",&ipnt);
	lindst(CoolHeavy.c520,520,"S 12",ipnt,'c',TRUE );
	
	/* S XIII 488.4, 1909 like, collisionally excited */
	PntForLine(488.,"S 13",&ipnt);
	lindst(CoolHeavy.c488,488,"S 13",ipnt,'c',TRUE );
	
	/* S 14 506 li seq 2s2p */
	linadd(TauLines[ipTSu418].xIntensity+TauLines[ipTSu446].xIntensity,427,"TOTL",'i' );
	PutLine(&TauLines[ipTSu418]);
	PutLine(&TauLines[ipTSu446]);

	/* S 14 30 li seq 2s3p */
	PutLine(&TauLines[ipTSu30]);

	/* chlorine lines */
	/* [Cl II] 33.281 micron */
	PutLine(&TauLines[ipfsCl233]);

	/* [Cl II] 14.3678 micron */
	PutLine(&TauLines[ipfsCl214]);

	/* Chlorine II 8581, 9127 doublet */
	PntForLine(8579.,"Cl 2",&ipnt);
	lindst(CoolHeavy.c8579*0.791,8579,"Cl 2",ipnt,'c',TRUE );
	
	/* Chlorine II 8581, 9127 doublet */
	PntForLine(9127.,"Cl 2",&ipnt);
	lindst(CoolHeavy.c8579*0.209,9127,"Cl 2",ipnt,'c',TRUE );
	linadd(CoolHeavy.c8579*0.209,9127,"Cl 2",'c' );

	/* Chlorine II 6164 auroral line */
	PntForLine(6164.,"Cl 2",&ipnt);
	lindst(CoolHeavy.c6164,6164,"Cl 2",ipnt,'c',TRUE );
	
	/* Chlorine II 3679 auroral line */
	PntForLine(3676.,"Cl 2",&ipnt);
	lindst(CoolHeavy.c3679,3676,"Cl 2",ipnt,'c',TRUE );
	
	/* Cl III 5519, 5539 doublet, both together */
	linadd(CoolHeavy.c5525,5525,"TOTL",'c' );

	/* Cl III 3354, 3344 doublet, both together */
	linadd(CoolHeavy.c3350,3350,"TOTL",'c' );

	/* Cl III 8504, 8436, 8552, 8483 multiplet, all together */
	linadd(CoolHeavy.c8494,8494,"TOTL",'c' );

	/* Cl III 5538  */
	PntForLine(5538.,"Cl 3",&ipnt);
	lindst(CoolHeavy.Cl5539,5538,"Cl 3",ipnt,'i',TRUE );
	
	/* Cl III 5518  */
	PntForLine(5518.,"Cl 3",&ipnt);
	lindst(CoolHeavy.Cl5519,5518,"Cl 3",ipnt,'i',TRUE );
	
	/* Cl III 3354  */
	PntForLine(3354.,"Cl 3",&ipnt);
	lindst(CoolHeavy.Cl3354,3354,"Cl 3",ipnt,'i',TRUE );
	
	/* Cl III 3344  */
	PntForLine(3344.,"Cl 3",&ipnt);
	lindst(CoolHeavy.Cl3344,3344,"Cl 3",ipnt,'i',TRUE );
	
	/* Cl III 8504  */
	PntForLine(8504.,"Cl 3",&ipnt);
	lindst(CoolHeavy.Cl8504,8504,"Cl 3",ipnt,'i',TRUE );
	
	/* Cl III 8436  */
	PntForLine(8436.,"Cl 3",&ipnt);
	lindst(CoolHeavy.Cl8436,8436,"Cl 3",ipnt,'i',TRUE );
	
	/* Cl III 8552  */
	PntForLine(8552.,"Cl 3",&ipnt);
	lindst(CoolHeavy.Cl8552,8552,"Cl 3",ipnt,'i',TRUE );
	
	/* Cl III 8483  */
	PntForLine(8483.,"Cl 3",&ipnt);
	lindst(CoolHeavy.Cl8483,8483,"Cl 3",ipnt,'i',TRUE );
	
	/* [Cl IV] fine structure line 20.354 microns */
	PutLine(&TauLines[ipCl04203]);

	/* [Cl IV] fine structure line 11.741 microns */
	PutLine(&TauLines[ipCl04117]);

	/* ClIV 8047 */
	PntForLine(8047.,"Cl 4",&ipnt);
	lindst(CoolHeavy.c8047*0.667,8047,"Cl 4",ipnt,'c',TRUE );

	/* ClIV 7532 */
	PntForLine(7532.,"Cl 4",&ipnt);
	lindst(CoolHeavy.c8047*0.333,7532,"Cl 4",ipnt,'c',TRUE );
	
	/* ClIV 3119 */
	PntForLine(3119.,"Cl 4",&ipnt);
	lindst(CoolHeavy.c3119,3119,"Cl 4",ipnt,'c',TRUE );
	
	/* ClIV 5324 */
	PntForLine(5324.,"Cl 4",&ipnt);
	lindst(CoolHeavy.c5324,5324,"Cl 4",ipnt,'c',TRUE );
	linadd(CoolHeavy.c5324,5324,"Cl 4",'c' );

	/* Cl IX 7334A */
	PutLine(&TauLines[ipCl973]);

	/* Cl X 3.05 microns */
	PutLine(&TauLines[ipCl1030]);

	/* Cl X 9223A */
	PutLine(&TauLines[ipCl1092]);

	/* Argon II 7 micron */
	PutLine(&TauLines[ipTAr7]);

	/* Argon III 7135 */
	PntForLine(7135.,"Ar 3",&ipnt);
	lindst(CoolHeavy.c7136/(1.+1./4.144),7135,"Ar 3",ipnt,'c',TRUE );
	
	/* Argon III 7751 */
	PntForLine(7751.,"Ar 3",&ipnt);
	lindst(CoolHeavy.c7136/(1.+4.144),7751,"Ar 3",ipnt,'c',TRUE );
	
	/* Argon III 5192 */
	PntForLine(5192.,"Ar 3",&ipnt);
	lindst(CoolHeavy.c5192,5192,"Ar 3",ipnt,'c',TRUE );
	
	/* Argon III 3109 */
	PntForLine(3109.,"Ar 3",&ipnt);
	lindst(CoolHeavy.c3109*0.9894,3109,"Ar 3",ipnt,'c',TRUE );
	
	/* Argon III 3005 */
	PntForLine(3005.,"Ar 3",&ipnt);
	lindst(CoolHeavy.c3109*(1.-0.9894),3005,"Ar 3",ipnt,'c',TRUE );
	
	/* Argon III 21.8, 9 micron lines */
	PutLine(&TauLines[ipTAr22]);

	/* Argon III 21.8, 9 micron lines */
	PutLine(&TauLines[ipTAr9]);

	/* Argon IV 4711 + 4740 together, 4740=90% */
	linadd(CoolHeavy.Ar4740+CoolHeavy.Ar4711,4725,"TOTL",'i' );

	/* [AvIV] 2868, 2854 together */
	linadd(CoolHeavy.Ar2868+CoolHeavy.Ar2854,2860,"TOTL",'i' );

	/* [AvIV] auroral lines, 7237, 7331, 7171, 7263 */
	linadd(CoolHeavy.Ar7237+CoolHeavy.Ar7331+CoolHeavy.Ar7171+CoolHeavy.Ar7263,
	  7250,"TOTL",'i' );

	/* [Ar IV] 4740 */
	PntForLine(4740.,"Ar 4",&ipnt);
	lindst(CoolHeavy.Ar4740,4740,"Ar 4",ipnt,'c',TRUE );
	
	/* [Ar IV] 4711 */
	PntForLine(4711.,"Ar 4",&ipnt);
	lindst(CoolHeavy.Ar4711,4711,"Ar 4",ipnt,'c',TRUE );
	
	/* [Ar IV] 2868 */
	PntForLine(2868.,"Ar 4",&ipnt);
	lindst(CoolHeavy.Ar2868,2868,"Ar 4",ipnt,'c',TRUE );
	
	/* [Ar IV] 2854 */
	PntForLine(2854.,"Ar 4",&ipnt);
	lindst(CoolHeavy.Ar2854,2854,"Ar 4",ipnt,'c',TRUE );
	
	/* [Ar IV] 7263 */
	PntForLine(7263.,"Ar 4",&ipnt);
	lindst(CoolHeavy.Ar7263,7263,"Ar 4",ipnt,'c',TRUE );
	
	/* [Ar IV] 7171 */
	PntForLine(7171.,"Ar 4",&ipnt);
	lindst(CoolHeavy.Ar7171,7171,"Ar 4",ipnt,'c',TRUE );
	
	/* [Ar IV] 7331 */
	PntForLine(7331.,"Ar 4",&ipnt);
	lindst(CoolHeavy.Ar7331,7331,"Ar 4",ipnt,'c',TRUE );
	
	/* [Ar IV] 7237 */
	PntForLine(7237.,"Ar 4",&ipnt);
	lindst(CoolHeavy.Ar7237,7237,"Ar 4",ipnt,'c',TRUE );
	
	/* Argon V, 3P lines, 7005, collisionally excited */
	PntForLine(7005.,"Ar 5",&ipnt);
	lindst(CoolHeavy.c7007/(1.+1./2.143),7005,"Ar 5",ipnt,'c',TRUE );
	
	/* Argon V, 3P lines, 6435, collisionally excited */
	PntForLine(6435.,"Ar 5",&ipnt);
	lindst(CoolHeavy.c7007/(1.+2.143),6435,"Ar 5",ipnt,'c',TRUE );

	/* >>chng 01 mar 10, add following two lines */
	/* Argon V, 4626 */
	PntForLine(4626.,"Ar 5",&ipnt);
	lindst( CoolHeavy.c4626 , 4626 ,"Ar 5",ipnt,'c',TRUE );

	/* Argon V, 2691 */
	PntForLine(2691.,"Ar 5",&ipnt);
	lindst( CoolHeavy.c2691 , 2691 ,"Ar 5",ipnt,'c',TRUE );

	/* Argon V fine structure lines, 13.09, 7.903 micron line */
	PutLine(&TauLines[ipTAr13]);

	/* Argon V fine structure lines, 13.09, 7.903 micron line */
	PutLine(&TauLines[ipTAr8]);

	/* [Ar VI] 4.53 micron */
	PutLine(&TauLines[ipAr06453]);

	/* Ar X 5533.4A */
	PutLine(&TauLines[ipAr1055]);

	/* Ar XI 2.60 microns */
	PutLine(&TauLines[ipAr1126]);

	/* Ar XI 6917A */
	PutLine(&TauLines[ipAr1178]);

	/* Ar XIV 4413, predicted lambda, not observed(?) */
	PntForLine(4413.,"Ar14",&ipnt);
	lindst(CoolHeavy.fs4413,4413,"Ar14",ipnt,'c',TRUE );
	
	/* collisionally excited */
	PntForLine(409.,"Ar15",&ipnt);
	lindst(CoolHeavy.c409,409,"Ar15",ipnt,'c',TRUE );
	
	/* collisionally excited Ar16 354, Li seq 2s-2p */
	PutLine(&TauLines[ipT354]);

	/* collisionally excited Ar16 389, Li seq 2s-2p */
	PutLine(&TauLines[ipT389]);

	/* collisionally excited Ar16 365, Li seq 2s-3p */
	PutLine(&TauLines[ipT25]);

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "   lines_lv1_na_ar returns\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->lines_lv1_na_ar()\n", debug_fp );
#	endif
	return;
}

