/*lines_hydro put H-iso seq into line intensity stack */
#include "cddefines.h"
#include "dphoht.h"
#include "radius.h"
#include "heat.h"
#include "linadd.h"
#include "grainvar.h"
#include "lines.h"

void lines_grains(void)
{
	double 
	  dhtot;
	long i,
		nd;

#	ifdef DEBUG_FUN
	fputs( "<+>lines_grains()\n", debug_fp );
#	endif

	/* next come the H-iso sequence lines */
	i = StuffComment( "grains" );
	linadd( 0., (float)i , "####", 'i');

	/* find total grain heating */
	dhtot = 0.;
	for( nd=0; nd < gv.nBin; nd++ )
	{
		/* add heating due to all grain species that are included */
		dhtot += gv.bin[nd]->GasHeatPhotoEl;
	}

	dphoht.TotalDustHeat += (float)(dhtot*radius.dVeff);
	dphoht.dphmax = MAX2((float)(dhtot/heat.htot),dphoht.dphmax);
	dphoht.h2pmax = MAX2(dphoht.h2pmax,(float)(heat.heating[0][16]/heat.htot));

	/* gas heating by grain photoionization */
	linadd(dhtot,0,"GrGH",'h');

	/* gas heating by thermionic emissions of grains */
	linadd(heat.heating[0][25],0,"GrTH",'h');

	dphoht.dclmax = MAX2(dphoht.dclmax,(float)(gv.GasCoolColl/heat.htot));

	/* gas cooling by collisions with grains */
	linadd(gv.GasCoolColl,0,"GrGC",'c');	

	/* total grain heating by all sources, lines, collisions, incident continuum */
	linadd(gv.GrainHeatSum,0,"GraT",'i');

	/* grain heating by incident continuum */
	linadd(gv.GrainHeatInc,0,"GraI",'i');

	/* grain heating due to destruction of Ly alpha  */
	linadd(gv.GrainHeatLya,1216,"GraL",'i');

	/* grain heating due to collisions with gas */
	linadd(gv.GrainHeatCollSum,0,"GraC",'i');

	/* grain heating due to diffuse fields, may also have grain emission */
	linadd(gv.GrainHeatDif,0,"GraD",'i');

#	ifdef DEBUG_FUN
	fputs( " <->lines_grains()\n", debug_fp );
#	endif
	return;

}
