/* original declaration is first, changed version is second */
/*void LevelN(long*,long,double,float[],float[],float[],float*,
	float*,float*,long*,float*,float*,STRING,int*);*/
/*void LevelN(long,long,float,double[],double[],double[],double*,
	double*,double*,long*,double*,double*,char*,int*);*/

void LevelN(
	/* nlev is the number of levels to compute*/ 
	long int nlev, 
	/* ndim is dimension of array 
	long int ndim, */
	/* ABUND is total abundance of species, used for nth equation */
	float abund, 
	/* G(ndim) is stat weight of levels */
	double g[], 
	/* EX(ndim) is excitation potential of levels, deg K
	 * 0 for first one, NOT d(ENER), but energy rel to ground */
	double ex[], 
	/* populations of each level as deduced here */
	double pops[], 
	/* departure coefficient derived here */
	double depart[],
	/* data(ihi,ilo) is transit rate, from up to low, A * esc prob
	 * data(ilo,ihi) is col str from up to low */
	double ***data, 
	/* dest(ilo,ihi) is destruction rate, from up to low, A * dest prob,
	 * asserts confirm that ihi,lo is zero */
	double ***dest, 
	/* pump(lo, hi) is pumping rate, A * occ num, (hi,lo) must be zero  */
	double ***pump, 
	/* collision rates, evaluated here and returned for cooling by calling function,
	 * unless following flag is true.  If true then calling function has already filled
	 * in these rates.  CollRate[i][j] is rate from i to j */
	double ***CollRate,
	/* flag saying whether CollRate already done, or we need to do it here */
	int lgCollRateDone,
	/* 2D array of integer indices for line energy in continuum array, used
	 * for setting ots rates.  ignored if zero, indices are [low][high]*/
	long int ***ipdest, 
	/* total cooling and its derivative, set here but nothing done with it*/
	double *cooltl, 
	double *coolder, 
	/* string used to identify calling program in case of error */
	char *chLabel, 
	/* lgNegPop flag indicating what we have done
	 * positive if negative populations occurred
	 * zero if normal calculation done
	 * negative if too cold (for some atoms other routine will be called in this case) */
	int *lgNegPop,
	/* option to print matrices for debugging */
	int lgDeBug);
	/* side-effects of this routine:
	 * PopLevls.PopLevels[n], PopLevls.DepLTELevels[n] are set
	 * lines added to ots array 
	 */
