/* iso.h - information for isoelectronic sequences */

/* set true to use new he opacities, false to use old he atom */
#define	lgHeNew	TRUE

/*iso_create create storage space data for hydrogen and helium, 1 one time per coreload */
void iso_create(void);

/* do photoionization rates for element nelem on the ipISO isoelectronic sequence */
void iso_photo( long ipISO , long nelem );

/*iso_cool compute net heating/cooling due to hydrogenc atom species */
void iso_cool(
	   /* the isoelectronic sequence, 0 for H */
	   long int ipISO , 
		/* nelem is element, so 0 for H itself */
		long int nelem);

/*	The Elevels data type, and then the iso_quant_desig[ipHE_LIKE] structure,
 *  which contain the quantum numbers n,l, and s for a given
 *  energy level, are defined here, for use in multiple subroutines. 
 *  Moved this definition here from "helike.h"	*/
typedef struct {
	long n;
	long s;
	long l;
} Elevels;/* Main_Config.h */ 

/* An array of structures each containing for a given element, n,l, and s
 * s=0 for singlets, s=1 for triplets */
EXTERN Elevels ***iso_quant_desig;

EXTERN struct t_iso 
{

	/* number of lyman lines to include only as opacity sources, in each iso seq,
	 * all now set to 100 in zero.c */
	long int nLyman[NISO];

	/* this is the set of extra lines,
	 * LymanLines[ipISO][ipZ][n]*/
	EmLine ***ExtraLymanLines;

	/* a set of array indices for all atoms on the iso sequences,
	 * ipIsoLevNIonCon[ipISO][ipZ][n] */
	long int ***ipIsoLevNIonCon;

	/* >>chng 01 dec 23, from float to double */
	/* ionization potential of level N in Ryd */
	double ***xIsoLevNIonRyd;

	/* ConBoltz excit to continuum */
	double ***ConBoltz/*ipISO][ipZ][n]*/;

	/* the ratio fully stripped ion to atom for all hydrogenic species
	 * HIonSimple is simple estimate, should agree at low density */
	double xIonSimple[NISO][LIMELM];

	/* option to turn off l-mixing collisions */
	int lgColl_l_mixing[NISO];

	/* option to turn off collisional excitation */
	int lgColl_excite[NISO];

	/* option to turn off collisional ionization */
	int lgColl_ionize[NISO];

	/* option to print departure coefficients */
	int lgPrtDepartCoef[NISO][LIMELM];

	/* option to print level populations */
	int lgPrtLevelPops[NISO][LIMELM];

	/* how the model atoms are topped off.  nHTopOff is the level, H set to 10 in zero */
	long int nTopOff[NISO];

	/*
	* iso.numLevels[ipISO][ipNELEM] is the number of levels in hydrogenic atoms, 
	* 0 is 1s, 1 is 2s, 2 is 2p, etc, going up to n = iso.numLevels[ipH_LIKE]
	* iso.numLevels[ipH_LIKE] is set on the fly with hydrogen levels command, and 
	* all loops should be from ipH1s to <= iso.numLevels[ipH_LIKE]
	* it is initialized in zero.c
	*/
	/* the total number of levels in each atom in the iso sequences */
	long int numLevels[NISO][LIMELM];

	/* this is the quantum number n of the highest resolved level */
	long int n_HighestResolved[NISO][LIMELM];

	/* the total number of levels to print in each atom in the iso sequences */
	long int numPrintLevels[NISO][LIMELM];

	/* the statistical weights of the levels, stat[ipISO][nelem][n] */
	float ***stat;

	/* the statistical weights of the ions for each species,
	 * used for Milne relation and recombination */
	float stat_ion[NISO];

	/* radiative recombination rate coefficient, RadRecomb[ipISO][ipZ][n][fcn]
	 * iso.RadRecomb[ipHE_LIKE][ipZ][ipLo][ipRecEsc] escape prob
	 * iso.RadRecomb[ipISO][ipZ][n][ipRecNetEsc] net escape prob, accounting for absorption 
	 * iso.RadRecomb[ipHE_LIKE][ipZ][ipLo][ipRecRad] rate coef, cm^3 s^-1 
	 * */
	float ****RadRecomb;

	/* difference between actual case b photons in rtdiffuse, and correct case b */
	float CaseBCheck[NISO][LIMELM];

	/* case b recombination rate coefficient */
	float RadRec_caseB[NISO][LIMELM];

	/* the total effective radiative recombination rate coefficient (cm3 s-1), 
	 * radiative rate with correction for absorption and ionization */
	float RadRec_effec[NISO][LIMELM];

	/* total recombination rate (s-1), all processes */
	float RecomTotal[NISO][LIMELM];

	/* collisional recombination rate (s-1), all processes */
	float RecomCollis[NISO][LIMELM];

	/* ipOpac pointers for photoionization cross sections of hydrogen
	 * iso.ipOpac[NISO][LIMELM][NHPLPHOT] */
	long int ***ipOpac;

	/* population of level relative to ion */
	float ***Pop2Ion;

	/* continuum to total opacity factors for each level */
	float ***ConOpacRatio;

	/* departure coefficient */
	double ***DepartCoef;

	/* true is all lte populations positive for Hydrogenic atoms */
	int lgPopLTE_OK[NISO][LIMELM];

	/* hlte is lte population of each level */
	double ***PopLTE;

	/* collisional ionization rate coefficient from each level */
	double ***ColIoniz;

	/* the ratio of ion to recombined species, for H-like and He-like ions of
	 * the heavy elements */
	double xIonRatio[NISO][LIMELM];

	/* net free bound cooling for this element */
	double FreeBnd_net_Cool_Rate[NISO][LIMELM];

	/* net cooling due to collisional ionization */
	double coll_ion[NISO][LIMELM];

	/* net cooling due to collisional excit of higher lines */
	double cRest_cool[NISO][LIMELM];

	/* net cooling due to total collisional excit of lines */
	double xLineTotCool[NISO][LIMELM];

	/* deriv of net cooling due to total collisional excit of lines */
	double dLTot[NISO][LIMELM];

	/* net cooling due to rad rec */
	double RadRecCool[NISO][LIMELM];

	/* net cooling due to collisional excit of balmer lines */
	double cBal_cool[NISO][LIMELM];

	/* net cooling due to collisional excit of higher lyman lines */
	double cLyrest_cool[NISO][LIMELM];

	/* net cooling due to collisional excit of Lya */
	double cLya_cool[NISO][LIMELM];

	/* photoionization rate, gammnc[iso][nelem][level] */
	double ***gamnc;

	/* RecomInducRate will become induced recombination rate coefficient
	 * when multipled by lte population.  
	 * integral of photorate times exp(-hu/kt) 
	 * for ind rec, produced by gamma routine needs to be mult
	 * by lte pop to become real rate  */
	double ***RecomInducRate;

	/* RecomInducCool_Coef becomes rate coef for incuded recombination cooling,
	 * when multipled by lte population. 
	 * this times hnu-hnuo0 to get cooling,
	 * evaluated in gamma routine and saved */
	double ***RecomInducCool_Coef;

	/* the actual induced recom cooling rate, erg cm-3 s-1 */
	double RecomInducCool_Rate[NISO][LIMELM];

	/* Boltzmann factor from lower to upper level, [ISO][nelem][up][lo] */
	double ****Boltzmann;

	/* photoelectric heating rate */
	double ***PhotoHeat;

} iso;
