/* ionrec.h */
/* max number of shells we ever have to deal with */
#define NSHELLS	7
EXTERN struct t_ion {

	/* store photoionization rates for ground terms of all elements
	 * first dim is nelem, the atomic number of element on the c scale, H is 0.
	 * second dim is stage of ionizaiton, on the c scale, atom is 0.
	 * third dim is shell number, valence shell depends on ion, up to 7
	 * last dim: 0 is photo rate
	 *           1 is low energy heating
	 *           2 is high energy (secondary-capable) total heating
	 *           both will be nultiplied by ion abundance to get vol rates 
	 * some special last pairs - 
	 * [x][0][10][0] pair production in highen
	 */
	double ****PhotoRate_Ground/*[LIMELM][LIMELM][7][3]*/;

	/* set to 1 in zero, so have no effect, 
	 * set to 0 with 'no photoionization' command, 
	 * kills photoionization of everything */
	int lgPhotoIoniz_On;

	/* collisional ionization rate for CollidRate[nelem][ion][0], s-1
	* cooling, erg/s in CollidRate[nelem][ion][1] */
	double ***CollIonRate_Ground/*[LIMELM][LIMELM][2]*/;

	/* cosmic ray ionization rate */
	double CosRayIonRate;

	/* cosmic ray heating rate */
	double CosRayHeatRate;

	/* local heating rate due to some "extra" process */
	double ExtraHeatRate;

	/* heating due to fast neutrons */
	double xNeutronHeatRate;

	/* ionization and heating due to pair production */
	double PairProducPhotoRate[3];

	/* ==============================================================
	 * following deal with compton recoil ionization of bound electrons */
	/* flag saying that compton recoil ionization of bound
	 * electrons is enabled,
	 * set false with no recoil ionization command */
	int lgCompRecoil;

	/* the local heating due to compton recoil ionization */
	double CompRecoilHeatLocal;

	/* array indices for continuum offset of compton recoil ionization threshold */
	long int **ipCompRecoil;

	/* rate of bound electron ionization by compton scattering */
	double **CompRecoilIonRate;

	/* save rate of bound electron ionization by compton scattering */
	double **CompRecoilIonRateSave;

	/* heating rate due to bound electron ionization by compton scattering */
	double **CompRecoilHeatRate;

	/* save heating rate due to bound electron ionization by compton scattering */
	double **CompRecoilHeatRateSave;

	/* number of valence electrons that can participate - multipies since electron rate */
	long int  nCompRecoilElec[LIMELM];

	double CompHeating_Max;
	/* ==============================================================
	 * end compton recoil ionization of bound electrons */

	}	ionrec;

