/*IonNitro ionization balance for nitrogen */
#include "cddefines.h"
#ifdef NDIM
#	undef NDIM
#endif
#define	NDIM	8
#include "abundances.h"
#include "heat.h"
#include "nitexc.h"
#include "timed.h"
#include "ionfracs.h"
#include "opacity.h"
#include "trace.h"
#include "converge.h"
#include "ionrec.h"
#include "collidionize.h"
#include "ionzer.h"
#include "makerecomb.h"
#include "theavy.h"
#include "photoionize.h"
#include "gammas.h"
#include "bidiag.h"
#include "ionheavy.h"

void IonNitro(void)
{
	long int i, 
	  _r;
	static double dicoef[2][NDIM - 1], 
	  dite[2][NDIM - 1];
	static double rec[NDIM - 2]={1.11e-10,7.91e-10,2.53e-9,1.08e-8,
	  2.07e-8,2.90e-8};
	static double pl[NDIM - 2]={-0.608,-0.639,-0.676,-0.765,-0.780,
	  -0.750};
	static double tlow[2]={0.,0.};
	static double ditcrt[NDIM - 1]={1.8e4,1.8e4,2.4e4,1.5e4,6.8e5,1.0e6,
	  1e20};
	static double aa[NDIM - 1]={0.0,0.0320,-0.8806,0.4134,0.,0.,0.};
	static double bb[NDIM - 1]={0.6310,-0.6624,11.2406,-4.6319,0.,0.,
	  0.};
	static double cc[NDIM - 1]={0.1990,4.3191,30.7066,25.9172,0.,0.,
	  0.};
	static double dd[NDIM - 1]={-0.0197,0.0003,-1.1721,-2.2290,0.,0.,
	  0.};
	static double ff[NDIM - 1]={0.4398,0.5946,0.6127,0.2360,0.1,0.,
	  0.};
	static int _aini = 1;
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		{ static double _itmp2[] = {2.98e-3,7.41e-3,1.13e-2,2.62e-3,
		  7.5e-2,4.61e-2,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[0][i-1] = _itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {0.,.0764,.164,.243,.35,.309,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[1][i-1] = _itmp3[_r++];
			}
		}
		{ static double _itmp4[] = {2.2e5,2.01e5,1.72e5,1.02e5,4.75e6,
		  5.44e6,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[0][i-1] = _itmp4[_r++];
			}
		}
		{ static double _itmp5[] = {0.,7.37e4,2.25e5,1.25e5,8.35e5,
		  1.14e6,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[1][i-1] = _itmp5[_r++];
			}
		}
		_aini = 0;
	}

#	ifdef DEBUG_FUN
	fputs( "<+>IonNitro()\n", debug_fp );
#	endif

	/* nitrogen, atomic number 7 */
	if( !abundances.lgElmtOn[6] )
	{
		
#		ifdef DEBUG_FUN
		fputs( " <->IonNitro()\n", debug_fp );
#		endif
		return;
	}

	ionzer(ipNITROGEN);

	PhotoIonize(ipNITROGEN,FALSE);

	/* find collisional ionization rates */
	CollidIonize(ipNITROGEN);

	/* get recombination coefficients */
	MakeRecomb(rec,pl,(double*)dicoef,(double*)dite,ditcrt,aa,bb,cc,
	  dd,ff,ipNITROGEN,tlow);

	/* photoionization from 2D of NI, is atomic nitrogen present? */
	if( xIonFracs[ipNITROGEN][0] > 0. )
	{
		nitexc.d5200r = (float)GammaK(opac.in1[0],opac.in1[1],opac.in1[2],1.);
		/*aeff = nitexc.d5200r + 1.28e-5;*/
		/* >>chng 01 sep 02, use values from coolnitr */
		/*cs5200 = 1.32e-4*phycon.te/(phycon.te10*phycon.te01);*/
		/* uses 1 for total pop of atom - so is normalized to unity */
		/*nitexc.p2nit = (float)(popexc(cs5200,4.,10.,aeff,2.769e4,1.)/aeff);*/
		/* if very first call then set to zero */
		if( !conv.nTotalIoniz ) 
			nitexc.p2nit = 0.;
		/* valence shell photoionization, [0][6] => atomic nitrogen */
		ionrec.PhotoRate_Ground[ipNITROGEN][0][2][0] = ionrec.PhotoRate_Ground[ipNITROGEN][0][2][0]*
		  (1. - nitexc.p2nit) + nitexc.p2nit*nitexc.d5200r;
		ionrec.PhotoRate_Ground[ipNITROGEN][0][2][1] = ionrec.PhotoRate_Ground[ipNITROGEN][0][2][1]*
		  (1. - nitexc.p2nit) + heat.HeatNet*nitexc.p2nit;
	}
	else
	{
		nitexc.p2nit = 0.;
		nitexc.d5200r = 0.;
	}

	if( timed.itime == -1 )
	{
		theavy(ipNITROGEN);
		
#		ifdef DEBUG_FUN
		fputs( " <->IonNitro()\n", debug_fp );
#		endif
		return;
	}

	/* solve for ionization balance */
	BiDiag(ipNITROGEN,FALSE);

	if( trace.lgTrace && trace.lgHeavyBug )
	{
		fprintf( ioQQQ, "     IonNitro retun; frac=" );
		for( i=1; i <= 8; i++ )
		{
			fprintf( ioQQQ, "%10.3e", xIonFracs[ipNITROGEN][i-1]/
			  abundances.gas_phase[ipNITROGEN] );
		}
		fprintf( ioQQQ, "\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->IonNitro()\n", debug_fp );
#	endif
	return;
}

