/*IonCarbo compute ionization balance for carbon */
#include "cddefines.h"
#ifdef NDIM
#	undef NDIM
#endif
#define	NDIM	7
#include "heat.h"
#include "pmp2s.h"
#include "timed.h"
#include "trace.h"
#include "abundances.h"
#include "ionrec.h"
#include "ionfracs.h"
#include "collidionize.h"
#include "makerecomb.h"
#include "ionzer.h"
#include "theavy.h"
#include "photoionize.h"
#include "bidiag.h"
#include "ionheavy.h"

void IonCarbo(void)
{
	long int i, 
	  _r;
	static double 
	  dicoef[2][NDIM - 1], 
	  dite[2][NDIM - 1];
	static double rec[NDIM - 2]={1.47e-10,8.74e-10,7.98e-9,1.34e-8,
	  1.30e-8};
	static double pl[NDIM - 2]={-0.624,-0.645,-0.803,-0.791,-0.721};
	static double tlow[2]={1.44e-10,-0.621};
	static double ditcrt[NDIM - 1]={1.2e4,1.2e4,1.1e4,4.4e5,7.0e5,1e20};
	static double aa[NDIM - 1]={.0108,1.8267,2.3196,0.,0.,0.};
	static double bb[NDIM - 1]={-0.1075,4.1012,10.7328,0.,0.,0.};
	static double cc[NDIM - 1]={.2810,4.8443,6.8830,0.,0.,0.};
	static double dd[NDIM - 1]={-0.0193,.2261,-0.1824,0.,0.,0.};
	static double ff[NDIM - 1]={0.000,0.5960,0.4101,0.1,0.1,0.};
	static int _aini = 1;
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		{ static double _itmp2[] = {2.54e-3,6.15e-3,1.62e-3,4.78e-2,
		  3.22e-2,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[0][i-1] = _itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {4.42e-2,5.88e-2,0.343,0.362,0.315,
		  0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[1][i-1] = _itmp3[_r++];
			}
		}
		{ static double _itmp4[] = {1.57e5,1.41e5,8.19e4,3.44e6,4.06e6,
		  0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[0][i-1] = _itmp4[_r++];
			}
		}
		{ static double _itmp5[] = {3.74e5,1.41e5,1.59e5,5.87e5,8.31e5,
		  0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[1][i-1] = _itmp5[_r++];
			}
		}
		_aini = 0;
	}

#	ifdef DEBUG_FUN
	fputs( "<+>IonCarbo()\n", debug_fp );
#	endif

	if( trace.lgTrace && trace.lgCarBug )
	{
		fprintf( ioQQQ, "     IonCarbo called.\n" );
	}

	if( !abundances.lgElmtOn[ipCARBON] )
	{
		pmp2s.p1909 = 0.;
		pmp2s.p2326 = 0.;
		heat.heating[ipCARBON][9] = 0.;
		
#		ifdef DEBUG_FUN
		fputs( " <->IonCarbo()\n", debug_fp );
#		endif
		return;
	}

	/* zero out ionization balance arrays */
	ionzer(ipCARBON);

	PhotoIonize(ipCARBON,FALSE);

	/* find collisional ionization rates */
	CollidIonize(ipCARBON);

	/* get recombination coefficients */
	MakeRecomb(rec,pl,(double*)dicoef,(double*)dite,ditcrt,aa,bb,cc,
	  dd,ff,ipCARBON,tlow);

	/* Photoproduction of 3P */
	pmp2s.p1909 = ionrec.PhotoRate_Ground[ipCARBON][1][1][0];

	/* photoproduction of C II] 2326 */
	pmp2s.p2326 = ionrec.PhotoRate_Ground[ipCARBON][0][1][0];

	if( timed.itime == -1 )
	{
		theavy(ipCARBON);
		
#		ifdef DEBUG_FUN
		fputs( " <->IonCarbo()\n", debug_fp );
#		endif
		return;
	}

	/* >>chng 01 dec 07, keep total molecular abundance in xMolFracs, which bidiag knows about */
	/* following accounts for part of carbon that is in CO, since BiDiag ony
	 * wants atoms/ions, but [ipCARBON][0] includes molecules too.  Must temperariyly
	 * convert [ipCARBON][0] to atoms/molecules only 
	coatom.catmic = (float)(abundances.gas_phase[ipCARBON]*MAX2(1e-7,1.-hevmolec.hevmol[ipCO]/
	  abundances.gas_phase[ipCARBON]));*/

	BiDiag(ipCARBON,FALSE);

	/* rate will be cm-3 s-1, into triplets only
	 * >>chng 96 nov 22, rid of carb() */
	pmp2s.p1909 *= xIonFracs[ipCARBON][1]*0.62;
	pmp2s.p2326 *= xIonFracs[ipCARBON][0]*0.1;

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "     IonCarbo returns;  fracs=" );
		for( i=1; i <= 7; i++ )
		{
			fprintf( ioQQQ, " %10.3e", xIonFracs[ipCARBON][i-1]/
			  abundances.gas_phase[ipCARBON] );
		}
		fprintf( ioQQQ, "\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->IonCarbo()\n", debug_fp );
#	endif
	return;
}
