/*he3col compute collisional rates for helium triplets */
#include "cddefines.h"
#include "nhe3lvl.h"
#include "he3lte.h"
#include "phycon.h"
#include "he3c.h"
#include "che2sn.h"
#include "iso.h"
#include "r2s3bd.h"
#include "trace.h"
#include "he3.h"

void he3col(void)
{
	double cs;
	double he3bol[NHE3LVL];

#	ifdef DEBUG_FUN
	fputs( "<+>he3col()\n", debug_fp );
#	endif

	/* edensqte = eden/sqrte
	 * cdsqte = 8.629e-6*eden/sqrte */
	if( trace.lgTrace && trace.lgHe3Bug )
	{
		fprintf( ioQQQ, " HE3COL called.\n" );
	}

	he3bol[0] = sexp(5.5298e4/phycon.te);
	he3bol[1] = sexp(4.2023e4/phycon.te);
	he3bol[2] = sexp(2.1676e4/phycon.te);
	he3bol[3] = sexp(1.8329e4/phycon.te);
	he3bol[4] = sexp(1.7558e4/phycon.te);

	/* all of following collision data from
	 * >>refer	he1	cs	Berrington, K.A., & Kingston, A.E. 1987, J.Phys. B, 20, 6631
	 * >>chng 97 jul 25, updated to 
	 * >>refer	he1	cs	Sawey, P.M.J., and Berrington, K.A., 1993,
	 * >>refercon At. Data Nucl. Data Tables 55, 81 */

	/* 10830, 2 3S 2 3P */
	cs = MIN2(64.04,0.0186*phycon.te70*phycon.te10/phycon.te01);
	he3c.c2p2s = (float)(cs*phycon.cdsqte/9.);
	he3c.c2s2p = (float)(he3c.c2p2s*3.*he3bol[0]/MAX2(1e-30,he3bol[1]));

	/* 2 trip p to ground */
	cs = MIN2(0.0364,4.322e-4*phycon.sqrte/phycon.te05/phycon.te02);
	che2sn.c2pg = (float)(cs*phycon.cdsqte/9.);
	che2sn.csg2p = (float)(che2sn.c2pg*9./1.*sexp(2.4314e5/phycon.te));

	/* 2 trip s to ground */
	che2sn.c2sg = (float)(8.428e-8*phycon.edensqte*phycon.te10);
	che2sn.csg2s = (float)(che2sn.c2sg*3./1.*sexp(2.2986e5/phycon.te));

	/* singlet 2s to triplet 2s */
	if( phycon.te > 1e4 )
	{
		cs = MAX2(2.397,7.580/(phycon.te10*phycon.te02*phycon.te005));
	}
	else
	{
		cs = MIN2(2.397,0.954*phycon.te10);
	}
	che2sn.cs2s2s = (float)(cs*phycon.cdsqte/1.);

	/* trip 2s to singlet 2s */
	che2sn.c2ss2s = (float)(che2sn.cs2s2s*1./3.*sexp(9234./phycon.te));

	/* singlet 2p to trip 2s */
	che2sn.cs2p2s = (float)(0.97*phycon.cdsqte/3.);

	/* trip 2s to singlet 2p */
	cs = MIN2(1.15,0.245*phycon.te10*phycon.te05);
	che2sn.c2ss2p = (float)(cs*phycon.cdsqte/3.*sexp(16219./phycon.te));

	/* 2p to singlet 2s */
	che2sn.c2ps2s = (float)(1.65*phycon.cdsqte/9.);
	/* the inverse reaction */
	che2sn.cs2s2p = (float)(che2sn.c2ps2s*9./1.*sexp(4041./phycon.te));

	/* 2p to singlet 2p */
	che2sn.cs2p2p = (float)(4.4*phycon.cdsqte/3.);
	/* the inverse reaction */
	che2sn.c2ps2p = (float)(che2sn.cs2p2p*3./9.*sexp(2945./phycon.te));

	/* triplet 3s to 2s */
	if( phycon.te > 1.5e4 )
	{
		cs = MIN2(2.63,0.561*phycon.te10*phycon.te05);
	}
	else
	{
		cs = MAX2(2.79,5.121/(phycon.te10/phycon.te02));
	}
	he3c.c3s2s = (float)(cs*phycon.cdsqte/3.);
	/* the inverse reaction */
	he3c.c2s3s = (float)(he3c.c3s2s*he3bol[0]/MAX2(1e-30,he3bol[2]));

	/* triplet 2s to 3p, 3889 */
	cs = MIN2(1.88,1.0128*phycon.te03*phycon.te03);
	he3c.c3p2s = (float)(cs*phycon.cdsqte/9.);
	he3c.c2s3p = (float)(he3c.c3p2s*3.*he3bol[0]/MAX2(1e-30,he3bol[3]));

	/* triplet 3d to 2s */
	cs = MIN2(4.47,3.281e-3*phycon.te70);
	he3c.c3d2s = (float)(cs*phycon.cdsqte/15.);
	/* the inverse reaction */
	he3c.c2s3d = (float)(he3c.c3d2s*5.*he3bol[0]/MAX2(1e-30,he3bol[4]));

	/* triplet 3s 2p, 7065 */
	cs = MIN2(6.460,1.974*phycon.te10*phycon.te01*phycon.te005);
	he3c.c3s2p = (float)(cs*phycon.cdsqte/3.);
	/* the inverse reaction */
	he3c.c2p3s = (float)(he3c.c3s2p/3.*he3bol[1]/MAX2(1e-30,he3bol[2]));

	/* triplet 3P -  2P */
	cs = MIN2(11.45,0.4229*phycon.te30*phycon.te02);
	he3c.c3p2p = (float)(cs*phycon.cdsqte/9.);
	/* the inverse reaction */
	he3c.c2p3p = (float)(he3c.c3p2p*he3bol[1]/MAX2(1e-30,he3bol[3]));

	/* trip 3 3D to 2 3P, 5876 */
	cs = MIN2(22.19,1.117e-3*phycon.te/phycon.te01/phycon.te01);
	he3c.c3d2p = (float)(cs*phycon.cdsqte/15.);
	/* the inverse reaction */
	he3c.c2p3d = (float)(he3c.c3d2p*1.67*he3bol[1]/MAX2(1e-30,he3bol[4]));

	/* HE3LTE is LTE density over (eden*next ion) */
	if( he3bol[0] > 0. )
	{
		he3lteCom.he3lte[0] = (float)(3./2.*2.0708e-16/phycon.te32/he3bol[0]);
		he3lteCom.he3lte[1] = (float)(9./2.*2.0708e-16/phycon.te32/he3bol[1]);
	}
	else
	{
		he3lteCom.he3lte[0] = 0.;
		he3lteCom.he3lte[1] = 0.;
	}

	if( he3bol[2] > 0. )
	{
		he3lteCom.he3lte[2] = (float)(3./2.*2.0708e-16/phycon.te32/he3bol[2]);
		he3lteCom.he3lte[3] = (float)(9./2.*2.0708e-16/phycon.te32/he3bol[3]);
		he3lteCom.he3lte[4] = (float)(15./2.*2.0708e-16/phycon.te32/he3bol[4]);
	}
	else
	{
		he3lteCom.he3lte[2] = 0.;
		he3lteCom.he3lte[3] = 0.;
		he3lteCom.he3lte[4] = 0.;
	}

	/* coll ioniz from 2.3.s from 
	 * >>refer	he1	cs	Seaton, M.S. 1964, Plan Sp Sci 12, 55. */
	he3c.c2sion = (float)(8.8e-10*phycon.sqrte*phycon.eden*he3bol[0]*iso.lgColl_ionize[ipHE_LIKE]);
	he3c.c2pion = (float)(3.*8.8e-10*phycon.sqrte*phycon.eden*he3bol[1]*iso.lgColl_ionize[ipHE_LIKE]);

	/* add three-body rec to recombination rates; units s^-1 */
	r2s3bdCom.r2s3bd = he3c.c2sion*he3lteCom.he3lte[0];
	r2s3bdCom.r2p3bd = he3c.c2pion*he3lteCom.he3lte[1];


#	ifdef DEBUG_FUN
	fputs( " <->he3col()\n", debug_fp );
#	endif
	return;
}

