/*he1jbr returns continuum occupation number for helium singlet lines */
#include "cddefines.h"
#include "nhe1lvl.h"
#include "rfield.h"
#include "iphe1l.h"
#include "he1.h"

double he1jbr(long int ihi, 
  long int low)
{
	float he1jbr_v;

#	ifdef DEBUG_FUN
	fputs( "<+>he1jbr()\n", debug_fp );
#	endif


	/*confirm that these are within range of code */
	ASSERT( iphe1lCom.iphe1l[low-1][ihi-1] > 0 );
	ASSERT( iphe1lCom.iphe1l[low-1][ihi-1] < rfield.nupper);

	if( rfield.lgInducProcess )
	{
		he1jbr_v = rfield.OccNumbIncidCont[iphe1lCom.iphe1l[low-1][ihi-1]-1];
	}
	else
	{
		/* option to turn off continuum fluorsecent excitation with
		 * "no induced" command */
		he1jbr_v = 0.;
	}


#	ifdef DEBUG_FUN
	fputs( " <->he1jbr()\n", debug_fp );
#	endif
	return( he1jbr_v );
}

