/*forlin derive radiative acceleration due to line absorption of incident continuum */
#include "cddefines.h"
#include "physconst.h"
#include "iso.h"
#include "taulines.h"
#include "ionfracs.h"
#include "h2.h"
#include "ionrange.h"
#include "pop371.h"
#include "forlin.h"

double forlin(void)
{
	long int i, 
	  ipHi, 
	  nelem, 
	  ipLo,
	  ipISO;

	double AllHeavy, 
	  AllRest, 
	  OneLine, 
	  fe2drive, 
	  forlin_v, 
	  h2drive,
	  accel_iso[NISO];

	/* following used for debugging */
	/* double 
	  RestMax, 
	  HeavMax, 
	  hydromax;
	  long int 
	  ipRestMax, 
	  ihmax; */

#	ifdef DEBUG_FUN
	fputs( "<+>forlin()\n", debug_fp );
#	endif

	/* this function finds the total rate the gas absorbs energy
	 * this result is divided by the calling routine to find the
	 * momentum absorbed by the gas, and eventually the radiative acceleration
	 *
	 * the energy absorbed by the line is
	 * Abundance * energy * A *(g_up/g_lo) * occnum * escape prob
	 * where occnum is the photon occupation number, and the g's are
	 * the ratios of statistical weights */

	/* TODO
	 * put helium triplets in */

	/* total energy absorbed in this zone, per cubic cm
	 * do hydrogen first */

	for( ipISO=ipH_LIKE; ipISO<NISO; ++ipISO )
	{
		accel_iso[ipISO] = 0;
		for( nelem=ipISO; nelem < LIMELM; nelem++ )
		{
			if( (IonRange.IonHigh[nelem] >= nelem + 1-ipISO)  )
			{
				/* do not put in highest level since its not real */
				for( ipLo=0; ipLo < (iso.numLevels[ipISO][nelem] - 2); ipLo++ )
				{
					/* must not include the two-photon continuum in the folipLoing*/
					for( ipHi=ipLo+1; ipHi < iso.numLevels[ipISO][nelem]; ipHi++ )
					{
						/* do not include bogus lines */
						if( EmisLines[ipISO][nelem][ipHi][ipLo].ipCont > 0 )
						{
							OneLine = EmisLines[ipISO][nelem][ipHi][ipLo].pump*
							EmisLines[ipISO][nelem][ipHi][ipLo].EnergyErg*
							EmisLines[ipISO][nelem][ipHi][ipLo].PopOpc*
							xIonFracs[nelem][nelem+2-ipISO-1];

							accel_iso[ipISO] += OneLine;
						}
					}
				}
			}
		}
		accel_iso[ipISO] *= EN1RYD;
	}
#	if 0
	/* >>chng 02 may 16 - all following moved into above loop */
	HydroAccel *= EN1RYD;

	HeAccel = 0;

	/* do not put in highest level since its not real */
	for( nelem=1; nelem < LIMELM; nelem++ )
	{
		/* is he-like ion present */
		if( (IonRange.IonHigh[nelem] >= nelem)  )
		{
			for( ipHi=1; ipHi <iso.numLevels[ipHE_LIKE][nelem]; ipHi++ )
			{
				/* should not include the two-photon continuum in the folipLoing*/
				for( ipLo=0; ipLo < ipHi; ipLo++ )
				{
					OneLine = EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].pump*
					  EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].EnergyErg*
					  EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopOpc*
					  /* >>>chng 99 sep 19, this did not have the following
					   * factor and caused build-up of radiation pressure in
					   * constant pressure models that went totally neutral */
					  xIonFracs[nelem][nelem];
					HeAccel += OneLine;
				}
			}
		}
	}

	HeAccel *= EN1RYD;
#	endif

	/* >>chng 02 may 15, rm this block, double counted with above */
#	if 0
	/* total energy absorbed in this zone, per cubic cm
	 * helium */
	he1l = 0;
	for( ipLo=0; ipLo < 7; ipLo++ )
	{
		for( ipHi=ipLo + 1; ipHi < 8; ipHi++ )
		{
			he1l += phe1lv.he1n[ipLo]*he1tauCOM.he1con[ipLo][ipHi]*
			  rfield.anu[iphe1lCom.iphe1l[ipLo][ipHi]-1];
		}
	}
	he1l *= EN1RYD*xIonFracs[ipHELIUM][1];
#	endif

	/* all heavy element lines in calculation of cooling 
	 * these are the level 1 lines */
	AllHeavy = 0.;
	for( i=1; i <= nLevel1; i++ )
	{
		OneLine = 
		  TauLines[i].pump*
		  TauLines[i].EnergyErg*
		  TauLines[i].PopOpc;
		AllHeavy += OneLine;
	}

	/* all heavy element lines treated with g-bar 
	 * these are the level 2 lines, f should be ok */
	AllRest = 0.;
	for( i=0; i < nWindLine; i++ )
	{
		OneLine = 
			TauLine2[i].pump*
			TauLine2[i].EnergyErg*
			TauLine2[i].PopOpc;
		AllRest += OneLine;
	}
	for( i=0; i < nHFLines; i++ )
	{
		OneLine = 
			HFLines[i].pump*
			HFLines[i].EnergyErg*
			HFLines[i].PopOpc;
		AllRest += OneLine;
	}
	for( i=0; i < nCORotate; i++ )
	{
		OneLine = 
			C12O16Rotate[i].pump*
			C12O16Rotate[i].EnergyErg*
			C12O16Rotate[i].PopOpc;
		AllRest += OneLine;
		OneLine = 
			C13O16Rotate[i].pump*
			C13O16Rotate[i].EnergyErg*
			C13O16Rotate[i].PopOpc;
		AllRest += OneLine;
	}

	/* the H2 molecule */
	h2drive = H2_Accel();

	/* The large model FeII atom */
	fe2drive = 0.;
	if( FeII.lgFeIION  )
	{
		FeIIAccel(&fe2drive);
	}

	/*lint -e771 accel_iso not init */
	forlin_v = AllHeavy + accel_iso[ipH_LIKE] + accel_iso[ipHE_LIKE] + 
		fe2drive + h2drive + AllRest;
	/*lint +e771 accel_iso not init */

	/*fprintf(ioQQQ," wind te %e %e %e %e %e\n", 	
		AllHeavy , HydroAccel , fe2drive , he1l , AllRest );*/

#	ifdef DEBUG_FUN
	fputs( " <->forlin()\n", debug_fp );
#	endif
	return( forlin_v );
}

