/*fe2dat block data storing energy levels for Fred's FeII ground
 * There are 373 transitions:
 * Wavelength (A)
 * absorption oscillator strength
 * Energy of lower level (Ryd)
 * Statistical weight of lower level (g) */
#include "cddefines.h"
#include "nfeii.h"
#include "fe2pmp.h"
#include "blockdata.h"
void blkdata2(void)
{
	long int i, 
	  _r;
	static int _aini = 1;
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		{ static double _itmp0[] = {1204.735,1204.742,1204.755,1204.762,
		  1204.867,1204.946,1205.021,1205.028,1205.117,1205.572,1205.576,
		  1205.606,1205.909,1205.975,1205.997,1206.188,1206.259,1206.332,
		  1206.350,1206.428,1206.457,1206.475,1206.487,1206.527,1206.549,
		  1206.638,1206.646,1206.695,1206.727,1206.740,1206.983,1207.020,
		  1207.031,1207.056,1207.122,1207.174,1207.286,1207.353,1207.354,
		  1207.360,1207.384,1207.480,1207.482,1207.516,1207.655,1207.893,
		  1207.928,1208.013,1208.162,1208.230,1208.430,1208.430,1208.432,
		  1208.459,1208.561,1208.630,1208.847,1208.995,1209.160,1209.207,
		  1209.292,1209.319,1209.378,1209.431,1209.484,1209.492,1209.503,
		  1209.504,1209.676,1209.763,1209.783,1209.829,1209.929,1209.956,
		  1210.068,1210.073,1210.103,1210.443,1210.490,1210.561,1210.572,
		  1210.694,1210.695,1210.744,1210.809,1210.840,1210.881,1210.948,
		  1211.010,1211.011,1211.037,1211.226,1211.230,1211.255,1211.272};
		for( i=1, _r = 0; i <= 95; i++ )
		{
			fe2pmp.fe2lam[i-1] = (float)_itmp0[_r++];
			}
		}
		{ static double _itmp1[] = {1211.311,1211.330,1211.342,1211.366,
		  1211.391,1211.432,1211.436,1211.503,1211.566,1211.578,1211.606,
		  1211.609,1211.618,1211.644,1211.690,1211.704,1211.809,1211.818,
		  1211.825,1211.838,1211.860,1211.883,1211.892,1211.959,1211.973,
		  1211.986,1212.014,1212.019,1212.070,1212.084,1212.122,1212.253,
		  1212.264,1212.356,1212.662,1212.753,1212.950,1212.966,1212.985,
		  1213.012,1213.075,1213.090,1213.091,1213.132,1213.221,1213.412,
		  1213.529,1213.580,1213.644,1213.719,1213.734,1213.738,1213.759,
		  1213.767,1213.833,1213.917,1214.032,1214.061,1214.067,1214.150,
		  1214.172,1214.251,1214.283,1214.285,1214.286,1214.398,1214.432,
		  1214.518,1214.559,1214.735,1214.821,1214.865,1214.905,1215.051,
		  1215.058,1215.081,1215.180,1215.183,1215.359,1215.387,1215.421,
		  1215.490,1215.647,1215.690,1215.691,1215.707,1215.801,1215.852,
		  1215.873,1215.983,1216.013,1216.026,1216.038,1216.141,1216.239};
		for( i=96, _r = 0; i <= 190; i++ )
		{
			fe2pmp.fe2lam[i-1] = (float)_itmp1[_r++];
			}
		}
		{ static double _itmp2[] = {1216.272,1216.275,1216.275,1216.483,
		  1216.522,1216.523,1216.638,1216.769,1216.783,1216.847,1216.902,
		  1216.908,1216.922,1216.978,1216.996,1217.011,1217.041,1217.050,
		  1217.107,1217.118,1217.143,1217.152,1217.205,1217.291,1217.301,
		  1217.347,1217.349,1217.486,1217.487,1217.497,1217.566,1217.583,
		  1217.593,1217.620,1217.633,1217.707,1217.729,1217.848,1217.854,
		  1217.878,1217.880,1217.887,1218.042,1218.053,1218.088,1218.097,
		  1218.099,1218.108,1218.186,1218.211,1218.213,1218.275,1218.301,
		  1218.304,1218.374,1218.395,1218.408,1218.464,1218.666,1218.668,
		  1218.672,1218.738,1218.808,1218.833,1218.835,1218.922,1218.928,
		  1219.125,1219.132,1219.186,1219.413,1219.424,1219.512,1219.517,
		  1219.533,1219.621,1219.649,1219.664,1219.708,1219.713,1219.731,
		  1219.735,1219.802,1219.978,1219.992,1220.035,1220.064,1220.132,
		  1220.173,1220.208,1220.239,1220.264,1220.270,1220.277,1220.386};
		for( i=191, _r = 0; i <= 285; i++ )
		{
			fe2pmp.fe2lam[i-1] = (float)_itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {1220.471,1220.479,1220.522,1220.560,
		  1220.669,1220.769,1220.807,1220.872,1220.924,1221.060,1221.067,
		  1221.123,1221.201,1221.204,1221.459,1221.465,1221.478,1221.526,
		  1221.536,1221.555,1221.596,1221.648,1221.763,1221.805,1221.918,
		  1221.998,1222.025,1222.231,1222.232,1222.384,1222.433,1222.453,
		  1222.472,1222.547,1222.658,1222.663,1222.723,1222.746,1222.825,
		  1222.912,1222.920,1222.927,1222.971,1223.107,1223.282,1223.291,
		  1223.320,1223.327,1223.428,1223.561,1223.590,1223.623,1223.747,
		  1223.827,1224.075,1224.101,1224.132,1224.225,1224.278,1224.380,
		  1224.383,1224.388,1224.391,1224.455,1224.486,1224.673,1224.696,
		  1224.829,1224.863,1224.878,1225.059,1225.111,1225.157,1225.212,
		  1225.273,1225.282,1225.400,1225.402,1225.412,1225.459,1225.487,
		  1225.496,1225.577,1225.615,1225.631,1225.651,1225.661,1225.730};
		for( i=286, _r = 0; i <= NFEII; i++ )
		{
			fe2pmp.fe2lam[i-1] = (float)_itmp3[_r++];
			}
		}
		{ static double _itmp4[] = {2.366e-08,1.037e-04,2.506e-03,4.529e-06,
		  5.662e-06,2.529e-04,2.157e-11,1.083e-07,1.465e-02,1.188e-05,
		  2.792e-03,2.697e-04,7.210e-05,1.101e-09,1.660e-02,5.715e-09,
		  9.416e-08,1.330e-08,5.081e-06,3.183e-06,2.349e-03,2.306e-05,
		  3.846e-07,4.601e-06,4.455e-04,3.733e-08,3.898e-06,2.371e-09,
		  5.080e-06,8.392e-05,2.142e-03,1.428e-04,8.930e-06,1.778e-05,
		  3.427e-06,4.976e-08,5.186e-05,6.697e-04,1.079e-03,2.269e-04,
		  5.713e-06,4.404e-06,4.580e-05,2.243e-05,7.192e-06,1.674e-02,
		  6.484e-08,1.373e-06,1.592e-03,2.897e-03,1.717e-04,2.495e-06,
		  1.439e-03,6.150e-04,2.697e-04,8.471e-05,2.804e-03,8.318e-03,
		  9.245e-06,2.629e-05,1.285e-10,1.538e-05,3.926e-06,2.018e-03,
		  3.639e-06,3.621e-06,9.591e-05,1.183e-03,1.412e-05,3.295e-04,
		  5.034e-05,5.621e-05,2.588e-03,9.681e-05,9.264e-07,7.012e-05,
		  1.492e-09,1.028e-06,2.132e-08,1.180e-05,2.239e-06,1.857e-06,
		  3.732e-04,4.225e-06,1.479e-03,8.014e-06,7.673e-06,2.600e-09,
		  1.161e-04,1.270e-03,1.614e-03,3.793e-06,5.080e-05,2.666e-04,
		  5.928e-03};
		for( i=1, _r = 0; i <= 95; i++ )
		{
			fe2pmp.fe2osc[i-1] = (float)_itmp4[_r++];
			}
		}
		{ static double _itmp5[] = {2.910e-04,9.141e-05,8.587e-07,1.242e-05,
		  1.297e-05,2.466e-07,1.968e-06,1.216e-09,3.146e-04,1.262e-03,
		  2.322e-07,1.663e-08,1.279e-04,1.667e-06,7.887e-04,8.259e-05,
		  8.182e-06,4.864e-09,5.164e-08,2.930e-04,6.484e-06,4.808e-05,
		  4.365e-06,9.791e-10,1.374e-04,4.017e-03,1.094e-05,2.172e-03,
		  8.951e-06,4.539e-07,6.947e-08,1.227e-11,1.932e-08,9.747e-04,
		  2.991e-08,4.416e-05,1.651e-08,4.275e-03,1.030e-08,4.374e-08,
		  1.510e-05,8.570e-05,7.852e-03,2.612e-02,9.837e-06,4.018e-03,
		  2.133e-06,4.548e-06,3.040e-04,7.328e-05,1.442e-08,1.216e-01,
		  1.116e-01,9.683e-07,1.573e-06,1.581e-05,1.297e-05,1.585e-09,
		  4.709e-03,1.603e-02,2.449e-06,1.438e-05,8.372e-07,3.443e-03,
		  1.782e-08,7.310e-04,3.228e-03,1.706e-07,2.697e-07,2.143e-04,
		  6.278e-06,2.647e-05,1.857e-06,2.698e-07,1.648e-03,6.053e-07,
		  5.458e-06,2.647e-03,4.294e-05,7.798e-07,1.183e-06,1.309e-06,
		  1.503e-06,1.106e-05,2.113e-03,2.197e-04,4.611e-07,1.541e-03,
		  3.792e-03,1.482e-04,1.794e-04,1.294e-04,5.727e-04,8.259e-08,
		  1.191e-03};
		for( i=96, _r = 0; i <= 190; i++ )
		{
			fe2pmp.fe2osc[i-1] = (float)_itmp5[_r++];
			}
		}
		{ static double _itmp6[] = {1.112e-03,1.339e-03,2.042e-06,6.107e-05,
		  5.270e-05,2.466e-03,9.814e-05,4.036e-05,7.548e-05,3.404e-03,
		  5.000e-05,1.023e-09,4.285e-06,5.571e-06,1.737e-07,3.097e-07,
		  6.901e-06,2.138e-06,4.149e-07,1.807e-05,1.644e-05,1.493e-03,
		  2.089e-03,6.380e-08,3.681e-03,6.010e-07,2.761e-06,1.671e-04,
		  6.095e-09,2.766e-06,9.078e-05,7.816e-07,1.879e-06,3.523e-03,
		  1.361e-10,1.309e-04,2.377e-06,4.017e-03,1.049e-04,9.418e-06,
		  3.133e-06,1.035e-07,3.707e-06,7.128e-07,1.333e-04,1.659e-04,
		  1.746e-06,2.890e-08,2.494e-03,3.289e-09,3.953e-03,6.081e-06,
		  4.932e-05,4.943e-09,1.239e-08,9.547e-04,2.079e-06,1.230e-02,
		  5.345e-05,2.426e-06,1.386e-04,9.549e-06,9.590e-04,8.034e-05,
		  6.252e-09,4.120e-05,2.366e-06,3.971e-06,1.503e-10,7.815e-08,
		  2.818e-04,5.873e-06,2.471e-07,5.584e-08,5.943e-06,5.358e-05,
		  2.332e-08,3.774e-06,1.014e-05,5.283e-06,3.890e-07,2.223e-07,
		  4.665e-02,5.740e-08,2.773e-06,2.393e-08,2.824e-07,1.084e-06,
		  4.753e-05,2.296e-04,5.927e-06,2.157e-05,5.874e-07,4.786e-06,
		  2.978e-03};
		for( i=191, _r = 0; i <= 285; i++ )
		{
			fe2pmp.fe2osc[i-1] = (float)_itmp6[_r++];
			}
		}
		{ static double _itmp7[] = {3.630e-08,1.007e-07,9.033e-05,3.061e-04,
		  6.037e-06,7.798e-05,3.281e-05,1.625e-03,1.534e-04,7.292e-08,
		  2.122e-07,6.484e-04,5.559e-05,3.013e-05,1.725e-04,4.345e-04,
		  1.096e-04,7.396e-06,1.074e-09,1.409e-04,3.589e-04,4.236e-05,
		  8.510e-06,1.986e-03,2.410e-06,2.786e-08,8.707e-06,3.303e-05,
		  2.280e-06,7.533e-04,5.534e-06,1.932e-05,4.083e-06,2.207e-05,
		  4.091e-05,6.774e-08,8.165e-05,5.874e-06,9.247e-07,4.374e-11,
		  2.443e-03,9.290e-07,2.248e-07,1.023e-07,2.850e-03,3.420e-04,
		  7.551e-08,7.278e-07,6.426e-07,1.156e-05,3.083e-05,1.247e-04,
		  1.161e-05,2.317e-05,4.149e-06,2.773e-06,4.907e-02,1.514e-04,
		  1.725e-03,4.294e-04,1.233e-06,6.727e-04,6.107e-06,7.534e-06,
		  1.074e-07,1.578e-03,8.993e-07,1.531e-05,8.051e-06,3.341e-10,
		  1.202e-07,8.994e-06,7.226e-05,7.028e-04,1.678e-08,5.224e-07,
		  3.775e-05,2.654e-06,9.244e-05,8.570e-05,1.345e-04,1.207e-02,
		  8.432e-06,7.210e-09,1.840e-04,6.995e-06,3.871e-07,3.655e-05};
		for( i=286, _r = 0; i <= NFEII; i++ )
		{
			fe2pmp.fe2osc[i-1] = (float)_itmp7[_r++];
			}
		}
		{ static double _itmp8[] = {0.0079,0.2350,0.2351,0.0806,0.0806,
		  0.2350,0.1853,0.1853,0.2385,0.2517,0.2374,0.0725,0.2367,
		  0.0035,0.2401,0.1896,0.1870,0.1896,0.0791,0.1870,0.2367,
		  0.2517,0.1896,0.1228,0.1898,0.1896,0.1870,0.1896,0.1870,
		  0.1898,0.2374,0.2517,0.1870,0.1898,0.2350,0.1898,0.1898,
		  0.2367,0.2351,0.0725,0.1870,0.1870,0.0765,0.1898,0.1228,
		  0.2317,0.2517,0.1853,0.2063,0.2351,0.2374,0.1444,0.2350,
		  0.2489,0.1228,0.1942,0.2374,0.2351,0.2489,0.2385,0.1988,
		  0.1444,0.1721,0.0725,0.1942,0.1853,0.0765,0.2351,0.1870,
		  0.2489,0.1942,0.0765,0.2367,0.2367,0.1853,0.2385,0.0061,
		  0.1896,0.1853,0.1246,0.2769,0.2489,0.2078,0.1870,0.2367,
		  0.1898,0.2350,0.1896,0.1898,0.2374,0.2374,0.1942,0.1898,
		  0.2385,0.2367};
		for( i=1, _r = 0; i <= 95; i++ )
		{
			fe2pmp.fe2enr[i-1] = (float)_itmp8[_r++];
			}
		}
		{ static double _itmp9[] = {0.1898,0.2401,0.1853,0.2769,0.1942,
		  0.1896,0.1444,0.1853,0.2317,0.2367,0.2489,0.1896,0.1898,
		  0.0725,0.1492,0.0791,0.1228,0.1896,0.1896,0.0791,0.1870,
		  0.2401,0.1721,0.1853,0.1898,0.0765,0.1870,0.0765,0.1898,
		  0.2769,0.1853,0.1853,0.2769,0.2374,0.2374,0.2401,0.1953,
		  0.0725,0.1967,0.1936,0.1870,0.1444,0.2351,0.0725,0.1870,
		  0.2351,0.2350,0.2385,0.2517,0.2063,0.1942,0.0791,0.0765,
		  0.1967,0.1228,0.1896,0.1870,0.1942,0.0791,0.0806,0.1942,
		  0.2517,0.1898,0.0806,0.1942,0.0725,0.2350,0.1942,0.1978,
		  0.1246,0.2374,0.2385,0.1978,0.1967,0.2063,0.2350,0.1967,
		  0.2317,0.1898,0.2401,0.1978,0.1953,0.1953,0.1978,0.2367,
		  0.2489,0.1953,0.0765,0.2317,0.0765,0.2367,0.2489,0.1988,
		  0.1492,0.0791};
		for( i=96, _r = 0; i <= 190; i++ )
		{
			fe2pmp.fe2enr[i-1] = (float)_itmp9[_r++];
			}
		}
		{ static double _itmp10[] = {0.0791,0.2078,0.2401,0.1898,0.0765,
		  0.0806,0.1898,0.1246,0.2374,0.2063,0.1988,0.2803,0.1896,
		  0.1978,0.1936,0.1936,0.1492,0.2401,0.1978,0.2351,0.2350,
		  0.0791,0.1988,0.1853,0.2367,0.1978,0.1896,0.2374,0.1896,
		  0.1492,0.2401,0.1967,0.1942,0.2078,0.2803,0.1898,0.1967,
		  0.0725,0.1898,0.1942,0.1942,0.1967,0.1967,0.1942,0.0765,
		  0.2042,0.1967,0.1246,0.2090,0.1896,0.0725,0.1942,0.2351,
		  0.1896,0.1896,0.2374,0.1936,0.2454,0.1988,0.1942,0.1898,
		  0.0806,0.2385,0.1988,0.1896,0.1673,0.2350,0.1942,0.1896,
		  0.1492,0.1444,0.0765,0.1853,0.1978,0.0171,0.0806,0.1953,
		  0.1953,0.1870,0.1978,0.1492,0.2367,0.1936,0.1978,0.0791,
		  0.1978,0.2350,0.0791,0.2769,0.1267,0.2517,0.0791,0.1978,
		  0.2350,0.2350};
		for( i=191, _r = 0; i <= 285; i++ )
		{
			fe2pmp.fe2enr[i-1] = (float)_itmp10[_r++];
			}
		}
		{ static double _itmp11[] = {0.2350,0.0725,0.1870,0.2517,0.1953,
		  0.2351,0.0791,0.0765,0.2367,0.1953,0.1953,0.2374,0.2401,
		  0.1988,0.1936,0.2351,0.2350,0.2401,0.1988,0.1267,0.2454,
		  0.1988,0.1988,0.2454,0.1967,0.1988,0.2374,0.1942,0.2350,
		  0.0791,0.1967,0.1942,0.0806,0.2385,0.2317,0.1936,0.2350,
		  0.0806,0.2769,0.0725,0.2374,0.1967,0.1936,0.1967,0.2367,
		  0.0806,0.1967,0.1967,0.2350,0.1936,0.1942,0.2351,0.1942,
		  0.2350,0.1978,0.2367,0.1953,0.2769,0.2374,0.2367,0.1978,
		  0.2374,0.1898,0.2769,0.2350,0.2351,0.1978,0.1942,0.1936,
		  0.1978,0.1978,0.1988,0.1978,0.1898,0.1978,0.2401,0.1988,
		  0.1988,0.1228,0.1967,0.2374,0.1936,0.1988,0.2489,0.2367,
		  0.1953,0.1936,0.2350};
		for( i=286, _r = 0; i <= NFEII; i++ )
		{
			fe2pmp.fe2enr[i-1] = (float)_itmp11[_r++];
			}
		}
		{ static double _itmp12[] = {4,4,10,2,2,4,12,12,12,6,6,8,8,
		  8,10,10,6,10,4,6,8,6,10,6,6,10,6,10,6,6,6,6,6,6,4,6,6,8,
		  10,8,6,6,6,6,6,12,6,12,10,10,6,10,4,8,6,4,6,10,8,12,4,10,
		  2,8,4,12,6,10,6,8,4,6,8,8,12,12,6,10,12,4,10,8,8,6,8,6,4,
		  10,6,6,6,4,6,12,8};
		for( i=1, _r = 0; i <= 95; i++ )
		{
			fe2pmp.fe2gs[i-1] = (float)_itmp12[_r++];
			}
		}
		{ static double _itmp13[] = {6,10,12,10,4,10,10,12,12,8,8,10,
		  6,8,8,4,6,10,10,4,6,10,2,12,6,6,6,6,6,10,12,12,10,6,6,10,
		  12,8,10,14,6,10,10,8,6,10,4,12,6,10,4,4,6,10,6,10,6,4,4,
		  2,4,6,6,2,4,8,4,4,8,4,6,12,8,10,10,4,10,12,6,10,8,12,12,
		  8,8,8,12,6,12,6,8,8,4,8,4};
		for( i=96, _r = 0; i <= 190; i++ )
		{
			fe2pmp.fe2gs[i-1] = (float)_itmp13[_r++];
			}
		}
		{ static double _itmp14[] = {4,8,10,6,6,2,6,4,6,10,4,8,10,8,
		  14,14,8,10,8,10,4,4,4,12,8,8,10,6,10,8,10,10,4,8,8,6,10,
		  8,6,4,4,10,10,4,6,2,10,4,6,10,8,4,10,10,10,6,14,2,4,4,6,
		  2,12,4,10,4,4,4,10,8,10,6,12,8,10,2,12,12,6,8,8,8,14,8,4,
		  8,4,4,10,2,6,4,8,4,4};
		for( i=191, _r = 0; i <= 285; i++ )
		{
			fe2pmp.fe2gs[i-1] = (float)_itmp14[_r++];
			}
		}
		{ static double _itmp15[] = {4,8,6,6,12,10,4,6,8,12,12,6,10,
		  4,14,10,4,10,4,2,2,4,4,2,10,4,6,4,4,4,10,4,2,12,12,14,4,
		  2,10,8,6,10,14,10,8,2,10,10,4,14,4,10,4,4,8,8,12,10,6,8,
		  8,6,6,10,4,10,8,4,14,8,8,4,8,6,8,10,4,4,6,10,6,14,4,8,8,
		  12,14,4};
		for( i=286, _r = 0; i <= NFEII; i++ )
		{
			fe2pmp.fe2gs[i-1] = (float)_itmp15[_r++];
			}
		}
		_aini = 0;
	}

#	ifdef DEBUG_FUN
	fputs( "<+>blkdata0()\n", debug_fp );
#	endif

#	ifdef DEBUG_FUN
	fputs( " <->blkdata0()\n", debug_fp );
#	endif
}

