/* routine called at end of iteration when advection is turned on */
void DynaEndIter(void);

/* routine called at end of iteration to save values in previous iteration */
void DynaSaveLast(void);

/* routine called at end of iteration to determine new step sizes */
void DynaNewStep(void);

/* DynaStartZone called at end of iteration when advection is turned on */
void DynaStartZone(void);

/* DynaIonize, called from ionize to evaluate advective terms for current conditions */
void DynaIonize(void);

/* DynaChangeDensity, called from PressureChange to evaluate new density needed for
 * current conditions and wind solution, returns ratio of new to old density,
 * called when wind velocity is negative for D-critical solutions  */
double DynaChangeDensity(void);

/*DynaZero zero some dynamics variables, called from zero.c */
void DynaZero( void );

/*DynaCreateArrays allocate some space needed to save the dynamics structure variables, called from CreateData */
void DynaCreateArrays( void );

/* ParseDynaWind parse the wind command, called from ParseCommands */
void ParseDynaWind( char *chCard );

/* all of these are initialized in zero */
EXTERN struct t_advec 
{


	/* DynTimestep, as derived in DynaEndIter */
	double DynTimestep;

	/* is advection turned on ?, set to FALSE in zero */
	int lgAdvection;

	/* advective cooling minus heating (erg cm^-3 s^-1) */
	double CoolHeat, dCoolHeatdT;

	/* largest fraction of cooling and heating */
	double CoolMax, HeatMax;

	/* the upstream grams per unit vol
	double DenMass;*/

	/* the advection photo rate (s^-1) */
	double Photo;

	/* the advective recombination rate (s^-1)*/
	double Recomb[LIMELM][LIMELM+2];


}	dynamics;
