/*DumpLine print various information about an emission line vector, 
 * used in debugging, print to std out, ioQQQ */
#include "cddefines.h"
#include "phycon.h"
#include "texcline.h"

void DumpLine(EmLine * t)
{
	char chLbl[11];

#	ifdef DEBUG_FUN
	fputs( "<+>DumpLine()\n", debug_fp );
#	endif

	/* routine to print contents of line arrays */
	strcpy( chLbl, chLineLbl(t) );

	fprintf( ioQQQ, 
		"   %10.10s te=%.2e eden%.1e CS=%.2e Aul=%.1e Tex%.1e col,het%.1e %.1e\n", 
	  chLbl, 
	  phycon.te, 
	  phycon.eden, 
	  t->cs, 
	  t->Aul, 
	  TexcLine(t), 
	  t->cool, 
	  t->heat );

	fprintf( ioQQQ, 
		"  Tin%.1e Tout%.1e Esc%.1e eEsc%.1e DesP%.1e Pump%.1e OTS%.1e PopL,U %.1e %.1e inten%.1e\n", 
	  t->TauIn, 
	  t->TauTot, 
	  t->Pesc, 
	  t->Pelec_esc, 
	  t->Pdest, 
	  t->pump, 
	  t->ots, 
	  t->PopLo, 
	  t->PopHi ,
	  t->xIntensity );

#	ifdef DEBUG_FUN
	fputs( " <->DumpLine()\n", debug_fp );
#	endif
	return;
}
