/*CoolSum  total cooling from all entries into cooling stack */
/*colzro set cooling and heating stack to zero */
/*coladd add coolants to the cooling stack, called in evaluation of cooling function */
#include "cddefines.h"
#include "taulines.h"
#include "heat.h"
#include "cooling.h"

/*coladd add coolants to the cooling stack, called in evaluation of cooling function */
void coladd(char *chLabel, 
  float lambda, 
  double cool)
{

#	ifdef DEBUG_FUN
	fputs( "<+>coladd()\n", debug_fp );
#	endif

	/* this can be done with an assert since these results cannot possibly
	 * depend on user input */
	ASSERT( cooling.ncltot < NCOLNT );

	/* copy coolant label into stack */
	strcpy( cooling.chClntLab[cooling.ncltot], chLabel);

	/* now the wavelength */
	cooling.collam[cooling.ncltot] = lambda;

	/* normal line cooling */
	cooling.cooling[cooling.ncltot] = MAX2(0.,cool);

	/* possible line heating - not supposed to be done this way!
	 * this is intrinsic positive number, to be added to heating */
	cooling.heatnt[cooling.ncltot] = MAX2(0.,-cool);

	/* now increment counter, this is the number of coolants entered */
	cooling.ncltot += 1;

#	ifdef DEBUG_FUN
	fputs( " <->coladd()\n", debug_fp );
#	endif
	return;
}

/*colzro set cooling and heating stack to zero */
void colzro(void)
{
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>colzro()\n", debug_fp );
#	endif


	cooling.ncltot = 0;
	cooling.dCooldT = 0.;

	for( i=0; i < NCOLNT; i++ )
	{
		cooling.cooling[i] = 0.;
		cooling.heatnt[i] = 0.;
	}


#	ifdef DEBUG_FUN
	fputs( " <->colzro()\n", debug_fp );
#	endif
	return;
}

/*CoolSum  total cooling from all entries into cooling stack */
void CoolSum(double *total)
{
	long int i;
	

#	ifdef DEBUG_FUN
	fputs( "<+>CoolSum()\n", debug_fp );
#	endif

	/* routine to add together all line heating and cooling */

	*total = 0.;
	cooling.coolheat = 0.;
	/* this is sum of agents that should be coolants
	 * coolheat will be coolants that came out as heat */
	for( i=0; i < cooling.ncltot; i++ )
	{
		*total += cooling.cooling[i];
		cooling.coolheat += cooling.heatnt[i];
	}
	heat.heating[0][12] = cooling.coolheat;

	/* make comment if negative cooling ever significant */
	if( heat.htot > 0. )
	{
		if( cooling.coolheat/heat.htot > 0.01 )
		{
			/* CoolHeatMax was set to zero at start of calc, we want very biggest */
			for( i=0; i < cooling.ncltot; i++ )
			{
				if( cooling.heatnt[i]/heat.htot > cooling.CoolHeatMax )
				{
					cooling.CoolHeatMax = (float)(cooling.heatnt[i]/heat.htot);
					cooling.wlCoolHeatMax = cooling.collam[i];
					strcpy( cooling.chCoolHeatMax, cooling.chClntLab[i] );
				}
			}
		}
	}

	/* this sum of lines that were heat sources - this
	 * part was not counted as heating in call to cooling add routine
	 * since level 2 and level 3 separate this out - this does
	 * NOT double count line heating */

	cooling.heatl = 0.;
	for( i=0; i < nWindLine; i++ )
	{
		cooling.heatl += TauLine2[i].heat;
	}

	for( i=1; i <= nLevel1; i++ )
	{
		cooling.heatl += TauLines[i].heat;
	}

	for( i=0; i < nCORotate; i++ )
	{
		cooling.heatl += C12O16Rotate[i].heat;
		cooling.heatl += C13O16Rotate[i].heat;
	}

	/* line heating added in following, only here */
	heat.heating[0][22] = cooling.heatl;

	/*begin sanity check */
	if( *total <= 0. )
	{
		fprintf( ioQQQ, " CoolSum finds cooling <= 0%10.2e\n", 
		  *total );
	}
	if( cooling.heatl/cooling.ctot < -1e-15 )
	{
		fprintf( ioQQQ, " CoolSum finds negative heating %10.2e %10.2e\n", 
		  cooling.heatl, cooling.ctot );
		/* write(qq,'('' dump went to fort.66'')') 
		 * write(66,'(1p,12e10.1)') (heatnt(i),i=1,ncltot) */
	}
	/*end sanity check
	 * */

#	ifdef DEBUG_FUN
	fputs( " <->CoolSum()\n", debug_fp );
#	endif
	return;
}

