/*ConvTempEdenIoniz determine  temperature, called by ConPresTempEdenIoniz,
 * calls ConvEdenIoniz to get electron density and ionization */
/*MakeDeriv derive numerical derivative of heating minus cooling */
/*PutHetCol save heating, cooling, and temperature in stack for numerical derivatives */
#include "cddefines.h"
/* >>chng 01 apr 06, from 10 to 20, also put damper at 0.5 below,
 * as part of strategy of letting code bracket solution */
#define	LIMDEF	20
#include "hmi.h"
#include "tehigh.h"
#include "tfidle.h"
#include "thermal.h"
#include "cooling.h"
#include "called.h"
#include "hydrogenic.h"
#include "heatcool.h"
#include "pressure.h"
#include "trace.h"
#include "phycon.h"
#include "ionfracs.h"
#include "heat.h"
#include "bit32.h"
#include "holod.h"
#include "converge.h"

/* evaluate ionization, and difference in heating and cooling, for temperature temp */
static double CoolHeatError( double temp );

/* use brent's method to find heating-cooling match */
static double TeBrent(
	  double x1, 
	  double x2);

/*MakeDeriv derive numerical derivative of heating minus cooling */
static void MakeDeriv(
  /* which job to do, either "zero" or "incr" */
  char *job, 
  /* result, the numerical derivative */
  double *DerivNumer);

/*PutHetCol save heating, cooling, and temperature in stack for numerical derivatives */
static void PutHetCol(double te, 
  double htot, 
  double ctot);

void ConvTempEdenIoniz( void )
{
	char chDEType;
	long int limtry,
		nThLoop ;
	/* followin is zero because there are paths were not set following abort */
	double CoolMHeat=0., 
	  Damper, 
	  dtl, 
	  dummy,
	  absdt ,
	  fneut;
	int lgdCNeg;
	double DerivNumer;
	static double OldCmHdT = 0.;

#	ifdef DEBUG_FUN
	fputs( "<+>ConvTempEdenIoniz()\n", debug_fp );
#	endif

	/* determine ionization and temperature, called by PIonte
	 * nCall tells routine which call this is, 0 for first one, not changed here
	 * nThLoop counts how many loops performed */

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "\n ConvTempEdenIoniz called\n" );
	}

	if ( strcmp( conv.chSolverTemp , "new" ) == 0 )
	{
		double t1 , t2 ,
			error1 , error2;
		double TeNew;
		double factor = 1.02;

		t1 = phycon.te;
		error1 = CoolHeatError( t1 );
		t2 = t1 * factor;
		error2 = CoolHeatError( t2 );
		TeNew = TeBrent( t1 , t2 );
	}
	else if( strcmp( conv.chSolverTemp , "simple") == 0 )
	{

		/* main routine to find ionization and temperature
		 * following is flag to check for temp oscillations
		 * it could be set true in main temp loop */
		conv.lgTOscl = FALSE;
		/* ots rates not oscillating */
		conv.lgOscilOTS = FALSE;

		/* scale factor for changes in temp - make smaller if oscillations */
		Damper = 1.;

		/* flag for d(cool - heat)/dT changing sign, an internal error
		 * >>chng 97 sep 03, only turn false one time, remains true if ever true */
		if( nzone < 1 )
		{
			conv.lgCmHOsc = FALSE;
		}

		/* option to make numerical derivatives of heating cooling */
		MakeDeriv("zero",&DerivNumer);

		/* this is will initial limit to number of tries at temp */
		limtry = LIMDEF;

		/* used to keep track of sign of dt, to check for oscillations */
		dtl = 0.;

		/* this counts how may thermal loops we go through
		 * used in calling routine to make sure that at least
		 * two solutions are performed */
		nThLoop = 0;

		/* this is the start of the heating-cooling match loop */
		while( nThLoop < limtry &&  !conv.lgAbort )
		{

			/* converge the ionization and electron density; 
			 * this calls ionize until lgIonDone is true */
			ConvEdenIoniz();

			/* get numerical heating-cooling derivative, but we may not use it */
			MakeDeriv("incr",&DerivNumer);

			/* remember this temp, heating, and cooling */
			PutHetCol(phycon.te,heat.htot,cooling.ctot);

			/* >>chng 01 mar 14, add check whether above converged electron density */
			if( !conv.lgConvEden )
			{
				CoolMHeat = 0.;
				if( trace.lgTrConvg>=2 )
				{
					fprintf( ioQQQ, 
						"  ConvTempEdenIoniz2 breaks since lgConvEden returns failed electron density.\n"); 
				}
				break;
			}

			if( called.lgTalk )
			{
				if( heat.htot < 0. )
				{
					fprintf( ioQQQ, " Total heating is <0; is this model collisionally ionized?\n" );
				}
				else if( heat.htot == 0. )
				{
					fprintf( ioQQQ, " Total heating is 0; is the density small?\n" );
				}
			}

			fneut = (xIonFracs[ipHYDROGEN][0] + 2.*hmi.htwo)/phycon.hden;

			if( cooling.dCooldT < 0. )
			{
				lgdCNeg = TRUE;
			}
			else
			{
				lgdCNeg = FALSE;
			}

			if( thermal.lgTSetOn )
			{
				/* constant temp - declare this a success */
				CoolMHeat = 0.;
			}
			else
			{
				/* we will try to make the following zero */
				CoolMHeat = cooling.ctot - heat.htot;
			}

			/* save old deriv to check for oscillations */
			if( nzone < 1 )
			{
				/* >>chng 96 jun 07, was set to dCoolmHeatdT, is not defined initially */
				OldCmHdT = cooling.ctot/phycon.te;
			}

			if( phycon.te < 1e4 && cooling.dCooldT < 0. )
			{
				/* use numerical guess, HTOT nearly equal to CTOT, drive Te lower
				 * this is to overcome thermal inflection points */
				cooling.dCoolmHeatdT = (double)(heat.htot)/phycon.te*2.;
				chDEType = 'd';
			}
			else
			{
				/* >>chng 97 mar 18, all below growth code just did the following */
				cooling.dCoolmHeatdT = cooling.dCooldT - heat.dHTotDT;
				chDEType = 'a';
			}

			/* >>chng 96 aug 15, alphas with fast compile underflow at low densities */
			if( cooling.dCoolmHeatdT == 0. )
			{
				chDEType = 'z';
				cooling.dCoolmHeatdT = cooling.ctot/phycon.te;
				if( cooling.dCoolmHeatdT == 0. && cooling.ctot == 0. )
				{
					fprintf( ioQQQ, " ConvTempEdenIoniz the cooling and its derivitive are zero.\n" );
					fprintf( ioQQQ, " ConvTempEdenIoniz I cannot perform the energy balance.\n" );
					if( phycon.hden <= 1e-3 && bit32.lgBit32 )
					{
						fprintf( ioQQQ, " Due to very low density on a 32-big cpu?\n" );
					}
					ShowMe();
					puts( "[Stop in ConvTempEdenIoniz]" );
					cdEXIT(EXIT_FAILURE);
				}
				else if( cooling.dCoolmHeatdT == 0. && cooling.ctot != 0. )
				{
					fprintf( ioQQQ, " ConvTempEdenIoniz the cooling derivitive is zero.\n" );
					fprintf( ioQQQ, " ConvTempEdenIoniz I cannot perform the energy balance.\n" );
					if( phycon.hden <= 1e-3 && bit32.lgBit32 )
					{
						fprintf( ioQQQ, " Due to very low density on a 32-big cpu?\n" );
					}
					ShowMe();
					puts( "[Stop ConvTempEdenIoniz]" );
					cdEXIT(EXIT_FAILURE);
				}
			}

			/* check whether deriv changing sign - an internal error or
			 * numerical instability */
			if( OldCmHdT*cooling.dCoolmHeatdT < 0. )
			{
				conv.lgCmHOsc = TRUE;
			}
			OldCmHdT = cooling.dCoolmHeatdT;

			/* derivative can change sign when heating and cooling balance,
			 * and processes have exactly same temp dependence
			 * happened in mods of ism.in test
			 * >>chng 97 sep 02, added following test for oscillating derivs */
			if( conv.lgCmHOsc )
			{
				cooling.dCoolmHeatdT = cooling.ctot/phycon.te;
				chDEType = 'o';
			}

			/* if not first pass throught then numerical deriv should not be zero */
			/* ASSERT( nThLoop==0 || DerivNumer!= 0. || thermal.lgTSetOn );*/
			/*fprintf(ioQQQ,"testtesttest\t%li\t%.2e\t%.2e\t%f\n",nzone,cooling.dCoolmHeatdT,DerivNumer,
				Damper);*/
			/*if( nThLoop > 0 ) 
				cooling.dCoolmHeatdT = DerivNumer;*/
			/* required change in temperature, this may be too large */
			thermal.dTemper = (float)(CoolMHeat/cooling.dCoolmHeatdT);

			/* try to stop numerical oscillation if dTemper is changing sign */
			if( dtl*thermal.dTemper < 0. )
			{
				conv.lgTOscl = TRUE;
				/* make DT smaller and smaller */
				/* >>chng 01 mar 16, from 0.5 to 0.75 
				Damper *= 0.75;*/
				Damper *= 0.5;
			}

			/* SIGN: sign of sec arg and abs val of first
			 * >>chng 96 nov 08, from 0.1 to 0.08 in fneut */
			if( fneut > 0.08 && hydro.lgHColionImp )
			{
				/* lgHColionImp is true if model collisionally ionized
				 * dont let TE change by too much if lgHColionImp is set by HLEVEL */
				absdt = fabs(thermal.dTemper),
				thermal.dTemper = (float)(sign(MIN2(absdt,0.005*phycon.te),
				  thermal.dTemper));
			}
			else if( nThLoop > 5 && !conv.lgTOscl )
			{
				/* need several changes but te not oscillating, increase dT */
				absdt = fabs(thermal.dTemper),
				thermal.dTemper = (float)(sign(MIN2(absdt,0.06*phycon.te),
				  thermal.dTemper));
			}
			else if( nThLoop > 3 && !conv.lgTOscl )
			{
				/* need several changes but te not oscillating, increase dT */
				absdt = fabs(thermal.dTemper),
				thermal.dTemper = (float)(sign(MIN2(absdt,0.04*phycon.te),
				  thermal.dTemper));
			}
			else
			{
				/* do not let temp change by more than 2 percent */
				absdt = fabs(thermal.dTemper),
				thermal.dTemper = (float)(sign(MIN2(absdt,0.02*phycon.te),
				  thermal.dTemper));
			}

			/* check if model in collisional recombination equilibirum
			 * if so then small change in temp causees big change in equilibrium
			 * lgHColRec set in hlevel, only true is totl rec >> rad rec */
			if( hydro.lgHColRec )
			{
				if( hydro.lgHCoolng )
				{
					if( conv.lgTOscl )
					{
						absdt = fabs(thermal.dTemper),
						thermal.dTemper = (float)(sign(MIN2(absdt,0.002*phycon.te),thermal.dTemper));
					}
					else
					{
						/*   not oscillating */
						absdt = fabs(thermal.dTemper),
						thermal.dTemper = (float)(sign(MIN2(absdt,
						  0.005*phycon.te),thermal.dTemper));
					}
				}
				else
				{
					absdt = fabs(thermal.dTemper),
					thermal.dTemper = (float)(sign(MIN2(absdt,0.01*
					  phycon.te),thermal.dTemper));
				}
			}

			thermal.dTemper *= (float)Damper;
			dtl = thermal.dTemper;

			/* THIS IS IT !!! this is it !!! this is the first of two places where te changes. */
			phycon.te = phycon.te - thermal.dTemper;

			/* update density - temperature variables which may have changed */
			tfidle(FALSE);

			/* >>chng 01 mar 16, evaluate pressure here since changing and other values needed */
			/* reevaluate pressure */
			dummy = PressureTotalDo();

			/* if te falls below 3K quit now */
			if( phycon.te <= 3. )
			{
				/* these will force all routines out to quit
				 * when lowest temp read in values below 3 were not allowed */
				phycon.te = 2.9998f;
				tfidle(FALSE);
				CoolMHeat = 0.;
				conv.lgConvIoniz = TRUE;
			}

			if( trace.lgTrConvg>=2 )
			{
				fprintf( ioQQQ, 
					"  ConvTempEdenIoniz2 %4li TE%.4e dt:%8.2e%7.1f%% C:%10.2e H:%10.2e CoolMHeat:%7.1f%%\n", 
				  nThLoop, 
				  phycon.te, 
				  thermal.dTemper, 
				  thermal.dTemper/(phycon.te+thermal.dTemper)*100,
				  cooling.ctot, 
				  heat.htot, 
				  CoolMHeat/heat.htot*100. );
				/* dCoolmHeatdT is the actual number used for getting dT
				 * cooling.dCooldT is just cooling */
			}

			if( trace.lgTrace )
			{
				fprintf( ioQQQ, 
					" ConvTempEdenIoniz TE:%11.5e dT%10.3e HTOT:%11.5e CTOT:%11.5e dCoolmHeatdT:%c%11.4e C-H%11.4e HDEN%10.2e\n", 
				  phycon.te, thermal.dTemper, heat.htot, cooling.ctot, chDEType, 
				  cooling.dCoolmHeatdT, CoolMHeat, 
				  phycon.hden );
			}

			/* this is test for valid thermal solution,
			 * lgIonDone = true if ionization routines got OK solution
			 * lgIonDone = false if problems
			 * TOLER can be set in READR, normally=0.02 */
			if( fabs(CoolMHeat/(heat.htot+holod.feheat)) < conv.HeatCoolRelError && 
			  conv.lgConvIoniz )
			{
				/* we have a good solution */
				/* back off a bit from the last change since it was probably too big */
				/* this is it - the second change, undoing a bit of the first */
				/* >>chng 99 nov 18, back off a bit, since temp in ism.in showed big jitter due to
				 * 1 sigma changes in T in nearly isothermal model was large */
				phycon.te = phycon.te + thermal.dTemper/2.f;
				tfidle(FALSE);

				if( trace.lgTrace )
				{
					fprintf( ioQQQ, " ConvTempEdenIoniz returns ok.\n" );
				}

				tehigh.thist = (float)MAX2(phycon.te,tehigh.thist);
				tehigh.tlowst = (float)MIN2(phycon.te,tehigh.tlowst);

				/* test for thermal stability
				 * >>chng 97 jul 31, set flag if unstable, increment only once per zone */
				if( lgdCNeg )
				{
					thermal.lgUnstable = TRUE;
				}
				else
				{
					thermal.lgUnstable = FALSE;
				}

				/* say that we have a valid solution */
				conv.lgConvTemp = TRUE;

				if( trace.lgTrConvg>=2 )
				{
					fprintf( ioQQQ, "  ConvTempEdenIoniz2 converged. Te:%11.4e Htot:%11.4e Ctot:%11.4e error:%9.1e%%, eden=%11.4e\n", 
					  phycon.te, heat.htot, cooling.ctot, (heat.htot - cooling.ctot)*
					  100./MAX2(1e-36,heat.htot), phycon.eden );
				}
				
#				ifdef DEBUG_FUN
				fputs( " <->ConvTempEdenIoniz()\n", debug_fp );
#				endif
				/*******************************************************
				 * 
				 * this is return for valid solution 
				 *
				 *******************************************************/
				return;
			}

			/* no solution, we must keep trying,
			 * this is option to increase limit to number of iterations
			 * if the solution is not oscillating
			 * nThLoop is number of times through heating-cooling-ionization loop */
			if( nThLoop == LIMDEF-1 && !conv.lgTOscl )
			{
				/* limdef is set to 10 in a data statement above
				 * >>chng 97 aug 10, from 2 to 4 to let keep going when not oscillation
				 * this helped in getting over huge jumpts in temperature at metal fronts */
				limtry = LIMDEF*4;
				if( trace.lgTrConvg>2 )
				{
					fprintf( ioQQQ, "  ConvTempEdenIonizs increases limtry to%3ld\n", 
					  limtry );
				}
			}

			/* increment loop counter */
			++nThLoop;
		}

		/* fall through, exceeded limit to number of solutions,
		 * >>chng 01 mar 14, or no electron density convergence
		 * no temperature convergence */
		if( fabs(CoolMHeat/(heat.htot+holod.feheat)) > conv.HeatCoolRelError)
		{
			conv.lgConvTemp = FALSE;
		}
		else
		{
			/* possible that ionization has failed, and we fell through to here
			 * with a valid thermal soln */
			conv.lgConvTemp = TRUE;
		}
	}
	else
	{
		fprintf( ioQQQ, "ConvTempEdenIoniz finds insane solver%s \n" , conv.chSolverTemp );
		ShowMe();
		puts( "[Stop in ConvTempEdenIoniz]" );
		cdEXIT(EXIT_FAILURE);
	}

#	ifdef DEBUG_FUN
	fputs( " <->ConvTempEdenIoniz()\n", debug_fp );
#	endif
	return;
}

/*MakeDeriv derive numerical derivative of heating minus cooling */
static void MakeDeriv(char *job, 
  double *DerivNumer)
{
	static long int nstore;
	static double OldTe , OldCool , OldHeat;

#	ifdef DEBUG_FUN
	fputs( "<+>MakeDeriv()\n", debug_fp );
#	endif

	if( strcmp(job,"zero") == 0 )
	{
		nstore = 0;
		OldTe = 0.;
		OldCool = 0.;
		OldHeat = 0.;
	}

	else if( strcmp(job,"incr") == 0 )
	{

		if( nstore > 0 && !thermal.lgTSetOn && fabs(phycon.te - OldTe)>SMALLFLOAT )
		{
			/* get numerical derivatives */
			double dCdT = (cooling.ctot - OldCool)/(phycon.te - OldTe);
			double dHdT = (heat.htot - OldHeat)/(phycon.te - OldTe);
			*DerivNumer = dCdT - dHdT;
#			if 0
			fprintf(ioQQQ,"derivderiv\t%li\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\t%.2e\n",
			  nzone, dCdT , cooling.dCooldT , 
			  cooling.ctot , OldCool,phycon.te , OldTe
			  /*(cooling.ctot - OldCool),(phycon.te - OldTe),dHdT, heat.dHTotDT*/);
#			endif
		}

		else
		{
			/* if early in soln, or constant temperature, return zero */
			*DerivNumer = 0.;
		}

		OldTe = phycon.te;
		OldCool = cooling.ctot;
		OldHeat = heat.htot;
		++ nstore;

	}
	else
	{
		fprintf( ioQQQ, " MakeDeriv called with insane job=%4.4s\n", 
		  job );
		puts( "[Stop in makederiv]" );
		cdEXIT(EXIT_FAILURE);
	}

#	ifdef DEBUG_FUN
	fputs( " <->MakeDeriv()\n", debug_fp );
#	endif
	return;
}

/*PutHetCol save heating, cooling, and temperature in stack for numerical derivatives */
static void PutHetCol(double te, 
  double htot, 
  double ctot)
{

#	ifdef DEBUG_FUN
	fputs( "<+>PutHetCol()\n", debug_fp );
#	endif

	if( nzone == 0 )
	{
		/* code is searching for first temp now - do not remember these numbers */
		HeatCool.ipGrid = 0;
	}
	else
	{
		if( HeatCool.ipGrid >= NGRID )
			HeatCool.ipGrid = 0;

		ASSERT( HeatCool.ipGrid >= 0 );
		ASSERT( HeatCool.ipGrid < NGRID );
		ASSERT( nzone>=0 );

		HeatCool.TeGrid[HeatCool.ipGrid] = (float)te;
		HeatCool.HtGrid[HeatCool.ipGrid] = (float)htot;
		HeatCool.ClGrid[HeatCool.ipGrid] = (float)ctot;
		HeatCool.nZonGrid[HeatCool.ipGrid] = nzone;

		++HeatCool.ipGrid;
	}

#	ifdef DEBUG_FUN
	fputs( " <->PutHetCol()\n", debug_fp );
#	endif
	return;
}

static double CoolHeatError( double temp )
{
	double dummy;

	phycon.te = (float)temp;
	tfidle(FALSE);

	/* converge the ionization and electron density; 
	 * this calls ionize until lgIonDone is true */
	ConvEdenIoniz();

	/* >>chng 01 mar 16, evaluate pressure here since changing and other values needed */
	/* reevaluate pressure */
	dummy = PressureTotalDo();

	/* remember this temp, heating, and cooling */
	PutHetCol(phycon.te,heat.htot,cooling.ctot);

	return cooling.ctot - heat.htot;
}

/*#define	EPS	3.e-8*/
#define	ITERMAX	100
/* use brent's method to find heating-cooling match */
static double TeBrent(
	  double x1, 
	  double x2)
{
	long int iter;
	double c, 
	  d, 
	  e, 
	  fx1, 
	  fx2, 
	  fc, 
	  p, 
	  q, 
	  r, 
	  s, 
	  xm;

#	ifdef DEBUG_FUN
	fputs( "<+>TeBrent()\n", debug_fp );
#	endif

	/* first evaluate function at two boundaries, and check
	 * that we have bracketed the target */
	fx1 = CoolHeatError(x1);
	fx2 = CoolHeatError(x2);

	if( fx1*fx2 > 0. )
	{
		/* both values either positive or negative, this is insane */
		fprintf( ioQQQ, " TeBrent called without proper bracket - this is impossible\n" );
		fprintf( ioQQQ, " Sorry.\n" );
		puts( "[Stop in TeBrent]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* we have bracketed the target */
	c = x2;
	fc = fx2;
	iter = 0;
	/* these are sanity checks, to get code past lint */
	e = DBL_MAX;
	d = DBL_MAX;
	while(  iter < ITERMAX )
	{
		if( (fx2 > 0. && fc > 0.) || (fx2 < 0. && fc < 0.) )
		{
			c = x1;
			fc = fx1;
			d = x2 - x1;
			e = d;
		}
		if( fabs(fc) < fabs(fx2) )
		{
			x1 = x2;
			x2 = c;
			c = x1;
			fx1 = fx2;
			fx2 = fc;
			fc = fx1;
		}

		xm = .5*(c - x2);

		/* soln converged if residual less than tol, or hit zero */
		if( fabs(xm) <= heat.htot*conv.HeatCoolRelError || fx2 == 0. )
			break;

		if( fabs(e) >= heat.htot*conv.HeatCoolRelError && fabs(fx1) > fabs(fx2) )
		{
			double aa , bb ;
			s = fx2/fx1;
			/*lint -e777 test floats for equality */
			if( x1 == c )
			/*lint +e777 test floats for equality */
			{
				p = 2.*xm*s;
				q = 1. - s;
			}
			else
			{
				q = fx1/fc;
				r = fx2/fc;
				p = s*(2.*xm*q*(q - r) - (x2 - x1)*(r - 1.));
				q = (q - 1.)*(r - 1.)*(s - 1.);
			}
			if( p > 0. )
				q = -q;

			p = fabs(p);
			aa = fabs(heat.htot*conv.HeatCoolRelError*q);
			bb = fabs(e*q);
			if( 2.*p < MIN2(3.*xm*q-aa,bb) )
			{
				e = d;
				d = p/q;
			}
			else
			{
				d = xm;
				e = d;
			}
		}
		else
		{
			d = xm;
			e = d;
		}
		x1 = x2;
		fx1 = fx2;
		if( fabs(d) > heat.htot*conv.HeatCoolRelError )
		{
			x2 += d;
		}
		else
		{
			x2 += sign(heat.htot*conv.HeatCoolRelError,xm);
		}
		fx2 = CoolHeatError(x2);

		++iter;
	}

	/* check whether we fell through (hit limit to number of iterations)
	 * of broke out when complete */
	if( iter == ITERMAX )
	{
		/* both values either positive or negative, this is insane */
		fprintf( ioQQQ, " TeBrent did not converge in %i iterations\n",ITERMAX );
		fprintf( ioQQQ, " Sorry.\n" );
		puts( "[Stop in TeBrent]" );
		cdEXIT(EXIT_FAILURE);
	}
	
#	ifdef DEBUG_FUN
	fputs( " <->TeBrent()\n", debug_fp );
#	endif
	return( x2 );

}

