/* 
 * this is the series of routines that converge the pressure, temperature, 
 * electron density, and ionization, for a zone.  Ideally, only the top
 * routine, ConvPresTempEdenIoniz, should be public 
 */

/*ConvInitTemp drive search for initial temperature, for illuminated face,
 * called by cloudy, returns 1 if outside conditions appropriate for cloudy  */
int ConvInitTemp(void);

/*ConvPresTempEdenIoniz drive pressure, ionization, and thermal balance routines to converge
 * conditions in current zone.  called by cloudy, calls ConvTempTempIoniz and PressureChange */
void ConvPresTempEdenIoniz(void);

/*PressureChange evaluate the current pressure, and change needed to get it to PressureInit,
 * var is true if oscillations have occurred, as when we are near solution */
void PressureChange(int lgPresOscil );

/*ConvTempEdenIoniz converge ionization and temperature, called by ConvPresTempTempIoniz,
 * calls ConvTempIoniz */
void ConvTempEdenIoniz(void);

/*ConvEdenIoniz called by ConvTempEdenIoniz and ConvInitIonize, 
 * it calls ConvIoniz and converges the electron density */
void ConvEdenIoniz(void);

/*ConvIoniz called by ConvEdenIoniz, it calls ConvIonizeOpacityDo until ionization is converged */
void ConvIoniz(void);

/*ConvIonizeOpacityDo main routine to drive ionization solution for all species */
void ConvIonizeOpacityDo(
	/* this tells how many times ConvIonizeOpacityDo has been called by ConvIoniz while
	 * trying to converge electron density == 0 on first call - allows
	 * logic in ConvIonizeOpacityDo to check for ots oscillations */
	 long loopi);

/*
 * the variables that deal with the convergence of the model 
 */

EXTERN struct t_conv {
	/* has the electron density converged?? */
	int lgConvEden;

	/* this says why the electron density did not converge,  */
	char chConvEden[11];

	/* this flag is used in ConvIoniz to check that ionization has converged */
	int lgConvIoniz;

	/* this says why the ionization did not converge, reasons can be a large
	 * change in the level of ionization, or in the heating */
	char chConvIoniz[11];

	/* when the lgConvIoniz flag is set false, the old and new numbers,
	 * the reason for the lack of convergence, should be set to following */
	double BadConvIoniz[2];

	/* this will count the number of ionizations in one call from ConPvPresTempIoniz*/
	long int nPres2Ioniz;

	/* this will count the number of ionizations in all calls after zero*/
	long int nTotalIoniz;

	/* lgSearch is true is initial temp-ion search underway,
	 * false after first zone established */
	int lgSearch;

	/* remember the average electron density error */
	float AverEdenError;

	/* remember the biggest and average heating-cooling error */
	float BigHeatCoolError;
	float AverHeatCoolError;

	/* remember the biggest and average pressure error */
	float BigPressError;
	float AverPressError;

	/* flag set in ConvIonizeOpacityDo, saying whether ionization stage is trimmed down */
	int lgIonStageTrimed;

	/* this says whether cooling-heating deriv is changing sign */
	int lgCmHOsc;

	/* this says whether temp is changing sign */
	int lgTOscl;

	/* this says whether electron density is changing sign */
	int lgEdenOscl;

	/* this is true if ots rates are oscillating, and this is why ionization
	 * is not converged */
	int lgOscilOTS ;

	/* true if temperature is converged, false if not */
	int lgConvTemp;

	/* true if pressure is converged, false if not */
	int lgConvPres;

	/* true if level 2 lines were contributors to the ots rates, set in dimacool */
	int lgLevel2_OTS_Imp;

	/* true if level 2 lines were contributors to the cooling, set in dimacool */
	int lgLevel2_Cool_Imp;

	/*
	 *info related to the number of temperature or pressure failures
	 */

	/* total number of all falures, used to trigger abort */
	long int nTotalFailures;

	/*nTeFail number of temperature failures*/
	long int nTeFail;

	/*failmx is largest relative error in heating cooling match*/
	float failmx;

	/*nPreFail is number of pressure failuers*/
	long int nPreFail;

	/*nNeFail is number of electron density failuers*/
	long int nNeFail;

	/* remember the biggest electron density error as test of convergence quality */
	float BigEdenError;

	/*nIonFail is number of ionization failuers*/
	long int nIonFail;

	/* number of ConvIoniz ionization failures */
	long int nConvIonizFails;

	/* flag saying that an ionization failure did occur in this zone, used to
	 * help choose next dr (failure may have been converged away by time nextdr is called */
	int lgConvIonizThisZone;

	/* number of grain ionization balance failures */
	long int nGrainFail;

	/* allowed error in heating - cooling balance, set with TOLERANCE command
	 * default set in zerologic */
	float HeatCoolRelError;

	/* LimFail is limit to number of te failures, set with "failures" cmnd */
	long int LimFail;

	/* lgMap is option to map failures */
	int lgMap;

	/* zones where converge problems occurred */
	long int ifailz[12];

	/* which electron density solver to use? 
	 * set with set eden solver command, simple and new */
	char chSolverEden[20];

	/* which temperature density solver to use? 
	 * set with set eden solver command, default and brent */
	char chSolverTemp[20];

	/* this says that we have jumped the rail, and must abort */
	int lgAbort;

	/* this gives the reason the model was declared not converged
	* when 'iter to convergence' command is given */
	char chNotConverged[11];

	/* says "interate to convergence" command given */
	int lgAutoIt;
	/* a convergence criteria */
	float autocv;
} conv;
