/*conpmp local continuum pumping rate radiative transfer for all lines */
/*opfun  routine used to get continuum pumping of lines 
 * used in conpmp in call to qg32 */
/*vfun approximate form of Voit function */
#include "cddefines.h"
#include "physconst.h"
#include "rfield.h"
#include "radius.h"
#include "conpmp.h"

/* damping constant used for pumping */
static float PumpDamp;
/* variable used for inward optical depth for pumping */
static float PumpTau;

/*vfun approximate form of Voit function */
static double vfun(double x);

/*opfun  routine used to get continuum pumping of lines 
 * used in conpmp in call to qg32 */
static double opfun(double x);

double conpmp(EmLine * t)
{
	double a0, 
	  conpmp_v, 
	  tau, 
	  yinc1, 
	  yinc2;

#	ifdef DEBUG_FUN
	fputs( "<+>conpmp()\n", debug_fp );
#	endif

	/* fit to results for tau less than 10 */
#	define FITTED(t)	((0.98925439 + 0.084594094*(t))/(1. + (t)*(0.64794212 + (t)*0.44743976)))

	if( !rfield.lgInducProcess )
	{
		/* option to turn of continuum pumping with no fluorescense */
		conpmp_v = 0.;
	}
	else
	{
		/* tau used will be optical depth in center of next zone
		 * >>chng 96 jul 06, had been ipLnTauIn, did not work when sphere static set */
		tau = t->TauIn + t->dTau*radius.dRNeff;
		/* compute pumping probability */
		if( tau <= 10. )
		{
			/* for tau<10 a does not matter, and one fit for all */
			conpmp_v = FITTED(tau);
		}
		else if( tau > 1e6 )
		{
			/* this far in winds line opacity well below electron scattering
			 * so ignore for this problem */
			conpmp_v = 0.;
		}
		else
		{
			/* following two are passed on to later subs */
			if( t->iRedisFun > 0 )
			{
				PumpDamp = t->damp;
			}
			else
			{
				PumpDamp = 0.;
			}
			PumpTau = (float)tau;
			a0 = 0.886227*(1. + PumpDamp);
#			define	BREAK_	3.
			yinc1 = qg32(0.,BREAK_,opfun);
			yinc2 = qg32(BREAK_,100.,opfun);
			conpmp_v = (yinc1 + yinc2)/a0;
		}
	}

	/* EscProb is escape probability, will not allow conpmp to be greater than it
	 * on second iteration with thick lines, pump prob=1 and esc=0.5
	 * conpmp = MIN( conpmp , t->t(ipLnEscP) )
	 * */

#	ifdef DEBUG_FUN
	fputs( " <->conpmp()\n", debug_fp );
#	endif
	return( conpmp_v );
#	undef	FITTED
}

/*opfun  routine used to get continuum pumping of lines 
 * used in conpmp in call to qg32 */
static double opfun(double x)
{
	double opfun_v, 
	  v;

#	ifdef DEBUG_FUN
	fputs( "<+>opfun()\n", debug_fp );
#	endif

	v = vfun(x);
	opfun_v = sexp(PumpTau*v)*v;


#	ifdef DEBUG_FUN
	fputs( " <->opfun()\n", debug_fp );
#	endif
	return( opfun_v );
}

/*vfun approximate form of Voit function */
static double vfun(double x)
{
	double vfun_v;

#	ifdef DEBUG_FUN
	fputs( "<+>vfun()\n", debug_fp );
#	endif

	vfun_v = sexp(x*x) + PumpDamp/SQRTPI/(1. + x*x);

#	ifdef DEBUG_FUN
	fputs( " <->vfun()\n", debug_fp );
#	endif
	return( vfun_v );
}
