/*codriv - public routine, calls comole to converge molecules */
/*comole fills in matrix for heavy elements molecular routines */
/*RotateCooling evaluate CO rotation cooling */
/*molav average old and new molecular equilibrium balance from comole */
#include "cddefines.h"
#define NMOLE 15
#include "physconst.h"
#include "taulines.h"
#include "secondaries.h"
#include "abundances.h"
#include "cooling.h"
#include "hmi.h"
#include "converge.h"
#include "trace.h"
#include "nomole.h"
#include "heat.h"
#include "leveln.h"
#include "phycon.h"
#include "hevmolec.h"
#include "doppvel.h"
#include "ionrec.h"
#include "rtescprob.h"
#include "rt.h"
#include "moldrv.h"
#include "called.h"
#include "ghabng.h"
#include "coolheavy.h"
#include "timesc.h"
#include "poplevls.h"
#include "ionfracs.h"
#include "destcrt.h"
#include "typmatrx.h"
#include "linpack.h"
#include "veclib.h"
#include "hmrate.h"
#include "co.h"

/* this will be set true when CO fully forms */
static int lgAllCO = FALSE;

/*molav average old and new molecular equilibrium balance from comole */
static void molav(long int JobMolAv);

static void comole(int *lgNegPop, 
  int *lgZerPop)
{

	char  chLab[NMOLE][5];
	long int i, 
	  icatm, 
	  ich, 
	  ich2p, 
	  ichp, 
	  ico, 
	  icop, 
	  icp, 
	  ih2o, 
	  ih2op, 
	  ih3op, 
	  io2, 
	  io2p, 
	  ioatm, 
	  ioh, 
	  iohp, 
	  ipiv[NMOLE], 
	  j, 
	  job, 
	  loop, 
	  merror,
	  ns;
	double cartot, 
	  cch, 
	  cf, 
	  ch2pc, 
	  ch2pch, 
	  ch2pco, 
	  ch2ph3, 
	  chch2, 
	  chchp, 
	  chhc, 
	  chhchp, 
	  choco, 
	  chohwa, 
	  chooh, 
	  chpe, 
	  chph, 
	  chphch, 
	  chplte, 
	  co2co, 
	  coch, 
	  cocn, 
	  cocop, 
	  cocp, 
	  coo2, 
	  cooh, 
	  copco, 
	  coplte, 
	  coprm, 
	  cpch2p, 
	  cpchp, 
	  crden, 
	  csav[NMOLE][NMOLE], 
	  e3opoh, 
	  e3opwa, 
	  eo2o, 
	  esc_co,
	  expc2, 
	  expchp, 
	  expco, 
	  expcop, 
	  expo2, 
	  h2lim, 
	  h2pchp, 
	  h3oh3p, 
	  h3opwa, 
	  h3owai, 
	  h3pchp, 
	  h3pcop, 
	  h3pohp, 
	  h3pwai, 
	  h3pwap, 
	  ho2p, 
	  o2co, 
	  o2cop, 
	  o2o2p, 
	  o2oh, 
	  o2rm, 
	  oh2wat, 
	  ohco, 
	  ohcop, 
	  oho, 
	  oho2, 
	  ohohp, 
	  ohohwa, 
	  ohph3p, 
	  ohpoh, 
	  ohprm, 
	  ohpwap, 
	  oohp, 
	  opohp, 
	  oxytot, 
	  pc2lte, 
	  pcolte, 
	  phodco, 
	  po2lte, 
	  ratio, 
	  saha,
	  wa2oh, 
	  wachoh, 
	  wacop, 
	  wah3op, 
	  waiwai, 
	  waoh, 
	  waohp, 
	  waph3p, 
	  wapoh, 
	  wapohp, 
	  waprm, 
	  wapwa, 
	  wawap;
	double amat[NMOLE][NMOLE], 
	  bvec[NMOLE], 
	  c[NMOLE + 1][NMOLE + 1], 
	  rcond, 
	  work[NMOLE];
	float oldcarb,
		abund ;
	float catmic , oatmic;

#	ifdef DEBUG_FUN
	fputs( "<+>comole()\n", debug_fp );
#	endif

	/* take averages of molecular abundances, this routine follows below */
	molav(1);

	saha = sqrt(SAHA2);
	loop = 0;
	while( moldrv.lgDriveMole || loop < 1 )
	{
		++loop;
		/* this block intentionally killed */
		/*if( moldrv.lgDriveMole )
		{
			// option to allow user to enter oh abundances 
			fprintf( ioQQQ, " enter log of OH abundance\n" );
			readf( 5, "(a80)", "%S ", chCard,81 );
			i = 1;
			// option to set OH here 
			fac = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
			if( fac == 1. )
			{
				
#				ifdef DEBUG_FUN
				fputs( " <->comole()\n", debug_fp );
#				endif
				return;
			}
			else if( fac == 0. )
			{
				molav(2);
			}
			else
			{
				hevmolec.hevmol[ipOH] = (float)pow(10.,fac);
			}
			fprintf( ioQQQ, " enter log of H2O abundance\n" );
			readf( 5, "(a80)", "%S ", chCard,81 );
			i = 1;
			// option to set H2O here 
			fac = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
			if( fac != 0. )
				hevmolec.hevmol[ipH2O] = (float)pow(10.,fac);
		}*/

		hevmolec.hevmol[ipCTWO] = 0.;
		hevmolec.hevmol[ipC2P] = 0.;
		hevmolec.hevmol[ipOTWO] = 0.;
		hevmolec.hevmol[ipO2P] = 0.;
		hevmolec.hevmol[ipH3P] = 0.;

		/* H2LIM is smallest ratio of H2/HDEN for which we will
		 * even try to invert heavy element network */
		if( nomole.lgNoH2Mole )
		{
			/* H2 network is turned off, ignore this limit */
			h2lim = 0.;
		}
		else
		{
			h2lim = 1e-4;
		}

		catmic = xIonFracs[ipCARBON][0];
		oatmic = xIonFracs[ipOXYGEN][0];
		/* do we want to try to calculate the CO? */
		if( nomole.lgNoCOMole || 
			(phycon.te > 3800.) || 
			(hmi.htwo/phycon.hden < h2lim) || 
			/* these are the atomic carbon and oxygen abundances */
			(xIonFracs[ipCARBON][0]*xIonFracs[ipOXYGEN][0] ==  0.) )
		{
			hevmolec.hevmol[ipCH] = 0.;
			hevmolec.hevmol[ipCHP] = 0.;
			hevmolec.hevmol[ipOH] = 0.;
			hevmolec.hevmol[ipOHP] = 0.;
			hevmolec.hevmol[ipOTWO] = 0.;
			hevmolec.hevmol[ipCO] = 0.;
			hevmolec.hevmol[ipCOP] = 0.;
			hevmolec.hevmol[ipH2O] = 0.;
			hevmolec.hevmol[ipH2OP] = 0.;
			hevmolec.hevmol[ipO2P] = 0.;
			hevmolec.hevmol[ipC2P] = 0.;
			hevmolec.hevmol[ipH3OP] = 0.;
			hevmolec.hevmol[ipCH2P] = 0.;
			hevmolec.hevmol[ipCH2] = 0.;
			hevmolec.hevmol[ipCH3] = 0.;
			hevmolec.hevmol[ipCP] = 0.;
			/* heating due to CO photodissociation */
			heat.heating[0][9] = 0.;
			/* CO cooling */
			CoolHeavy.C12O16Rot = 0.;
			CoolHeavy.dC12O16Rot = 0.;
			CoolHeavy.C13O16Rot = 0.;
			CoolHeavy.dC13O16Rot = 0.;
			co.CODissHeat = 0.;

			for( i=0; i < nCORotate; i++ )
			{
				C12O16Rotate[i].PopLo = 0.;
				C13O16Rotate[i].PopLo = 0.;
				/* population of upper level */
				C12O16Rotate[i].PopHi = 0.;
				C13O16Rotate[i].PopHi = 0.;
				/* population of lower level with correction for stim emission */
				C12O16Rotate[i].PopOpc = 0.;
				C13O16Rotate[i].PopOpc = 0.;
				/* following two heat exchange excitation, deexcitation */
				C12O16Rotate[i].cool = 0.;
				C12O16Rotate[i].heat = 0.;
				C13O16Rotate[i].cool = 0.;
				C13O16Rotate[i].heat = 0.;
				/* intensity of line */
				C12O16Rotate[i].xIntensity = 0.;
				C13O16Rotate[i].xIntensity = 0.;
				/* number of photons emitted in line */
				C12O16Rotate[i].phots = 0.;
				C13O16Rotate[i].phots = 0.;
			}			
#			ifdef DEBUG_FUN
			fputs( " <->comole()\n", debug_fp );
#			endif
			return;
		}

		/* dissociation energies;
		 * CO 11.09, CO+ 8.3eV, CH+ 3.8eV
		 * LTE population of CO+ */

		/* following, pc2lte, chplte, po2lte, coplte, pcolte, are not ever
		 * used for anything - first document what they are relative to, and
		 * then use them to define departure coefficients */
		/* turn this error off for now */
		/*lint -e550 */
		expcop = sexp(9.632e4/phycon.te);
		if( expcop > 0. )
		{
			coplte = saha/(phycon.te32*expcop)*(1./(6.*9.));
		}
		else
		{
			coplte = 0.;
		}

		expco = sexp(1.287e5/phycon.te);
		if( expco > 0. )
		{
			pcolte = saha/(phycon.te32*expco)*(1./(9.*9.));
		}
		else
		{
			pcolte = 0.;
		}

		expchp = sexp(4.4098e4/phycon.te);
		if( expchp > 0. )
		{
			chplte = saha/(phycon.te32*expchp)*(1./(1.*6.));
		}
		else
		{
			chplte = 0.;
		}

		expc2 = sexp(4.4098e4/phycon.te);
		if( expc2 > 0. )
		{
			pc2lte = saha/(phycon.te32*expc2)*(1./(9.*9.));
		}
		else
		{
			pc2lte = 0.;
		}

		expo2 = sexp(4.4098e4/phycon.te);
		if( expo2 > 0. )
		{
			po2lte = saha/(phycon.te32*expo2)*(3./(9.*9.));
		}
		else
		{
			po2lte = 0.;
		}


		/* molecule formation */
		for( i=0; i < NMOLE; i++ )
		{
			c[NMOLE][i] = 0.;
			for( j=0; j < NMOLE; j++ )
			{
				c[j][i] = 0.;
			}
		}

		/* set up array indices  */
		icatm = 0;
		strcpy( chLab[icatm], "C   " );

		ioatm = 1;
		strcpy( chLab[ioatm], "O   " );

		ich = 2;
		strcpy( chLab[ich], "CH  " );

		ichp = 3;
		strcpy( chLab[ichp], "CH+ " );

		ioh = 4;
		strcpy( chLab[ioh], "OH  " );

		iohp = 5;
		strcpy( chLab[iohp], "OH+ " );

		ich2p = 6;
		strcpy( chLab[ich2p], "CH2+" );

		icp = 7;
		strcpy( chLab[icp], "C+  " );

		ico = 8;
		strcpy( chLab[ico], "CO  " );

		icop = 9;
		strcpy( chLab[icop], "CO+ " );

		ih2o = 10;
		strcpy( chLab[ih2o], "H2O " );

		ih2op = 11;
		strcpy( chLab[ih2op], "H2O+" );

		ih3op = 12;
		strcpy( chLab[ih3op], "H3O+" );

		io2 = 13;
		strcpy( chLab[io2], "O2  " );

		io2p = 14;
		strcpy( chLab[io2p], "O2+ " );

		/* carbon conservation */
		cartot = 0.;
		for( i=3; i <= 7; i++ )
		{
			cartot += xIonFracs[ipCARBON][i-1];
		}
		cartot = abundances.gas_phase[ipCARBON] - cartot;
		c[NMOLE][icatm] = cartot;

		/* oxygen conservation */
		if( oatmic == 0. )
			oatmic = xIonFracs[ipOXYGEN][0];

		oxytot = 0.;
		for( i=2; i <= 9; i++ )
		{
			oxytot += xIonFracs[ipOXYGEN][i-1];
		}
		oxytot = abundances.gas_phase[ipOXYGEN] - oxytot;
		c[NMOLE][ioatm] = oxytot;

		/*--------------------------------------------------------------------
		 *
		 * first equation is carbon conservation */
		c[icatm][icatm] = 1.;
		c[ioatm][icatm] = 0.;
		c[ich][icatm] = 1.;
		c[ichp][icatm] = 1.;
		c[ioh][icatm] = 0.;
		c[iohp][icatm] = 0.;
		c[io2][icatm] = 0.;
		c[io2p][icatm] = 0.;
		c[ico][icatm] = 1.;
		c[icop][icatm] = 1.;
		c[ih2o][icatm] = 0.;
		c[ih2op][icatm] = 0.;
		c[ih3op][icatm] = 0.;
		c[ich2p][icatm] = 1.;
		c[icp][icatm] = 1.;

		/*--------------------------------------------------------------------
		 *
		 * second equation is oxygen conservation */
		c[icatm][ioatm] = 0.;
		c[ioatm][ioatm] = 1.;
		c[ich][ioatm] = 0.;
		c[ichp][ioatm] = 0.;
		c[ioh][ioatm] = 1.;
		c[iohp][ioatm] = 1.;
		c[io2][ioatm] = 2.;
		c[io2p][ioatm] = 2.;
		c[ico][ioatm] = 1.;
		c[icop][ioatm] = 1.;
		c[ih2o][ioatm] = 1.;
		c[ih2op][ioatm] = 1.;
		c[ih3op][ioatm] = 1.;
		c[ich2p][ioatm] = 0.;
		c[icp][ioatm] = 0.;

		/*--------------------------------------------------------------------
		 *
		 * balance equations;
		 * (1,n) is C, called ICATM
		 * (2,n) is O, called IOATM
		 * (3,n) is CH, called ICH
		 * (4,n) is CHP, called ICHP
		 * (5,n) is OH, called IOH
		 * (6,n) is OHP, called IOHP
		 * (7,n) is CH2P, called ICH2P
		 * (8,n) is CP, called ICP
		 * (9,n) is CO, called ICO
		 * (10,n) is COP, called ICOP
		 * (11,n) is H2O, called IH2O
		 * (12,n) is H2OP, called IH2OP
		 * (13,n) is H3OP, called IH3OP
		 * (14,n) is OTWO, IO2
		 * (15,n) is O2P, called IO2P
		 *
		 *--------------------------------------------------------------------
		 *
		 * CH balance equations
		 *
		 * sum of CH + HII => ch+ and both H+ and Ho
		 * also electrons to 2e */
		chchp = hmrate(8.83e-14,0.5,1.29e5)*(xIonFracs[ipHYDROGEN][1] + xIonFracs[ipHYDROGEN][0] + hmi.htwo) + 
		  1.90e-9*xIonFracs[ipHYDROGEN][1] + hmrate(5.2e-10,0.5,1.50e5)*phycon.eden;
		c[ich][ich] -= chchp;

		/* o + ch => co + h */
		choco = hmrate(9.53e-11,0.5,0.)*oatmic;
		c[ich][ich] -= choco;

		/* O + CH => C + OH */
		chooh = hmrate(1.73e-11,0.50,4000.)*oatmic;
		c[ich][ich] -= chooh;

		/* CH + H => C + H2 */
		chhc = hmrate(1.80e-11,0.50,4000.)*xIonFracs[ipHYDROGEN][0];

		/* there is no carbon balance equation */
		c[ich][ich] -= chhc;

		/* CH + H => CH+ + H + e */
		chhchp = hmrate(8.83e-14,0.5,1.29e5)*xIonFracs[ipHYDROGEN][0];
		c[ich][ich] -= chhchp;

		/* C + H2 => CH + H */
		cch = hmrate(4.50e-11,0.5,1.56e4)*hmi.htwo;
		c[icatm][ich] += cch;

		/* CO + H => CH + O */
		coch = hmrate(9.53e-11,0.5,8.83e4)*xIonFracs[ipHYDROGEN][0];
		c[ico][ich] += coch;

		/* H2O + C => CH + OH */
		wachoh = hmrate(1.43e-10,0.50,2.40e4)*catmic;
		c[ih2o][ich] += wachoh;

		/* e- + CH2+ => CH + H */
		ch2pch = hmrate(2.50e-7,-0.5,0.)*phycon.eden;
		c[ich2p][ich] += ch2pch;

		/* H2 + CH2+ => CH + H3+ */
		ch2ph3 = hmrate(1.20e-9,0.,4.22e4)*hmi.htwo;
		c[ich2p][ich] += ch2ph3;

		/* CH + H2 => CH2 + H */
		chch2 = hmrate(3.60e-10,0.,3.90e3)*hmi.htwo;
		c[ich][ich] -= chch2;

		/* OH + CH => H2O + C */
		chohwa = 1e-10*hevmolec.hevmol[ipOH];
		c[ich][ich] -= chohwa;

		/*--------------------------------------------------------------------
		 *
		 * CH+ balance equation
		 *
		 * CH+ + e => C + H */
		chpe = hmrate(3.00e-7,-0.40,0.)*phycon.eden;
		c[ichp][ichp] -= chpe;

		/* CH+ + H => H2 + C+ */
		/* >>chng 00 nov 27, update to */
		/*>>refer	chem	rate	Hollenbach, D.J., Takahashi, T., & Tielens, A.G.G.M., 1991, ApJ, 377, 192-209*/
		/*chph = hmrate(6.00e-10,-0.25,0.)*xIonFracs[ipHYDROGEN][0];*/
		chph = (2.0e-10+ 1.0e-9*300./(300.+phycon.te) )*xIonFracs[ipHYDROGEN][0];
		c[ichp][ichp] -= chph;

		/* make CH+ from CH via collisions with protons and electrons, H */
		c[ich][ichp] += chchp + chhchp;

		/* H2 + C+ => H + CH+ */
		cpchp = hmrate(2.00e-10,0.,4640.)*hmi.htwo;
		c[icp][ichp] += cpchp;

		/* C + H3+ => H2 + CH+ */
		h3pchp = 2.00e-9*hmi.h3plus;
		c[icatm][ichp] += h3pchp;

		/* H + CH2+ => H2 + CH+ */
		h2pchp = hmrate(1.00e-9,0.,1.20e4)*xIonFracs[ipHYDROGEN][0];
		c[ich2p][ichp] += h2pchp;

		/* H2 + CH+ => H + CH2+ */
		chphch = 1.00e-9*hmi.htwo;
		c[ichp][ichp] -= chphch;

		/*--------------------------------------------------------------------
		 *
		 * OH balance equations
		 *
		 * various processes which change OH to OH+ */
		ohohp = 2.10e-10*xIonFracs[ipHYDROGEN][1] + hmrate(8.83e-14,0.5,1.53e5)*(xIonFracs[ipHYDROGEN][1] + 
		  xIonFracs[ipHYDROGEN][0] + hmi.htwo) + 7.60e-10*hmi.h2plus + hmrate(5.20e-10,
		  0.5,1.5e5)*phycon.eden;
		c[ioh][ioh] -= ohohp;

		/* this is first major step to making CO
		 * OH + C+ => H + CO+ */
		ohcop = 7.70e-10*hevmolec.hevmol[ipCP];
		c[ioh][ioh] -= ohcop;

		/* OH + CH => H2O + C */
		chohwa = 1e-10*hevmolec.hevmol[ipCH];
		c[ioh][ioh] -= chohwa;

		/* C + OH => CO + H */
		ohco = hmrate(1.11e-10,0.5,0.)*catmic;
		c[ioh][ioh] -= ohco;

		/* O + OH => O2 + H */
		oho2 = hmrate(4.33e-11,-0.5,30.0)*oatmic;
		c[ioh][ioh] -= oho2;

		/* OH + H => O + H2 */
		oho = hmrate(6.60e-13,1.53,2970.)*xIonFracs[ipHYDROGEN][0];

		/* this is really OH + cr => O + H, enhance from 
		 * >>refer	OH	cr dest	Gredel et al. ApJ 347, 289 */
		oho += Secondaries.csupra*500.;
		c[ioh][ioh] -= oho;

		/* two ways to make water, H2 and OH
		 * first is OH + H2 => H2O + H */
		oh2wat = hmrate(8.80e-13,1.95,1420.)*hmi.htwo;

		/* second is OH + OH => H2O + O */
		ohohwa = hmrate(4.20e-12,0.,242.)*hevmolec.hevmol[ipOH];
		c[ioh][ioh] += -oh2wat - ohohwa*2.;

		/* O2 + H => OH + O */
		o2oh = hmrate(1.63e-9,-0.9,8750.)*xIonFracs[ipHYDROGEN][0];
		c[io2][ioh] += o2oh;

		/* OH+ + stuff goes to OH */
		ohpoh = hmrate(2.10e-9,0.,2800.)*xIonFracs[ipHYDROGEN][0] + 
			hmrate(7.60e-10,0., 2.36e4)*hmi.htwo;
		c[iohp][ioh] += ohpoh;

		/* O + CH => C + OH */
		c[ich][ioh] += chooh;

		/* CO + H => C + OH */
		cooh = hmrate(1.11e-10,0.5,7.77e4)*xIonFracs[ipHYDROGEN][0];
		c[ico][ioh] += cooh;

		/* water into OH */
		waoh = 2.03e-10*xIonFracs[ipHELIUM][1] + hmrate(9.20e-9,-0.5,6.96e4)*phycon.eden + 
		  hmrate(7.44e-12,1.57,9140.)*xIonFracs[ipHYDROGEN][0];
		c[ih2o][ioh] += waoh;

		/* H2O + O => OH + OH */
		wa2oh = hmrate(1.35e-12,1.75,7860.)*oatmic;
		c[ih2o][ioh] += wa2oh*2.;

		/* H2O + C => CH + OH */
		c[ih2o][ioh] += wachoh;

		/* ionized water into OH */
		wapoh = hmrate(7.60e-10,0.,4e4)*xIonFracs[ipHYDROGEN][0] + hmrate(1.30e-9,0.,2.03e4)*
		  hmi.htwo + hmrate(2e-7,-0.5,0.)*phycon.eden;
		c[ih2op][ioh] += wapoh;

		/* H2 + H2O+ => OH + H3+ */
		waph3p = hmrate(1.30e-9,0.,2.03e4)*hmi.htwo;
		c[ih2op][ioh] += waph3p;

		/* e- + H3O+ => OH + H3 */
		e3opoh = hmrate(3.00e-7,-0.5,0.)*phycon.eden;
		c[ih3op][ioh] += e3opoh;

		/* OH + H3P => H2 + H2O+ */
		h3pwap = 1.0e-9*hmi.h3plus;
		c[ioh][ioh] -= h3pwap;

		/*--------------------------------------------------------------------
		 *
		 * OH+ balance equations
		 *
		 * following remove OH+ from network
		 * both collide with H, go to H2 or H2+ */
		ohprm = hmrate(1.60e-9,0.,2.26e4)*xIonFracs[ipHYDROGEN][0] + hmrate(4.90e-10,-0.03,
		  1970.)*xIonFracs[ipHYDROGEN][0] + hmrate(2.00e-7,-0.5,0.)*phycon.eden;
		c[iohp][iohp] -= ohprm;

		/* OH+ + H => OH + H+ and OH+ + H2 => OH + H2+ */
		c[iohp][iohp] -= ohpoh;

		/* h2 + oh+ => h + h2o+ */
		ohpwap = 1.10e-9*hmi.htwo;
		c[iohp][iohp] -= ohpwap;

		/* several processes converting OH into OH+ */
		c[ioh][iohp] += ohohp;

		/* water into OH+ */
		waohp = 2.86e-10*xIonFracs[ipHELIUM][1];
		c[ih2o][iohp] += waohp;

		/* H + H2O+ => H2 + OH+ */
		wapohp = hmrate(1.70e-9,0.29,1.40e4)*xIonFracs[ipHYDROGEN][0];
		c[ih2op][iohp] += wapohp;

		/* O+ + H2 => H + OH+ */
		if( xIonFracs[ipOXYGEN][1] > 0. )
		{
			ratio = xIonFracs[ipOXYGEN][1]/xIonFracs[ipOXYGEN][0];
			opohp = 1.60e-9*ratio*hmi.htwo;
			c[ioatm][iohp] += opohp;
		}

		/* O + H2+ => H + OH+ */
		oohp = 1.50e-9*hmi.h2plus;
		c[ioatm][iohp] += oohp;

		/* O + H3P => H2 + OHP */
		h3pohp = 8.00e-10*hmi.h3plus;
		c[ioatm][iohp] += h3pohp;

		/* H2 + OH+ => O + H3P */
		ohph3p = hmrate(8.00e-10,0.,2900.)*hmi.htwo;
		c[iohp][iohp] -= ohph3p;

		/*--------------------------------------------------------------------
		 *
		 * O2 balance equation
		 *
		 * reactions that remove O2 from network */
		o2o2p = 1.20e-9*xIonFracs[ipHYDROGEN][1] + hmrate(2.37e-15,1.04,1.40e5)*xIonFracs[ipHYDROGEN][1] + 
		  2.70e-9*hmi.h2plus + hmrate(1.40e-11,1.04,1.40e5)*phycon.eden + 
		  hmrate(2.37e-15,1.04,1.40e5)*(xIonFracs[ipHYDROGEN][0] + hmi.htwo);
		c[io2][io2] -= o2o2p;
		o2rm = 1.10e-9*xIonFracs[ipHELIUM][1] + hmrate(2.30e-9,-0.5,6.96e4)*phycon.eden;

		/* cr destruction with enhancement from
		 * >>refer	O2	cr dest	Gredel et al. ApJ 347, 289 */
		o2rm += Secondaries.csupra*730.;
		c[io2][io2] -= o2rm;

		/* O2 + C+ => O + CO+ */
		o2cop = 3.76e-10*hevmolec.hevmol[ipCP];
		c[io2][io2] -= o2cop;

		/* O2 + C+ => CO + O+ */
		o2co = 6.14e-10*hevmolec.hevmol[ipCP];
		c[io2][io2] -= o2co;

		/* C + O2 => CO + O */
		co2co = hmrate(1.80e-11,0.5,0.)*catmic;
		c[io2][io2] -= co2co;

		/* O2 + H => OH + O */
		c[io2][io2] -= o2oh;

		/* o + oh => o2 + h */
		c[ioh][io2] += oho2;

		/* o + co => c + o2 */
		coo2 = hmrate(2.90e-11,0.5,6.93e4)*oatmic;
		c[ico][io2] += coo2;

		/* h + o2+ => o2 + h+ */
		ho2p = hmrate(2.80e-10,-0.04,1.78e4)*xIonFracs[ipHYDROGEN][0];
		c[io2p][io2] += ho2p;

		/*--------------------------------------------------------------------
		 *
		 * O2+ balance
		 *
		 * e + O2+ => O + O */
		eo2o = hmrate(2.00e-7,-0.5,0.)*phycon.eden;
		c[io2p][io2p] -= eo2o;

		/* H + O2+ => O2 + H+ */
		c[io2p][io2p] -= ho2p;

		/* various processes creating O2+ from O2 */
		c[io2][io2p] += o2o2p;

		/*------------------------------------------------------------------
		 *
		 * CO balance equation carbon monoxide
		 *
		 * CO + H+ => H + CO+, also CO + H+ => CO+ + */
		cocop = hmrate(1.90e-10,0.,4660.)*xIonFracs[ipHYDROGEN][1] + hmrate(1.13e-13,
		  0.6,1.63e5)*(xIonFracs[ipHYDROGEN][1] + xIonFracs[ipHYDROGEN][0] + hmi.htwo) + 2.80e-9*hmi.h2plus + 
		  hmrate(6.70e-10,0.6,1.63e5)*phycon.eden;
		c[ico][ico] -= cocop;

		/* co + hE+ => o + c+ + hE */
		/*TODO - update dates to this reference */
		/* >>refer	CO	He+ destruction	Kwong, V.H.S., Chen, D., & Fang, Z. 2000, ApJ, 536, 954-958*/
		cocp = 1.70e-9*xIonFracs[ipHELIUM][1]*1.1;
		c[ico][ico] -= cocp;

		/* CO + e => C + O  + e */
		cocn = hmrate(8.1e-10,-0.50,1.14e5)*phycon.eden;

		/* extra factor is enhancement due to light */
		/*TODO - check this - the following two almost certainly should be to CO+ */
		cocn += Secondaries.csupra*20.;

		/* >>chng 01 aug 24, add this term */
		/* direct photoionization */
		for( ns=0; ns<3; ++ns )
		{
			int ion=0;
			cocn += ionrec.PhotoRate_Ground[ipCARBON][ion][ns][0];
			cocn += ionrec.PhotoRate_Ground[ipOXYGEN][ion][ns][0];
		}

		c[ico][ico] -= cocn;

		/* CO + hnu(line abs continuum) => C + O, from Teilens and Hollenback, Table 5 */
		/* >>chng 00 nov 27, eqn 11 & 12 from
		 >>refer	CO	photodissoc	Hollenbach, D.J., Takahashi, T., & Tielens, A.G.G.M., 1991, ApJ, 377, 192-209
		 * which was based on 
		 >>refer	CO	photodissoc	van Dishoeck, E.F., & Black, J.H., 1988,  ApJ, 334, 771
		 */
		/* phodco = ghabng.GammaHabing*1.4e-11;*/
		esc_co = 4.4e-15 * hevmolec.hevcol[ipCO] / DoppVel.doppler[LIMELM] /
			(1. + phycon.sqrte*0.6019) ;
		phodco = ghabng.GammaHabing* 1.67e-10 * esca0k2(esc_co);
		c[ico][ico] -= phodco;

		/* O + CO => C + O2 */
		c[ico][ico] -= coo2;

		/* CO + H => C + OH */
		c[ico][ico] -= cooh;

		/* CO + H => CH + O */
		c[ico][ico] -= coch;

		/* O + CH => CO + H */
		c[ich][ico] += choco;

		/* C + OH => CO + H */
		c[ioh][ico] += ohco;

		/* O2 + C+ => CO + O+ */
		o2co = 6.14e-10*hevmolec.hevmol[ipOTWO];
		c[icp][ico] += o2co;

		/* C + O2 => CO + O */
		c[io2][ico] += co2co;

		/* CO+ + H => CO + H+ */
		copco = 1.90e-10*xIonFracs[ipHYDROGEN][0];
		c[icop][ico] += copco;

		/* CO + H3+ => H2 + CO+ */
		h3pcop = 1.70e-9*hmi.h3plus;
		c[ico][ico] -= h3pcop;

		/* remember longest CO timescale */
		if( -c[ico][ico] > SMALLFLOAT )
		{
			/* this is rate CO is destroyed, equal to formation rate in equilibrium */
			timesc.AgeCOMoleDest = -1./c[ico][ico];
			/* moved to radinc */
			/*timesc.BigCOMoleForm = (float)MAX2(timesc.BigCOMoleForm,timesc.AgeCOMoleForm);*/
		}
		else
		{
			timesc.AgeCOMoleDest = 0.;
		}

		/*--------------------------------------------------------------------
		 *
		 * CO+ balance equation
		 *
		 * e + CO+ => C + O */
		coprm = hmrate(1.80e-7,-0.5,0.)*phycon.eden;
		c[icop][icop] -= coprm;

		/* CO+ + H => CO + H+ */
		c[icop][icop] -= copco;

		/* co + h+ => h + co+, ALSO co + h+ => co++ */
		c[ico][icop] += cocop;

		/* OH + C+ => H + CO+ */
		ohcop = 7.70e-10*hevmolec.hevmol[ipOH];
		c[icp][icop] += ohcop;

		/* H2O + C+ => H2 + CO+ */
		wacop = 2.70e-9*hevmolec.hevmol[ipCP];
		c[ih2o][icop] += wacop;

		/* CO + H3+ => H2 + CO+ */
		c[ico][icop] += h3pcop;

		/* o + ch2+ => h + co+ */
		ch2pco = 7.50e-10*oatmic;
		c[ich2p][icop] += ch2pco;

		/* O2 + C+ => O + CO+ */
		o2cop = 3.76e-10*hevmolec.hevmol[ipCP];
		c[io2][icop] += o2cop;

		/*--------------------------------------------------------------------
		 *
		 * water H2O balance
		 *
		 * processes converting wat to wap */
		wawap = 8.20e-9*xIonFracs[ipHYDROGEN][1] + hmrate(7.55e-14,0.45,1.47e5)*(xIonFracs[ipHYDROGEN][0] + 
		  hmi.htwo + xIonFracs[ipHYDROGEN][1]) + 3.90e-9*hmi.h2plus + hmrate(4.40e-10,
		  0.45,1.47e5)*phycon.eden + 6.05e-11*xIonFracs[ipHELIUM][1];
		c[ih2o][ih2o] -= wawap;

		/* h2o => oh+ */
		c[ih2o][ih2o] -= waohp;

		/* water into OH */
		c[ih2o][ih2o] -= waoh;

		/* H2O + C => CH + OH */
		c[ih2o][ih2o] -= wachoh;

		/* H2O + O => OH + OH */
		c[ih2o][ih2o] -= wa2oh;

		/* h2o + c+ => h2 + co+ */
		c[ih2o][ih2o] -= wacop;

		if( c[ih2o][ih2o] == 0. )
		{
			/* possible for zero water destruction, this is an error */
			c[ih2o][ih2o] = -1e-35;
			hevmolec.lgH2Ozer = TRUE;
		}

		/* end of water destruction mechanisms
		 * CH + OH => H2O + C */
		chohwa = 1e-10*hevmolec.hevmol[ipOH];
		c[ich][ih2o] += chohwa;

		/* OH + stuff => water */
		c[ioh][ih2o] += oh2wat + ohohwa;

		/* ionized water into water */
		wapwa = hmrate(8.20e-9,0.,1.15e4)*xIonFracs[ipHYDROGEN][0] + hmrate(3.90e-9,0.,
		  3.27e4)*hmi.htwo;
		c[ih2op][ih2o] += wapwa;

		/* H2 + H3O => H2O + H3+ */
		h3oh3p = hmrate(5.90e-9,0.,3.28e4)*hmi.htwo;
		c[ih3op][ih2o] += h3oh3p;

		/* H2O + H2+ => H + H3O+ */
		wah3op = 3.40e-9*hmi.h2plus;
		c[ih2o][ih2o] -= wah3op;

		/* H + H3O+ => H2O + H2+ */
		h3opwa = hmrate(5.90e-9,0.,3.28e4)*hmi.htwo;
		c[ih3op][ih2o] += h3opwa;

		/* e- + H3O+ => H2O + H */
		e3opwa = hmrate(1.00e-6,-0.5,0.)*phycon.eden;
		c[ih3op][ih2o] += e3opwa;

		/* H2O + H3P => H2 + H3OP */
		h3pwai = 5.90e-9*hmi.h3plus;
		c[ih2o][ih2o] -= h3pwai;

		/*--------------------------------------------------------------------
		 * H2O+ balance
		 *
		 * removes ionized water from network */
		waprm = hmrate(2e-7,-0.5,0.)*phycon.eden;
		c[ih2op][ih2op] -= waprm;

		/* H + H2O+ => H2 + OH+ */
		c[ih2op][ih2op] -= wapohp;

		/* ionized water into water */
		c[ih2op][ih2op] -= wapwa;

		/* ionized water into OH */
		c[ih2op][ih2op] -= wapoh;

		/* H2 + OH+ => H + H2O */
		c[iohp][ih2op] += ohpwap;

		/* processes converting wat to wap */
		c[ih2o][ih2op] += wawap;

		/* OH + H3P => H2 + H2O+ */
		h3pwap = 1.0e-9*hmi.h3plus;
		c[ioh][ih2op] += h3pwap;

		/* H2 + H2O+ => OH + H3+ */
		c[ih2op][ih2op] -= waph3p;

		/* H2 + H2O+ => H + H3O+ */
		waiwai = 6.10e-10*hmi.htwo;
		c[ih2op][ih2op] -= waiwai;

		/* H + H3O+ => H2 + H2O+ */
		h3owai = hmrate(6.00e-9,0.390,1.98e4)*xIonFracs[ipHYDROGEN][0];
		c[ih3op][ih2op] += h3owai;

		/*--------------------------------------------------------------------
		 * H3O+ balance
		 * H2O + H3P => H2 + H3OP */
		c[ih2o][ih3op] += h3pwai;

		/* H2 + H3O+ => H2O + H3+ */
		c[ih3op][ih3op] -= h3oh3p;

		/* H2O + H2+ => H + H3O+ */
		c[ih2o][ih3op] += wah3op;

		/* H2 + H2O+ => H + H3O+ */
		c[ih2op][ih3op] += waiwai;

		/* H + H3O+ => H2 + H2O+ */
		c[ih3op][ih3op] -= h3owai;

		/* H + H3O+ => H2O + H2+ */
		c[ih3op][ih3op] -= h3opwa;

		/* e- + H3O+ => H2O + H */
		c[ih3op][ih3op] -= e3opwa;

		/* e- + H3O+ => OH + H3 */
		c[ih3op][ih3op] -= e3opoh;

		/*--------------------------------------------------------------------
		 * CH2+ balance
		 * e- + CH2+ => C + H2, there is no carbon balance eqn */
		ch2pc = hmrate(2.50e-7,-0.5,0.)*phycon.eden;
		c[ich2p][ich2p] -= ch2pc;

		/* e- + CH2+ => CH + H */
		c[ich2p][ich2p] -= ch2pch;

		/* H + CH2+ => H2 + CH+ */
		c[ich2p][ich2p] -= h2pchp;

		/* H2 + CH2+ => CH + H3+ */
		c[ich2p][ich2p] -= ch2ph3;

		/* O + CH2+ => H + CO+ */
		c[ich2p][ich2p] -= ch2pco;

		/* H2 + C+ => CH2+ */
		cpch2p = hmrate(4.00e-16,-0.20,0.)*hmi.htwo;
		c[icp][ich2p] += cpch2p;

		/* H2 + CH+ => H + CH2+ */
		c[ichp][ich2p] += chphch;

		/*--------------------------------------------------------------------
		 * C+ balance
		 * atomic processes changing C+ into Co, calculated in car bal */
		c[icp][icp] -= DestCrt.Recombine[ipCARBON][0];

		/* atomic processes changing Co into C+, calculated in car bal */
		c[icatm][icp] += DestCrt.xIonize[ipCARBON][0];

		/* CO + He+ => C + C+ + He */
		c[ico][icp] += cocp;

		/* H2 + C+ => H + CH+ */
		c[icp][icp] -= cpchp;

		/* H2 + C+ => CH2+ */
		c[icp][icp] -= cpch2p;

		/* OH + C+ => H + CO+ */
		ohcop = 7.70e-10*hevmolec.hevmol[ipOH];
		c[icp][icp] -= ohcop;

		/* CH+ + H => H2 + C+ */
		c[ichp][icp] += chph;

		/* O2 + C+ => O + CO+ */
		o2cop = 3.76e-10*hevmolec.hevmol[ipOTWO];
		c[icp][icp] -= o2cop;

		/* O2 + C+ => CO + O+ */
		o2co = 6.14e-10*hevmolec.hevmol[ipOTWO];
		c[icp][icp] -= o2co;

		/*--------------------------------------------------------------------
		 * */
		/*lint -e506 constant value Boolean */
		if( trace.lgTrace && trace.lgTrMole )
		{
			fprintf( ioQQQ, " COMOLE matrix\n           " );

			for( i=0; i < MIN2(NMOLE,8); i++ )
			{
				fprintf( ioQQQ, "%4.4s", chLab[i] );
			}
			fprintf( ioQQQ, "     \n" );

			for( j=0; j < NMOLE; j++ )
			{
				fprintf( ioQQQ, " %4.4s", chLab[j] );
				fprintf( ioQQQ, " " );
				for( i=0; i < MIN2(NMOLE,8); i++ )
				{
					fprintf( ioQQQ, "%9.1e", c[i][j] );
				}
				fprintf( ioQQQ, "\n" );
			}

			if( NMOLE >= 9 )
			{
				fprintf( ioQQQ, " COMOLE matrix\n           " );

				for( i=8; i < NMOLE; i++ )
				{
					fprintf( ioQQQ, "%4.4s", chLab[i] );
				}
				fprintf( ioQQQ, "     \n" );

				for( j=0; j < NMOLE; j++ )
				{
					fprintf( ioQQQ, " %4.4s", chLab[j] );
					fprintf( ioQQQ, " " );
					for( i=8; i < NMOLE; i++ )
					{
						fprintf( ioQQQ, "%9.1e", c[i][j] );
					}
					fprintf( ioQQQ, "\n" );
				}
			}

			fprintf( ioQQQ, " COMOLE H2 den:%10.3e, H2,3+=%10.2e%10.2e Carb sum=%10.3e Oxy sum=%10.3e\n", 
			  hmi.htwo, hmi.h2plus, hmi.h3plus, c[NMOLE][icatm], 
			  c[NMOLE][ioatm] );

		}

		/* invert matrix */
		for( i=0; i < NMOLE; i++ )
		{
			for( j=0; j < NMOLE; j++ )
			{
				csav[j][i] = c[j][i];
			}
		}

		/* which matrix solver? */
		if( strcmp(TypMatrx.chMatrix,"matin1 ") == 0 )
		{
			/*matin1();*/
			/* this should be set upon error return to non-zero val*/
			merror = 1 ;
		}

		else if( strcmp(TypMatrx.chMatrix,"linpack") == 0 )
		{
			/* this one may be more robust */
			for( j=0; j < NMOLE; j++ )
			{
				for( i=0; i < NMOLE; i++ )
				{
					amat[i][j] = c[i][j];
				}
				bvec[j] = c[NMOLE][j];
			}

			DGETRF(NMOLE,NMOLE,(double*)amat,NMOLE, ipiv,&merror);

			DGETRS('N',NMOLE,1,(double*)amat,NMOLE,ipiv,bvec,NMOLE, &merror);

			if( merror != 0 )
			{
				fprintf( ioQQQ, " comole dgetrs error\n" );
				puts( "[Stop in comole]" );
				cdEXIT(EXIT_FAILURE);
			}

			/* now put results back into z so rest of code treates only
			 * one case - as if matin1 had been used */
			for( i=0; i < NMOLE; i++ )
			{
				c[NMOLE][i] = bvec[i];
			}
		}

		else if( strcmp(TypMatrx.chMatrix,"veclib ") == 0 )
		{
			/* Jason found this one on the Exemplar, distributed source just stops */
			fprintf( ioQQQ, " this has not been checked since H atom conv\n" );
			for( j=0; j < NMOLE; j++ )
			{
				for( i=0; i < NMOLE; i++ )
				{
					amat[i][j] = c[i][j];
				}
				bvec[j] = c[NMOLE][j];
			}

			job = 0;
			rcond = 0.;
			dgeco((double*)amat,NMOLE,NMOLE,ipiv,rcond,work);
			dgesl((double*)amat,NMOLE,NMOLE,ipiv,bvec,job);
			/* if this matrix inversion routine is ever used 
			 * put a definition of the error return in the following variable*/
			merror = 0;

			/* now put results back into z so rest of code treates only
			 * one case - as if matin1 had been used */
			for( i=0; i < NMOLE; i++ )
			{
				c[NMOLE][i] = bvec[i];
			}
			/* code not in place, so this does not work */
			puts( "[Stop in comole]" );
			cdEXIT(EXIT_FAILURE);
		}

		else
		{
			fprintf( ioQQQ, " chMatrix type insane in hydrogen, was%7.7s\n", 
			  TypMatrx.chMatrix );
			puts( "[Stop in comole]" );
			cdEXIT(EXIT_FAILURE);
		}

		/* check for negative populations, which happens when 100% co */
		*lgNegPop = FALSE;
		*lgZerPop = FALSE;
		for( i=0; i < NMOLE; i++ )
		{
			if( c[NMOLE][i] < 0. )
			{
				*lgNegPop = TRUE;
			}
			else if( c[NMOLE][i] == 0. )
			{
				*lgZerPop = TRUE;
			}
		}

		if( merror != 0 )
		{
			fprintf( ioQQQ, " COMOLE matrix inversion error, MERROR=%5ld zone=%5ld\n", 
			  merror, nzone );
			ShowMe();
			fprintf( ioQQQ, " Product matrix\n           " );

			for( i=0; i < MIN2(NMOLE,8); i++ )
			{
				fprintf( ioQQQ, "%4.4s", chLab[i] );
			}
			fprintf( ioQQQ, "     \n" );

			for( j=0; j < NMOLE; j++ )
			{
				fprintf( ioQQQ, " %4.4s", chLab[j] );
				fprintf( ioQQQ, " " );

				for( i=0; i < MIN2(NMOLE,8); i++ )
				{
					fprintf( ioQQQ, "%9.1e", csav[i][j]*
					  c[NMOLE][i] );
				}
				fprintf( ioQQQ, "\n" );
			}

			if( NMOLE >= 9 )
			{
				fprintf( ioQQQ, " COMOLE matrix\n           " );
				for( i=8; i < NMOLE; i++ )
				{
					fprintf( ioQQQ, "%4.4s", chLab[i] );
				}
				fprintf( ioQQQ, "     \n" );

				for( j=0; j < NMOLE; j++ )
				{
					fprintf( ioQQQ, " %4.4s", chLab[j] );
					fprintf( ioQQQ, " " );
					for( i=8; i < NMOLE; i++ )
					{
						fprintf( ioQQQ, "%9.1e", 
							csav[i][j]* c[NMOLE][i] );
					}
					fprintf( ioQQQ, "\n" );
				}
			}

			fprintf( ioQQQ, " Molecular densities relative to H2\n " );
			for( j=0; j < NMOLE; j++ )
			{
				fprintf( ioQQQ, "%4.4s:%10.2e", chLab[j]
				  , c[NMOLE][j] );
			}
			fprintf( ioQQQ, " \n" );

			puts( "[Stop in comole]" );
			cdEXIT(EXIT_FAILURE);
		}

		if( trace.lgTrace && trace.lgTrMole )
		{
			fprintf( ioQQQ, " Product matrix\n           " );

			for( i=0; i < MIN2(NMOLE,8); i++ )
			{
				fprintf( ioQQQ, "%4.4s", chLab[i] );
			}
			fprintf( ioQQQ, "     \n" );

			for( j=0; j < NMOLE; j++ )
			{
				fprintf( ioQQQ, " %4.4s", chLab[j] );
				fprintf( ioQQQ, " " );
				for( i=0; i < MIN2(NMOLE,8); i++ )
				{
					fprintf( ioQQQ, "%9.1e", csav[i][j]*
					  c[NMOLE][i] );
				}
				fprintf( ioQQQ, "\n" );

			}

			if( NMOLE >= 9 )
			{
				fprintf( ioQQQ, " COMOLE matrix\n           " );
				for( i=8; i < NMOLE; i++ )
				{
					fprintf( ioQQQ, "%4.4s", chLab[i] );
				}
				fprintf( ioQQQ, "     \n" );

				for( j=0; j < NMOLE; j++ )
				{
					fprintf( ioQQQ, " %4.4s", chLab[j] );
					fprintf( ioQQQ, " " );

					for( i=8; i < NMOLE; i++ )
					{
						fprintf( ioQQQ, "%9.1e", csav[i][j]* c[NMOLE][i] );
					}
					fprintf( ioQQQ, "\n" );
				}
			}

			fprintf( ioQQQ, " Molecular densities relative to H2\n " );
			for( j=0; j < NMOLE; j++ )
			{
				fprintf( ioQQQ, "%4.4s:%10.2e", chLab[j]
				  , c[NMOLE][j] );
			}
			fprintf( ioQQQ, " \n" );
		}

		/* (1,n) is C atomic */
		oldcarb = catmic;
		catmic = (float)c[NMOLE][icatm];

		/* (2,n) is O atomic */
		oatmic = (float)c[NMOLE][ioatm];

		/* (3,n) is CH */
		hevmolec.hevmol[ipCH] = (float)c[NMOLE][ich];

		/* (4,n) is CHP */
		hevmolec.hevmol[ipCHP] = (float)c[NMOLE][ichp];

		/* (5,n) is OH */
		hevmolec.hevmol[ipOH] = (float)c[NMOLE][ioh];

		/* (6,n) is OHP */
		hevmolec.hevmol[ipOHP] = (float)c[NMOLE][iohp];

		/* (9,n) is CO */
		hevmolec.hevmol[ipCO] = (float)c[NMOLE][ico];

		/* (10,n) is COP */
		hevmolec.hevmol[ipCOP] = (float)c[NMOLE][icop];

		/* (11,n) is H2O */
		hevmolec.hevmol[ipH2O] = (float)c[NMOLE][ih2o];

		/* (12,n) is H2OP */
		hevmolec.hevmol[ipH2OP] = (float)c[NMOLE][ih2op];

		/* (14,n) is H3OP */
		hevmolec.hevmol[ipH3OP] = (float)c[NMOLE][ih3op];

		/* (15,n) is CH2P */
		hevmolec.hevmol[ipCH2P] = (float)c[NMOLE][ich2p];

		/* (16,n) is CP */
		hevmolec.hevmol[ipCP] = (float)c[NMOLE][icp];

		/* (7,n) is OTWO */
		hevmolec.hevmol[ipOTWO] = (float)c[NMOLE][io2];

		/* (8,n) is O2P */
		hevmolec.hevmol[ipO2P] = (float)c[NMOLE][io2p];

		/* rememeber largest fraction of carbon in molecules */
		cf = (hevmolec.hevmol[ipCH] + hevmolec.hevmol[ipCHP] + 
		  hevmolec.hevmol[ipCO] + hevmolec.hevmol[ipCOP] + hevmolec.hevmol[ipCH2P])/
		  abundances.gas_phase[ipCARBON];
#		if 0
		if( hevmolec.hevmol[ipCO] / abundances.gas_phase[ipCARBON] > 1. )
		{
			fprintf(ioQQQ," co/c>1, fracs are %g %g %g %g %g\n",
			hevmolec.hevmol[ipCH]/abundances.gas_phase[ipCARBON], hevmolec.hevmol[ipCHP]/abundances.gas_phase[ipCARBON],
			hevmolec.hevmol[ipCO]/abundances.gas_phase[ipCARBON], hevmolec.hevmol[ipCOP]/abundances.gas_phase[ipCARBON],
			hevmolec.hevmol[ipCH2P]/abundances.gas_phase[ipCARBON] );
		}
#		endif

		co.CarMolFrac = MAX2(co.CarMolFrac,(float)cf);

		/* heating due to CO photodissociation */
		co.CODissHeat = (float)(phodco*hevmolec.hevmol[ipCO]*1e-12);

		heat.heating[0][9] = co.CODissHeat;

		/* cooling due to coll excit of vib-rot levels
		 * from 
		 * >>refer	co	vib cool	Hollenbach & McKee 1979, ApJS, 41, 555 */
		crden = 1.9e3*phycon.sqrte;

#		if 0
		/* this is old code for the simple CO molecule from Hollenbach & McKee */
		/* this is their cooling coefficent, per H2, and CO */
		CoolHeavy.COVibCoolOld = (float)(1.94e-23*phycon.te*phycon.te/(hmi.htwo + 
		  crden + 1.5*pow(hmi.htwo*crden,0.5)));
		/* >>chng 00 mar 14, extra boltzmann factor for lowest level */
		CoolHeavy.COVibCoolOld *= (float)sexp(5.554/phycon.te ) ;

		/* this is total cooling per unit vol */
		/* multiply by smaller of co or total carbon abundance (all phases).  There are models
		 * where ALL c is in co and matrix is unstable, returning co/c > 1.  other molecules
		 * have negative abundances.  this will eventually be detected by the code, which
		 * will bail out, but we don't get to that stage if co cooling is oscillating. */
		CoolHeavy.COVibCoolOld *= (float)(hmi.htwo*MIN2(hevmolec.hevmol[ipCO],abundances.gas_phase[ipCARBON])*0.3);
		/* its derivative */
		CoolHeavy.dCOVdTOld = (float)(CoolHeavy.COVibCoolOld*2./phycon.te);
#		endif

		/* the real multi-level model molecule */
		abund = hevmolec.hevmol[ipCO];
		/* IonStg and nelem were set to 2, 0 in makelevlines */
		ASSERT( C12O16Rotate[0].IonStg < LIMELM+2 );
		ASSERT( C12O16Rotate[0].nelem-1 < LIMELM+2 );
		xIonFracs[ C12O16Rotate[0].nelem-1][C12O16Rotate[0].IonStg-1] = abund;

		RotateCooling(&C12O16Rotate, abund , "12CO",&CoolHeavy.C12O16Rot,&CoolHeavy.dC12O16Rot);

		abund = hevmolec.hevmol[ipCO]/hevmolec.RatioC12O16_2_C13O16;
		/* IonStg and nelem were set to 3, 0 in makelevlines */
		ASSERT( C13O16Rotate[0].IonStg < LIMELM+2 );
		ASSERT( C13O16Rotate[0].nelem-1 < LIMELM+2 );
		xIonFracs[ C13O16Rotate[0].nelem-1][C13O16Rotate[0].IonStg-1] = abund;

		RotateCooling(&C13O16Rotate, abund ,"13CO",&CoolHeavy.C13O16Rot,&CoolHeavy.dC13O16Rot);

		/* check for negative or zero atomic carbon populations */
		if( catmic <= 0. )
		{
			catmic = (float)(fabs(catmic/2.));
			catmic = oldcarb;

			if( hevmolec.hevmol[ipCO] > hevmolec.hevmol[ipCH] )
			{
				hevmolec.hevmol[ipCO] = (float)MAX2(hevmolec.hevmol[ipCO]/
				  2.,hevmolec.hevmol[ipCO]-catmic);
			}
			else
			{
				hevmolec.hevmol[ipCH] = (float)MAX2(hevmolec.hevmol[ipCH]/
				  2.,hevmolec.hevmol[ipCH]-catmic);
			}
		}

		if( oatmic <= 0. )
		{
			/*  WRITE(QQ,'('' WARNING; O population is negative or 0.'',1P,
			 *  1   E10.2)') OATMIC */
			oatmic = 0.;
		}

		if( hevmolec.hevmol[ipCH] <= 0. )
		{
			/*  WRITE(QQ,'('' WARNING; CH population is negative or 0.'',1P,
			 *  1   E10.2)') CH */
			hevmolec.hevmol[ipCH] = -hevmolec.hevmol[ipCH]/2.f;
		}

		if( hevmolec.hevmol[ipCHP] <= 0. )
		{
			/*  WRITE(QQ,'('' WARNING; CH+ population is negative or 0.'',1P,
			 *  1   E10.2)') CHP */
			hevmolec.hevmol[ipCHP] = -hevmolec.hevmol[ipCHP]/2.f;
		}

		if( hevmolec.hevmol[ipOH] <= 0. )
		{
			/*  WRITE(QQ,'('' WARNING; OH population is negative or 0.'',1P,
			 *  1   E10.2)') OH */
			hevmolec.hevmol[ipOH] = 0.;
		}

		if( hevmolec.hevmol[ipOHP] <= 0. )
		{
			/*  WRITE(QQ,'('' WARNING; OH+ population is negative or 0.'',1P,
			 *  1   E10.2)') OHP */
			hevmolec.hevmol[ipOHP] = 0.;
		}

		if( hevmolec.hevmol[ipCO] <= 0. )
		{
			/*  WRITE(QQ,'('' WARNING; CO population is negative or 0.'',1P,
			 *  1   E10.2)') CO */
			hevmolec.hevmol[ipCO] = 0.;
		}

		if( hevmolec.hevmol[ipCOP] <= 0. )
		{
			/*  WRITE(QQ,'('' WARNING; CO+ population is negative or 0.'',1P,
			 *  1   E10.2)') COP */
			hevmolec.hevmol[ipCOP] = 0.;
		}

		if( hevmolec.hevmol[ipH2O] <= 0. )
		{
			hevmolec.hevmol[ipH2O] = 0.;
		}

		if( hevmolec.hevmol[ipH2OP] <= 0. )
		{
			hevmolec.hevmol[ipH2OP] = 0.;
		}

		if( hevmolec.hevmol[ipH3OP] <= 0. )
		{
			hevmolec.hevmol[ipH3OP] = 0.;
		}

		if( hevmolec.hevmol[ipCH2P] <= 0. )
		{
			hevmolec.hevmol[ipCH2P] = -hevmolec.hevmol[ipCH2P]/2.f;

		}

		if( hevmolec.hevmol[ipCP] <= 0. )
		{
			hevmolec.hevmol[ipCP] = -hevmolec.hevmol[ipCP]/2.f;
		}
	}

	/* now set total density of each element locked in gas phase */
	for( i=0;i<LIMELM; ++i )
	{
		xMolFracs[i] = 0.;
	}

	/* add in gas phase abundances locked in molecules */
	/* these were computed in hmole.c */
	xMolFracs[ipHYDROGEN] += hmi.hminus+2.f*hmi.htwo+2.f*hmi.h2plus+hmi.hehp+2.f*hmi.htwo_star;

	xMolFracs[ipHYDROGEN] += hevmolec.hevmol[ipCH]+ hevmolec.hevmol[ipCHP]+ hevmolec.hevmol[ipOH]+
		hevmolec.hevmol[ipOHP]+ 2.f*hevmolec.hevmol[ipH2O]+ 2.f*hevmolec.hevmol[ipH2OP]+	
		3.f*hevmolec.hevmol[ipH3P]+3.f*hevmolec.hevmol[ipH3OP]+2.f*hevmolec.hevmol[ipCH2P]+
		2.f*hevmolec.hevmol[ipCH2]+ 3.f*hevmolec.hevmol[ipCH3];

	xMolFracs[ipCARBON] += hevmolec.hevmol[ipCH]+hevmolec.hevmol[ipCHP]+2.f*hevmolec.hevmol[ipCTWO]+
		hevmolec.hevmol[ipCO]+hevmolec.hevmol[ipCOP]+2.f*hevmolec.hevmol[ipC2P]+hevmolec.hevmol[ipCH3]+
		hevmolec.hevmol[ipCH2P]+hevmolec.hevmol[ipCH2];

	xMolFracs[ipOXYGEN] += hevmolec.hevmol[ipOH]+hevmolec.hevmol[ipOHP]+2.f*hevmolec.hevmol[ipOTWO]+
		hevmolec.hevmol[ipCO]+hevmolec.hevmol[ipCOP]+hevmolec.hevmol[ipH2O]+hevmolec.hevmol[ipH2OP]+
		2.f*hevmolec.hevmol[ipO2P]+hevmolec.hevmol[ipH3OP];

#	ifdef DEBUG_FUN
	fputs( " <->comole()\n", debug_fp );
#	endif
	return;
}

/*lint +e550 */

/*molav average old and new molecular equilibrium balance from comole */
static void molav(long int JobMolAv)
{
	long int i;
	double damper;
	static double hevsav[NHEVML];

#	ifdef DEBUG_FUN
	fputs( "<+>molav()\n", debug_fp );
#	endif

	/* when called with IX=1, set saver */
	if( JobMolAv == 1 )
	{
		/* this is first call - remember initial abundances */
		for( i=0; i < NHEVML; i++ )
		{
			hevsav[i] = hevmolec.hevmol[i];
		}

		if( trace.lgTrace && trace.lgTrMole )
		{
			fprintf( ioQQQ, "      MOLAV pop1=" );
			for(i=0; i < NHEVML; i++)
				fprintf( ioQQQ, "%9.1e", hevmolec.hevmol[i] );
			fprintf( ioQQQ, "\n" );
		}
	}

	else if( JobMolAv < 0 )
	{
		for( i=0; i < NHEVML; i++ )
		{
			hevmolec.hevmol[i] = 0.;
			hevsav[i] = 0.;
		}
	}

	else
	{
		/* get new numbers - take average of old and new */
		for( i=0; i < NHEVML; i++ )
		{
			/* parameter to mix old and new */
			damper = 0.2;
			hevmolec.hevmol[i] = (float)(hevmolec.hevmol[i]*(1. - damper) + 
			  hevsav[i]*damper);
			hevsav[i] = hevmolec.hevmol[i];
		}

		if( trace.lgTrace && trace.lgTrMole )
		{
			fprintf( ioQQQ, "      MOLAV pop2=" );
			for(i=0; i < NHEVML; i++)
				fprintf( ioQQQ, "%9.1e", hevmolec.hevmol[i] );
			fprintf( ioQQQ, "\n" );
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->molav()\n", debug_fp );
#	endif
	return;
}

/*=================================================================*/
/*codriv main driver for heavy molecular equilibrium routines      */
#define	COTOLER	0.10
#define	LUPMAX	10

void codriv(void)
{
	int lgNegPop, 
	  lgZerPop;
	static long int loop;
	static float ohold;

#	ifdef DEBUG_FUN
	fputs( "<+>codriv()\n", debug_fp );
#	endif

	/* set lgAllCO at start of every calculation */
	if( !nzone ) 
		lgAllCO = FALSE;

	ohold = hevmolec.hevmol[ipOH];
	comole(&lgNegPop,&lgZerPop);
	molav(1);

	/* >>chng 97 jul 29, turn on flag for too much CO here too, there were
	 * models in which this test never took place since oh went zero */
	if( hevmolec.hevmol[ipOH] == 0. )
	{
		if( hevmolec.hevmol[ipCO]/abundances.gas_phase[ipCARBON] > co.COLimit )
		{
			co.lgLotsCO = TRUE;
		}
		
#		ifdef DEBUG_FUN
		fputs( " <->codriv()\n", debug_fp );
#		endif
		return;
	}

	loop = 1;
	while( ((fabs(ohold/hevmolec.hevmol[ipOH]-1.) > COTOLER || lgNegPop) && 
	  (loop < LUPMAX)) && (hevmolec.hevmol[ipCO]/abundances.gas_phase[ipCARBON] < 
	  co.COLimit) )
	{
		molav(2);
		ohold = hevmolec.hevmol[ipOH];
		comole(&lgNegPop,&lgZerPop);
		if( hevmolec.hevmol[ipOH] == 0. )
		{ 
#			ifdef DEBUG_FUN
			fputs( " <->codriv()\n", debug_fp );
#			endif
			return;
		}
		++loop;
	}

	/* this sets flag if there is too much CO, a precursor to negative pops,
	 * and so a stopping condition */
	if( hevmolec.hevmol[ipCO]/abundances.gas_phase[ipCARBON] > co.COLimit )
	{
		co.lgLotsCO = TRUE;
		lgAllCO = TRUE;
	}

	/* did the molecule network have negative pops? */
	else if( lgNegPop )
	{
		co.lgLotsCO = TRUE;
		lgAllCO = TRUE;
		lgNegPop = FALSE;
		if( called.lgTalk )
		{
			fprintf( ioQQQ, 
				" CODRIV failed to converge, pops, zone=%4ld, CO/C=%10.2e negpop?%1c\n", 
			  nzone, 
			  hevmolec.hevmol[ipCO]/abundances.gas_phase[ipCARBON], 
			  TorF(lgNegPop) );
		}
	}

	/* this test, hit upper limit to number of iterations */
	else if( loop == LUPMAX )
	{
		if( called.lgTalk )
		{
			fprintf( ioQQQ, 
				" CODRIV failed to converge in %li iter, zone=%4ld, CO/C=%10.2e negpop?%1c\n", 
			  loop,
			  nzone, 
			  hevmolec.hevmol[ipCO]/abundances.gas_phase[ipCARBON], 
			  TorF(lgNegPop) );
		}
	}

	if( lgNegPop )
	{
		co.lgComNeg = TRUE;
	}

	/* this would be a reason to exit */
	if( co.lgLotsCO )
		conv.lgAbort = TRUE;

#	ifdef DEBUG_FUN
	fputs( " <->codriv()\n", debug_fp );
#	endif
	return;
}

/* evaluate CO rotation cooling */
void RotateCooling(
	EmLine ** Rotate , 
	float abund, 
	char * chLabel ,
	float * Cooling ,
	float * dCoolingDT )
{

	/* will need to MALLOC space for these but only on first call */
	static double **data, 
	  **dest, 
	  /* pump[low][high] is rate (s^-1) from lower to upper level */
	  **pump,
	  **CollRate,
	  *pops,
	  *depart,
	  /* statistical weight */
	  *stat ,
	  /* excitation energies in kelvin */
	  *excit;

	static long int **ipdest;

	static int lgFirst=TRUE;
	long int i,
		j,
	ilo , 
	ihi,
	nUsed;
	int lgDeBug,lgNegPop;
	double rot_cooling , dCoolDT ;

#	ifdef DEBUG_FUN
	fputs( "<+>RotateCooling()\n", debug_fp );
#	endif

	if( lgFirst )
	{
		/* will never do this again */
		lgFirst = FALSE;
		/* allocate the 1D arrays*/
		if( (excit = (double *)MALLOC( sizeof(double)*(size_t)(nCORotate+1) )) == NULL )
		{ 
			printf( " not enough memory to allocate excit in RotateCooling\n" );
			puts( "[Stop in RotateCooling]" );
			cdEXIT(EXIT_FAILURE);
		}
		if( (stat = (double *)MALLOC( sizeof(double)*(size_t)(nCORotate+1) )) == NULL )
		{ 
			printf( " not enough memory to allocate stat in RotateCooling\n" );
			puts( "[Stop in RotateCooling]" );
			cdEXIT(EXIT_FAILURE);
		}
		if( (pops = (double *)MALLOC( sizeof(double)*(size_t)(nCORotate+1) )) == NULL )
		{ 
			printf( " not enough memory to allocate pops in RotateCooling\n" );
			puts( "[Stop in RotateCooling]" );
			cdEXIT(EXIT_FAILURE);
		}
		if( (depart = (double *)MALLOC( sizeof(double)*(size_t)(nCORotate+1) )) == NULL )
		{ 
			printf( " not enough memory to allocate depart in RotateCooling\n" );
			puts( "[Stop in RotateCooling]" );
			cdEXIT(EXIT_FAILURE);
		}
		/* create space for the 2D arrays */
		if( (pump = ((double **)MALLOC((size_t)(nCORotate+1)*sizeof(double *)))) == NULL )
		{
			fprintf(ioQQQ," RotateCooling could not malloc1 pump\n");
			puts( "[Stop in RotateCooling]" );
			cdEXIT(EXIT_FAILURE);
		}
		if( (CollRate = ((double **)MALLOC((size_t)(nCORotate+1)*sizeof(double *)))) == NULL )
		{
			fprintf(ioQQQ," RotateCooling could not malloc1 CollRate\n");
			puts( "[Stop in RotateCooling]" );
			cdEXIT(EXIT_FAILURE);
		}
		if( (dest = ((double **)MALLOC((size_t)(nCORotate+1)*sizeof(double *)))) == NULL )
		{
			fprintf(ioQQQ," RotateCooling could not malloc1 dest\n");
			puts( "[Stop in RotateCooling]" );
			cdEXIT(EXIT_FAILURE);
		}
		if( (data = ((double **)MALLOC((size_t)(nCORotate+1)*sizeof(double *)))) == NULL )
		{
			fprintf(ioQQQ," RotateCooling could not malloc1 data\n");
			puts( "[Stop in RotateCooling]" );
			cdEXIT(EXIT_FAILURE);
		}
		if( (ipdest = ((long int **)MALLOC((size_t)(nCORotate+1)*sizeof(long int *)))) == NULL )
		{
			fprintf(ioQQQ," RotateCooling could not malloc1 ipdest\n");
			puts( "[Stop in RotateCooling]" );
			cdEXIT(EXIT_FAILURE);
		}
		for( i=0; i<(nCORotate+1); ++i )
		{
			if( (pump[i] = ((double *)MALLOC((size_t)(nCORotate+1)*sizeof(double )))) == NULL )
			{
				fprintf(ioQQQ," RotateCooling could not malloc2 pump\n");
				puts( "[Stop in RotateCooling]" );
				cdEXIT(EXIT_FAILURE);
			}
			if( (CollRate[i] = ((double *)MALLOC((size_t)(nCORotate+1)*sizeof(double )))) == NULL )
			{
				fprintf(ioQQQ," RotateCooling could not malloc2 CollRate\n");
				puts( "[Stop in RotateCooling]" );
				cdEXIT(EXIT_FAILURE);
			}
			if( (dest[i] = ((double *)MALLOC((size_t)(nCORotate+1)*sizeof(double )))) == NULL )
			{
				fprintf(ioQQQ," RotateCooling could not malloc2 dest\n");
				puts( "[Stop in RotateCooling]" );
				cdEXIT(EXIT_FAILURE);
			}
			if( (data[i] = ((double *)MALLOC((size_t)(nCORotate+1)*sizeof(double )))) == NULL )
			{
				fprintf(ioQQQ," RotateCooling could not malloc2 data\n");
				puts( "[Stop in RotateCooling]" );
				cdEXIT(EXIT_FAILURE);
			}
			if( (ipdest[i] = ((long int *)MALLOC((size_t)(nCORotate+1)*sizeof(double )))) == NULL )
			{
				fprintf(ioQQQ," RotateCooling could not malloc2 ipdest\n");
				puts( "[Stop in RotateCooling]" );
				cdEXIT(EXIT_FAILURE);
			}
		}
	}

	/* all elements are used, and must be set to zero if zero */
	for( i=0; i < (nCORotate+1); i++ )
	{
		for( j=0; j < (nCORotate+1); j++ )
		{
			data[j][i] = -1e33;
			dest[j][i] = 0.;
			pump[j][i] = 0.;
			ipdest[j][i] = 0;
		}
		data[i][i] = 0.;
	}

	/* the statistical weights of the levels */
	for( j=0; j < nCORotate; j++ )
	{
		/* statistical weights for each level */
		stat[j] = (*Rotate)[j].gLo;
	}
	/* this is the highest level, which is one more than the highest line */
	stat[nCORotate] = (*Rotate)[nCORotate-1].gHi;

	/* set up the excitation potentials of each level relative to ground -
	 * the struc saves the energy of the line only */
	excit[0] = 0.;
	for( j=1; j < nCORotate; j++ )
	{
		/* excitation energy of each level relative to ground, in K */
		excit[j] = excit[j-1] + (*Rotate)[j-1].EnergyK;
	}

	/* this is the highest level, which is one more than the highest line */
	excit[nCORotate] = excit[nCORotate-1] + (*Rotate)[nCORotate-1].EnergyK;

	nUsed = nCORotate;
	/* this derives largest molecule that can be inverted at this
	 * temperature.  Need boltzmann factors to be positive for all levels */
	while( (excit[nUsed] > phycon.te*20.) && (nUsed > 1) )
	{
		--nUsed;
	}
	/*fprintf(ioQQQ,"%.1e %li %li \n", phycon.te, nUsed, nCORotate);*/

	for( j=0; j < nCORotate; j++ )
	{
		data[j][j+1] = (*Rotate)[j].Aul*((*Rotate)[j].Pesc + (*Rotate)[j].Pelec_esc);
		dest[j][j+1] = (*Rotate)[j].Aul*(*Rotate)[j].Pdest;
		/* this is trick to make H2 cs that will work when multiplied by electron density */
		(*Rotate)[j].cs = 1.;
		data[j+1][j] = (*Rotate)[j].cs*hmi.htwo/phycon.eden ;
		/* temporary kludge to have cs data from ground */
		pump[j][j+1] = (*Rotate)[j].pump;
		/* the continuum indices are on the f, not c, scale, and will be passed to 
		 * LevelN, which works on f, not c, scale */
		ipdest[j][j+1] = (*Rotate)[j].ipCont;
	}

	/* next loop for collisional transitions that have delta J >1 */
	for( ilo=0; ilo < nCORotate-1; ilo++ )
	{
		/* need to have upper limit to to nCORotate because 
		 * number ov levels is 1 gt number of lines*/
		for( ihi=ilo+2; ihi <= nCORotate; ihi++ )
		{
			data[ihi][ilo] = 1. *hmi.htwo/phycon.eden ;
			/* these are escape and dest rates, which are zero for a rigid rotator */
			data[ilo][ihi] = 0 ;
			dest[ilo][ihi] = 0 ;
		}
	}

	/* now evaluate the H2 collision rates */
	/* >>refer	H2	collision de Jong, T., Chu, S-I., & Dalgarno, A. 1975, ApJ, 199, 69 */
	/* recall one more level than lines */
	for( ilo=0; ilo < nCORotate; ilo++ )
	{
		/* need to have upper limit to to nCORotate because 
		 * number ov levels is 1 gt number of lines*/
		for( ihi=ilo+1; ihi <= MIN2(nCORotate,ilo+5); ihi++ )
		{
			double a[5]={1.66, 2.80, 1.19, 1.00, 1.30 };
			double b[5]={1.67, 1.47, 1.85, 1.55, 2.24 };
			/* >>refer	CO	collision, McKee, C.F., Storey, J.W.V., Watson, D.M., & Green, S., 1982, ApJ, 259, 647 */
			/* footnote to their table 1 says He collisions are 1.37 slower than H2 collisions*/
			double collid = hmi.htwo + xIonFracs[ipHELIUM][0]/1.37;

			/* first do deexcitation rate, equation 17 of deJong et al. */
			CollRate[ihi][ilo] = a[ihi-ilo-1]*1.e-10*(*Rotate)[ilo].gLo/(*Rotate)[ilo].gHi*
				(1.+(excit[ihi]-excit[ilo])/phycon.te) *
				sexp( b[ihi-ilo-1]*sqrt((excit[ihi]-excit[ilo])/phycon.te) )*collid;

			/* now get excitation rate */
			CollRate[ilo][ihi] = CollRate[ihi][ilo]*
				sexp( (excit[ihi]-excit[ilo])/phycon.te )*
				(*Rotate)[ilo].gHi / (*Rotate)[ilo].gLo;

			/* debug print statement */
			/*fprintf(ioQQQ," %li %li %.2e %.2e \n",ilo, ihi, 
				CollRate[ihi][ilo]/hmi.htwo  , CollRate[ilo][ihi]/hmi.htwo );*/
		}
		/* finish off with zeros */
		for( ihi=ilo+6; ihi <= nCORotate; ihi++ )
		{
			CollRate[ihi][ilo] = 0.;
			CollRate[ilo][ihi] = 0.;
		}
	}

	lgDeBug = FALSE;

	LevelN(
		/* number of levels is number of lines plus one */
		/* set nUsed so that CO is evaluated even at very low temperatures */
		nUsed+1, /*nCORotate+1,*/
		abund,
		stat,
		excit,
		pops,
		depart,
		&data,
		&dest,
		&pump,
		&CollRate,
		/* say that we have evaluated the collision rates already */
		TRUE,
		&ipdest,
		&rot_cooling,
		&dCoolDT,
		chLabel,
		/* lgNegPop positive if negative pops occured, negative if too cold */
		&lgNegPop,
	    lgDeBug );/* option to print suff - set to true for debug printout */

	/* put cooling into place where we can use it later */
	*Cooling = (float)rot_cooling;
	*dCoolingDT = (float)dCoolDT;

	/* derivative of cooling function 
	cooling.dCooldT += dCoolDT;*/

	/* zero out higher populations for case where full CO levels not done */
	for( i=nUsed+1; i<=nCORotate; ++i )
	{
		pops[i] = 0.;
		depart[i] = 0.;
	}

	/* can only define first LIMLEVELN elements, the vector's length */
	for( i=0; i< MIN2(LIMLEVELN,nCORotate) ; ++i )
	{
		PopLevls.PopLevels[i] = pops[i];
		PopLevls.DepLTELevels[i] = depart[i];
	}

	if( lgNegPop > 0 )
	{
		fprintf(ioQQQ,"RotateCooling called LevelN which returned negative populations.\n");
	}

	/* now establish information that is passed out to rest of code's infrastructure */
	for( j=0; j<nCORotate; ++j )
	{
		double EnrLU, EnrUL;
		/* lower upper populations, stim emission correct population */
		(*Rotate)[j].PopLo = pops[j];
		(*Rotate)[j].PopHi = pops[j+1];
		(*Rotate)[j].PopOpc = (pops[j] - pops[j+1]*(*Rotate)[j].gLo/(*Rotate)[j].gHi);

		/* number of photons in the line */
		(*Rotate)[j].phots = (*Rotate)[j].Aul*((*Rotate)[j].Pesc + (*Rotate)[j].Pelec_esc)*pops[j+1];

		/* local ots rates, added to line ots array */
		(*Rotate)[j].ots = (*Rotate)[j].Aul*(*Rotate)[j].Pdest*(float)pops[j+1];
		RT_OTS_AddLine( (*Rotate)[j].ots , (*Rotate)[j].ipCont);

		/* the intensity in the line */
		(*Rotate)[j].xIntensity = (*Rotate)[j].phots*(*Rotate)[j].EnergyErg;

		/* ratio of collisional to total excitation */
		(*Rotate)[j].ColOvTot = (float)(CollRate[j][j+1]/(CollRate[j][j+1]+(*Rotate)[j].pump) );

		/* AovTot, used to estimate fraction of line coming from coll vs pump */
		(*Rotate)[j].AovTot = (float)((*Rotate)[j].Aul*((*Rotate)[j].Pesc + (*Rotate)[j].Pelec_esc)/
			((*Rotate)[j].Aul*((*Rotate)[j].Pesc + (*Rotate)[j].Pelec_esc) + CollRate[j+1][j] + 
			(*Rotate)[j].pump*(*Rotate)[j].gLo/(*Rotate)[j].gHi) );

		/* two cases - collisionally excited (usual case) or 
		 * radiatively excited - in which case line can be a heat source
		 * following are correct heat exchange, if will mix to get correct deriv */
		EnrLU = (*Rotate)[j].PopLo*CollRate[j][j+1]*(*Rotate)[j].EnergyErg;
		EnrUL = (*Rotate)[j].PopHi*CollRate[j+1][j]*(*Rotate)[j].EnergyErg;
		/* energy exchange due to this level
		 * net cooling due to excit minus part of de-excit */
		(*Rotate)[j].cool = EnrLU - EnrUL*(*Rotate)[j].ColOvTot;
		/* net heating is remainder */
		(*Rotate)[j].heat = EnrUL*(1.f - (*Rotate)[j].ColOvTot);
		/* do not add to cooling, since done with evaluated cooling from LevelN */
		/*coladd( chLabel, (long)t10->WLAng , t10->cool);*/
	}

	/* generate flag if co cooling important and highest level is fainter
	 * than second highest level */
	if( rot_cooling / cooling.ctot > 0.1 && 
		(*Rotate)[nUsed-1].xIntensity > (*Rotate)[nUsed-2].xIntensity)
	{
		co.lgCOCoolCaped = TRUE;
	}

#	ifdef DEBUG_FUN
	fputs( " <->RotateCooling()\n", debug_fp );
#	endif
	return;
}
/*lint +e506 constant value Boolean */
#undef NMOLE
