/*cloudy the main routine, this IS Cloudy, ret 0 normal exit, 1 error exit,
 * called by maincl when used as standalone program */
/*BadStart announce that things are so bad the calculation cannot even start */
#include "cddefines.h"
#include "itercnt.h"
#include "prtheader.h"
#include "punch.h"
#include "prtcomment.h"
#include "called.h"
#include "noexec.h"
#include "lines.h"
#include "firstdr.h"
#include "continuum.h"
#include "warnings.h"
#include "createdata.h"
#include "nextdr.h"
#include "converge.h"
#include "setabundances.h"
#include "warngs.h"
#include "parse.h"
#include "prtfinal.h"
#include "opacity.h"
#include "rt.h"
#include "assertresults.h"
#include "startendzone.h"
#include "startenditer.h"
#include "lgendfun.h"
#include "plot.h"
#include "radinc.h"
#include "sanitycheck.h"
#include "cloudy.h"

/*BadStart announce that things are so bad the calculation cannot even start */
static void BadStart(void);

/* returns 1 if disaster strikes, 0 if everything appears ok */
int cloudy(void)
{
	int lgOK,
		/* will be used to remember why we stopped, 
		 * return error exit in some cases */
		lgBadEnd;

	/* 
	 * this is the main routine to drive the modules that compute a model
	 * when cloudy is used as a stand-alone program 
	 * the main program (maincl) calls cdInit then cdDrive
	 * this sub is called by cdDrive which returns upon exiting
	 *
	 * this routine uses the following variables:
	 *
	 * nzone 
	 * this is the zone number, and is incremented here
	 * logical function lgEndFun returns a true condition if NZONE reaches
	 * NEND(ITER), the limit to the number of zones in this iteration
	 * nzone is totally controlled in this subroutine
	 *
	 * iteration 
	 * this is the iteration number, it is 1 for the first iteration
	 * and is incremented in this subroutine at the end of each iteration
	 *
	 * IterCnt.itermx
	 * this is the limiit to the number of iterations, and is entered
	 * by the user
	 * This routine returns when iteration > IterCnt.itermx
	 */

	/* NZONE is zero while initial search for conditions takes place */
	nzone = 0;

	/* iteration is iteration number, cal complete when iteration > IterCnt.itermx */
	iteration = 1;

	/* flag for error exit */
	lgBadEnd = FALSE;

	/* scan in and parse input data */
	ParseCommands();

	/* >>chng 01 oct 16, move ContCreateMesh back to just before CreateData so that
	 * path and mesh size can be set with commands before mesh is set */
	/* >>chng 01 aug 19, move ContCreateMesh from just after, to just before,
	 * ParseCommands, to allocate all needed vectors */
	/* calls fill to set up continuum energy mesh if first call, 
	 * otherwise reset to original mesh */
	ContCreateMesh();

	/* create several data sets by allocating memory and reading in data files, 
	 * but only if this is first call */
	CreateData();

	/* fix pointers to ionization edges and frequency array
	 * calls iso_create
	 * this routine has internal check for whether ever called before,
	 * if only returns if this is a later call of code */
	ContCreatePointers();

	/* fix abundances of elements */
	SetAbundances();

	/* set continuum normalization, continuum itself, and ionization stage limits */
	ContSetIntensity(&lgOK);

	/* print header */
	PrtHeader();

	/* this is an option to stop after printing header only */
	if( noexec.lgNoExec )
		return(0);

	/* this happens when disaster strikes in the inital setup of the continuum intensity array */
	if( !lgOK )
	{
		BadStart();
		return(1);
	}

	/* guess some outward optical depths, set inward optical depths, 
	 * also calls RTMake so escap probs ok before printout of trace */
	RTOptDepthInit();

	/* generate inital set of opacities, but only if this is the first call 
	 * in this coreload */
	OpacityCreateAll();

	/* this checks that various parts of the code still work properly */
	SanityCheck("begin");

	/* find the initial temperature, punt if initial conditions outside range of code,*/
	if( ConvInitTemp() )
	{
		BadStart();
		return(1);
	}

	/* set thickness of first zone */
	FirstDR();

	/* find thickness of next zone */
	NextDR();

	/* set up some zone variables, correct continuum for sphercity, 
	 * after return, radius is equal to the inner radius, not outer radius
	 * of this zone */
	StartZone("init");

	plot("FIRST");

	/* outer loop is over number of iterations*/
	while( TRUE )
	{
		StartIter();
		nzone = 0;

		/* loop over zones across cloud for this iteration, 
		 * lgEndFun checks whether model is complete and this iteration is done
		 * returns TRUE is current iteration is complete */
		while( !lgEndFun() )
		{
			++nzone;

			/* set variable dealing with new radius, in startendzone.c */
			StartZone("incr");

			/* converge the pressure-temperature-ionization solution for this zone */
			ConvPresTempEdenIoniz();

			/* use changes in opacity, temperature, ionization, to fix new dr for next zone */
			NextDR();

			/* generate diffuse emission from this zone, add to outward & reflected beams */
			RTDiffuse();

			/* do work associated with incrementing this radius, 
			 * total attenuation and dilution of radiation fields takes place here,
			 * reflected continuum incremented here*/
			RadInc();

			/* increment optical depths */
			RTOptDepthIncre();

			/* >>chng 99 may 04, move lines here from after RTDiffuse */
			/* fill in emission line array, adds outward lines */
			/* >>chng 99 dec 29, moved to here from below RTOptDepthIncre, 
			 * lines adds lines to outward beam,
			 * and these are attenuated in RadInc */
			lines();

			/* now that optical depths have been incremented, do escape prob */
			RTMake(TRUE);

			/* possibly punch out some results from this zone */
			PunchDo("MIDL");

			/* do some things to finish out this zone */
			EndZone();
		}

		/* close out this iteration */
		EndIter();

		/* print out some comments, generate warning and cautions*/
		PrtComment();

		/* punch stuff only needed on completion of this iteration */
		PunchDo("LAST" );

		/* second call to plot routine, to complete plots for this iteration */
		plot("SECND");

		/* print out the results */
		PrtFinal();

		/* this is the normal exit, occurs if we reached limit to number of iterations,
		 * or if code has set busted */
		if( iteration > IterCnt.itermx || called.lgBusted )
			break;

		/* reset limiting and initial optical depth variables, in rtoptdepthinit */
		RTOptDepthReset();

		/* increment iteration counter */
		++iteration;

		/* reinitialize some variables to initial conditions at previous first zone
		 * routine in startenditer.c */
		RestartIter();

		/* reset zone number to 0 - done here since this is only routine that sets nzone */
		nzone = 0;

		/* now redo escape probabilities */
		RTMake(TRUE);

		StartZone("init");

		/* find new first temperature, punt if gas totally cold and molecular */
		if( ConvInitTemp() )
		{ 
			lgBadEnd = TRUE;
			break;
		}
	}

	ClosePunchFiles();

	/* this checks that various parts of the code worked properly */
	SanityCheck("final");

	/* check whether any asserts were present and failed.  
	 * return is true if ok, false if not.  routine also checks
	 * number of warnings and returns false if not ok */
	lgOK = lgCheckAsserts(ioQQQ);

	if( lgOK && !warngs.lgWarngs && !lgBadEnd)
	{
		/* no failed asserts or warnings */
		return(0);
	}
	else
	{
		/* there were failed asserts or warnings */
		return(1);
	}

}

/*BadStart announce that things are so bad the calculation cannot even start */
static void BadStart(void)
{
	char chLine[INPUT_LINE_LENGTH];

#	ifdef DEBUG_FUN
	fputs( "<+>BadStart()\n", debug_fp );
#	endif

	/* initialize the line saver */
	wcnint();
	sprintf( warnings.chRgcln[0], "   Calculation stopped because initial conditions out of bounds." );
	sprintf( chLine, " W-Calculation could not begin." );
	warnin(chLine);
	called.lgBusted = TRUE;

#	ifdef DEBUG_FUN
	fputs( " <->BadStart()\n", debug_fp );
#	endif
	return;
}

