/*Zerologic set initial values for logical variables */
#ifdef _MSC_VER
#	pragma warning( disable : 4305 )/* disable const double to float warning in MS VS*/
#endif
#include "cddefines.h"
#include "kshllenr.h"
#include "crsnut.h"
#include "mappar.h"
#include "didz.h"
#include "recom.h"
#include "con0.h"
#include "assav.h"
#include "extinc.h"
#include "plot.h"
#include "dump.h"
#include "atomcwgt.h"
/*  */
/* following used to enter total predicted continuum into emission line array 
 * actually entered into line array in lineset1
 */
#include "predcont.h"
/* energies where diffuse continuuum is to be entered into line array 
 * variables are declared in predcont.h, where array dimensioned 
 * NB - if these numbers change, the wavelength in the printout will change 
 * too, since the wavelength is derived form this */
/* >>>chng 99 mar 23, adjusted energies so that wavelength line list is
 * the same as it was in C90 - small changes were caused by going over
 * to proper rydberg constant */
float EnrPredCont[NPREDCONT] = {
	  7.445e-04 
	, 1.498e-03 
	, 2.211e-03 
	, 2.952e-03 
	, 3.677e-03 
	, 3.7501e-03 /* Ney-Allen */
	, 3.9915e-03 /* Ney-Allen */
	, 4.2543e-03 /* Ney-Allen */
	, 4.314e-03 
	, 4.6446e-03 /* Ney-Allen */
	, 5.162e-03 
	, 5.2462e-03 /* Ney-Allen */
	, 5.8079e-03 /* Ney-Allen */
	, 6.240e-03 
/* 	, 7.320e-03  */
	, 7.3312e-03 /* Ney-Allen */
	, 7.9936e-03 /* Ney-Allen */
	, 8.7119e-03 /* Ney-Allen */
	, 9.6125e-03 /* Ney-Allen */
	, 9.772432e-03
	, 1.1099e-02 /* Ney-Allen */
	, 1.2022e-02 /* Ney-Allen */
	, 1.29253e-02f 
	, 2.2152e-02 
	, 3.920443e-02 
	, 5.54593e-02f 
	/* next two either side of n=4 edge of hydrogen, set to 1.5% off either direction*/
	/* >>chng 00 sep 18, had been too close in energy */
	, 6.1563e-02 
	, 6.3437e-02 
	, 8.1460e-02 
	/* >>chng 00 sep 14, changed energies of paschen jump to be farther away as
	 * per note on BJ */
	, 0.1094 
	, 0.1128 
	, 0.14675 
	, 0.18653 
	/* >>chng 00 sep 14, next two energies changed since they were too close to BJ
	 * and so both ended up shortward of limit*/
	, 0.246   /* these two are the Balmer jump, below and above. */
	, 0.254  /* continuum binning not much better than 1% so offset energyies by more */
	, 0.38096 
	, 0.43994 
	, 0.44394 
	, 0.50811 
	, 0.57489
	, 0.62487 
	, 0.67155 
	, 0.70244 
	, 0.72163 
	, 0.74812 
	, 0.76172 
	, 0.77551 
	, 0.79681 
	, 0.81859 
	, 0.8260 
	, 0.84859 
	, 0.85618 
	, 0.87967 
	, 0.911267 /*exactly 1000A */ 
	/* points on either side of Lyman jump,
	 * energies changed to be robust when energy grid changes,
	 * grid resolution is about 1%, so change from 0.99783 and 1.000
	 * to 1 +/- 1.5%
	 * >>chng 00 sep 23 change wavelength points for next two */
	, 0.985 
	, 1.015 
	, 1.199 
	, 1.299 
	, 1.4984 
	, 1.58441 
	/* points on either side of Lyman jump,
	 * energies changed to be robust when energy grid changes,
	 * grid resolution is about 1%, so change from 1.80433 and 1.809
	 * to 1.807 +/- 1.5%
	 * >>chng 00 sep 23 change wavelength points for next two */
	, 1.780 
	, 1.834 
	, 2.283};

long int ipPredCont[NPREDCONT];
#include "heavy.h"
#include "wkhtcl.h"
#include "phycon.h"
#include "printit.h"
#include "fudgec.h"
#include "thermal.h"
#include "norm.h"
#include "dampon.h"
#include "itercnt.h"
#include "filfac.h"
#include "egray.h"
#include "noexec.h"
#include "trovrd.h"
#include "moldrv.h"
#include "autoit.h"
#include "vary.h"
#include "timed.h"
#include "reason.h"
#include "drmnon.h"
#include "strkon.h"
#include "freeon.h"
#include "fston.h"
#include "trace.h"
#include "thigh.h"
#include "sphere.h"
#include "nomole.h"
#include "recoil.h"
#include "cyclot.h"
#include "hextra.h"
#include "zero.h"
/*
 * long names of elements 
 * ok here since never change */
/*#include "elementnames.h"*/
struct /*t_elementnames*/ {

/* definition of this is in zerologic, where it is also initialized
 * THIS FILE MUST BE KEPT PARALLEL WITH THE DEFINITIOND IN zerologic.c */
	/* names are LIMELM+2 since c12o and c13o are last two */
	char chElementName[LIMELM+2][11] ;

	char chElementNameShort[LIMELM+2][5] ;

	/* symbols for elements, used in various printouts */
	char chElementSym[LIMELM+2][3] ;

	/* ionization stages */
	char chIonStage[LIMELM+3][3] ;

	/* string giving ionization stage as roman numerals */
	char chIonRoman[LIMELM+3][7];

} elementnames = {

	/*char chElementName[LIMELM+2][11] = */
	{
	 "Hydrogen  " ,
	 "Helium    " ,
	 "Lithium   " ,
	 "Beryllium " ,
	 "Boron     " ,
	 "Carbon    " ,
	 "Nitrogen  " ,
	 "Oxygen    " ,
	 "Fluorine  " ,
	 "Neon      " ,
	 "Sodium    " ,
	 "Magnesium " ,
	 "Aluminium " ,
	 "Silicon   " ,
	 "Phosphorus" ,
	 "Sulphur   " ,
	 "Chlorine  " ,
	 "Argon     " ,
	 "Potassium " ,
	 "Calcium   " ,
	 "Scandium  " ,
	 "Titanium  " ,
	 "Vanadium  " ,
	 "Chromium  " ,
	 "Manganese " ,
	 "Iron      " ,
	 "Cobalt    " ,
	 "Nickel    " ,
	 "Copper    " ,
	 "Zinc      " ,
	 "C12O18    " ,
	 "C13O18    " ,
	},

	 /*char chElementNameShort[LIMELM][5] = */
	 {
 	 "HYDR" ,
	 "HELI" ,
	 "LITH" ,
	 "BERY" ,
	 "BORO" ,
	 "CARB" ,
	 "NITR" ,
	 "OXYG" ,
	 "FLUO" ,
	 "NEON" ,
	 "SODI" ,
	 "MAGN" ,
	 "ALUM" ,
	 "SILI" ,
	 "PHOS" ,
	 "SULP" ,
	 "CHLO" ,
	 "ARGO" ,
	 "POTA" ,
	 "CALC" ,
	 "SCAN" ,
	 "TITA" ,
	 "VANA" ,
	 "CHRO" ,
	 "MANG" ,
	 "IRON" ,
	 "COBA" ,
	 "NICK" ,
	 "COPP" ,
	 "ZINC" ,
	 "12CO" ,
	 "13CO" ,
	 },

	/* symbols for elements, used in various printouts */
	 /*char elementnames.chElementSym[LIMELM][3] = */
	 { 
		"H " ,
		"He" ,
		"Li" ,
		"Be" ,
		"B " ,
		"C " ,
		"N " ,
		"O " ,
		"F " ,
		"Ne" ,
		"Na" ,
		"Mg" ,
		"Al" ,
		"Si" ,
		"P " ,
		"S " ,
		"Cl" ,
		"Ar" ,
		"K " ,
		"Ca" ,
		"Sc" ,
		"Ti" ,
		"V " ,
		"Cr" ,
		"Mn" ,
		"Fe" ,
		"Co" ,
		"Ni" ,
		"Cu" ,
		"Zn" ,
		"12" ,
	    "13"} ,

	/* ionization stages */
	 /*char chIonStage[LIMELM+1][3] =*/
		{
		" 1" ,
		" 2" ,
		" 3" ,
		" 4" ,
		" 5" ,
		" 6" ,
		" 7" ,
		" 8" ,
		" 9" ,
		"10" ,
		"11" ,
		"12" ,
		"13" ,
		"14" ,
		"15" ,
		"16" ,
		"17" ,
		"18" ,
		"19" ,
		"20" ,
		"21" ,
		"22" ,
		"23" ,
		"24" ,
		"25" ,
		"26" ,
		"27" ,
		"28" ,
		"29" ,
		"30" ,
		"31" ,
		/* this is special for molecule */
		"CO",
		"CO"
		} ,

	/* ionization stages as roman numeral */
	 /*char chIonRoman[LIMELM+1][7] =*/
		{
		"I" ,
		"II" ,
		"III" ,
		"IV" ,
		"V" ,
		"VI" ,
		"VII" ,
		"VIII" ,
		"IX" ,
		"X" ,
		"XI" ,
		"XII" ,
		"XIII" ,
		"XIV" ,
		"XV" ,
		"XVI" ,
		"XVII" ,
		"XVIII" ,
		"XIX" ,
		"XX" ,
		"XXI" ,
		"XXII" ,
		"XXIII" ,
		"XXIV" ,
		"XXV" ,
		"XXVI" ,
		"XXVII" ,
		"XXVIII" ,
		"XXIX" ,
		"XXX" ,
		"XXXI" ,
		/* this is special for molecule */
		"  ",
		"  "
		} 
	};

void Zerologic(void)
{
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>Zerologic()\n", debug_fp );
#	endif

	/* drChange was reset to get orion flux in h-beta correct
	 * drChange is really tau of current zone */
	didz.drChange = 0.15;

	crsnut.CrsSecNeutron = 4e-26;

	/* parameters having to do with thermal map */
	MapPar.RangeMap[0] = 10.;
	MapPar.RangeMap[1] = .99e10;
	MapPar.MapZone = 9999;
	MapPar.lgMapOK = TRUE;
	MapPar.lgMapDone = FALSE;
	MapPar.nMapStep = 20;
	/* will be reset to positive number when map actually done */
	MapPar.nMapAlloc = 0;
	MapPar.nmap = 0;

	/* form of escape and dest probs for subordinte lines
	strcpy( rt.chDstFun, "  K2" );
	strcpy( rt.chEscFunSubord, "CRDW" ); */

	/* redistribution function for La
	strcpy( rt.chRedisLa, "INCO" ); */

	/* upper limit to energies of inner shell opacities in ryd
	 * this is 1 mev by default */
	KshllEnr.EnergyKshell = 7.35e4;

	dump.nzdump = -100;

	/* constant for the extinguish command */
	extinc.excolm = 0.;
	extinc.exleak = 0.;
	extinc.exlow = 1.;
	/* the constant that multiplies the column density to get optical depth */
	extinc.cnst_col2optdepth = 6.22e-18f ;
	/* the power on the energy */
	extinc.cnst_power = -2.43f ;

	con0.lgCoStarInterpolationCaution = FALSE;
	con0.lgCon0 = FALSE;

	/* list of shells, 1 to 7 */
	strcpy( Heavy.chShell[0], "1s" );
	strcpy( Heavy.chShell[1], "2s" );
	strcpy( Heavy.chShell[2], "2p" );
	strcpy( Heavy.chShell[3], "3s" );
	strcpy( Heavy.chShell[4], "3p" );
	strcpy( Heavy.chShell[5], "3d" );
	strcpy( Heavy.chShell[6], "4s" );

	/* zero out diffuse recombinaiton emission arrays */
	for( i=0; i < LIMELM; i++ )
	{
		int j;
		for( j=0; j < (LIMELM - 1); j++ )
		{
			Heavy.xLyaHeavy[j][i] = 0.;
		}
	}

	/* threshold for faintest heating cooling to punch with 
	 * punch heating or punch cooling commands,
	 * can be reset with PUNCH WEAKHEATCOOL command */
	WkHtCl.WeakHeatCool = 0.05;

	/* list of atomic weights, mass in amu, used for thermal line widths */
	/* >>refer	all	atomic weight	Coplen, T.B. 2001, J. Phys. Chem REf Data, 30, 701 */
	AtomcWgt.AtomicWeight[0] = 1.00794;
	AtomcWgt.AtomicWeight[1] = 4.0026022;
	AtomcWgt.AtomicWeight[2] = 6.9412;
	AtomcWgt.AtomicWeight[3] = 9.0121823;
	AtomcWgt.AtomicWeight[4] = 10.8117;
	AtomcWgt.AtomicWeight[5] = 12.01078;
	AtomcWgt.AtomicWeight[6] = 14.00672;
	AtomcWgt.AtomicWeight[7] = 15.99943;
	AtomcWgt.AtomicWeight[8] = 18.9984032;
	AtomcWgt.AtomicWeight[9] = 20.17976;
	AtomcWgt.AtomicWeight[10] = 22.989770;
	AtomcWgt.AtomicWeight[11] = 24.30506;
	AtomcWgt.AtomicWeight[12] = 26.9815382;
	AtomcWgt.AtomicWeight[13] = 28.08553;
	AtomcWgt.AtomicWeight[14] = 30.9737612;
	AtomcWgt.AtomicWeight[15] = 32.0655;
	AtomcWgt.AtomicWeight[16] = 35.4532;
	AtomcWgt.AtomicWeight[17] = 39.9481;
	AtomcWgt.AtomicWeight[18] = 39.09831;
	AtomcWgt.AtomicWeight[19] = 40.0784;
	AtomcWgt.AtomicWeight[20] = 44.9559108;
	AtomcWgt.AtomicWeight[21] = 47.8671;
	AtomcWgt.AtomicWeight[22] = 50.94151;
	AtomcWgt.AtomicWeight[23] = 51.99616;
	AtomcWgt.AtomicWeight[24] = 54.9380499;
	AtomcWgt.AtomicWeight[25] = 55.8472;
	AtomcWgt.AtomicWeight[26] = 58.9332009;
	AtomcWgt.AtomicWeight[27] = 58.69342;
	AtomcWgt.AtomicWeight[28] = 63.5463;
	AtomcWgt.AtomicWeight[29] = 65.392;

	noexec.lgNoExec = FALSE;

	phycon.hden = -99.f;

	/* default no printing of optical depths, TooFaint is .1 */
	printit.lgPrtTau = FALSE;
	printit.PrtTauFnt = 0.1;
	printit.lgPrtShort = FALSE;
	printit.TooFaint = 1e-3;
	printit.lgFaintOn = TRUE;
	printit.lgFntSet = FALSE;

	/* if true then print main block of lines as array,
	 * set false with print lines column, will then
	 * do a single column of lines */
	printit.lgPrtLineArray = TRUE;
	/* when printing a column this is option to print linear rather than log */
	printit.lgPrtLineLog = TRUE;

	/* print ages */
	printit.lgPrnAges = FALSE;
	/* print column densities */
	printit.lgPrintColumns = FALSE;
	/* option to sort lines by wavelength, print sort command */
	printit.lgSortLines = FALSE;
	printit.lgPrtMaser = FALSE;
	printit.lgPrintTime = TRUE;
	
	printit.lgPrtCont = FALSE;
	printit.lgPrnDiff = FALSE;
	printit.lgPrnPump = FALSE;
	printit.lgPrnInwd = FALSE;
	printit.lgPrnColl = FALSE;
	printit.lgPrnHeat = FALSE;
	/* >>chng 00 dec 08, these determine the standard items included in "nFnu", PvH */
	printit.lgSourceReflected = TRUE;
	printit.lgSourceTransmitted = FALSE;
	printit.lgDiffuseInward = TRUE;
	printit.lgDiffuseOutward = TRUE;
	printit.lgPrtLastIt = FALSE;
	printit.lgOnlyZone = FALSE;
	printit.lgOnlyHead = FALSE;
	printit.lgPrtStart = FALSE;
	printit.nstart = 0;

	/* turn off printing of heating agents */
	printit.lgPrintHeating = FALSE;
	printit.lgPrtArry = FALSE;
	printit.lgPrintFluxEarth = FALSE;

	fudgec.nfudge = 0;

	for( i=0; i < NFUDGC; i++ )
	{
		fudgec.fudgea[i] = 0.;
	}

	for( i=0; i < ITRDIM; i++ )
	{
		IterCnt.IterPrnt[i] = 10000;
	}
	IterCnt.itermx = 0;
	iteration = 0;

	hextra.TurbHeat = 0.;
	/* >>chng 01 feb 22, had set this to 1e30, change to 0 as sentinal that is not used */
	hextra.turrad = 0.;
	hextra.turback = 0.;
	hextra.cryden = 0.;
	hextra.crpowr = 0.;
	hextra.crtemp = 0.;
	cyclot.CycloCoolCoef = 0.;

	/* following are in norm.h */
	/* index within the line in the line stack 
	 * default is Hbeta total - the third line in the stack
	 * first is a zero for sanity, second is a comment */
	norm.ipNormWavL = 2;
	norm.ipEmerNormWavL = 0;
	norm.WavLNorm = 4861.f;
	norm.lgNormFound = FALSE;
	norm.lgNormSet = FALSE;

	/* the label for the normalization line */
	strcpy( norm.chNormLab, "    " );

	/* the scale factor for the normalization line */
	norm.ScaleNormLine = 1.;

	thermal.lgTSetOn = FALSE;
	thermal.ForceTemp = 0.;

	dampon.DampOnFac = 1.;
	egray.EnerGammaRay = 7676.;
	filfac.fiscal = 1.;
	filfac.FillFac = 1.;
	filfac.filpow = 0.;
	strcpy( reason.chReason, "reason not specified." );

	timed.itime = 0;
	timed.dt = 0.;
	timed.tmt1 = 0.;
	timed.tmpwr = 0.;

	/* following were block data logic */
	strkon.lgStarkON = TRUE;
	vary.lgVaryOn = FALSE;
	fston.lgFstOn = TRUE;
	recoil.lgCompRecoil = TRUE;
	freeon.lgFreeOn = TRUE;

	trace.lgTraceInput = FALSE;
	trace.lgOpacBug = FALSE;
	trace.lgTrConvg = FALSE;
	trace.lgTr8446 = FALSE;
	trace.lgTrLevN = FALSE;
	trace.lgTrGant = FALSE;
	trace.lgOptcBug = FALSE;
	trace.lgTrace3Bod = FALSE;
	trace.lgOTSBug = FALSE;
	trace.lgTrMole = FALSE;
	trace.lgHeatBug = FALSE;
	trace.lgHeavyBug = FALSE;
	trace.lgBug2nu = FALSE;
	trace.lgDrBug = FALSE;
	trace.lgPtrace = FALSE;
	trace.lgDrv_cdLine = FALSE;
	trace.lgDustBug = FALSE;
	trace.lgComBug = FALSE;
	trace.lgHeBug = FALSE;
	trace.lgCarBug = FALSE;
	trace.lgCalBug = FALSE;
	trace.lgConBug = FALSE;
	trace.lgNeBug = FALSE;
	trace.lgFeBug = FALSE;
	trace.lgHBug = FALSE;
	trace.lgTrLine = FALSE;
	trace.lgHe1Bug = FALSE;
	trace.lgHe2Bug = FALSE;
	trace.lgHe3Bug = FALSE;
	trace.nznbug = 10000;
	trace.npsbug = 10000;
	trace.lgHBugFull = FALSE;
	trace.lgHeBugFull = FALSE;
	trace.lgTrace = FALSE;
	trace.lgPointBug = FALSE;
	trace.lgNeonBug = FALSE;
	trace.lgCoolTr = FALSE;
	trace.lgTrDiff = FALSE;

	/* default is open geometry, not sphere */
	sphere.lgSphere = FALSE;
	/* the radiative transport covering factor */
	sphere.covrt = 0.;
	/* the geometric covering factor */
	sphere.covgeo = 1.;
	/* default is expanding when sphere set */
	sphere.lgStatic = FALSE;
	/* option to tell code not to complain when sphere static done without iterating,
	 * set with (OK) option on sphere command */
	sphere.lgStaticNoIt = FALSE;
	/* this is exponent for emissivity contributing to observed luminosity, r^2.
	 * set to 1 with aperture slit, to 0 with aperture beam command */
	sphere.iEmissPower = 2;

	/* flags that turn off molecular network */
	nomole.lgNoH2Mole = FALSE;
	nomole.lgNoCOMole = FALSE;

	thigh.lgTeHigh = FALSE;

	/* parameters dealing with printer plots */
	for( i=0; i < NDPLOT; i++ )
	{
		plotCom.lgPltTrace[i] = FALSE;
	}

	/* this says what types of printer plots we will make */
	for( i=0; i < NDPLOT; i++ )
	{
		strcpy( plotCom.chPType[i], "NONE" );
	}
	plotCom.lgPlotON = FALSE;

	drmnon.lgDrMnOn = TRUE;

	for( i=0; i<4; ++i )
	{
		recom.GuessDiel[i] = 1.;
	}
	recom.lgVrrFit = TRUE;

	/* default condition is burgess supressed, nusbaumer and storye not */
	recom.lgSupDie[0] = TRUE;
	recom.lgSupDie[1] = FALSE;

	recom.lgNoCota = FALSE;
	for( i=0; i < LIMELM; i++ )
	{
		recom.CotaRate[i] = 0.;
	}
	recom.ilt = 0;
	recom.iltln = 0;
	recom.ilthn = 0;
	recom.ihthn = 0;
	recom.ifail = 0;
	recom.grecon = 1.;

	trovrd.lgTrOvrd = TRUE;
	autoit.lgAutoIt = FALSE;
	autoit.autocv = 0.20;
	moldrv.lgDriveMole = FALSE;

	/* used for hei */
	AsSav.HeAsSav[0][1] = 6.265e8;
	AsSav.HeAsSav[0][2] = 5.575e7;
	AsSav.HeAsSav[0][3] = 1.278e7;
	AsSav.HeAsSav[0][4] = 4.125e6;
	AsSav.HeAsSav[0][5] = 1.644e6;
	AsSav.HeAsSav[0][6] = 7.568e5;
	AsSav.HeAsSav[0][7] = 3.86e5;
	AsSav.HeAsSav[0][8] = 2.14e5;

	AsSav.HeAsSav[1][2] = 4.41e7;
	AsSav.HeAsSav[1][3] = 8.42e6;
	AsSav.HeAsSav[1][4] = 2.53e6;
	AsSav.HeAsSav[1][5] = 9.73e5;
	AsSav.HeAsSav[1][6] = 4.39e5;
	AsSav.HeAsSav[1][7] = 2.219e5;
	AsSav.HeAsSav[1][8] = 1.22e5;

	AsSav.HeAsSav[2][3] = 8.99e6;
	AsSav.HeAsSav[2][4] = 2.201e6;
	AsSav.HeAsSav[2][5] = 7.78e5;
	AsSav.HeAsSav[2][6] = 3.36e5;
	AsSav.HeAsSav[2][7] = 1.65e5;
	AsSav.HeAsSav[2][8] = 8.91e4;

	AsSav.HeAsSav[3][4] = 2.70e6;
	AsSav.HeAsSav[3][5] = 7.71e5;
	AsSav.HeAsSav[3][6] = 3.041e5;
	AsSav.HeAsSav[3][7] = 1.42e5;
	AsSav.HeAsSav[3][8] = 7.46e4;

	AsSav.HeAsSav[4][5] = 1.025e6;
	AsSav.HeAsSav[4][6] = 3.253e5;
	AsSav.HeAsSav[4][7] = 1.39e5;
	AsSav.HeAsSav[4][8] = 6.91e4;

	AsSav.HeAsSav[5][6] = 4.561e5;
	AsSav.HeAsSav[5][7] = 1.56e5;
	AsSav.HeAsSav[5][8] = 7.07e4;

	AsSav.HeAsSav[6][7] = 2.27e5;
	AsSav.HeAsSav[6][8] = 8.24e4;

	AsSav.HeAsSav[7][8] = 1.23e5;


#	ifdef DEBUG_FUN
	fputs( " <->Zerologic()\n", debug_fp );
#	endif
	return;
}

