/* timesc.h */
EXTERN struct t_timesc {
	/* timescales tracked by the code, some set in checkage, some in radinc */

	/* compton equilibrium timescale */
	double tcmptn;

	/* thermal timescale */
	double ttherm;

	/* hydrogen recombination timescale */
	double threc; 

	/* sound is sound travel time (sec) updated in radinc */
	double sound;

	/* age of cloud set with age command */
	float CloudAgeSet;

	/* local and longest timescales for CO and H2 molecules to form */
	double AgeH2MoleDest, 
	  AgeCOMoleDest, 
	  BigH2MoleForm, 
	  BigCOMoleForm;

	/* timescale for photoerosion of iron due to gamma rays */
	float TimeErode;

	/* H 21 cm line to come into equilibrium */
	double TimeH21cm;

	}	timesc;

