/*tfidle update some temperature dependent variables */
/*tauff compute optical depth where cloud is thin to free-free and plasma freq */
/*velset set thermal velocities for all particles in gas */
#include "cddefines.h"
#include "physconst.h"
#include "cooling.h"
#include "opacity.h"
#include "iso.h"
#include "plasnu.h"
#include "phycon.h"
#include "ionfracs.h"
#include "gffsub.h"
#include "trace.h"
#include "rfield.h"
#include "doppvel.h"
#include "radius.h"
#include "wind.h"
#include "atomcwgt.h"
#include "tfidle.h"

/*tauff compute optical depth where cloud is thin to free-free and plasma freq */
static void tauff(void);
/*velset set thermal velocities for all particles in gas */
static void velset(void);

void tfidle(
	/* option to force update of all variables */
	int lgForceUpdate)
{
	static float tgffused=-1.f, 
	  tgffsued2=-1.f;
	static long int nff_defined=-1;
	static float ttused = 0.f;
	static double edused = 0.;
	static int lgZLogSet = FALSE;
	int lgGauntF[2];
	long int n, 
	  i, 
	  if1;
	double fac, 
	  fanu;

#	ifdef DEBUG_FUN
	fputs( "<+>tfidle()\n", debug_fp );
#	endif

	/* called with lgForceUpdate true in zero.c, when we must update everything */
	if( lgForceUpdate )
	{
		ttused = -1.f;
		edused = 0.;
	}

	/* check that eden not negative */
	if( phycon.eden <= 0. )
	{
		fprintf( ioQQQ, " I found a zero or negative electron density,%10.2e\n", 
		  phycon.eden );
		puts( "[Stop in tfidle]" );
		ShowMe();
		puts( "[Stop in tfidle]" );
		cdEXIT(1);
	}

	/* check that temperature not negative */
	if( phycon.te <= 0. )
	{
		fprintf( ioQQQ, " I found a zero or negative electron temperature,%10.2e\n", 
		  phycon.te );
		puts( "[Stop in tfidle]" );
		ShowMe();
		puts( "[Stop in tfidle]" );
		cdEXIT(1);
	}

	/* only time only, set up array of logs of charge squared */
	if( !lgZLogSet )
	{
		for( i=0; i<LIMELM; ++i )
		{
			/* this array is used to modify the log temperature array
			 * defined below, for hydrogenic species of charge i+1 */
			phycon.sqlogz[i] = (float)log10( POW2(i+1.) );
		}
		lgZLogSet = TRUE;
	}

	if( phycon.te != ttused )
	{
		ttused = phycon.te;
		/* current temperature in eV */
		phycon.te_eV = phycon.te/(float)EVDEGK;
		phycon.te_ryd = phycon.te/(float)TE1RYD;
		phycon.tesqrd = POW2(phycon.te);
		phycon.sqrte = (float)sqrt(phycon.te);
		cooling.halfte = (float)(0.5/phycon.te);
		cooling.tsq1 = 1.f/phycon.tesqrd;
		phycon.te32 = phycon.te*phycon.sqrte;
		phycon.te70 = (float)pow(phycon.te,0.70f);
		phycon.te30 = (float)pow(phycon.te,0.30f);
		phycon.te20 = (float)pow(phycon.te,0.20f);
		phycon.te10 = (float)pow(phycon.te,0.10f);
		phycon.te07 = (float)pow(phycon.te,0.07f);
		phycon.te05 = (float)pow(phycon.te,0.05f);
		phycon.te03 = (float)pow(phycon.te,0.03f);
		phycon.te02 = (float)pow(phycon.te,0.02f);
		phycon.te01 = (float)pow(phycon.te,0.01f);
		phycon.te005 = (float)pow(phycon.te,0.005f);
		phycon.te003 = (float)pow(phycon.te,0.003f);
		phycon.te001 = (float)pow(phycon.te,0.001f);
		phycon.teinv = 1.f/phycon.te;
		phycon.alogte = (float)log10(phycon.te);
		phycon.alogete = (float)log(phycon.te);
		phycon.telogn[0] = phycon.alogte;

		for( i=1; i < 7; i++ )
		{
			phycon.telogn[i] = phycon.telogn[i-1]*phycon.telogn[0];
		}
	}

	/* term with hi added June 4, 93, to account for warm pdr */
	phycon.edensqte = (float)((phycon.eden + xIonFracs[ipHYDROGEN][1]/1e4)/phycon.sqrte);
	phycon.cdsqte = (float)(phycon.edensqte*8.629e-6);

	/* >>>chng 99 nov 23, removed this line, so back to old method of h coll */
	/* used for hydrogenic collisions */
	phycon.EdenHCorr = (float)(phycon.eden + xIonFracs[ipHYDROGEN][1]*1.7e-4);

	/* phycon.ElecFrac is electron fraction, used for secondary ionization efficiency */
	phycon.ElecFrac = (float)(phycon.eden/phycon.TotalNuclei);

	phycon.alogne = (float)log10(phycon.eden);

	if( phycon.eden != edused )
	{
		edused = phycon.eden;
		phycon.SqrtEden = (float)sqrt(phycon.eden);
	}

	/* finally reset velocities */
	/* find line widths for thermal and turbulent motion
	 * CLOUDY uses line center optical depths, =0.015 F / DELTA NU */
	velset();

	/* rest have to do with radiation field which may not be defined yet */
	if( !lgRfieldMalloced )
	{
#		ifdef DEBUG_FUN
		fputs( " <->tfidle()\n", debug_fp );
#		endif
		return;
	}

	/* correction factors for induced recombination, 
	 * also used as Boltzmann factors
	 * check for zero is because ContBoltz is zeroed out in initizationation
	 * of code, its possible this is a constant density grid of models
	 * in which the code is called as a subroutine */
	/* >>chng 01 aug 21, must also test on size of continuum nflux because 
	 * conintitemp can increase nflux then call this routine, although 
	 * temp may not have changed */
	if( tgffused != phycon.te || rfield.ContBoltz[0] <= 0. || nff_defined<rfield.nflux )
	{
		tgffused = phycon.te;
		fac = TE1RYD/phycon.te;
		i = 0;
		fanu = fac*rfield.anu[i];
		/* NB - the 84 in the following must be kept parallel with the 84 in sexp,
		 * since level2 uses ContBoltz to see whether the rates will be significant.
		 * If the numbers did not agree then this test would be flawed, resulting in
		 * div by zero */
		while( i < rfield.nupper && fanu < 84. )
		{
			rfield.ContBoltz[i] = exp(-fanu);
			++i;
			/* this is boltz factor for NEXT cell */
			fanu = fac*rfield.anu[i];
		}
		/* ipMaxBolt is number of cells defined, so defined up through ipMaxBolt-1 */
		rfield.ipMaxBolt = i;

		/* zero out remainder */
		/* >>chng 01 apr 14, upper limit has been ipMaxBolt+1, off by one */
		for( i=rfield.ipMaxBolt; i < rfield.nupper; i++ )
		{
			rfield.ContBoltz[i] = 0.;
		}
	}

	/* find frequency where thin to brems or plasma frequency */
	tauff();

	/* reevaluate if temperature or number of cells has changed */
	if( fabs(1.-tgffsued2/phycon.te) > 0.10 || nff_defined<rfield.nflux )
	{
		gffsub(0.,rfield.anulog,rfield.gff,1,rfield.nflux,&if1);
		nff_defined = rfield.nflux;

		/* follwoing for ionized helium */
		gffsub(0.30103,rfield.anulog,rfield.gffhe2,1,rfield.nflux,
		  &if1);

		tgffsued2 = phycon.te;
		lgGauntF[0] = TRUE;
	}
	else
	{
		/* this is flag that would have been set in gffsub, and
		 * printed in debug statement below.  We are not evaluating
		 * so set to -1 */
		if1 = -1;
		lgGauntF[0] = FALSE;
	}

	if( trace.lgTrace && trace.lgTrGant )
	{
		fprintf( ioQQQ, "     BOLTGN; gaunt facs?" );
		for(n=0; n < 2; n++)
			fprintf( ioQQQ, "%2c", TorF(lgGauntF[n]) );

		fprintf( ioQQQ, "%2f g 1 2=%10.2e%9.2ld flag%2f guv(1,n)%10.2e\n", 
		  rfield.gff[0], rfield.gff[iso.ipIsoLevNIonCon[ipHYDROGEN][0][2]-1], if1, rfield.gff[iso.ipIsoLevNIonCon[ipHYDROGEN][0][2]], 
		  rfield.gff[rfield.nflux-1] );
	}

#	ifdef DEBUG_FUN
	fputs( " <->tfidle()\n", debug_fp );
#	endif
	return;
}

/*tauff compute optical depth where cloud is thin to free-free and plasma freq */
static void tauff(void)
{
	double fac;

#	ifdef DEBUG_FUN
	fputs( "<+>tauff()\n", debug_fp );
#	endif

	/* simply return if space not yet allocated */
	if( !lgOpacMalloced )
		return;

	/* routine sets variable ipEnergyBremsThin, index for lowest cont cell that is optically thin */
	/* find frequency where continuum thin to free-free */
	while( rfield.ipEnergyBremsThin < rfield.nflux && 
		opac.TauAbsGeo[0][rfield.ipEnergyBremsThin] >= 1. )
	{
		++rfield.ipEnergyBremsThin;
	}

	/* TFF will be frequency where cloud becomes optically thin to brems
	 * >>chng 96 may 7, had been 2, change as per Kevin Volk bug report */
	if( rfield.ipEnergyBremsThin > 1 && opac.TauAbsGeo[0][rfield.ipEnergyBremsThin] > 0.001 )
	{
		/* tau can be zero when plasma frequency is within energy grid, */
		fac = (1. - opac.TauAbsGeo[0][rfield.ipEnergyBremsThin-1])/(opac.TauAbsGeo[0][rfield.ipEnergyBremsThin] - 
		  opac.TauAbsGeo[0][rfield.ipEnergyBremsThin-1]);
		fac = MAX2(fac,0.);
		rfield.EnergyBremsThin = (float)(rfield.anu[rfield.ipEnergyBremsThin-1] + rfield.widflx[rfield.ipEnergyBremsThin-1]*
		  fac);
	}
	else
	{
		rfield.EnergyBremsThin = 0.;
	}

	/* now evaluate the plasma frequency */
	plasnu.plsfrq = (float)(2.729e-12*sqrt(phycon.eden*1.2));

	/* also remember the largest plasma frequency we encounter */
	plasnu.plsfrqmax = MAX2(plasnu.plsfrqmax, plasnu.plsfrq);

	/* is plasma frequency within energy grid? */
	if( plasnu.plsfrq > rfield.anu[0] )
	{
		plasnu.lgPlasNu = TRUE;
	}

	/* >>chng 96 jul 15, did not include plasma freq before
	 * function returns larger of these two frequencies */
	rfield.EnergyBremsThin = (float)MAX2(plasnu.plsfrq,rfield.EnergyBremsThin);

	/* now increment ipEnergyBremsThin still further, until above plasma frequency */
	while( rfield.ipEnergyBremsThin < rfield.nflux && 
		rfield.anu[rfield.ipEnergyBremsThin] <= rfield.EnergyBremsThin )
	{
		++rfield.ipEnergyBremsThin;
	}

	/* save max plasma frequency for case where density changes */
	if( rfield.EnergyBremsThin == plasnu.plsfrq )
	{
		plasnu.ipPlasmax = MAX2(plasnu.ipPlasma,rfield.ipEnergyBremsThin);
	}

#	ifdef DEBUG_FUN
	fputs( " <->tauff()\n", debug_fp );
#	endif
	return;
}

/*velset set thermal velocities for all particles in gas */
static void velset(void)
{
	long int nelem;
	double turb2;

#	ifdef DEBUG_FUN
	fputs( "<+>velset()\n", debug_fp );
#	endif

	/* usually TurbVel =0, reset with turbulence command
	 * cm/s here, but was entered in km/s with command */
	turb2 = DoppVel.TurbVel*DoppVel.TurbVel;

	/* this is option to dissipate the turbulence.  DispScale is entered with
	 * dissipate keyword on turbulence command.  The velocity is reduced here,
	 * by an assumed exponential scale, and also adds heat */
	if( DoppVel.DispScale > 0. )
	{
		/* square of exp depth dependence */
		turb2 *= sexp( 2.*radius.depth / DoppVel.DispScale );
	}

	/* in case of D-Critical flow include inital velocity as
	 * a component of turbulence */
	if( wind.windv0 < 0. )
	{
		turb2 += POW2(wind.windv0);
	}

	/* computes one doppler width, in cm/sec,
	 * for each element with atomic number the array index*/
	for( nelem=0; nelem < LIMELM; nelem++ )
	{
		DoppVel.doppler[nelem] = 
			/*(float)sqrt(1.651e8*phycon.te/AtomcWgt.AtomicWeight[nelem]+*/
			/* >>chng 00 may 02 to physical constants */
			(float)sqrt(2.*BOLTZMANN/ATOMIC_MASS_UNIT*phycon.te/AtomcWgt.AtomicWeight[nelem]+
		  turb2);
		/* this is average (NOT rms) particle speed for Maxwell distribution, Mihalas 70, 9-70 */
		DoppVel.AveVel[nelem] = sqrt(8.*BOLTZMANN/PI/ATOMIC_MASS_UNIT*phycon.te/AtomcWgt.AtomicWeight[nelem]);
	}

	/* DoppVel.doppler[LIMELM] is CO, vector is dim LIMELM+1 */
	/* C12O16 */
	DoppVel.doppler[LIMELM] = 
		(float)sqrt(2.*BOLTZMANN/ATOMIC_MASS_UNIT*phycon.te/
		(AtomcWgt.AtomicWeight[5]+AtomcWgt.AtomicWeight[7]) + turb2);
	/* C13O16 */
	DoppVel.doppler[LIMELM+1] = 
		(float)sqrt(2.*BOLTZMANN/ATOMIC_MASS_UNIT*phycon.te/
		(AtomcWgt.AtomicWeight[5]*13./12.+AtomcWgt.AtomicWeight[7]) + turb2);

#	ifdef DEBUG_FUN
	fputs( " <->velset()\n", debug_fp );
#	endif
	return;
}

