/*TexcLine derive excitation temperature of line from contents of line array */
#include "cddefines.h"
#include "texcline.h"

double TexcLine(EmLine * t)
{
	double TexcLine_v;

#	ifdef DEBUG_FUN
	fputs( "<+>TexcLine()\n", debug_fp );
#	endif

	/* routine to evaluate line excitation temp using contents of line array
	 * */
	if( t->PopHi * t->PopLo > 0. )
	{
		TexcLine_v = ( t->PopHi / t->gHi )/( t->PopLo / t->gLo );
		TexcLine_v = - t->EnergyK / log(TexcLine_v);
	}
	else
	{
		TexcLine_v = 0.;
	}

#	ifdef DEBUG_FUN
	fputs( " <->TexcLine()\n", debug_fp );
#	endif
	return( TexcLine_v );
}

