/*StartIter set and save values of many variables at start of iteration */
/*RestartIter restart iteration */
#include "cddefines.h"
#include "cddrive.h"
#include "cooling.h"
#include "physconst.h"
#include "iso.h"
#include "nhe1lvl.h"
#include "nhe3lvl.h"
#include "taulines.h"
#include "hydrogenic.h"
#include "dynamics.h"
#include "recom.h"
#include "angllum.h"
#include "abundances.h"
#include "grain.h"
#include "recoil.h"
#include "pop371.h"
#include "pressure.h"
#include "linesave.h"
#include "stopcalc.h"
#include "fe2neg.h"
#include "printit.h"
#include "converge.h"
#include "mean.h"
#include "hemase.h"
#include "thermal.h"
#include "hevmolec.h"
#include "heots.h"
#include "atom_oi.h"
#include "wind.h"
#include "colmas.h"
#include "he3pht.h"
#include "opacity.h"
#include "qs.h"
#include "timesc.h"
#include "frcind.h"
#include "max2pht.h"
#include "phe1lv.h"
#include "he1nxt.h"
#include "tehigh.h"
#include "he3tau.h"
#include "heopfr.h"
#include "dndt.h"
#include "he1tau.h"
#include "trace.h"
#include "zonecnt.h"
#include "itercnt.h"
#include "heat.h"
#include "colden.h"
#include "norm.h"
#include "secondaries.h"
#include "hmi.h"
#include "radius.h"
#include "he1bn.h"
#include "he3bn.h"
#include "he.h"
#include "phycon.h"
#include "doppvel.h"
#include "called.h"
#include "the1lo.h"
#include "dphoht.h"
#include "co.h"
#include "intalk.h"
#include "he1stat.h"
#include "ionfracs.h"
#include "heatlmax.h"
#include "dcala.h"
#include "extramax.h"
#include "rfield.h"
#include "ionrange.h"
#include "chargtran.h"
#include "lines.h"
#include "aver.h"
#include "molcol.h"
#include "h2max.h"
#include "jmin.h"
#include "smbeta.h"
#include "totlum.h"
#include "input.h"
#include "drminu.h"
#include "negdrg.h"
#include "uspher.h"
#include "dtmase.h"
#include "trovrd.h"
#include "pca2ex.h"
#include "stimax.h"
#include "rt.h"
#include "startenditer.h"
/* these are the static saved variables, set in StartIter and reset in RestartIter */

/* args are atomic number, ionization stage*/
static float xIonFsave[LIMELM+2][LIMELM+2];
static double HeatSave[LIMELM][LIMELM];

static float he3sav;

/* these are used to reset the level popls of the h and he model atoms */
/*static float hnsav[LIMELM][LMHLVL+1], */
static int lgHNSAV = FALSE;

static float  ***HOpacRatSav, ***hnsav;

/*save opacity ratios for hydrogen and helium*/
static float he1nsav[NHE1LVL + 1] ,
  ophe1s[NHE1LVL];

static double heb1sv[10], 
  heb3sv[NHE3LVL];

static float h2sav, 
  h2psav, 
  hmisav, 
  h3psav;

static float hsv, 
  edsav, 
  EDOthSav, 
  EDMSav;

static float xMolFracsSave[LIMELM];

void StartIter(void)
{
	int lgHit;
	long int i, 
	  ii, 
	  ion, 
	  ipISO,
	  ipZ, 
	  j, 
	  n ,
	  nelem;
	double dtau, 
	  fhe1nx, 
	  ratio;

#	ifdef DEBUG_FUN
	fputs( "<+>StartIter()\n", debug_fp );
#	endif

	/* allocate two matrices if first time in this coreload */
	if( !lgHNSAV )
	{
		/* set flag so we never do this again */
		lgHNSAV = TRUE;

		if(  (HOpacRatSav = (float ***)MALLOC(sizeof(float **)*NISO ))==NULL  )
			bad_malloc();

		if(  (hnsav = (float ***)MALLOC(sizeof(float **)*NISO ))==NULL  )
			bad_malloc();

		for( ipISO=ipHYDROGEN; ipISO<NISO; ++ipISO )
		{

			if(  (HOpacRatSav[ipISO] = (float **)MALLOC(sizeof(float *)*LIMELM ))==NULL  )
				bad_malloc();

			if(  (hnsav[ipISO] = (float **)MALLOC(sizeof(float *)*LIMELM ))==NULL  )
				bad_malloc();

			/* now do the second dimension */
			for( ipZ=0; ipZ<LIMELM; ++ipZ )
			{
				if( (HOpacRatSav[ipISO][ipZ] = (float *)MALLOC(sizeof(float)*(unsigned)(iso.nLevels[ipISO][ipZ]+1) ) )==NULL )
					bad_malloc();

				if( (hnsav[ipISO][ipZ] = (float *)MALLOC(sizeof(float)*(unsigned)(iso.nLevels[ipISO][ipZ]+1) ) )==NULL )
					bad_malloc();
			}
		}
	}

	/* StartIter is called at the start of EVERY iteration */
	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " StartIter called.\n" );
	}

	/* check if this is the last iteration */
	if( iteration > IterCnt.itermx )
	{
		IterCnt.lgLastIt = TRUE;
	}
	else
	{
		IterCnt.lgLastIt = FALSE;
	}

	hemase.lgHeMase = FALSE;
	rfield.SumOutCon = 0.;
	rfield.SumIncCon = 0.;

	/* flag set true in RTLineTauInc if maser ever capped */
	dtMase.lgMaserCapHit = FALSE;

	/* zero out charge transfer heating and cooling fractions */
	ChargTran.HCharHeatMax = 0.;
	ChargTran.HCharCoolMax = 0.;

	/* save exansion rate here */
	dndt.dndtSave = dndt.dDensityDT;

	timesc.AgeH2MoleDest = 0.;
	timesc.AgeCOMoleDest = 0.;
	timesc.BigH2MoleForm = 0.;
	timesc.BigCOMoleForm = 0.;
	timesc.TimeH21cm = 0.;
	cooling.CoolHeatMax = 0.;
	hydro.HCollIonMax = 0.;

	ChargTran.HIonFracMax = 0.;

	/* will save highest n=2p/1s ratio for hydrogen atom*/
	hydro.pop2mx = 0.;
	hydro.lgHiPop2 = FALSE;

	hydro.nLyaHot = 0;
	hydro.TLyaMax = 0.;
	Max2Pht.xMax2Pht = 0.;
	hydro.xLaMase = 0.;
	Fe2Neg.nFe2Neg = 0;

	/* TLAST is the temperature of the last zone, and is normally
	 * evaluated in ZoneDone, at the end of a zone calculation
	 * it has been undefined up til now, and for the first zone is nonsense */
	phycon.tlast = phycon.te;

	/* evaluate the gas and radiation pressure */
	pressure.PressureInit = PressureTotalDo();
	pressure.PressureCurrent = pressure.PressureInit;

	pressure.PresInteg = 0.;
	pressure.pinzon = 0.;

	dynamics.HeatMax = 0.;
	dynamics.CoolMax = 0.;
	hmi.HeatH2DexcMax = 0.;

	/* reset these since we now have a valid solution */
	pressure.pbeta = 0.;
	pressure.RadBetaMax = 0.;
	pressure.lgPradCap = FALSE;
	pressure.lgPradDen = FALSE;

	/* define two timescales for equilibrium, Compton and thermal */
	timesc.tcmptn = 1.e0/(qs.qtot*6.65e-25*phycon.eden);
	timesc.ttherm = 1.5*phycon.pden*BOLTZMANN*phycon.te/cooling.ctot;

	for( ipZ=0; ipZ < LIMELM; ipZ++ )
	{
		/* save molecular densities */
		xMolFracsSave[ipZ] = xMolFracs[ipZ];

		if( abundances.lgElmtOn[ipZ] )
		{

			/* now zero out the ionic fractions */
			for( ion=1; ion <= (ipZ + 2); ion++ )
			{
				xIonFsave[ipZ][ion] = xIonFracs[ipZ][ion];
			}

			for( ion=0; ion < LIMELM; ion++ )
			{
				HeatSave[ipZ][ion] = heat.heating[ion][ipZ];
			}
		}
	}

	/* >>chng 02 jan 28, add ipISO loop */
	for( ipISO=ipHYDROGEN; ipISO<NISO; ++ipISO )
	{
		for( ipZ=0; ipZ < LIMELM; ipZ++ )
		{
			if( abundances.lgElmtOn[ipZ] )
			{
				for( n=0; n < iso.nLevels[ipISO][ipZ]; n++ )
				{
					HOpacRatSav[ipISO][ipZ][n] = iso.ConOpacRatio[ipISO][ipZ][n];
					hnsav[ipISO][ipZ][n] = iso.Pop2Ion[ipISO][ipZ][n];
				}
			}
		}
	}

	rfield.ipEnergyBremsThin = 0;
	rfield.EnergyBremsThin = 0.;

	atom_oi.nNegOI = 0;
	for( i=0; i< N_OI_LEVELS; ++i )
	{
		atom_oi.popoi[i] = 0.;
	}

	/* save ionization bal for second row elements */
	for( ipZ=0; ipZ < LIMELM; ipZ++ )
	{
		IonRange.IonLowSave[ipZ] = IonRange.IonLow[ipZ];
		IonRange.IonHighSave[ipZ] = IonRange.IonHigh[ipZ];
	}

	hsv = (float)phycon.hden;
	edsav = (float)phycon.eden;
	EDOthSav = phycon.EdenNotH;
	EDMSav = phycon.EdenMet;

	/* save molecular fractions */
	for( i=0; i < NHEVML; i++ )
	{
		hevmolec.HevMolSav[i] = hevmolec.hevmol[i];
	}

	h2sav = hmi.htwo;
	h2psav = hmi.h2plus;
	h3psav = hmi.h3plus;
	hmisav = hmi.hminus;

	/* save zone thicknes, and next zone thickness */
	radius.drSave = radius.drad;
	radius.drnsv = radius.drNext;

	/* these are opacity factors needed for recombination coef */
	for( n=0; n < (NHE1LVL + 1); n++ )
	{
		he1nsav[n] = phe1lv.he1n[n];
		heb1sv[n] = he1bnCOM.he1bn[n];
	}

	for( n=0; n < NHE1LVL; n++ )
	{
		ophe1s[n] = heopfr.ophe1f[n];
	}

	ZoneCnt.nprint = IterCnt.IterPrnt[iteration-1];

	colmas.TotMassColl = 0.;
	colmas.tmas = 0.;
	colmas.wmas = 0.;

	the1loCom.nhe1lo = 0;
	thermal.nUnstable = 0;
	thermal.lgUnstable = FALSE;

	he3sav = he.hei3;

	for( i=0; i < NHE3LVL; i++ )
	{
		heb3sv[i] = he3bnCom.he3bn[i];
	}

	he3pht.he3photo = 0.;
	he3pht.he3lya = 0.;
	he3pht.He3Fr2Phot = 0.;

	/* plus 1 is to zero out point where unit integration occurs */
	for( i=0; i < rfield.nupper+1; i++ )
	{
		/* diffuse fields continuum */
		rfield.ConEmitReflec[i] = 0.;
		rfield.ConEmitOut[i] = 0.;
		rfield.ConInterOut[i] = 0.;
		/* save OTS continuum for next iteration */
		rfield.otssav[i][0] = rfield.otscon[i];
		rfield.otssav[i][1] = rfield.otslin[i];
		rfield.outlin[i] = 0.;
		/* save opacities for next iteration */
		opac.opacsv[i] = opac.opac[i];
		opac.sctsav[i] = opac.scatop[i];
		/* will accumulate optical depths through cloud */
		opac.TauAbsFace[i] = opac.taumin;
		opac.TauScatFace[i] = opac.taumin;
		/* >>chng 99 dec 04, having exactly 1 for first zone caused discontinuity
		 * for heating in very high T models in map.in.  zone 1 and 2 were 20% different,
		 * since tau in is 1e-20, e2 is 0.9999, and so some H ots
		 * these were not here at all*/
		/* attenuation of flux by optical depths IN THIS ZONE 
		 * AngleIllum is 1/COS(theta), is usually 1, reset with illuminate command,
		 * option for illumination of slab at an angle */
		opac.ExpZone[i] = sexp(opac.opac[i]*radius.drad/2.*Angllum.AngleIllum);

		/* e(-tau) in inward direction, up to illuminated face */
		opac.ExpmTau[i] = (float)opac.ExpZone[i];

		/* e2(tau) in inward direction, up to illuminated face, this is used to get the
		 * recombination escape probability */
		opac.e2TauAbs[i] = (float)e2(opac.TauAbsFace[i],opac.ExpmTau[i]);
	}

	/* this zeroes out arrays to hold mean ionization fractions
	 * later enered by mean
	 * read out by setlim */
	MeanZero();

	/* zero out the column densities */
	for( i=0; i < NCOLD; i++ )
	{
		coldenCom.colden[i] = 0.;
	}
	for( i=0; i < 5; i++ )
	{
		coldenCom.C2Pops[i] = 0.;
		coldenCom.C2Colden[i] = 0.;
	}

	coldenCom.dlnenp = 0.;

	/* now zero heavy element molecules */
	molcol("ZERO");

	/* this will be sum of all free free heating over model */
	hydro.FreeFreeTotHeat = 0.;

	tehigh.thist = 0.;
	tehigh.tlowst = 1e20f;

	wind.AccelAver = 0.;
	wind.acldr = 0.;
	recom.ilt = 0;
	recom.iltln = 0;
	recom.ilthn = 0;
	recom.ihthn = 0;
	recom.ifail = 0;

	Secondaries.SecHIonMax = 0.;
	Secondaries.supsav = Secondaries.csupra;
	Secondaries.x12sav = Secondaries.x12tot;
	Secondaries.hetsav = Secondaries.heatef;
	Secondaries.savefi = Secondaries.efionz;
	for( nelem=0; nelem<LIMELM; ++nelem)
	{
		recoil.CompRecoilHeatRate[nelem] = recoil.CompRecoilHeatRateSave[nelem];
		recoil.CompRecoilIonRate[nelem] = recoil.CompRecoilIonRateSave[nelem];
	}

	/* these will keep track of the number of convergence failures that occur */
	conv.nTeFail = 0;
	conv.nTotalFailures = 0;
	conv.nPreFail = 0;
	conv.failmx = 0.;
	conv.nIonFail = 0;
	conv.nNeFail = 0;
	conv.nGrainFail = 0;

	/* zero out averaging routine */
	aver("zero",0.,0.,"          ");

	GrainStartIter();

	rfield.comtot = 0.;

	co.codfrc = 0.;
	co.codtot = 0.;
	co.lgLotsCO = FALSE;

	co.lgComNeg = FALSE;
	co.COCoolBigFrac = 0.;
	co.lgCOCoolCaped = FALSE;

	hmi.h2dfrc = 0.;
	hmi.h2line_cool_frac = 0.;
	hmi.h2dtot = 0.;
	dphoht.TotalDustHeat = 0.;
	dphoht.dphmax = 0.;
	dphoht.h2pmax = 0.;
	dphoht.dclmax = 0.;
	heatlmax.HeatLineMax = 0.;
	ExtraMax.GBarMax = 0.;
	hydro.cintot = 0.;
	ZoneCnt.lgZoneTrp = FALSE;

	/************************************************************************
	 *
	 * allocate space for lines arrays 
	 *
	 ************************************************************************/

	/* set up line array */
	/* first count number of lines */
	LineSave.ipass = -1;
	lines();
	/* in a grid this may not be the first time here, return old memory
	 * and grab new appropriate for this size, since number of lines to
	 * be stored can change
	 * as now coded this memory is freed and reallocated on every iteration.
	 * this allows some details of line emission to change for last iteration,
	 * but may not really be necessary */
	if( LineDSv!=NULL )
	{
		if( trace.lgTrace )
		{
			fprintf( ioQQQ, "StartIter has freed LindDSv \n" );
		}
		free(LineDSv );
		LineDSv = NULL;
	}

	if( LineSv!=NULL )
	{
		if( trace.lgTrace )
		{
			fprintf( ioQQQ, "StartIter has freed LindSv \n" );
		}
		free(LineSv );
		LineSv = NULL;
	}

	/* only allocate space if this sum is positive - will be zero if no grains present */
	if( LineSave.ndsum > 0 )
	{
		if( (LineDSv=(LinDstSv *)MALLOC((unsigned)LineSave.ndsum*sizeof( LinDstSv ) ) ) == NULL )
		{
			fprintf( ioQQQ, "StartIter could not allocate space for LineSave.ndsum array, needed %li\n",
				LineSave.ndsum );
			puts( "[Stop in StartIter]" );
			cdEXIT(1);
		}
	}

	/* this is the large main line array */
	if( (LineSv=(LinSv*)MALLOC((unsigned)LineSave.nsum*sizeof( LinSv ) ) ) == NULL )
	{
		fprintf( ioQQQ, "StartIter could not allocate space for LineSave.nsum array, needed %li\n",
			LineSave.nsum );
		puts( "[Stop in StartIter]" );
		cdEXIT(1);
	}

	for( i=0; i < LineSave.nsum; i++ )
	{
		/* this is array of line energies, only defined for some lines,
		 * this is sentinel saying whether line should be added into total continuum */
		LineSv[i].xLineEnergy = 0.;
	}

	LineSave.nsum = 0;

	/* second call to set up line labels */
	LineSave.ipass = 0;
	lines();
	/* in the future calls to lines will result in integrations */
	LineSave.ipass = 1;

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "%7ld lines printed in main line array\n", 
		  LineSave.nsum );
	}

	/* now zero out some variables set by last call to LINES */
	hydro.cintot = 0.;
	cooling.totcol = 0.;
	cooling.GrossHeat = 0.;
	rfield.comtot = 0.;
	heat.power = 0.;
	dphoht.TotalDustHeat = 0.;
	dphoht.dphmax = 0.;
	dphoht.h2pmax = 0.;
	dphoht.dclmax = 0.;
	heatlmax.HeatLineMax = 0.;
	ExtraMax.GBarMax = 0.;

	co.codfrc = 0.;
	co.codtot = 0.;
	co.lgLotsCO = FALSE;

	hmi.h2dfrc = 0.;
	hmi.h2line_cool_frac = 0.;
	hmi.h2dtot = 0.;
	timesc.sound = 0.;

	if( norm.lgNormFound == FALSE && norm.lgNormSet == TRUE )
	{
		norm.ipNormWavL = cdLine( norm.chNormLab , norm.WavLNorm , &fhe1nx , &ratio );
		if( norm.ipNormWavL < 0 )
		{
			/* did not find the line if return is negative */
			fprintf( ioQQQ, "There was a problem resetting the normalisation line.\n");
			fprintf( ioQQQ, 
			"StartIter could not find a line with a wavelength of %f and a label of %s\n", 
			  norm.WavLNorm, norm.chNormLab );
			fprintf( ioQQQ, "Please check the emission line output to find the correct line identification.\n");
			fprintf( ioQQQ, "Sorry.\n");
			puts( "[Stop in StartIter]" );
			cdEXIT(1);
		}

		norm.ipEmerNormWavL = cdDLine( norm.chNormLab , norm.WavLNorm , &fhe1nx , &ratio );
		/* possible that valid line specied but it did not happen to be one of the
		 * predicted emergent lines - use hbeta */
		if( norm.ipEmerNormWavL < 0 )
		{
			norm.ipEmerNormWavL = 0;
		}
	}
#	if 0
	/* find which line to normalise array to (default is H BETA) */
	if( norm.lgNormFound == FALSE && norm.lgNormSet == TRUE )
	{
		norm.lgNormFound = TRUE;

		lgHit = FALSE;

		i = 1;

		/* this must be reset or it will crash */
		j = -LONG_MAX;

		while( !lgHit && i < LineSave.nsum )
		{
			if( fabs(LineSv[i].wavelength - norm.WavLNorm)/MAX2(SMALLFLOAT,norm.WavLNorm) < 
				norm.errorwave )
			{
				/* no label was set, so any will do */
				if( strcmp( norm.chNormLab,"    ") == 0 )
				{
					j = i;
					lgHit = TRUE;
				}
				else
				{
					/* check whether labels match  */
					cap4(chCAPS , (char*)LineSv[i].chALab);

					if( strcmp( norm.chNormLab,chCAPS) == 0 )
					{
						/* when chNormLab set, only count as hit when label matches too */
						j = i;
						lgHit = TRUE;
					}
				}
			}
			++i;
		}

		if( !lgHit )
		{
			/* did not find the line */
			fprintf( ioQQQ, "There was a problem resetting the normalisation line.\n");
			fprintf( ioQQQ, 
			"StartIter could not find a line with a wavelength of %f and a label of %s\n", 
			  norm.WavLNorm, norm.chNormLab );
			fprintf( ioQQQ, "Please check the emission line output to find the correct line identification.\n");
			fprintf( ioQQQ, "Sorry.\n");
			puts( "[Stop in StartIter]" );
			cdEXIT(1);
		}

		/* following confirms that index within bounds, mostly for lint */
		assert( j>0 );
		assert( j<LineSave.nsum);

		norm.ipNormWavL = j;

		if( trace.lgTrace )
		{
			fprintf( ioQQQ, 
				" Reormalize line spectrum to line number %li wavelength is %f scale=%5.2f label is %s\n", 
			  norm.ipNormWavL, 
			  LineSv[j-1].wavelength, 
			  norm.ScaleNormLine, 
			  LineSv[j-1].chALab  );
		}
	}
#	endif

	/* if STPINT not 1E37 then stop integration when line LineStopWl
	 * reaches intensity STPINT relative to H BETA */
	/* nstpl is number of stop line commands, 0 if none entered */
	for( ii=0; ii < StopCalc.nstpl; ii++ )
	{
		if( iteration <= 1 )
		{
			i = 0;
			lgHit = FALSE;
			/* >>chng 96 dec 12, got rid of if, change to do while */
			/* search through lines to find wavelength that matches */
			while( !lgHit && i < LineSave.nsum )
			{
				/* >>chng 01 aug 15, add test for label */
				if( fabs(LineSv[i].wavelength - StopCalc.StopLineWl[ii])/
					MAX2(SMALLFLOAT,StopCalc.StopLineWl[ii])<StopCalc.ErrorLineWl[ii] &&
					strcmp(StopCalc.chStopLabel[ii] , LineSv[i].chALab) == 0 )
				{
					/* set to array index of proper line */
					StopCalc.ipStopLin1[ii] = i;
					lgHit = TRUE;
				}
				++i;
			}
			/* back off since incremented too many times above */
			--i;

			if( !lgHit )
			{
				fprintf( ioQQQ, " StartIter 1 couldnt find line%5ld\n", 
				  StopCalc.ipStopLin1[ii] );
				puts( "[Stop in StartIter]" );
				cdEXIT(1);
			}

			if( trace.lgTrace )
			{
				fprintf( ioQQQ, 
					" stop line 1 is number %5ld wavelength is %f label is %4.4s\n", 
				  StopCalc.ipStopLin1[ii], 
				  LineSv[StopCalc.ipStopLin1[ii]].wavelength, 
				  LineSv[StopCalc.ipStopLin1[ii]].chALab );
			}

			/* line index was set to zero in zero.c, if non-zero here then we want
			 * the seconc line - if zero the second line not entered */
			if( StopCalc.StopLineWl2[ii] != 0 )
			{
				i = 0;
				lgHit = FALSE;
				while( !lgHit && i < LineSave.nsum )
				{
					/* >>chng 96 dec 12, more to do while logic
					 * do i=1,nsum */
					if( fabs(LineSv[i].wavelength - StopCalc.StopLineWl2[ii])/MAX2(SMALLFLOAT,StopCalc.StopLineWl2[ii])<StopCalc.ErrorLineWl2[ii] &&
						strcmp(StopCalc.chStopLabel2[ii] , LineSv[i].chALab) == 0 )
					{
						StopCalc.ipStopLin2[ii] = i;
						lgHit = TRUE;
					}
					++i;
				}
				/* back off since incremented too many times above */
				--i;

				if( !lgHit )
				{
					fprintf( ioQQQ, " StartIter 2 couldnt find line with wavelength %ld\n", 
					  StopCalc.ipStopLin2[ii] );
					puts( "[Stop in StartIter]" );
					cdEXIT(1);
				}

				if( trace.lgTrace )
				{
					fprintf( ioQQQ, 
						" stop line 2 is number %5ld wavelength is %f label is %4.4s\n", 
					  StopCalc.ipStopLin2[ii], 
					  LineSv[StopCalc.ipStopLin2[ii]].wavelength, 
					  LineSv[StopCalc.ipStopLin2[ii]].chALab  );
				}
			}
		}
	}

	/* option to only print last iteration */
	if( printit.lgPrtLastIt )
	{
		if( iteration == 1 )
		{
			called.lgTalk = FALSE;
		}

		/* initial condition of TALK may be off if AMOEBA used
		 * sec part is for print last command 
		 * lgTalkForce is set true when cdTalk is called with false
		 * to turn off printing */
		if( IterCnt.lgLastIt && !printit.lgPrtStart && !called.lgTalkForce )
		{
			called.lgTalk = intalk.lgInTalk;
		}
	}

	if( trace.lgTrace && trace.lgOptcBug )
	{
		if( opac.lgTauOutOn )
		{
			fprintf( ioQQQ, " Outer optical depths defined.\n" );
		}
		else
		{
			fprintf( ioQQQ, " Outer optical depths NOT defined.\n" );
		}

		fprintf( ioQQQ, " Helium \n" );
		for( i=1; i <= NHE3TAU; i++ )
		{
			fprintf( ioQQQ, "%6f:%8.1e%8.1e%8.1e", 
				he3tau[i-1].WLAng, 
			  he3tau[i-1].TauIn, 
			  he3tau[i-1].TauTot, 
			  he3tau[i-1].Pesc );
		}

		fprintf( ioQQQ, "\n" );

		/* heavy element lines */
		for( i=1; i <= nLevel1; i++ )
		{
			fprintf( ioQQQ, "%6f:%8.1e%8.1e%8.1e", 
				TauLines[i-1].WLAng, 
			  TauLines[i-1].TauIn, 
			  TauLines[i-1].TauTot, 
			  TauLines[i-1].Pesc );
		}

		fprintf( ioQQQ, "\n" );
	}

	if( opac.lgCaseB )
	{
		if( trace.lgTrace )
		{
			fprintf( ioQQQ, " StartIter does not change mid-zone optical depth since CASE B\n" );
		}
	}

	else
	{
		fhe1nx = xIonFracs[ipHELIUM][2]*radius.dReff/DoppVel.doppler[1]*0.52;

		for( j=1; j < NHE1LVL; j++ )
		{
			dtau = (phe1lv.he1n[0] - phe1lv.he1n[j]*he1statCOM.he1stat[0]/
			  he1statCOM.he1stat[j])*he1tauCOM.he1opc[0][j];
			he1nxtCOM.he1nxt[0][j] = MAX2(he1tauCOM.he1tau[0][j],(float)(dtau*fhe1nx));
		}

		/* shit */
		for( i=1; i < (NHE1LVL - 1); i++ )
		{
			for( j=i + 1; j < NHE1LVL; j++ )
			{
				dtau = (phe1lv.he1n[i] - phe1lv.he1n[j]*he1statCOM.he1stat[i]/
				  he1statCOM.he1stat[j])*he1tauCOM.he1opc[i][j];

				he1nxtCOM.he1nxt[i][j] = MAX2(opac.taumin,(float)(dtau*fhe1nx) );
				  
			}
		}

		if( trace.lgTrace )
		{
			if( trace.lgHe1Bug )
			{
				fprintf( ioQQQ, " StartIter estimates optical depths for center of first zone;  HE1NXT array follows:\n" );
				for( i=1; i < NHE1LVL; i++ )
				{
					fprintf( ioQQQ, "       %1ld", i );
					for( j=0; j < 7; j++ )
					{
						fprintf( ioQQQ, "%10.2e", he1nxtCOM.he1nxt[j][i] );
					}
					fprintf( ioQQQ, "\n" );
				}
			}
		}
	}

	/* check if induced recombination can be ignored */
	frcind.FracInd = 0.;
	frcind.fbul = 0.;

	/* remember some things about effects of induced rec on H onlye
	 * don't do ground state since SPHERE turns it off */
	for( i=ipH2p; i < (iso.nLevels[ipHYDROGEN][ipHYDROGEN] - 1); i++ )
	{
		ratio = iso.RecomInducRate[ipHYDROGEN][ipHYDROGEN][i]*iso.PopLTE[ipHYDROGEN][ipHYDROGEN][i]/(iso.RecomInducRate[ipHYDROGEN][ipHYDROGEN][i]*iso.PopLTE[ipHYDROGEN][ipHYDROGEN][i] + 
			iso.RadRecomb[ipHYDROGEN][ipHYDROGEN][i][ipRecRad]*
			iso.RadRecomb[ipHYDROGEN][ipHYDROGEN][i][ipRecNetEsc]);
		if( ratio > frcind.FracInd )
		{
			frcind.FracInd = (float)ratio;
			frcind.ndclev = i;
		}

		ratio = EmisLines[ipHYDROGEN][ipHYDROGEN][i+1][i].pump/
			(EmisLines[ipHYDROGEN][ipHYDROGEN][i+1][i].pump + 
			EmisLines[ipHYDROGEN][ipHYDROGEN][i+1][i].Aul);

		if( ratio > frcind.fbul )
		{
			frcind.fbul = (float)ratio;
			frcind.nbul = i;
		}
	}

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " StartIter returns.\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->StartIter()\n", debug_fp );
#	endif
	return;
}

/*===============================================================*/
/*reset reset many variables at the start of a new iteration */
void RestartIter(void)
{
	long int i, 
	  ion, 
	  ipISO ,
	  ipZ, 
	  n, 
	  ipOTSchange,
	  nelem;
	double SumOTS ;

#	ifdef DEBUG_FUN
	fputs( "<+>RestartIter()\n", debug_fp );
#	endif

	rfield.SumOutCon = 0.;
	rfield.SumIncCon = 0.;
	dndt.dDensityDT = dndt.dndtSave;

	/* this is case where temperature floor has been set, if it was hit
	 * then we did a constant temperature calculation, and must go back to 
	 * a thermal solution */
	if( StopCalc.TeFloor > 0. )
	{
		thermal.lgTSetOn = FALSE;
		thermal.ForceTemp = 0.;
	}

	h2max.BiggestH2 = -1.f;

	called.lgBusted = FALSE;

	jmin.rjnmin = FLT_MAX;
	jmin.ajmmin = FLT_MAX;

	hydro.xLaMase = 0.;
	stimaxCom.stimax[0] = 0.;
	stimaxCom.stimax[1] = 0.;

	dcala.oldcla = 0.;
	co.CarMolFrac = -1.f;

	/* reset molecular fractions */
	for( i=0; i < NHEVML; i++ )
	{
		hevmolec.hevmol[i] = hevmolec.HevMolSav[i];
	}

	/* compute timestep if advection is enabled */
	if( dynamics.lgAdvection )
		DynaEndIter();

	hmi.htwo = h2sav;
	hmi.h2plus = h2psav;
	hmi.h3plus = h3psav;
	hmi.hminus = hmisav;

	rfield.ipEnergyBremsThin = 0;
	rfield.EnergyBremsThin = 0.;

	radius.glbdst = 0.;
	/* zone thickness, and next zone thickness */
	radius.drad = radius.drSave;
	radius.drNext = radius.drnsv;
	uspher.lgUSphON = FALSE;
	drminu.lgDrMinUsed = FALSE;
	negdrg.lgNegGrnDrg = FALSE;

	/* simple estimate of H-beta intensity */
	smbeta.SimHBeta = (float)(qs.qhtot*4.75e-13);
	smbeta.cn4861 = smbeta.sv4861;
	smbeta.cn1216 = smbeta.sv1216;

	/* total luminosity */
	totlum.totlsv = totlum.TotalLumin;

	/* set debugger on now if NZONE desired is 0 */
	if( (trace.nznbug == 0 && iteration >= trace.npsbug) && trovrd.lgTrOvrd )
	{
		trace.lgTrace = TRUE;
		fprintf( ioQQQ, " RestartIter called.\n" );
	}
	else
	{
		trace.lgTrace = FALSE;
	}

	/* zero secondary suptrathermals variables for first ionization attem */
	Secondaries.csupra = Secondaries.supsav;
	Secondaries.x12tot = Secondaries.x12sav;
	Secondaries.heatef = Secondaries.hetsav;
	Secondaries.efionz = Secondaries.savefi;
	for( nelem=0; nelem<LIMELM; ++nelem)
	{
		recoil.CompRecoilHeatRate[nelem] = recoil.CompRecoilHeatRateSave[nelem];
		recoil.CompRecoilIonRate[nelem] = recoil.CompRecoilIonRateSave[nelem];
	}

	wind.lgVelPos = TRUE;
	wind.AccelMax = 0.;
	wind.AccelAver = 0.;
	wind.acldr = 0.;
	wind.windv = wind.windv0;

	thermal.nUnstable = 0;
	thermal.lgUnstable = FALSE;

	pressure.pbeta = 0.;
	pressure.RadBetaMax = 0.;
	pressure.lgPradCap = FALSE;
	pressure.lgPradDen = FALSE;

	pca2ex.popca2ex = 0.;

	/* these are opacity factors needed for recombination coef */
	for( n=0; n < NHE1LVL; n++ )
	{
		heopfr.ophe1f[n] = ophe1s[n];
	}

	for( n=0; n < (NHE1LVL + 1); n++ )
	{
		phe1lv.he1n[n] = he1nsav[n];
	}

	heots.esc626 = 0.;
	heots.esc584 = 0.;
	heots.esc660 = 0.;
	heots.esc911 = 0.;
	heots.esc228 = 0.;

	phycon.hden = hsv;
	phycon.eden = edsav;
	phycon.EdenHCorr = (float)phycon.eden;
	phycon.EdenNotH = EDOthSav;
	phycon.EdenMet = EDMSav;
	phycon.EdenTrue = edsav;

	for( ipZ=0; ipZ < LIMELM; ipZ++ )
	{
		/* reset molecular densities */
		xMolFracs[ipZ] = xMolFracsSave[ipZ];
	}

	for( ipISO=ipHYDROGEN; ipISO<NISO; ++ipISO )
	{
		for( ipZ=0; ipZ < LIMELM; ipZ++ )
		{
			if( abundances.lgElmtOn[ipZ] )
			{
				for( n=ipH1s; n < iso.nLevels[ipISO][ipZ]; n++ )
				{
					iso.ConOpacRatio[ipISO][ipZ][n] = HOpacRatSav[ipISO][ipZ][n];
					iso.Pop2Ion[ipISO][ipZ][n] = hnsav[ipISO][ipZ][n];
				}
			}
		}
	}

	/* NHE1LVL is 9, with 2s at 10, this loop is through 10 */
	for( n=0; n < NHE1LVL+1; n++ )
	{
		he1bnCOM.he1bn[n] = heb1sv[n];
	}

	for( n=0; n < NHE3LVL; n++ )
	{
		he3bnCom.he3bn[n] = heb3sv[n];
	}

	if( trace.lgTrace && trace.lgNeBug )
	{
		fprintf( ioQQQ, "     EDEN set to%12.4e by RestartIter.\n", 
		  phycon.eden );
	}

	for( nelem=0; nelem < LIMELM; nelem++ )
	{
		/* reset total gas phase abundance to the original set */
		xIonFracs[nelem][0] = abundances.solar[nelem]*(float)phycon.hden;
		for( ion=1; ion <= (nelem + 2); ion++ )
		{
			xIonFracs[nelem][ion] = xIonFsave[nelem][ion];
		}
		for( i=0; i < LIMELM; i++ )
		{
			/*TODO swap indices around for heating and HeatSave */
			heat.heating[nelem][i] = HeatSave[nelem][i];
		}
	}

	he.hei1 = xIonFracs[ipHELIUM][1];
	he.hei3 = he3sav;

	hmi.hmihet = 0.;
	hmi.hmitot = 0.;

	GrainRestartIter();

	/* fix number of stages of ionization */
	for( i=0; i < LIMELM; i++ )
	{
		IonRange.IonLow[i] = IonRange.IonLowSave[i];
		IonRange.IonHigh[i] = IonRange.IonHighSave[i];
	}

	/* continuum was saved in FluxSave */
	for( i=0; i < rfield.nupper; i++ )
	{
		rfield.flux[i] = rfield.FluxSave[i];
		rfield.OccNumbIncidCont[i] = rfield.flux[i]*rfield.convoc[i];
		rfield.otscon[i] = rfield.otssav[i][0];
		rfield.otslin[i] = rfield.otssav[i][1];
		/* >>chng 01 apr 10, add these two resets */
		rfield.otsconNew[i] = rfield.otscon[i];
		rfield.otslinNew[i] = rfield.otslin[i];
		rfield.ConInterOut[i] = 0.;
		rfield.OccNumbDiffCont[i] = 0.;
		rfield.outlin[i] = 0.;

		opac.opac[i] = opac.opacsv[i];
		opac.OldOpacSave[i] = opac.opacsv[i];
		opac.scatop[i] = opac.sctsav[i];
		opac.albedo[i] = 
			opac.scatop[i]/MAX2(1e-30,opac.scatop[i] + opac.opac[i]);
		opac.tmn[i] = 1.;
		/* >>chng 99 dec 04, having exactly 1 for first zone caused discontinuity
		 * for heating in very high T models in map.in.  zone 1 and 2 were 20% different,
		 * since tau in is 1e-20, e2 is 0.9999, and so some H ots
		opac.ExpmTau[i] = 1.;
		opac.e2TauAbs[i] = 1.;*/
		/* >>chng 99 dec 04, having exactly 1 for first zone caused discontinuity
		 * for heating in very high T models in map.in.  zone 1 and 2 were 20% different,
		 * since tau in is 1e-20, e2 is 0.9999, and so some H ots
		 * these were not here at all*/
		/* attenuation of flux by optical depths IN THIS ZONE 
		 * AngleIllum is 1/COS(theta), is usually 1, reset with illuminate command,
		 * option for illumination of slab at an angle */
		opac.ExpZone[i] = sexp(opac.opac[i]*radius.drad/2.*Angllum.AngleIllum);

		/* e(-tau) in inward direction, up to illuminated face */
		opac.ExpmTau[i] = (float)opac.ExpZone[i];

		/* e2(tau) in inward direction, up to illuminated face */
		opac.e2TauAbs[i] = (float)e2(opac.TauAbsFace[i],opac.ExpmTau[i]);
		rfield.reflin[i] = 0.;
		rfield.ConEmitReflec[i] = 0.;
		rfield.ConEmitOut[i] = 0.;
		rfield.ConRefIncid[i] = 0.;
	}

	/* update continuum */
	RT_OTS_Update(&SumOTS , &ipOTSchange , 0.);

	hydro.FreeFreeHeat = 0.;
	hydro.FreeFreeTotHeat = 0.;

	if( called.lgTalk )
	{
		fprintf( ioQQQ, "\f\n          Start Iteration Number%2ld   %75.75s\n\n\n", 
		  iteration, input.chTitle );
	}

	/* reset variable to do with FeII atom, in pop371 */
	FeIIReset();

#	ifdef DEBUG_FUN
	fputs( " <->RestartIter()\n", debug_fp );
#	endif
	return;
}

/* do some work with ending the iteration */
void EndIter(void)
{
	long i;
	double fac,
		tau;

#	ifdef DEBUG_FUN
	fputs( "<+>RestartIter()\n", debug_fp );
#	endif

	/* these were attenuated by too much in last zone */
	for( i=0; i < rfield.nflux; i++ )
	{
		/* >>chng 99 dec 25, removed div by 2, caused crash due to 
		 * overflow when factor was too small*/
		{
			/*@-redef@*/
			enum{DEBUG=FALSE};
			/*@+redef@*/
			if( DEBUG)
			{
				fprintf(ioQQQ,"i=%li opac %.2e \n", i, 
					(double)opac.opac[i]*radius.dReff/2.*(double)Angllum.AngleIllum );
			}
		}
		tau = opac.opac[i]*radius.dReff/2.*Angllum.AngleIllum;
		assert( tau > 0. );
		fac = sexp( tau );/**/
		assert( fac <= 1. );

		if( fac > SMALLFLOAT )
		{
			rfield.ConInterOut[i] /= (float)fac;
			rfield.outlin[i] /= (float)fac;
		}
	}

	/* remember thickness of previous iteration */
	radius.router[iteration-1] = radius.depth;

#	ifdef DEBUG_FUN
	fputs( " <->EndIter()\n", debug_fp );
#	endif
	return;
}
