/*RTOptDepthReset after first iteration, updates the optical depths, mirroring this
 * routine but with the previous iteration's variables */
#include "cddefines.h"
#include "taulines.h"
#include "nhe1lvl.h"
#include "trace.h"
#include "iso.h"
#include "rfield.h"
#include "xry.h"
#include "opacity.h"
#include "he1tau.h"
#include "he3tau.h"
#include "he1nxt.h"
#include "phycon.h"
#include "sphere.h"
#include "double.h"
#include "stopcalc.h"
#include "taddlya.h"
#include "abundances.h"
#include "pop371.h"
#include "itercnt.h"
#include "phe1lv.h"
#include "nhe1.h"
#include "autoit.h"
#include "colden.h"
#include "punch.h"
#include "noconverge.h"
#include "receff.h"
#include "rt.h"

/* ====================================================================== */
/*RTOptDepthReset update total optical depth scale, 
 * called after iteration is complete */
void RTOptDepthReset(void)
{
	int lgConverged;

	long int i, 
	  ipHi, 
	  ipISO,
	  ipZ, 
	  ipLo;

	double AverFac, 
	  TauOff, 
	  f1, 
	  f2, 
	  fhe1;

	static double OldEfrac=0.;

#	ifdef DEBUG_FUN
	fputs( "<+>RTOptDepthReset()\n", debug_fp );
#	endif

	/* save column density */
	coldenCom.ColDenSav[iteration-1] = coldenCom.colden[ipCOLUMNDENSITY];

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " UPDATE estimating new optical depths\n" );
		if( trace.lgHBug && trace.lgHBugFull )
		{
			fprintf( ioQQQ, " New Hydrogen outward optical depths:\n" );
			for( ipHi=1; ipHi < iso.nLevels[ipHYDROGEN][trace.ipZTrace]; ipHi++ )
			{
				fprintf( ioQQQ, "%3ld", ipHi );
				for( ipLo=0; ipLo < ipHi; ipLo++ )
				{
					fprintf( ioQQQ, "%10.2e", 
						EmisLines[ipHYDROGEN][trace.ipZTrace][ipHi][ipLo].TauIn );
				}
				fprintf( ioQQQ, "\n" );
			}
		}
	}

	/* pumping of CaH */
	opac.tpcah[1] = opac.tpcah[0];
	opac.tpcah[0] = opac.taumin;

	/* =======================================================================*/
	/* this is an option to keep iterating until it converges
	 * iterate to convergence option
	 * autocv is percentage difference in optical depths allowed,
	 * =0.20 in block data */
	lgConverged = TRUE;
	strcpy( NoConverge.chNotConverged, "Converged!" );

	if( iteration > 1 && autoit.lgAutoIt )
	{
		for( ipZ=0; ipZ < LIMELM; ipZ++ )
		{
			if( abundances.lgElmtOn[ipZ] )
			{
				/* check both H-alpha and Ly-alpha - only if balmer lines thick */
				/* following checks if Ha optical deth significant */
				if( EmisLines[ipHYDROGEN][ipZ][3][2].TauIn > 0.5 )
				{
					if( fabs(EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].TauTot/
					  (EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].TauIn*double_.DoubleTau)-1.) > 
					  autoit.autocv )
					{
						/* not converged to within AUTOCV, normally 15 percent */
						lgConverged = FALSE;

						/* for iterate to convergence, print reason why it was not converged 
						 * on 3rd and higher iterations */
						strcpy( NoConverge.chNotConverged, "H Lya     " );

						if( punch.lgPunConv )
						{
							fprintf( punch.ipPunConv, " H Lya\n" );
						}
					}

					if( fabs(EmisLines[ipHYDROGEN][ipZ][3][2].TauTot/
					  (EmisLines[ipHYDROGEN][ipZ][3][2].TauIn*double_.DoubleTau)-1.) > 
					  autoit.autocv )
					{
						/* not converged to within AUTOCV, normally 15 percent */
						lgConverged = FALSE;

						/* for iterate to convergence, print reason why it was not converged 
						 * on 3rd and higher iterations */
						strcpy( NoConverge.chNotConverged, "H B a     " );

						if( punch.lgPunConv )
						{
							fprintf( punch.ipPunConv, " H B a\n" );
						}
					}
				}
			}
		}

		/* check for changes in the HeI Lya line */
		if( (he1tauCOM.he1tau[0][1] - TAddLya.TAddHeI) > 0.5 )
		{
			if( fabs(he1tauCOM.he1tau[0][1]*double_.DoubleTau/he1tauCOM.he1lim[0][1]-1.) > 
				autoit.autocv )
			{
				lgConverged = FALSE;
				strcpy( NoConverge.chNotConverged, "He1 Lya   " );

				if( punch.lgPunConv )
				{
					fprintf( punch.ipPunConv, " He1 Lya\n" );
				}

			}
		}

		/* >>>chng 00 mar 24, also check on 10830 if optically thick */
		if( he3tau[IPT10830-1].TauIn > 0.5 )
		{
			if( fabs(he3tau[IPT10830-1].TauTot/
			  (he3tau[IPT10830-1].TauIn*double_.DoubleTau)-1.) > 
			  autoit.autocv )
			{
				/* not converged to within AUTOCV, normally 15 percent */
				lgConverged = FALSE;
				strcpy( NoConverge.chNotConverged, "HeI 10830 " );
				if( punch.lgPunConv )
				{
					fprintf( punch.ipPunConv, " 10830\n" );
				}
			}
		}

		if( punch.lgPunConv && lgConverged )
		{
			fprintf( punch.ipPunConv, " converged\n" );
		}

		/* lower limit to number of iterations if converged */
		if( lgConverged )
			IterCnt.itermx = MIN2(IterCnt.itermx,iteration);

		/* >>chng 96 dec 20, moved following to within if on lgAutoIt
		 * this is test for stopping on first zone */
		if( phycon.te < StopCalc.tend && nzone == 1 )
		{
			lgConverged = TRUE;
			strcpy( NoConverge.chNotConverged, "          " );
			IterCnt.itermx = MIN2(IterCnt.itermx,iteration);
		}
	}

	/* ======================================================================== */
	/* must take average of old and new optical depths - were old in place?
	 * */
	if( iteration <= 1 )
	{
		/* this is first pass */
		f1 = 1.;
	}
	else
	{
		/* >>chng 96 jun 06, kill logic for oscillations, do not use
		 * optical depths this was too conservative.  instead check whether
		 * i-front breaking out by looking at electron fractions */
		if( (OldEfrac - 0.98)*(phycon.ElecFrac - 0.98) < 0. )
		{
			f1 = 0.2;
		}
		else
		{
			/* no oscillations, save to speed up convergence */
			f1 = 0.75;
		}
	}

	/* will use this to check on electron density oscillations */
	OldEfrac = phycon.ElecFrac;

	AverFac = f1;
	f2 = 1. - f1;

	/* ===================================================================== */
	/* HeI He I singlet emission lines */
	/* static is false unless sphere static set */
	if( sphere.lgStatic )
	{
		for( ipHi=1; ipHi < NHE1LVL; ipHi++ )
		{
			/* DoubleTau is usually 1, set to 2 with the DoubleTau option to
			 * simulate two-sided photoionization */
			if( iteration == 1 )
			{
				TauOff = TAddLya.TAddHeI*he1tauCOM.he1opc[0][ipHi]/he1tauCOM.he1opc[0][1];
			}
			else
			{
				TauOff = 0.;
			}

			he1tauCOM.he1lim[0][ipHi] = (float)pow(10.,log10(MAX2(opac.taumin,
			  (he1tauCOM.he1tau[0][ipHi]-TauOff)*double_.DoubleTau))*
			  f1 + log10(MAX2(opac.taumin,he1tauCOM.he1lim[0][ipHi]))* f2);

			if( he1tauCOM.he1lim[0][ipHi] <= 0. )
			{
				/* this probably due to underflow above */
				he1tauCOM.he1lim[0][ipHi] = (float)(TauOff/1e6);
			}
			he1nxtCOM.he1nxt[0][ipHi] = he1tauCOM.he1lim[0][ipHi]/2.f;
			he1tauCOM.he1tau[0][ipHi] = he1tauCOM.he1lim[0][ipHi]/2.f;
		}
	}
	else
	{
		for( ipHi=1; ipHi < NHE1LVL; ipHi++ )
		{
			/* DoubleTau is usually 1, set to 2 with the DoubleTau option to
			 * simulate two-sided photoionization */
			if( iteration == 1 )
			{
				TauOff = TAddLya.TAddHeI*he1tauCOM.he1opc[0][ipHi]/he1tauCOM.he1opc[0][1];
			}
			else
			{
				TauOff = 0.;
			}
			/* he1lim(ipHi,1) = (he1tau(ipHi,1)-TauOff)*f1*DoubleTau + he1lim(ipHi,1)*f2 */
			he1tauCOM.he1lim[0][ipHi] = (float)pow(10.,log10(MAX2(opac.taumin,
			  (he1tauCOM.he1tau[0][ipHi]-TauOff)*double_.DoubleTau))*
			  f1 + log10(MAX2(opac.taumin,he1tauCOM.he1lim[0][ipHi]))*
			  f2);
			if( he1tauCOM.he1lim[0][ipHi] <= 0. )
			{
				/* this probably due to underflow above */
				he1tauCOM.he1lim[0][ipHi] = (float)(TauOff/1e6);
			}
			he1nxtCOM.he1nxt[0][ipHi] = 
				MIN2(opac.taumin,he1tauCOM.he1lim[0][ipHi]/2.f);
			he1tauCOM.he1tau[0][ipHi] = 
				MIN2(opac.taumin,he1tauCOM.he1lim[0][ipHi]/2.f);
		}
	}

	if( sphere.lgStatic )
	{
		for( ipLo=1; ipLo < (NHE1LVL - 1); ipLo++ )
		{
			for( ipHi=ipLo + 1; ipHi < NHE1LVL; ipHi++ )
			{
				/* he1lim(ipHi,ipLo) = he1tau(ipHi,ipLo)*f1*DoubleTau + he1lim(ipHi,ipLo) * f2 */
				he1tauCOM.he1lim[ipLo][ipHi] = (float)pow(10.,log10(MAX2(opac.taumin,
				  (he1tauCOM.he1tau[ipLo][ipHi])*double_.DoubleTau))*f1 + 
				  log10(MAX2(opac.taumin,he1tauCOM.he1lim[ipLo][ipHi]))*f2);

				he1nxtCOM.he1nxt[ipLo][ipHi] = he1tauCOM.he1lim[ipLo][ipHi]/2.f;
				he1tauCOM.he1tau[ipLo][ipHi] = he1tauCOM.he1lim[ipLo][ipHi]/2.f;
			}
		}
	}
	else
	{
		for( ipLo=1; ipLo < (NHE1LVL - 1); ipLo++ )
		{
			for( ipHi=ipLo + 1; ipHi < NHE1LVL; ipHi++ )
			{
				/* he1lim(ipHi,ipLo) = he1tau(ipHi,ipLo)*f1*DoubleTau + he1lim(ipHi,ipLo) * f2 */
				he1tauCOM.he1lim[ipLo][ipHi] = (float)pow(10.,log10(MAX2(opac.taumin,
				  (he1tauCOM.he1tau[ipLo][ipHi])*double_.DoubleTau))*f1 + 
				  log10(MAX2(opac.taumin,he1tauCOM.he1lim[ipLo][ipHi]))*f2);

				he1nxtCOM.he1nxt[ipLo][ipHi] = 
					MIN2(opac.taumin,he1tauCOM.he1lim[ipLo][ipHi]/2.f);
				he1tauCOM.he1tau[ipLo][ipHi] = 
					MIN2(opac.taumin,he1tauCOM.he1lim[ipLo][ipHi]/ 2.f);
			}
		}
	}

	/* force hydrogen outward optical depths to be on */
	opac.lgTauOutOn = TRUE;

	/* possibly fix La optical depths
	 * tlamin is set to large number when case b set */
	if( (opac.tlamin > 1e-5 && (!sphere.lgStatic)) || opac.lgCaseB )
	{
		fhe1 = opac.tlamin/he1tauCOM.he1opc[0][1];
		he1tauCOM.he1tau[0][1] = opac.tlamin;
		he1tauCOM.he1lim[0][1] = opac.tlamin*2.f;
		he1nxtCOM.he1nxt[0][1] = opac.tlamin;
		for( ipHi=2; ipHi < NHE1LVL; ipHi++ )
		{
			he1tauCOM.he1tau[0][ipHi] = (float)(fhe1*he1tauCOM.he1opc[0][ipHi]);
			he1tauCOM.he1lim[0][ipHi] = he1tauCOM.he1tau[0][ipHi]*2.f;
			he1nxtCOM.he1nxt[0][ipHi] = he1tauCOM.he1tau[0][ipHi];
		}
	}

	/* following sets (1)=inward optical depth to TAUMIN,
	 * (2)=outward = (log) mean of old optical depths,
	 * sets (3) to escap prob for first zone */
	for( ipHi=0; ipHi < NHE3TAU; ipHi++ )
	{
		RTTauUpdate(&he3tau[ipHi],AverFac);
	}

	RTTauUpdate(&t206,AverFac);

	if( sphere.lgSphere )
	{
		phe1lv.he1rec[ipRecNetEsc][0] = MAX2(0.f,opac.otsmin);
		phe1lv.he1rec[ipRecNetEsc][1] = 1.;
	}
	else
	{
		phe1lv.he1rec[ipRecNetEsc][0] = (float)receff(nhe1Com.nhe1[0]);
	}

	opac.telec = opac.taumin;
	opac.thmin = opac.taumin;

	/* hydrogenic species */
	for( ipZ=0; ipZ < LIMELM; ipZ++ )
	{
		if( abundances.lgElmtOn[ipZ] )
		{
			for( ipLo=0; ipLo < (iso.nLevels[ipHYDROGEN][ipZ] - 1); ipLo++ )
			{
				for( ipHi=ipLo + 1; ipHi < iso.nLevels[ipHYDROGEN][ipZ]; ipHi++ )
				{
					/*RTTauUpdate computes average of old and new optical depths 
					 * for new scale at end of iter */
 					RTTauUpdate(&EmisLines[ipHYDROGEN][ipZ][ipHi][ipLo],0.5);
				}
			}
		}
	}

	/* he-like species */
	for( ipZ=1; ipZ < LIMELM; ipZ++ )
	{
		if( abundances.lgElmtOn[ipZ] )
		{
			for( ipHi=1; ipHi <iso.nLevels[ipHELIUM][ipZ]; ipHi++ )
			{
				for( ipLo=0; ipLo < ipHi; ipLo++ )
				{
					/*RTTauUpdate computes average of old and new optical depths 
					 * for new scale at end of iter */
					RTTauUpdate(&EmisLines[ipHELIUM][ipZ][ipHi][ipLo],0.5);
				}
			}
		}
	}

	/* do optical depths in extra Lyman lines */
	for(ipISO=0; ipISO<NISO; ++ipISO )
	{
		for( ipZ=ipISO; ipZ < LIMELM; ipZ++ )
		{
			if( abundances.lgElmtOn[ipZ] )
			{
				for( ipHi=2; ipHi <iso.nLyman[ipISO]; ipHi++ )
				{
					iso.ExtraLymanLines[ipISO][ipZ][ipHi].TauIn = opac.taumin;
				}
			}
		}
	}

	/* >>>chng 99 nov 11 did not have case b for hydrogenic species on second and
	 * higher iterations */
	/* option to clobber these taus for lyman lines, if case b is set */
	if( opac.lgCaseB )
	{
		for( ipZ=0; ipZ < LIMELM; ipZ++ )
		{
			if( abundances.lgElmtOn[ipZ] )
			{
				float f;
				/* La may be case B, tlamin set to 1e9 by default with case b command */
				EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].TauIn = opac.tlamin;
				/* >>>chng 99 nov 22, did not reset TauCon */
				EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].TauCon = EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].TauIn;
				EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].TauTot = 
				  2.f*EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].TauIn;
				f = opac.tlamin/EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].opacity;

				for( ipHi=3; ipHi < iso.nLevels[ipHYDROGEN][ipZ]; ipHi++ )
				{
					EmisLines[ipHYDROGEN][ipZ][ipHi][ipH1s].TauIn = 
						f*EmisLines[ipHYDROGEN][ipZ][ipHi][ipH1s].opacity;
					/* reset line optical depth to continuum source */
					EmisLines[ipHYDROGEN][ipZ][ipHi][ipH1s].TauCon = EmisLines[ipHYDROGEN][ipZ][ipHi][ipH1s].TauIn;
					EmisLines[ipHYDROGEN][ipZ][ipHi][ipH1s].TauTot = 
					  2.f*EmisLines[ipHYDROGEN][ipZ][ipH2p][ipH1s].TauIn;
				}
			}
		}
	}

	/* now do helium like sequence */
	if( opac.lgCaseB )
	{
		for( ipZ=1; ipZ < LIMELM; ipZ++ )
		{
			if( abundances.lgElmtOn[ipZ] )
			{
				float Aprev,
					ratio;
				/* La may be case B, tlamin set to 1e9 by default with case b command */
				EmisLines[ipHELIUM][ipZ][ipHe2p1P][ipHe1s1S].TauIn = opac.tlamin;

				EmisLines[ipHELIUM][ipZ][ipHe2p1P][ipHe1s1S].TauCon = EmisLines[ipHELIUM][ipZ][ipHe2p1P][ipHe1s1S].TauIn;

				EmisLines[ipHELIUM][ipZ][ipHe2p1P][ipHe1s1S].TauTot = 
				  2.f*EmisLines[ipHELIUM][ipZ][ipHe2p1P][ipHe1s1S].TauIn;

				ratio = opac.tlamin/EmisLines[ipHELIUM][ipZ][ipHe2p1P][ipHe1s1S].opacity;

				/* this will be the trans prob of the previous lyman line, will use this to 
				 * find the next one up in the series */
				Aprev = EmisLines[ipHELIUM][ipZ][ipHe2p1P][ipHe1s1S].Aul;

				i = ipHe2p1P+1;
				/* >>chng 02 jan 05, remove explicit list of lyman lines, use As to guess
				 * which are which - this will work for any number of levels */
				while( i < iso.nLevels[ipHELIUM][ipZ] )
				/*while( i < N_HE_LYMAN && ipHeLyman[i] < iso.nLevels[ipHELIUM][ipZ] )*/
				{
					if( EmisLines[ipHELIUM][ipZ][i][ipHe1s1S].Aul> Aprev/10. )
					{
						Aprev = EmisLines[ipHELIUM][ipZ][i][ipHe1s1S].Aul;
						EmisLines[ipHELIUM][ipZ][i][ipHe1s1S].TauIn = 
							ratio*EmisLines[ipHELIUM][ipZ][i][ipHe1s1S].opacity;
						/* reset line optical depth to continuum source */
						EmisLines[ipHELIUM][ipZ][i][ipHe1s1S].TauCon = EmisLines[ipHELIUM][ipZ][i][ipHe1s1S].TauIn;
						EmisLines[ipHELIUM][ipZ][i][ipHe1s1S].TauTot = 
						  2.f*EmisLines[ipHELIUM][ipZ][i][ipHe1s1S].TauIn;
						/*fprintf(ioQQQ,"%li\t%li\t%.2e\t%.2e\n",ipZ, i, 
							EmisLines[ipHELIUM][ipZ][i][ipHe1s1S].Aul, EmisLines[ipHELIUM][ipZ][i][ipHe1s1S].TauIn );*/
					}
					++ i;
				}
			}
		}
	}

	/* all heavy element lines */
	for( i=1; i <= nLevel1; i++ )
	{
		RTTauUpdate(&TauLines[i],AverFac);
		/* >>chng 96 jul 06 following sanity check added
		 *begin sanity check */
		if( fabs(TauLines[i].TauIn) > 
			fabs(TauLines[i].TauTot) )
		{
			fprintf( ioQQQ, " UPDATE finds TauIn>TauOut, line=%5ld%10.2e%10.2e\n", 
			  i, TauLines[i].TauIn, TauLines[i].TauTot );
			ShowMe();
			puts( "[Stop in RTOptDepthReset]" );
			cdEXIT(1);
		}
		/*end sanity check */
	}

	/* all level 2 heavy element lines */
	for( i=0; i < nWindLine; i++ )
	{
		if( TauLine2[i].nelem != TauLine2[i].IonStg )
		{
			RTTauUpdate(&TauLine2[i],AverFac);
		}
	}

	/* all hyperfine structure lines */
	for( i=0; i < nHFLines; i++ )
	{
		RTTauUpdate(&HFLines[i],AverFac);
	}

	/* co carbon monoxide lines */
	for( i=0; i < nCORotate; i++ )
	{
		RTTauUpdate(&C12O16Rotate[i],AverFac);
		RTTauUpdate(&C13O16Rotate[i],AverFac);
	}

	/* Verner's FeII atom */
	if( FeII.lgFeIION )
	{
		FeIITauAver();
	}

	if( opac.lgCaseB )
	{
		for( i=0; i < rfield.nupper; i++ )
		{
			/* DEPABS and SCT are abs and sct optical depth for depth only
			 * we will not change total optical depths, just reset inner to half
			 * TauAbsGeo(i,2) = 2.*TauAbsFace(i) */
			opac.TauAbsGeo[0][i] = opac.TauAbsGeo[1][i]/2.f;
			/* TauScatGeo(i,2) = 2.*TauScatFace(i) */
			opac.TauScatGeo[0][i] = opac.TauScatGeo[1][i]/2.f;
			opac.TauScatFace[i] = opac.taumin;
			opac.TauAbsFace[i] = opac.taumin;
		}
	}
	else if( sphere.lgSphere )
	{
		for( i=0; i < rfield.nupper; i++ )
		{
			/* [1] is total optical depth from previous iteration,
			 * [0] is optical depth at current position */
			opac.TauAbsGeo[1][i] = 2.f*opac.TauAbsFace[i];
			opac.TauAbsGeo[0][i] = opac.TauAbsFace[i];
			opac.TauScatGeo[1][i] = 2.f*opac.TauScatFace[i];
			opac.TauScatGeo[0][i] = opac.TauScatFace[i];
			opac.TauTotalGeo[1][i] = opac.TauScatGeo[1][i] + opac.TauAbsGeo[1][i];
			opac.TauTotalGeo[0][i] = opac.TauScatGeo[0][i] + opac.TauAbsGeo[0][i];
			/* TauAbsFace and TauScatFace are abs and sct optical depth to ill face */
			opac.TauScatFace[i] = opac.taumin;
			opac.TauAbsFace[i] = opac.taumin;
		}
	}
	else
	{
		for( i=0; i < rfield.nupper; i++ )
		{
			opac.TauTotalGeo[1][i] = opac.TauTotalGeo[0][i];
			opac.TauTotalGeo[0][i] = opac.taumin;
			opac.TauAbsGeo[1][i] = opac.TauAbsGeo[0][i];
			opac.TauAbsGeo[0][i] = opac.taumin;
			opac.TauScatGeo[1][i] = opac.TauScatGeo[0][i];
			opac.TauScatGeo[0][i] = opac.taumin;
			opac.TauScatFace[i] = opac.taumin;
			opac.TauAbsFace[i] = opac.taumin;
		}
	}

	/* this is optical depth at x-ray point defining effective optical depth */
	xry.tauxry = opac.TauAbsGeo[0][xry.ipxry-1];

#	ifdef DEBUG_FUN
	fputs( " <->RTOptDepthReset()\n", debug_fp );
#	endif
	return;
}

