/*RTLineTauInc increment optical depths for all heavy element lines, zone by zone,
 * mainly called by RTOptDepthIncre, but also by FeII */
#include "cddefines.h"
#include "doppvel.h"
#include "filfac.h"
#include "radius.h"
#include "wind.h"
#include "dtmase.h"
#include "rt.h"

void RTLineTauInc(EmLine * t )
{
	double dtau, 
	  vel;

#	ifdef DEBUG_FUN
	fputs( "<+>RTLineTauInc()\n", debug_fp );
#	endif

	/* routine increments optical depths for static or exanding atmosphere */
	vel = DoppVel.doppler[ t->nelem -1];

	/* use static solution for both d-critical and static */
	if( wind.windv <= 0. )
	{
		/* static solution */
		t->dTau = (float)( t->PopOpc * t->opacity / vel);

		dtau = t->dTau * radius.dReff;
		t->TauIn += (float)dtau;

		dtMase.dTauMase = MIN2(dtMase.dTauMase,(float)dtau);

		/* this will cause comment to be printed in prtComments */
		if( dtMase.dTauMase < -1. )
		{
			dtMase.lgMaserCapHit = TRUE;
		}

		/* following stops disaster, will allow escape prob to get big and
		 * damp out the maser */
		dtau = MAX2(-1.,dtau);

		t->TauCon += t->dTau*(float)radius.dReff;
	}

	else
	{
		double absAccelTot = fabs(wind.AccelTot);
		/* wind solution */

		/* this is effective length scale for sobolev or lvg approximation.
		 * This is equation 3 of
		 * >>refer	RT	wind	Castor, J.I., Abbott, D.C., & Klein, R.I., 1975, ApJ, 195, 157
		 *
		 * >>chng 01 mar 24, change to this formalism from previous, constant velocity
		 * approximation 
		 */
		/*t->TauIn = wind.wndeff * t->PopOpc * t->opacity;*/
		/* do not let the physical scale exceed the current depth */
		t->TauIn = (float)(MIN2( radius.depth, vel/ MAX2(absAccelTot,SMALLFLOAT) ) *
			filfac.FillFac * t->PopOpc * t->opacity);

		t->TauCon = t->TauIn;

		/* save for continuum pumping array
		 * t->t(ipLnDTau) = t->t(ipLnTauIn) / dReff
		 * >>chng 96 jan 15 above had been place,
		 * current nova.in crashed due to small dr
		 * why was it as above? */
		/* >>chng 01 mar 24, removed following max of hydrogen and element's velocity */
		/*t->dTau = (float)(t->PopOpc * t->opacity *
		  filfac.FillFac / MAX2((double)DoppVel.doppler[0],vel));*/

		t->dTau = t->TauIn;

		t->TauTot = t->TauIn;
	}

#	ifdef DEBUG_FUN
	fputs( " <->RTLineTauInc()\n", debug_fp );
#	endif
	return;
}
