/*RTDiffuse evaluate local diffuse emission for this zone,
 * fill in ConEmitLocal and ThrowOut arrays with diffuse emission,
 * ots rates for this zone were set in RT_OTS,
 * called by Cloudy, this routine adds energy to the outward beam */
#include "cddefines.h"
#include "physconst.h"
#include "ip626.h"
#include "taulines.h"
#include "nhe1lvl.h"
#include "qheat.h"
#include "grainvar.h"
#include "hydrogenic.h"
#include "iso.h"
#include "opacity.h"
#include "trace.h"
#include "iphmin.h"
#include "he1blt.h"
#include "rfield.h"
#include "phycon.h"
#include "nhe1.h"
#include "helike.h"
#include "radius.h"
#include "he1nionryd.h"
#include "iphe1l.h"
#include "outer.h"
#include "phe1lv.h"
#include "ionfracs.h"
#include "ionrange.h"
#include "heavy.h"
#include "pbowen.h"
#include "fekems.h"
#include "heots.h"
#include "he3lines.h"
#include "plasnu.h"
#include "pop371.h"
#include "rt.h"

void RTDiffuse(void)
{
	long int i, 
	  ip, 
	  ipISO,
	  ipHi, 
	  ipLo, 
	  ipla,
	  nelem,
	  nion,
	  limit, 
	  n;

	double EdenAbund, 
	  difflya, 
	  esc, 
	  ots, 
	  xInWrd,
	  arg, 
	  bolt2, 
	  cor, 
	  dwid, 
	  fac, 
	  facff, 
	  fache2, 
	  factor, 
	  gamma, 
	  gion, 
	  gn, 
	  photon, 
	  sum,
	  Sum1level,
	  /*sumh1[NISO][LIMELM], */
	  SumCaseB;

	float Dilution , fach;

	/* total local two photon emission */
	float *Diff2Pht/*[rfield.nupper]*/;

#	ifdef DEBUG_FUN
	fputs( "<+>RTDiffuse()\n", debug_fp );
#	endif

	if( (Diff2Pht = (float*)MALLOC((size_t)((unsigned)rfield.nupper*sizeof(float)) ) ) == NULL )
		bad_malloc();

	/* this routine evaluates the local diffuse fields
	 * it fills in the vector ConEmitLocal */
	for( i=0; i < rfield.nupper; i++ )
	{
		rfield.ThrowOut[i] = 0.;
		rfield.ConEmitLocal[i] = 0.;
		rfield.ConOTS_local_photons[i] = 0.;
		Diff2Pht[i] = 0.;
	}

	/* hydrogen continuous recombination continuum (free-bound) emission
	 * dwid used to adjust where within WIDFLX exp is evaluated */
	dwid = 0.2;

	/* loop over hydrogenic and helium-like species of all elements 
	 * to add all recombination continua*/
	for( ipISO=ipHYDROGEN; ipISO<NISO; ++ipISO )
	{
		/* >>chng 01 sep 23, rewrote for iso sequences */
		for( nelem=ipISO; nelem < LIMELM; nelem++ )
		{
			/* this will be the sum of recombinations to all excited levels */
			SumCaseB = 0.;

			/* the product of the densities of the parent ion and electrons */
			EdenAbund = phycon.eden*xIonFracs[nelem][nelem+2-ipISO];

			/* >>chng 01 sep 22, from ==nelem+1 to >=nelem+1-ipISO */
			/* only do recombinations for H-like and He-like - 
			 * check whether they exist */
			if( IonRange.IonHigh[nelem] >= nelem + 1 - ipISO  )
			{
				/* loop over all levels with explicit opacities */
				limit = iso.nLevels[ipISO][nelem];

				/* this will be the number of recombinations to each level */

				/* pick highest continuum to to consider */
				/* for ground continuum, go up to highest defined boltzmann factor,
				 * at bottom of loop will be reset to ground state photo edge */
				ipHi = rfield.ipMaxBolt;
				for( n=0; n < limit; n++ )
				{
					Sum1level = 0;
					/*TODO bring ground state into this loop */
					/* fixit();remove the following test and continue */
					if( n==0 && nelem==ipHELIUM && ipISO==ipHELIUM )
						continue;
					/* the number is (2 pi me k/h^2) ^ -3/2 * 8 pi/c^2 / ge - it includes
					 * the stat weight of the free electron in the demominator */
					gamma = 2.0618684e11*iso.stat[ipISO][n]/iso.stat_ion[ipISO]/phycon.te/phycon.sqrte;

					/* following is boltz fac for second cell, check not zero,*/
					bolt2 = rfield.anu[iso.ipIsoLevNIonCon[ipISO][nelem][n]]/phycon.te_ryd;

					/* only escaping part of recombinations are thrown into ThrowOut here,
					 * added to ConInterOut.  The lost photons are never put back in.*/
					if( iso.ConBoltz[ipISO][nelem][n] > 0. )
					{
						for( i=iso.ipIsoLevNIonCon[ipISO][nelem][n]-1; i < ipHi; i++ )
						{
							/* flux is in photons per sec per ryd
							 * ContBoltz is ratio of Boltz fac for each freq */
							photon = gamma*rfield.ContBoltz[i]/iso.ConBoltz[ipISO][nelem][n]*
							  rfield.widflx[i]*rfield.anu2[i]*
							  opac.OpacStack[i-iso.ipIsoLevNIonCon[ipISO][nelem][n]+iso.ipOpac[ipISO][nelem][n]];
							Sum1level += photon;
							rfield.ConEmitLocal[i] += (float)(photon*EdenAbund);
							rfield.ThrowOut[i] += 
								(float)(photon*EdenAbund*iso.RadRecomb[ipISO][nelem][n][ipRecEsc]/**/);
						}
					}

					else if( bolt2 < 3. )
					{
						/*   boltzmann factor is zero, but still emission within continuum */
						for( i=iso.ipIsoLevNIonCon[ipISO][nelem][n]-1; i < ipHi; i++ )
						{
							arg = MAX2(0.,1.57890e5*
								(rfield.anu[i]-iso.xIsoLevNIonRyd[ipISO][nelem][n]+
							  rfield.widflx[i]*dwid)/phycon.te);
							/* flux is in photons per sec per ryd */
							photon = gamma*sexp(arg)*rfield.widflx[i]*
							  opac.OpacStack[i-iso.ipIsoLevNIonCon[ipISO][nelem][n]+iso.ipOpac[ipISO][nelem][n]]*
							  rfield.anu2[i];
							Sum1level += photon;
							rfield.ConEmitLocal[i] += (float)(photon*EdenAbund);
							rfield.ThrowOut[i] += 
								(float)(photon*EdenAbund*iso.RadRecomb[ipISO][nelem][n][ipRecEsc]);
						}
					}
					/* reset this counter at 2s, lowest excited state, will use below
					 * to confirm case B sum */
					if( n > 0 )
					{
						/* SumCaseB will be sum to all excited */
						SumCaseB += Sum1level;
					}

					/* for excited states go either up to ground continuum edge 
					 * or highest defined Boltzmann factor */
					/* >>chng 00 dec 15, form ipHn to ipHn-1, since ipHn is on F scale */
					ipHi = MIN2(rfield.ipMaxBolt,iso.ipIsoLevNIonCon[ipISO][nelem][0]-1);
					/*if( nelem==1 && ipISO == 1 )
					{
						fprintf(ioQQQ,"herecccc \t%li\t%.2e\t%.2e\n", 
							n , 
							Sum1level , 
							iso.RadRecomb[ipISO][nelem][n][ipRecRad]);
					}*/
				}
				/* code for NHPLPHOT < 400 is at end of routine */
				/* following is check on self-consistency */
				iso.CaseBCheck[ipISO][nelem] = MAX2(iso.CaseBCheck[ipISO][nelem],
				  (float)(SumCaseB/iso.RadRec_caseB[ipISO][nelem]));
			}
		}
	}

	/* at this stage the diffuse arrays have only the hydrogenic recombination continua */

	/* recombination from He+ into he triplets */
#	if 0
	EdenAbund = phycon.eden*xIonFracs[ipHELIUM][2];
	sumtri = 0.;

	if( EdenAbund > 0. )
	{
		gion = 2.;
		gn = 3.;
		gamma = 2.0618684e11*gn/gion/phycon.te/phycon.sqrte;
		bolt2 = 1.57890e5*rfield.anu[he.nhei3-1]/phycon.te;

		if( rfield.ContBoltz[he.nhei3-1] > 0. )
		{
			for( i=he.nhei3-1; i < nhe1Com.nhe1[0]; i++ )
			{
				photon = gamma*rfield.ContBoltz[i]/rfield.ContBoltz[he.nhei3-1]*
				  rfield.widflx[i]*opac.OpacStack[i-he.nhei3+opac.ioptri]*
				  rfield.anu2[i];
				sumtri += photon;
				rfield.ConEmitLocal[i] += (float)(photon*EdenAbund);
				rfield.ThrowOut[i] += (float)(photon*EdenAbund);
			}
		}

		else if( bolt2 < 4. )
		{
			for( i=he.nhei3-1; i < nhe1Com.nhe1[0]; i++ )
			{
				arg = MAX2(0.,1.57890e5*(rfield.anu[i]-rfield.anu[he.nhei3-1])/
				  phycon.te);
				photon = gamma*sexp(arg)*rfield.widflx[i]*opac.OpacStack[i-he.nhei3+opac.ioptri]*
				  rfield.anu2[i];
				sumtri += photon;
				rfield.ConEmitLocal[i] += (float)(photon*EdenAbund);
				rfield.ThrowOut[i] += (float)(photon*EdenAbund);
			}
		}
	}
#	endif

	/* singlet neutral helium free-bound recombination continua */
	/* recombination from He+ into ground state */
	EdenAbund = phycon.eden*xIonFracs[ipHELIUM][2];

	if( EdenAbund > 0. )
	{
		gion = 2.;
		gn = 1.;
		gamma = 2.0618684e11*gn/gion/phycon.te/phycon.sqrte;
		cor = he1blt.he1cbt[0];
		if( cor > 0. )
		{
			for( i=nhe1Com.nhe1[0]-1; i < rfield.ipMaxBolt; i++ )
			{
				/* flux is in photons per sec per ryd
				 * ContBoltz is ratio of Boltz fac for each freq */
				photon = gamma*rfield.ContBoltz[i]/cor*rfield.widflx[i]*
				  opac.OpacStack[i-nhe1Com.nhe1[0]+opac.iophe1[0]]*
				  rfield.anu2[i];
				rfield.ConEmitLocal[i] += (float)(photon*EdenAbund);
				rfield.ThrowOut[i] += (float)(photon*EdenAbund*phe1lv.he1rec[ipRecEsc][0]);
			}
		}
		else
		{
			for( i=nhe1Com.nhe1[0]-1; i < rfield.ipMaxBolt; i++ )
			{
				arg = MAX2(0.,1.57890e5*(rfield.anu[i]-He1NIonRyd.He1IonRyd[0])/
				  phycon.te);
				/* flux is in photons per sec per ryd */
				photon = gamma*sexp(arg)*rfield.widflx[i]*opac.OpacStack[i-nhe1Com.nhe1[0]+
				  opac.iophe1[0]]*rfield.anu2[i];
				rfield.ConEmitLocal[i] += (float)(photon*EdenAbund);
				rfield.ThrowOut[i] += (float)(photon*EdenAbund*phe1lv.he1rec[ipRecEsc][0]);
			}
		}
	}

#	if 0
	/* do recombination from He+ into excited states */
	sum1ex = 0.;
	EdenAbund = phycon.eden*xIonFracs[ipHELIUM][2];
	if( EdenAbund > 0. )
	{
		gion = 2.;
		for( n=1; n < NHE1LVL; n++ )
		{
			bolt2 = 1.57890e5*rfield.anu[nhe1Com.nhe1[n]-1]/phycon.te;

			/* this is trick to do 2p, 2s correctly */
			gn = MAX2(4.,he1statCOM.he1stat[n]);
			gamma = 2.0618684e11*gn/gion/phycon.te/phycon.sqrte;

			/* Milne relation for excited states */
			limit = MIN2(nhe1Com.nhe1[0],rfield.nflux);

			if( rfield.ContBoltz[nhe1Com.nhe1[n]-1] > 0. )
			{
				for( i=nhe1Com.nhe1[n]-1; i < limit; i++ )
				{
					photon = gamma*rfield.ContBoltz[i]/rfield.ContBoltz[nhe1Com.nhe1[n]-
					  1]*rfield.widflx[i]*opac.OpacStack[i-nhe1Com.nhe1[n]+
					  opac.iophe1[n]]*rfield.anu2[i];
					sum1ex += photon;
					rfield.ConEmitLocal[i] += (float)(photon*EdenAbund);
					rfield.ThrowOut[i] += (float)(photon*EdenAbund*phe1lv.he1rec[ipRecEsc][n]);
				}
			}
			else if( bolt2 < 3. )
			{
				for( i=nhe1Com.nhe1[n]-1; i < limit; i++ )
				{
					arg = MAX2(0.,1.57890e5*(rfield.anu[i]-He1NIonRyd.He1IonRyd[n])/
					  phycon.te);
					photon = gamma*sexp(arg)*rfield.widflx[i]*
					  opac.OpacStack[i-nhe1Com.nhe1[n]+opac.iophe1[n]]*
					  rfield.anu2[i];
					sum1ex += photon;
					rfield.ConEmitLocal[i] += (float)(photon*EdenAbund);
					rfield.ThrowOut[i] += (float)(photon*EdenAbund*phe1lv.he1rec[ipRecEsc][n]);
				}
			}
		}
	}
	/* trace diffuse triggers this print */
	if( trace.lgTrace && trace.lgTrDiff )
	{
		fprintf( ioQQQ, " RTDiffuse: Hgrd;%10.2e Ex;%10.2e He3;%10.2e He1g;%10.2e Ex;%10.2e He2g;%10.2e Ex;\n", 
		  sumh1[ipISO][0], SumCaseB, sumtri, sum1gr, sum1ex, sumh1[ipISO][1] );
	}
#	endif

	/* >>chng 01 jan 25, make loop over all hydrogenic species */
	/* hydrogenic two photon emission */
	ipISO = ipHYDROGEN;
	for( nelem=0; nelem < LIMELM; nelem++ )
	{
		/* if an element is turned off then IonHigh is -1 */
		if( (IonRange.IonHigh[nelem] == nelem + 1)  )
		{

			/* in all following the factor of two is because a single
			 * decay produces two photons */
			EdenAbund = iso.Pop2Ion[ipHYDROGEN][nelem][ipH2s]*xIonFracs[nelem][nelem+2]*8.226;

			/* upper limit to H-like 2-phot is energy of La, which is in ipCont-1 cell */
			limit = EmisLines[ipHYDROGEN][nelem][ipH2p][ipH1s].ipCont-1;
			assert( limit > 0 );
			/* remember sum of rates, this will add up to twice the real rate since
			 * each transition makes two photons */
			sum = 0.;
			for( i=0; i < limit; i++ )
			{
				/*>>chng 01 jan 23, previous change had doubled cross section for H two-photon,
				 * so here we divide by 2 to get correct answer */
				/* >>chng 01 sep 16, break out TWO_PHOT_CONST and factor of two from AsHy2nu */
				sum += hydro.AsHy2nu[ipISO][nelem][i]/2.;
				fach = hydro.AsHy2nu[ipISO][nelem][i]/2.f*(float)EdenAbund;
				rfield.ConEmitLocal[i] += fach;
				Diff2Pht[i] += fach;
				/* this is escaping part, 
				 * as determined from optical depth to illuminated face */
				rfield.ThrowOut[i] += fach*opac.ExpmTau[i];
				/* save locally destroyed ots two-photon continuum */
				rfield.ConOTS_local_photons[i] += fach*(1.f - opac.ExpmTau[i]);
			}

			/* a sanity check on the code but only for hydrogen itself,
			 * div by two since two photons for every decay */
			assert( nelem!=0 || fabs( (sum*2.*TWO_PHOT_CONST-8.22485)/8.22485 )< 0.01 );
		}
	}

	/* HeI two photon emission, first part that cannot ionize hydrogen */
	EdenAbund = 2.*phe1lv.he12s*xIonFracs[ipHELIUM][2];
	/* following also protects from element being turned off */
	if( EdenAbund > 0. )
	{
		for( i=0; i < iso.ipIsoLevNIonCon[ipHYDROGEN][ipHYDROGEN][ipH1s]; i++ )
		{
			fach = (float)(helike.he12nu[i]*EdenAbund);
			rfield.ConEmitLocal[i] += fach;
			Diff2Pht[i] += fach;
			rfield.ThrowOut[i] += (float)(fach*opac.ExpmTau[i]);
			rfield.ConOTS_local_photons[i] += fach*(1.f - opac.ExpmTau[i]);
		}

		/* HeI two photon emission, energies that can photoionize hydrogen */
		for( i=iso.ipIsoLevNIonCon[ipHYDROGEN][ipHYDROGEN][ipH1s]; i < iphe1lCom.iphe1l[0][1]; i++ )
		{
			fach = (float)(helike.he12nu[i]*EdenAbund);
			rfield.ConEmitLocal[i] += fach;
			Diff2Pht[i] += fach;
			rfield.ThrowOut[i] += (float)(fach*opac.ExpmTau[i]);
			rfield.ConOTS_local_photons[i] += fach*(1.f - opac.ExpmTau[i]);
		}
	}

	/* H, He, heavy element, brems free-free */
	fach = (float)(phycon.eden*1.032e-11*(xIonFracs[ipHYDROGEN][2] + xIonFracs[ipHELIUM][2])/
	  phycon.sqrte);
	fache2 = phycon.eden*1.032e-11*4.*xIonFracs[ipHELIUM][3]/phycon.sqrte;
	facff = phycon.eden*1.032e-11*phycon.EdenFFSum*5./phycon.sqrte;

	/* ipEnergyBremsThin is index to energy where gas goes optically thin to brems,
	 * so this loop is over optically thick frequencies */
	/* >>chng 01 jul 08, combine loops into one with if branch to
	 * only add optically thin part to outward beam in ThrowOut */
	/* >>chng 01 aug 21, put limit to continuum defined with photons, ipMaxBolt can
	 * be larger than that */
	limit = MIN2( rfield.ipMaxBolt , rfield.nflux );
	for( i=0; i < limit; i++ )
	{
		fac = (fach*rfield.gff[i]*(1. + opac.OpacStack[i-1+opac.iphmra]*
		  iso.Pop2Ion[ipHYDROGEN][ipHYDROGEN][ipH1s]) + fache2*rfield.gffhe2[i] + facff*rfield.gff[i])*
		  rfield.widflx[i]*rfield.ContBoltz[i]/rfield.anu[i];

		/* >>chng 01 jul 01, move thick brems back to ConEmitLocal but do not add
		 * to outward beam - ConLocNoInter array removed as result
		 * if problems develop with very dense blr clouds, this may be reason */
		/*rfield.ConLocNoInter[i] += (float)fac;*/
		rfield.ConEmitLocal[i] += (float)fac;

		/* do not add optically thick part to outward beam since self absorbed
		 * >>chng 96 feb 27, put back into outward beam since do not integrate
		 * over it anyway. */
		/* >>chng 99 may 28, take back out of beam since DO integrate over it
		 * in very dense BLR clouds */
		/* >>chng 01 jul 10, add here, in only one loop, where opticall thin */
		if( i >= rfield.ipEnergyBremsThin )
			rfield.ThrowOut[i] += (float)fac;
	}

	/* grain dust emission */
	/* >>chng 01 nov 22, moved calculation of grain flux to qheat.c, PvH */
	if( gv.lgDustOn )
	{
		/* this calculates diffuse emission from grains,
		 * and stores the result in gv.GrainEmission */
		GrainMakeDiffuse();

		for( i=0; i < rfield.nflux; i++ )
		{
			rfield.ConEmitLocal[i] += gv.GrainEmission[i];
			rfield.ThrowOut[i] += gv.GrainEmission[i];
		}
	}

	/* hminus emission */
	fac = phycon.eden*(double)xIonFracs[ipHYDROGEN][1];
	gn = 1.;
	gion = 2.;
	gamma = 2.0618684e11*gn/gion/phycon.te/phycon.sqrte;
	cor = rfield.ContBoltz[iphminCom.iphmin-1];
	limit = MIN2(nhe1Com.nhe1[0],rfield.nflux);
	/* >>chng 00 dec 15 change limit to -1 of H edge */
	limit = MIN2(iso.ipIsoLevNIonCon[ipHYDROGEN][ipHYDROGEN][ipH1s]-1,rfield.nflux);

	if( cor > 0. )
	{
		for( i=iphminCom.iphmin-1; i < limit; i++ )
		{
			/* flux is in photons per sec per ryd
			 * ContBoltz is ratio of Boltz fac for each freq */
			factor = gamma*rfield.ContBoltz[i]/cor*rfield.widflx[i]*
			  opac.OpacStack[i-iphminCom.iphmin+opac.iphmop]*
			  rfield.anu2[i]*fac;
			rfield.ConEmitLocal[i] += (float)factor;
			rfield.ThrowOut[i] += (float)factor;
		}
	}
	else
	{
		for( i=iphminCom.iphmin-1; i < limit; i++ )
		{
			arg = MAX2(0.,1.57890e5*(rfield.anu[i]-0.05544)/phycon.te);
			/* flux is in photons per sec per ryd */
			factor = gamma*sexp(arg)*rfield.widflx[i]*
				opac.OpacStack[i-iphminCom.iphmin+opac.iphmop]*
			  rfield.anu2[i]*fac;
			rfield.ConEmitLocal[i] += (float)factor;
			rfield.ThrowOut[i] += (float)factor;
		}
	}

	/* this is a unit of energy that will be passed through the code as a test
	 * that all integrations are carried out.  A similar test is set in lineset1
	 * and verified in PrtFinal.  The opacity at this cell is zero so only
	 * geometrical dilution will affect the integral
	 * Radius is currently outer edge of zone, so radius-drad/2 is radius
	 * of center of zone */

	/* this dilution is needed to conserve volume in spherical models.  tests such
	 * as parispn.in will fault if this is removed */
	Dilution = (float)POW2( radius.rinner / (radius.Radius-radius.drad/2.) );/**/
	rfield.ConEmitLocal[rfield.nflux] = 1.e-10f * Dilution /* */ ;
	rfield.ThrowOut[rfield.nflux] = 1.e-10f * Dilution /* */;

	/* opacity should be zero at this energy */
	assert( opac.opac[rfield.nflux] == 0. );

	/* many tmn added to conserve energy in very high Z models
	 * rerun highZ qso model if any tmn ever deleted here
	 *
	 * tmn set in StartZone and includes both opacity and dilution 
	 *
	 * use duffuse lines and continuum to add flux to outward beam
	 *
	 * NB!!!  this routine adds flux to the outward beam
	 *  it can only be called once per zone
	 *
	 * covrt is radiative transfer covering factor
	 * covrt = 0 for open geometry
	 * covrt = 1 for closed geometry
	 *
	 * outwrd is fraction that goes outward, of the escaping line radiation
	 * default covrt is zero for open geometry, is 1 for closed
	 * outwrd is 1/2 for opten, 1 for closed */

	/*outwrd = (1. + cover.covrt)/2.;*/

	/* radius is the outer edge of the current zone
	 * dVolOutwrd = outwrd * dreff
	 * >>chng 95 nov 16
	 * dVolOutwrd = outwrd * dreff * ( radius/(radius+drad) )**2
	 * dreff in upper since fill fac enters, but not in lower
	 * >>chng 96 may 08, moved to zonsrt
	 * dVolOutwrd = outwrd * radius * dreff / (radius + 2.*drad) */
	 
	/* save contents of ConInterOut for checking how much was added */
	for( i=0; i < rfield.nflux; i++ )
	{
		rfield.SavOutCon[i] = rfield.ConInterOut[i] + rfield.outlin[i];
	}

	/* >>chng 96 may 08, moved to zonsrt
	 * dVolReflec = (1.-outwrd) * dReff * r1r0sq
	 * dVolOutwrd = outwrd * radius * dReff / (radius + 2.*drad)
	 *
	 * continuum interaction arrays that occur here:
	 *
	 * ContNoInter - not counted in internal energy budget
	 * of the cloud, used to get pretty plots afterwards
	 *
	 * ConInterOut, outward only continuum, inc in heating rates
	 * otscon, otslin, loc ots rates, inc in heating */
	
	/*  add HI hydrogenic lines to outward and reflected beams */
	for( nelem=0; nelem < LIMELM; nelem++ )
	{
		if( (IonRange.IonHigh[nelem] == nelem + 1)  )
		{
			for( ipLo=ipH1s; ipLo < (iso.nLevels[ipHYDROGEN][nelem] - 1); ipLo++ )
			{
				for( ipHi=ipLo+1 ; ipHi < iso.nLevels[ipHYDROGEN][nelem]; ipHi++ )
				{
					/* must not include 2s-1s two photon in this since is actually a continuum,
					 * or the 2p-2s transition which is off our energy grid */
					if( EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].ipCont < 1 )
						continue;

					/* pointer to line energy in continuum array,
					 * in most all cases the 2p-2s transition will have an energy very far
					 * off our energy grid.  These were assigned an ipCont of 1, 0 here,
					 * and the A to such a small value that these lines should not appear 
					 * in the resulting spectrum */
					ip = EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].ipCont-1;

					/* number of photons in the line has not been defined up til now,
					 * do so now.  this is redone in lines.  */
					EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].phots = 
						EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].Aul*
						EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].PopHi*
						EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].Pesc*
						xIonFracs[nelem][nelem+2];

					/* inward fraction of line */
					xInWrd = EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].phots*
					  EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].FracInwd;

					/* reflected part of line */
					rfield.reflin[ip] += (float)(xInWrd*radius.BeamInIn);

					/* inward beam that goes out since sphere set */
					/* in all this the ColOvTot term has been commented out,
					 * since this is not meaningful for something like the hydrogen atom,
					 * where most forms by recombination */
					rfield.outlin[ip] += (float)(xInWrd*radius.BeamInOut*opac.tmn[ip]/*
					  EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].ColOvTot*/);

					/* outward part of line */
					rfield.outlin[ip] += 
						(float)(EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].phots*
					  (1. - EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].FracInwd)*
					  radius.BeamOutOut*opac.tmn[ip]/*
					  EmisLines[ipHYDROGEN][nelem][ipHi][ipLo].ColOvTot*/);
				}
			}
		}
	}
	
	/*  add he-like iso seq lines to outward and reflected beams */
	/*fixit(); nb - following should loop from 1, is 2 to avoid double counting ioniz radiation */
	/*fixit(); add diffuse continuous emission, but then do not include he-like species in
	         * loop over heavy elements below */
	for( nelem=2; nelem < LIMELM; nelem++ )
	{
		if( (IonRange.IonHigh[nelem] >= nelem )  )
		{
			/* must not include 2s-1s two photon in this since is actually a continuum */
			for( ipHi=1 ; ipHi <iso.nLevels[ipHELIUM][nelem]; ipHi++ )
			{
				for( ipLo=0; ipLo < ipHi; ipLo++ )
				{
					/* pointer to line energy in continuum array */
					ip = EmisLines[ipHELIUM][nelem][ipHi][ipLo].ipCont-1;
					/* this is flag for fake line */
					if( ip<0 )
						continue;

					/* number of photons in the line has not been defined up til now,
					 * do so now.  this is redone in lines.  */
					EmisLines[ipHELIUM][nelem][ipHi][ipLo].phots = 
						EmisLines[ipHELIUM][nelem][ipHi][ipLo].Aul*
						EmisLines[ipHELIUM][nelem][ipHi][ipLo].PopHi*
						EmisLines[ipHELIUM][nelem][ipHi][ipLo].Pesc*
						xIonFracs[nelem][nelem+1];

					/* inward fraction of line */
					xInWrd = EmisLines[ipHELIUM][nelem][ipHi][ipLo].phots*
					  EmisLines[ipHELIUM][nelem][ipHi][ipLo].FracInwd;

					/* reflected part of line */
					rfield.reflin[ip] += (float)(xInWrd*radius.BeamInIn);

					/* inward beam that goes out since sphere set */
					/* in all this the ColOvTot term has been commented out,
					 * since this is not meaningful for something like the hydrogen atom,
					 * where most forms by recombination */
					rfield.outlin[ip] += (float)(xInWrd*radius.BeamInOut*opac.tmn[ip]/*
					  EmisLines[ipHELIUM][nelem][ipHi][ipLo].ColOvTot*/);

					/* outward part of line */
					rfield.outlin[ip] += 
						(float)(EmisLines[ipHELIUM][nelem][ipHi][ipLo].phots*
					  (1. - EmisLines[ipHELIUM][nelem][ipHi][ipLo].FracInwd)*
					  radius.BeamOutOut*opac.tmn[ip]/*
					  EmisLines[ipHELIUM][nelem][ipHi][ipLo].ColOvTot*/);
				}
			}
		}
	}

	/*  HeI  He I   He I   He I   He I   He I   He I   He I
	 * outward part of escaping He I Ly alpha hei lya */
	rfield.reflin[iphe1lCom.iphe1l[0][1]-1] += (float)radius.dVolReflec*heots.esc584;
	rfield.outlin[iphe1lCom.iphe1l[0][1]-1] += (float)radius.dVolOutwrd*heots.esc584;

	/* HeI higher lyman lines */
	for( ipHi=2; ipHi < (NHE1LVL - 1); ipHi++ )
	{
		rfield.outlin[iphe1lCom.iphe1l[0][ipHi]-1] += xIonFracs[ipHELIUM][2]*phe1lv.he1n[ipHi]*
		  phe1lv.he1mis[0][ipHi]*(float)radius.dVolOutwrd;
		rfield.reflin[iphe1lCom.iphe1l[0][ipHi]-1] += xIonFracs[ipHELIUM][2]*phe1lv.he1n[ipHi]*
		  phe1lv.he1mis[0][ipHi]*(float)radius.dVolReflec;
	}

	/* helium 1 triplet lines */
	rfield.outlin[he3lines.ipHe3l[0]-1] += (float)(he3lines.p10830/1.84e-12*
	  radius.dVolOutwrd);
	rfield.outlin[he3lines.ipHe3l[1]-1] += (float)(he3lines.p5876/3.39e-12*
	  radius.dVolOutwrd);
	rfield.outlin[he3lines.ipHe3l[2]-1] += (float)(he3lines.p7065/2.82e-12*
	  radius.dVolOutwrd);
	rfield.outlin[he3lines.ipHe3l[3]-1] += (float)(he3lines.p3889/5.12e-12*
	  radius.dVolOutwrd);

	rfield.reflin[he3lines.ipHe3l[0]-1] += (float)(he3lines.p10830/1.84e-12*
	  radius.dVolReflec);
	rfield.reflin[he3lines.ipHe3l[1]-1] += (float)(he3lines.p5876/3.39e-12*
	  radius.dVolReflec);
	rfield.reflin[he3lines.ipHe3l[2]-1] += (float)(he3lines.p7065/2.82e-12*
	  radius.dVolReflec);
	rfield.reflin[he3lines.ipHe3l[3]-1] += (float)(he3lines.p3889/5.12e-12*
	  radius.dVolReflec);

	/* He I ionized helium singlet lines */
	for( ipLo=1; ipLo < (NHE1LVL - 2); ipLo++ )
	{
		for( ipHi=ipLo + 1; ipHi <= (NHE1LVL - 1); ipHi++ )
		{
			rfield.outlin[iphe1lCom.iphe1l[ipLo][ipHi]-1] += xIonFracs[ipHELIUM][2]*
			  phe1lv.he1n[ipHi]*phe1lv.he1mis[ipLo][ipHi]*(float)radius.dVolOutwrd;
			rfield.reflin[iphe1lCom.iphe1l[ipLo][ipHi]-1] += xIonFracs[ipHELIUM][2]*
			  phe1lv.he1n[ipHi]*phe1lv.he1mis[ipLo][ipHi]*(float)radius.dVolReflec;
		}
	}

	rfield.outlin[ip626.ipHe23sGrnd-1] += (float)radius.dVolOutwrd*heots.out626;
	rfield.reflin[ip626.ipHe23sGrnd-1] += (float)radius.dVolReflec*heots.out626;

	rfield.outlin[pbowen.ip660-1] += (float)radius.dVolOutwrd*heots.esc660;
	rfield.reflin[pbowen.ip660-1] += (float)radius.dVolReflec*heots.esc660;

	/* >>chng 96 nov 19, do not consider energies below plasma freq
	 * ipPlasmaFreq points to lowest energy thin to brems and plas freq 
	ipPlasmaFreq = MAX2(plasnu.ipPlasma,1)-1;*/

	/* >>chng 01 jul 04, this is a major change in logic */
	/* add the local diffuse continuum to the outward beam contained
	 * in rfield.ConInterOut - this will be added to the interactive part
	 * of the continuum if outward-only is set, and ignored otherwise.
	 * this is done by multiplying ConInterOut by lgOutOnly which is 1 if outward,
	 * zero otherwise */

	/* add rfield.ThrowOut continuum (set in RTDiffuse) to ConInterOut,
	 * lower limit of plasnu.ipPlasma-1 since continuum is zero below plasnu.ipPlasma-1 
	 * due to plasma frequency
	 * note that upper range of sum is <= nflux, which contains the unit
	 * verification token in the highest cell*/

	for( i=plasnu.ipPlasma-1; i <= rfield.nflux; i++ )
	{
		/* ConInterOut is the interactive continuum
		 * tmn is attenuation across one zone
		 * ThrowOut contains all radiation thrown into outward beam, 
		 * eval in RTDiffuse */
		/* NB opac.tmn is needed for FIR brems emission in dense BLR clouds -
		 * each zone is vastly optically thick to 1 cm radiation */
		rfield.ConInterOut[i] += rfield.ThrowOut[i]*(float)radius.dVolOutwrd;
	}

	/* now save the outward continua to track changes */
	for( i=0; i < rfield.nflux; i++ )
	{
		/* >>chng 96 jul 13, add extra grain emiss to save out, so it is
		 * not counted in effective sum - benign source of radiation */
		rfield.SavOutCon[i] += gv.GrainEmission[i]*
		  (float)radius.dVolOutwrd;
	}

	{
		/*@-redef@*/
		enum {DEBUG=FALSE};
		/*@+redef@*/
		if( DEBUG )
		{
			fprintf(ioQQQ,"rtdiffusedebugg %li\t%.2e\t%.2e\t%.2e\n", 
				nzone, rfield.ConInterOut[1158] , rfield.ThrowOut[1158],radius.dVolOutwrd);
		}
	}

#	if !defined(NDEBUG)
	/*begin sanity check for level 1 lines */
	for( i=1; i <= nLevel1; i++ )
	{
		if( TauLines[i].phots*
			TauLines[i].ColOvTot < 0. )
		{
			fprintf( ioQQQ, " RTDiffuse finds insane NPohts*ColovTot for level 1 line, vals=%10.1e%10.1e\n", 
			  TauLines[i].phots, 
			  TauLines[i].ColOvTot );
			DumpLine(&TauLines[i]);
			ShowMe();
			puts( "[Stop in RTDiffuse]" );
			cdEXIT(1);
		}
	}
	/*end sanity check */
#	endif

	/* outward level 1 line photons, 0 is dummy line */
	for( i=1; i <= nLevel1; i++ )
	{
		/* pointer to line energy in continuum array */
		ip = TauLines[i].ipCont-1;

		/* last factor does not accout for frac of lines pumped */
		xInWrd = TauLines[i].phots*TauLines[i].FracInwd;
		rfield.reflin[ip] += (float)(xInWrd*radius.BeamInIn);

		/* inward beam that goes out since sphere set */
		rfield.outlin[ip] += (float)(xInWrd*radius.BeamInOut*opac.tmn[ip]*
		  TauLines[i].ColOvTot);

		rfield.outlin[ip] += (float)(TauLines[i].phots*
		  (1. - TauLines[i].FracInwd)*radius.BeamOutOut*
		  /*opac.tmn[ip]**/   TauLines[i].ColOvTot);
	}

#	if !defined(NDEBUG)
	/*begin sanity check for level 2 lines */
	for( i=0; i < nWindLine; i++ )
	{
		if( TauLine2[i].phots*TauLine2[i].ColOvTot < 0. )
		{
			fprintf( ioQQQ, " RTDiffuse finds insane NPohts*ColovTot for level 2 line, vals=%10.1e%10.1e\n", 
			  TauLine2[i].phots, TauLine2[i].ColOvTot );
			DumpLine(&TauLine2[i]);
			ShowMe();
			puts( "[Stop in RTDiffuse]" );
			cdEXIT(1);
		}
	}
	for( i=0; i < nHFLines; i++ )
	{
		if( HFLines[i].phots*HFLines[i].ColOvTot < 0. )
		{
			fprintf( ioQQQ, " RTDiffuse finds insane NPohts*ColovTot for level 2 line, vals=%10.1e%10.1e\n", 
			  HFLines[i].phots, HFLines[i].ColOvTot );
			DumpLine(&HFLines[i]);
			ShowMe();
			puts( "[Stop in RTDiffuse]" );
			cdEXIT(1);
		}
	}
	/*end sanity check */
#	endif

	/* outward level 2 line photons */
	for( i=0; i < nWindLine; i++ )
	{
		if( TauLine2[i].nelem != TauLine2[i].IonStg )
		{
			/* NB if this changes, then FeIIEmitOut in pop371 
			 * probably needs to change too
			 * pointer to line energy in continuum array */
			ip = TauLine2[i].ipCont-1;

			/* last factor does not accout for frac of lines pumped */
			xInWrd = TauLine2[i].phots*TauLine2[i].FracInwd;
			rfield.reflin[ip] += (float)(xInWrd*radius.BeamInIn);

			/* inward beam that goes out since sphere set */
			rfield.outlin[ip] += (float)(xInWrd*radius.BeamInOut*opac.tmn[ip]*
			  TauLine2[i].ColOvTot);

			rfield.outlin[ip] += (float)(TauLine2[i].phots*
			  (1. - TauLine2[i].FracInwd)*radius.BeamOutOut*
			  /*opac.tmn[ip]**/TauLine2[i].ColOvTot);
			/* >>chng 96 jul 16, added ipLnColovTOT */
		}
	}

	/* outward hyperfine structure line photons */
	for( i=0; i < nHFLines; i++ )
	{
		if( HFLines[i].nelem != HFLines[i].IonStg )
		{
			/* NB if this changes, then FeIIEmitOut in pop371 
			 * probably needs to change too
			 * pointer to line energy in continuum array */
			ip = HFLines[i].ipCont-1;

			/* last factor does not accout for frac of lines pumped */
			xInWrd = HFLines[i].phots*HFLines[i].FracInwd;
			rfield.reflin[ip] += (float)(xInWrd*radius.BeamInIn);

			/* inward beam that goes out since sphere set */
			rfield.outlin[ip] += (float)(xInWrd*radius.BeamInOut*opac.tmn[ip]*
			  HFLines[i].ColOvTot);

			rfield.outlin[ip] += (float)(HFLines[i].phots*
			  (1. - HFLines[i].FracInwd)*radius.BeamOutOut*
			  /*opac.tmn[ip]**/HFLines[i].ColOvTot);
			/* >>chng 96 jul 16, added ipLnColovTOT */
		}
	}

	/* carbon monoxide */
	for( i=0; i < nCORotate; i++ )
	{
		/* C12O16 */
		/* pointer to line energy in continuum array */
		ip = C12O16Rotate[i].ipCont-1;

		/* last factor does not accout for frac of lines pumped */
		xInWrd = C12O16Rotate[i].phots*C12O16Rotate[i].FracInwd;
		rfield.reflin[ip] += (float)(xInWrd*radius.BeamInIn);

		/* inward beam that goes out since sphere set */
		rfield.outlin[ip] += (float)(xInWrd*radius.BeamInOut*opac.tmn[ip]*
		  C12O16Rotate[i].ColOvTot);

		rfield.outlin[ip] += (float)(C12O16Rotate[i].phots*
		  (1. - C12O16Rotate[i].FracInwd)*radius.BeamOutOut*C12O16Rotate[i].ColOvTot);

		/* C13O16 */
		/* pointer to line energy in continuum array */
		ip = C13O16Rotate[i].ipCont-1;

		/* last factor does not accout for frac of lines pumped */
		xInWrd = C13O16Rotate[i].phots*C13O16Rotate[i].FracInwd;
		rfield.reflin[ip] += (float)(xInWrd*radius.BeamInIn);

		/* inward beam that goes out since sphere set */
		rfield.outlin[ip] += (float)(xInWrd*radius.BeamInOut*opac.tmn[ip]*
		  C13O16Rotate[i].ColOvTot);

		rfield.outlin[ip] += (float)(C13O16Rotate[i].phots*
		  (1. - C13O16Rotate[i].FracInwd)*radius.BeamOutOut*C13O16Rotate[i].ColOvTot);
	}

	/* do the large FeII atom if it is turned on */
	if( FeII.lgFeIION )
	{
		/* this will do the above, adding FeII to reflected, outward beam */
		if( xIonFracs[ipIRON][2] > 0. && FeII.lgFeIION  )
		{
			FeIIEmitOut(radius.dVolOutwrd,radius.dVolReflec);
		}
	}

	/* add recombination continua for elements heavier than He */
	/* nelem = 2 is Li */
	for( nelem=2; nelem < LIMELM; nelem++ )
	{
		/* do not include hydrogenic species in following */
		for( nion=0; nion < nelem; nion++ )
		{
			if( xIonFracs[nelem][nion+2] > 0. )
			{
				long int ipNu, ns, nshell,igRec , igIon,
					iplow , iphi , ipop;

				ip = Heavy.ipHeavy[nion][nelem]-1;

				/* nflux was reset upward in ConvInitTemp to encompass all
				 * possible line and continuum emission.  this test should not
				 * possibly fail.  It could if the ionization were to increase with depth.
				 * This is important because the nflux cell in ConInterOut is used to carry out the
				 * unit integration, and if it gets clobbered by diffuse emission the code
				 * will declare insanity in PrtComment */
				assert( ip >= 0 && ip < rfield.nflux );

				/* >>chng 01 jul 01, removed ConOutRecInter array, added ground state recombination
				 * into outward beam using Milne relation below */

				/* get shell number, stat weights for this species */
				outer( nelem+1 , nelem+1-nion , &nshell, &igRec , &igIon );
				gn = (double)igRec;
				/* >>chng 01 jun 30, following should have been igIon
				gion = (double)igRec; */
				gion = (double)igIon;

				/* shell number */
				ns = Heavy.nsShells[nion][nelem]-1;
				assert( ns == (nshell-1) );

				/* lower and upper energies, and offset for opacity stack */
				iplow = opac.ipElement[0][ns][nion][nelem]-1;
				iphi = opac.ipElement[1][ns][nion][nelem];
				iphi = MIN2( iphi , rfield.nflux );
				ipop = opac.ipElement[2][ns][nion][nelem];

				/* now convert ipop to the offset in the opacity stack from threshold */
				ipop = ipop - iplow;

				bolt2 = 1.57890e5*rfield.anu[iplow]/phycon.te;

				gamma = 2.0618684e11*gn/gion/phycon.te/phycon.sqrte*phycon.eden*xIonFracs[nelem][nion+2];

				/* this is ground state continuum from stored opacities */
				if( rfield.ContBoltz[iplow] > SMALLFLOAT )
				{
					for( ipNu=iplow; ipNu < iphi; ++ipNu )
					{
						photon = gamma*rfield.ContBoltz[ipNu]/rfield.ContBoltz[iplow]*
							rfield.widflx[ipNu]*opac.OpacStack[ipNu+ipop]*rfield.anu2[ipNu];
						/* >>chng 01 jul 01, add heavy rec to ground in active beam,
						 * had been in before but not in active beam */
						/* fixit();should use ConEmitLocal for all continua, but not followed
								 * by ThrowOut - put that at the end.  Once continua all
								 * bundled this way, it will be easy to save them as a function
								 * of depth and then do exact rt */
						rfield.ConEmitLocal[ipNu] += (float)photon;
						rfield.ThrowOut[i] += (float)photon;
					}
				}

				/* now do the recombination Lya */
				ipla = Heavy.ipLyHeavy[nion][nelem]-1;
				assert( ipla >= 0 );
				esc = opac.ExpmTau[ipla];
				/* esc = 1.;testcode();this is to balance killing it in rtots */
				/* xLyaHeavy is set to a fraction of the total rad rec in MakeRecomb, includes eden */
				difflya = Heavy.xLyaHeavy[nion][nelem]*xIonFracs[nelem][nion+2];
				rfield.outlin[ipla] += (float)(difflya*radius.dVolOutwrd*opac.tmn[ipla]*esc);
				rfield.reflin[ipla] += (float)(difflya*radius.dVolReflec*opac.tmn[ipla]*esc);

				/* now do the recombination Balmer photons */
				ipla = Heavy.ipBalHeavy[nion][nelem]-1;
				assert( ipla >= 0 );
				esc = opac.ExpmTau[ipla];
				/* xLyaHeavy is set to fraction of total rad rec in MakeRecomb, includes eden */
				difflya = Heavy.xLyaHeavy[nion][nelem]*xIonFracs[nelem][nion+2];
				rfield.outlin[ipla] += (float)(difflya*radius.dVolOutwrd*opac.tmn[ipla]*esc);
				rfield.reflin[ipla] += (float)(difflya*radius.dVolReflec*opac.tmn[ipla]*esc);
			}
		}
	}

	/* Fe Auger K-alpha in outward only
	 * first is rec plus hot auger
	 * this is pointer to valence shell Lya
	 * >>chng 97 apr 28, had been 26,20, so picked up vastly wrong energy for Ka
	 * improve to real pointers for line
	 * >>chng 96 nov 20, added tmn to two below, to prevent line from
	 * overwhelming very thick models
	 * >>chng 97 apr 28, put in reflected Ka, had been only outward
	 * outlin(ip) = outlin(ip) + fekhot/1.11e-8 * dReff * */
	rfield.outlin[fekems.ipkhot-1] += fekems.fekhot*(float)radius.dVolOutwrd*
	  opac.tmn[fekems.ipkhot-1];

	rfield.reflin[fekems.ipkhot-1] += fekems.fekhot*(float)radius.dVolReflec;

	/* >>chng 97 apr 28, put in reflected Ka, had been only outward
	 * this is cold iron, one cell below hot
	 * outlin(ip-1) = outlin(ip-1) +fekcld/1.03e-8*dReff* */
	/* >>chng 02 jan 14, add grain fe to both cold Ka */
	rfield.outlin[fekems.ipkcld-1] += (fekems.fekcld+fekems.fegrain)*(float)radius.dVolOutwrd*
	  opac.tmn[fekems.ipkcld-2];

	rfield.reflin[fekems.ipkcld-1] += (fekems.fekcld+fekems.fegrain)*(float)radius.dVolReflec;

	if( FeII.lgFeIION )
	{
		/* do OTS and outward parts of FeII lines, if large atom is turned on */
		Fe2RTOut();
	}

	/**********************************************************************
	 *                                                                    *
	 * now analyse what we have done to the outward beam                  *
	 *                                                                    *
	 **********************************************************************/

	/* now figure out how much we added to the beam
	 * this is used for setting zone thickness - do not want to
	 * add too much energy in outward beam */
	rfield.SumOutCon = 0.;
	rfield.SumIncCon = 0.;
	ots = 0.;

	/* this will be photon energy where this peak occurs */
	rfield.SumOutMax = 0.;

	/* radiation field may not extend up to H ionization limit */
	limit = MIN2( rfield.nflux , (iso.ipIsoLevNIonCon[ipHYDROGEN][0][ipH1s] - 1) );
	for( i=0; i < limit; i++ )
	{
		/* >>chng 96 jan 14, was photon number, now energy
		 * >>chng 96 nov 19, save difference in SavOutCon array, for later punch */
		rfield.SavOutCon[i] = (float)(MAX2(0.,rfield.outlin[i]+rfield.ConInterOut[i]-
			rfield.SavOutCon[i]));

		esc = rfield.SavOutCon[i]*opac.opac[i]*rfield.anu[i];

		if( esc > ots )
		{
			ots = esc;
			rfield.SumOutMax = rfield.anu[i];
			rfield.ipSumOutMax = i+1;
		}

		/* the ratio of SumOutCon to SumIncCon is kept below 5% in nextdr */
		rfield.SumOutCon += (float)(esc*0.);/*fixit();remove *0. */

		/* >>chng 96 nov 18, add ConInterOut, outlin to sum
		 * SumIncCon = SumIncCon + (flux(i)+otscon(i)+otslin(i)) *opac(i)* */
		rfield.SumIncCon += (float)((rfield.flux[i] + rfield.otscon[i] + 
		  rfield.otslin[i] + rfield.ConInterOut[i] + rfield.outlin[i])*
		  opac.opac[i]*rfield.anu[i]);
	}

	rfield.SumHOutCon = 0.;
	rfield.SumHIncCon = 0.;
	/* this will be sum of H-ionizing continuum
	 * >>chng 96 jan 14, was photon number, now energy */
	for( i=limit; i < rfield.nflux; i++ )
	{
		/* esc = ( outlin(i)+ConInterOut(i)-SavOutCon(i) )* opac(i)* anu(i) */
		rfield.SavOutCon[i] = (float)MAX2(0.,rfield.outlin[i]+rfield.ConInterOut[i]-
		  rfield.SavOutCon[i]);

		esc = rfield.SavOutCon[i]*opac.opac[i]*rfield.anu[i];

		if( esc > ots )
		{
			ots = esc;
			rfield.SumOutMax = rfield.anu[i];
			rfield.ipSumOutMax = i+1;
		}

		rfield.SumHOutCon += (float)esc;

		/* >>chng 96 nov 18, add ConInterOut, outlin to sum */
		rfield.SumHIncCon += (float)((rfield.flux[i] + rfield.otscon[i] + 
		  rfield.otslin[i] + rfield.ConInterOut[i] + rfield.outlin[i])*
		  opac.opac[i]*rfield.anu[i]);
	}
	rfield.SumOutCon += rfield.SumHOutCon;
	rfield.SumIncCon += rfield.SumHIncCon;

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " RTDiffuse returns.\n" );
	}

	for( i=0; i < rfield.nflux; i++ )
	{
		/* >>chng 00 oct 03, add diffuse continua */
		/* local diffuse continua */
		rfield.OccNumbDiffCont[i] = rfield.ConEmitLocal[i]*rfield.convoc[i];

		/* confirm that all are non-negative */
		assert( rfield.flux[i] >=0.);
		assert( rfield.otscon[i] >=0.) ;
		assert( rfield.otslin[i] >=0.) ;
		assert( rfield.ConInterOut[i] >=0.) ;
		assert( rfield.outlin[i] >=0.) ;
	}

	free( Diff2Pht );

#	ifdef DEBUG_FUN
	fputs( " <->RTDiffuse()\n", debug_fp );
#	endif
	return;
}
