/* recoil.h */
EXTERN struct t_recoil {
	/* flag saying that compton recoil ionization of bound
	 * electrons is enabled,
	 * set false with no recoil ionization command */
	int lgCompRecoil;

	/* array indices for continuum offset of compton recoil ionization threshold */
	long int ipCompRecoil[LIMELM];

	/* rate of bound electron ionization by compton scattering */
	double CompRecoilIonRate[LIMELM];
	/* save rate of bound electron ionization by compton scattering */
	double CompRecoilIonRateSave[LIMELM];

	/* heating rate due to bound electron ionization by compton scattering */
	double CompRecoilHeatRate[LIMELM];
	/* save heating rate due to bound electron ionization by compton scattering */
	double CompRecoilHeatRateSave[LIMELM];

	/* number of valence electrons that can participate - multipies since electron rate */
	long int  nCompRecoilElec[LIMELM];

	}	recoil;

