/* punchvar.h */
#define	LIMPUN	100L

/*PunchDo produce punch output during calculation */
void PunchDo(
	char *chTime); /* chTime is null terminated 4 char string, either "MIDL" or "LAST" */

/* punch one line, called by PunchLineStuff */
void pun1Line( EmLine * t , FILE * io , float xLimit , long index );

/*PunchLineData punches selected line data for all lines transferred in code */
void PunchLineData(FILE * io);

/*Punch1LineData data for punch one line */
void Punch1LineData( EmLine * t , FILE * io);

/*PunResults1Line do single line of output for the punch results and punch line intensity commands */
void PunResults1Line(FILE * io, 
  char *chLab, 
  float wavelength, 
  double xInten, 
  char chType,
  char *chFunction); /* null terminated string saying what to do */

/*punResults punch results from punch results command */
void punResults(FILE* io);

/*punlin parse punch lines command, or actually do the punch output */
void punlin(FILE * ip, /* the file we will write to */
  char *chDo, 
  int lgLog3);

EXTERN struct t_pnunit {

	/* this is the file where we will direct the output */
	FILE*ipPnunit[LIMPUN]; 

	/* number of punch commands entered */
	long int npunch;

	/*chPunch - what is it we want to punch? set in GetPunch, used in DoPunch */
	char chPunch[LIMPUN][5];

	/* flag saying whether any punch continuum commands were entered
	 * set true in parsecontinuum when punch continuum entered,
	 * used in PrtComment to warn if continuum punched with no iterations */
	int lgPunContinuum;

	/* punarg is set of optional arguments for the punch command */
	float punarg[3][LIMPUN];

	/* set of optional arguments for punch command, but as a string */
	char chPunchArgs[LIMPUN][5];

	/* lg flag lgPunLstIter for this punch option, */
	/* do we only want to punch on last iteration? */
	int lgPunLstIter[LIMPUN];

	/* option to append instead of overwrite */
	int lgNoClobber[LIMPUN];

	/* option to say whether punch units should be opened,
	 * set to false during optimizer runs, but not on the final model */
	int lgOpenUnits;

	/*chConPunEnr - units of continuum in punch output */
	char chConPunEnr[LIMPUN][5];

	/* this global variable is index of punch command loop in dopunch */
	long int ipConPun;

	/* should hash marks be printed after every iteration?
	 * default is yes, set no with no hash option on punch command */
	int lgHashEndIter;

	/* these are initialized in parsepunch.c, in routine PunchFilesInit */
	/* min and max range of punch new continuum command */
	float cp_range_min[LIMPUN] ,
		cp_range_max[LIMPUN];

	/* the resolving power of the rebinned continuum, set with
	 * set cpunch resolving 100 command, 
	 * if not specified then native resolution will be kept */
	float cp_resolving_power[LIMPUN];

	/* number of new punch continuum commands */
	long int cp_npun;

	/* set with punch line intensites and punch results commands,
	 * says whether results arrays produced by routine PunResults1Line should
	 * be column or array */
	char chPunRltType[7];

	/* option to punch out pointers with punch pointers commmand
	 * ipPoint is punch file handle, lgPunPoint says whether we will do it
	 */
	FILE* ipPoint;
	int lgPunPoint;

	/* unit number, and flag, for punching reason for continued iterations */
	int lgPunConv;
	FILE* ipPunConv;

	/* these control punching choice of dr - this is not really a punch cmnd
	 * ipDRout is io unit, lgDROn says punching dr logic has been set,
	 * and lgDRPLst says to punch the last iteration */
	FILE * ipDRout;
	int lgDROn, 
	  lgDRPLst;

	/* option to punch recombination coefficients to external file */
	FILE* ioRecom;
	int lgioRecom;

	/* lgPunH2 says to punch H2 rates on unit ipPunH2 */
	FILE * ipPunH2;
	int lgPunH2;

	/* option to punch line intensities every linevery zones
	 * logical variable says whether LinEvery was set */
	long int LinEvery;
	int lgLinEvery;

	}	punch;
